<?php

declare(strict_types=1);

namespace Macopedia\OrlenShipping\Block\Adminhtml\Shipment\Create;

use Magento\Backend\Block\Template\Context;
use Magento\CatalogInventory\Api\StockConfigurationInterface;
use Magento\CatalogInventory\Api\StockRegistryInterface;
use Magento\Framework\Registry;
use Magento\Sales\Helper\Data;
use Magento\Shipping\Block\Adminhtml\Create\Items as CoreItems;
use Macopedia\OrlenShipping\Model\Source\BoxSize;
use Macopedia\OrlenShipping\Helper\Data as OrlenHelper;
use Magento\Shipping\Model\CarrierFactory;

class Items extends CoreItems
{
    /**
     * @inheritDoc
     */
    public function __construct(
        Context $context,
        StockRegistryInterface $stockRegistry,
        StockConfigurationInterface $stockConfiguration,
        Registry $registry,
        Data $salesData,
        CarrierFactory $carrierFactory,
        private readonly BoxSize $boxSize,
        private readonly OrlenHelper $orlenHelper,
        array $data = []
    ) {
        parent::__construct(
            $context,
            $stockRegistry,
            $stockConfiguration,
            $registry,
            $salesData,
            $carrierFactory,
            $data
        );
    }

    /**
     * Get the box size options for dropdown
     *
     * @return array
     */
    public function getBoxSizeOptions(): array
    {
        return $this->boxSize->toOptionArray();
    }

    /**
     * Get default box size from configuration
     *
     * @return string|null
     */
    public function getDefaultBoxSize(): ?string
    {
        return $this->orlenHelper->getDefaultBoxSize();
    }
}
