<?php

declare(strict_types=1);

namespace Macopedia\OrlenShipping\Block\Adminhtml;

use Macopedia\OrlenShipping\Helper\Data;
use Macopedia\OrlenShipping\Model\Carrier\OrlenShipping;
use Magento\Framework\Exception\LocalizedException;
use Magento\Sales\Block\Adminhtml\Order\AbstractOrder;

class Map extends AbstractOrder
{
    /**
     * Can show
     *
     * @return bool
     * @throws LocalizedException
     */
    public function canShow(): bool
    {
        if (!$this->getToken()) {
            return false;
        }
        return str_contains($this->getOrder()->getShippingMethod(), OrlenShipping::CODE);
    }

    /**
     * Get map widget token
     *
     * @return string|null
     */
    public function getToken(): ?string
    {
        return $this->_scopeConfig->getValue(Data::XML_PATH_MAP_WIDGET_TOKEN);
    }
}
