<?php

declare(strict_types=1);

namespace Macopedia\OrlenShipping\Api;

interface ClientInterface
{
    /**
     * Generate label business pack
     *
     * @param array $parameters
     * @return \Macopedia\OrlenShipping\Model\Api\Response
     * @throws \Macopedia\OrlenShipping\Model\Api\OrlenApiException
     */
    public function generateLabelBusinessPackTwo(array $parameters);

    /**
     * Generate protocol
     *
     * @param array $parameters
     * @return \Macopedia\OrlenShipping\Model\Api\Response
     * @throws \Macopedia\OrlenShipping\Model\Api\OrlenApiException
     */
    public function generateProtocol(array $parameters);

    /**
     * Give partner status
     *
     * @param array $parameters
     * @return \Macopedia\OrlenShipping\Model\Api\Response
     * @throws \Macopedia\OrlenShipping\Model\Api\OrlenApiException
     */
    public function givePartnerStatus(array $parameters);

    /**
     * Ping command
     *
     * @return \Macopedia\OrlenShipping\Model\Api\Response
     * @throws \Macopedia\OrlenShipping\Model\Api\OrlenApiException
     */
    public function ping();

    /**
     * Get available pickups
     *
     * @param array $parameters
     * @return \Macopedia\OrlenShipping\Model\Api\Response
     * @throws \Macopedia\OrlenShipping\Model\Api\OrlenApiException
     */
    public function getAvailablePickupWindows(array $parameters);

    /**
     * Order courier
     *
     * @param array $parameters
     * @return \Macopedia\OrlenShipping\Model\Api\Response
     * @throws \Macopedia\OrlenShipping\Model\Api\OrlenApiException
     */
    public function callPickupNew(array $parameters);
}
