<?php

declare(strict_types=1);

namespace Macopedia\HyvaCheckoutOrlen\Plugin;

use Hyva\Checkout\Model\Magewire\Payment\PlaceOrderServiceInterface;
use Macopedia\OrlenShipping\Model\Carrier\OrlenShipping;
use Magento\Quote\Model\Quote;

class CleanupPointDetails
{
    /**
     * Before place order plugin
     *
     * @param PlaceOrderServiceInterface $subject
     * @param Quote $quote
     * @return Quote[]
     */
    public function beforePlaceOrder(PlaceOrderServiceInterface $subject, Quote $quote): array
    {
        if (!str_contains((string) $quote->getShippingAddress()?->getShippingMethod(), OrlenShipping::CODE)) {
            $quote->setData('orlenpaczka_point_details', null);
            $quote->setData('orlenpaczka_destination_code', null);
        }

        return [$quote];
    }
}
