<?php

/*

Plugin Name: ORLEN Paczka WooCommerce

Description: Integracja WooCommerce z ORLEN Paczka.

Version: 1.1.0

Author: <a href="https://sm32.pl/" target="_blank">sm32 STUDIO sp. z o. o.</a>

*/



if (!defined('ABSPATH')) exit;



// Wczytywanie klas

require_once plugin_dir_path(__FILE__) . 'includes/cpt-orlen-auth.php';

require_once plugin_dir_path(__FILE__) . 'includes/class-api-client.php';

require_once plugin_dir_path(__FILE__) . 'includes/class-orlenpaczka-soap.php';

require_once plugin_dir_path(__FILE__) . 'includes/class-orlenpaczka-pickup.php';

require_once plugin_dir_path(__FILE__) . 'includes/class-orlenpaczka-orlen-shipping-history.php';

require_once plugin_dir_path(__FILE__) . 'includes/class-label-generator.php';

require_once plugin_dir_path(__FILE__) . 'includes/class-admin-settings.php';

require_once plugin_dir_path(__FILE__) . 'includes/class-orlen-paczka-pickup-point-field.php';

require_once plugin_dir_path(__FILE__) . 'includes/class-sender-helper.php';

require_once plugin_dir_path(__FILE__) . 'includes/class-logger.php';

require_once plugin_dir_path(__FILE__) . 'includes/class-orlen-paczka-admin-pickup.php';





add_action('plugins_loaded', 'orlen_init_shipping_method', 20);



function orlen_init_shipping_method() {

    if (!class_exists('WC_Shipping_Method')) {

        return; 

    }






    add_action( 'before_woocommerce_init', function() {
    if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility(
            'custom_order_tables',
            __FILE__,
            true
        );
    }
});




add_filter('woocommerce_cart_shipping_method_full_label', function($label, $method) {

    if ( strpos($method->id, 'orlen_paczka') !== false ) {

        $logo_url = 'https://www.orlenpaczka.pl/wp-content/themes/orlenpaczka/img/logo.svg';

        $logo = '<img src="' . esc_url($logo_url) . '" 
                    style="height:30px; vertical-align:middle; margin-right:6px;">';

        return $logo . $label;
    }

    return $label;

}, 10, 2);





    require_once plugin_dir_path(__FILE__) . 'includes/class-orlenpaczka-shipping.php';



    add_filter('woocommerce_shipping_methods', function ($methods) {

        $methods['orlen_paczka'] = 'OrlenPaczka_Shipping';

        return $methods;

    });

}



add_action('admin_enqueue_scripts', 'orlen_paczka_enqueue_admin_styles');



function orlen_paczka_enqueue_admin_styles($hook) {

    if (strpos($hook, 'orlen') === false) return;



    wp_enqueue_style(

        'orlen-admin-style',

        plugin_dir_url(__FILE__) . 'assets/css/admin-style.css',

        [],

        '1.0'

    );

}





class Orlen_Auth_Helper {

    public static function get_credentials() {

        $auth = get_posts([

            'post_type' => 'orlen_auth',

            'numberposts' => 1

        ]);



        if (empty($auth)) {

            $post_id = wp_insert_post([

                'post_type' => 'orlen_auth',

                'post_title' => 'ORLEN Autoryzacja',

                'post_status' => 'publish'

            ]);

        } else {

            $post_id = $auth[0]->ID;

        }



        return [

            'partner_id' => sanitize_text_field(get_option('orlen_partner_id', '')),

            'partner_key' => sanitize_text_field(get_option('orlen_partner_key', '')),

        ];

    }



    public static function get_post_id() {

        $auth = get_posts([

            'post_type' => 'orlen_auth',

            'numberposts' => 1

        ]);



        if (!empty($auth)) {

            return $auth[0]->ID;

        }



        return wp_insert_post([

            'post_type' => 'orlen_auth',

            'post_title' => 'ORLEN Autoryzacja',

            'post_status' => 'publish'

        ]);

    }

}



add_action('plugins_loaded', 'orlen_check_woocommerce_loaded', 11);



function orlen_check_woocommerce_loaded() {

    if (!class_exists('WC_Shipping_Method')) {

        return; 

    }



    // Rejestracja klasy metody wysyłki

    add_action('woocommerce_shipping_init', 'orlen_load_shipping_class');

    function orlen_load_shipping_class() {

        require_once plugin_dir_path(__FILE__) . 'includes/class-orlenpaczka-shipping.php';

    }



    // Rejestracja metody w systemie WooCommerce

    add_filter('woocommerce_shipping_methods', 'orlen_register_shipping_method');

    function orlen_register_shipping_method($methods) {

        $methods['orlen_paczka'] = 'OrlenPaczka_Shipping';

        return $methods;

    }

}



// ============ Inicjalizacja generowanie etykiet ============

//require_once plugin_dir_path(__FILE__) . 'includes/class-label-generator.php';

add_action('plugins_loaded', 'orlen_init_label_generator');

function orlen_init_label_generator() {

    if (class_exists('Orlen_Label_Generator')) {

        new Orlen_Label_Generator();

    }

}



// ============ Inicjalizacja ustawień administracyjnych ============

//require_once plugin_dir_path(__FILE__) . 'includes/class-admin-settings.php';

add_action('plugins_loaded', 'orlen_paczka_init');

function orlen_paczka_init() {

    if (class_exists('Orlen_Paczka_Admin_Settings')) {

        new Orlen_Paczka_Admin_Settings();

    }

}



// ============ Inicjalizacja mapy ORLEN Paczka ============

// add_action('plugins_loaded', 'orlen_init_pickup_point_field');

// function orlen_init_pickup_point_field() {

//     require_once plugin_dir_path(__FILE__) . 'includes/class-orlen-paczka-pickup-point-field.php';



//     $credentials = get_option('orlen_credentials'); 

//     $token = isset($credentials['partner_key']) ? $credentials['partner_key'] : '';



//     if (!empty($token)) {

//         //new Orlen_Paczka_Pickup_Point_Field($token);

//     }

// }





// ============ Inicjalizacja mapy ORLEN Paczka ============

add_action('plugins_loaded', 'orlen_init_pickup_point_field');

function orlen_init_pickup_point_field() {

    $map_type = get_option('orlen_map_type'); 

   $map_token = get_option('orlen_map_token', '');





    if (empty($token)) return;



    // Wczytaj plik z klasami

    require_once plugin_dir_path(__FILE__) . 'includes/class-orlen-paczka-pickup-point-field.php';



    // Utwórz odpowiednią instancję w zależności od map_type

    if ($map_type === 'popup') {

        new Orlen_Paczka_Pickup_Point_Field_Popup($map_token);

    } elseif ($map_type === 'embedded') {

        new Orlen_Paczka_Pickup_Point_Field_Embedded($map_token);

    }

}







// Walidacja pola 

add_action('woocommerce_checkout_process', 'orlen_paczka_pickup_point_field_validation');

function orlen_paczka_pickup_point_field_validation() {

    $chosen_methods = WC()->session->get('chosen_shipping_methods');

    if (is_array($chosen_methods) && in_array('orlen_paczka', $chosen_methods)) {

        if (empty($_POST['orlen_paczka_pickup_point'])) {

            wc_add_notice(__('Proszę wybrać punkt odbioru z mapy.'), 'error');

        }

    }

}



// Zapis do meta zamówienia

add_action('woocommerce_checkout_update_order_meta', 'orlen_paczka_pickup_point_save_order_meta');

function orlen_paczka_pickup_point_save_order_meta($order_id) {

    if (!empty($_POST['orlen_paczka_pickup_point'])) {

        update_post_meta($order_id, '_orlen_paczka_pickup_point', sanitize_text_field($_POST['orlen_paczka_pickup_point']));

    }

}







// menu ORLEN Paczka do górnego paska WordPressa

add_action('admin_bar_menu', 'orlen_paczka_admin_bar_menu', 100);



function orlen_paczka_admin_bar_menu($wp_admin_bar) {

    

    if (!current_user_can('manage_options')) {

        return;

    }

   

    $wp_admin_bar->add_node([

        'id'    => 'orlen-paczka-top',

        'title' => '📦 ORLEN Paczka',

        'href'  => admin_url('admin.php?page=orlen-paczka-panel'),

        'meta'  => [

            'title' => 'Panel ORLEN Paczka'

        ]

    ]);



    $wp_admin_bar->add_node([

        'id'     => 'orlen-paczka-ustawienia',

        'parent' => 'orlen-paczka-top',

        'title'  => 'Dane autoryzacyjne',

        'href'   => admin_url('admin.php?page=orlen-auth-settings'),

    ]);



    $wp_admin_bar->add_node([

        'id'     => 'orlen-paczka-nadawca',

        'parent' => 'orlen-paczka-top',

        'title'  => 'Dane nadawcy',

        'href'   => admin_url('admin.php?page=orlen-sender-settings'),

    ]);



    $wp_admin_bar->add_node([

        'id'     => 'orlen-paczka-konf-cen',

        'parent' => 'orlen-paczka-top',

        'title'  => 'Konfiguracja cen',

        'href'   => admin_url('admin.php?page=orlen-shipping-config'),

    ]);



     $wp_admin_bar->add_node([

        'id'     => 'orlen-paczka-historia',

        'parent' => 'orlen-paczka-top',

        'title'  => 'Historia nadań',

        'href'   => admin_url('admin.php?page=orlen-shipping-history'),

    ]);

    

    $wp_admin_bar->add_node([

        'id'     => 'orlen-paczka-kurier',

        'parent' => 'orlen-paczka-top',

        'title'  => 'Historia zamówień kuriera',

        'href'   => admin_url('admin.php?page=orlen-paczka-pickup'),

    ]);



    $wp_admin_bar->add_node([

        'id'     => 'orlen-paczka-logi',

        'parent' => 'orlen-paczka-top',

        'title'  => 'Logi',

        'href'   => admin_url('admin.php?page=orlen-paczka-logs'),

    ]);



   

}





// Protokól pobieranie z edycji zamówienia 

add_action('wp_ajax_orlen_check_protocol', function() {

    $order_id = intval($_POST['order_id'] ?? 0);



    if (!$order_id) {

        wp_send_json_error(['message' => 'Brak ID zamówienia.']);

    }



    $protocols = get_post_meta($order_id, '_orlen_protocols', true);



    if (empty($protocols) || !is_array($protocols)) {

        wp_send_json_error(['message' => 'Brak protokołów dla tego zamówienia.']);

    }



    // Zwracamy tylko pierwszy protokół (lub wszystkie jeśli chcesz)

    $first = reset($protocols);



    wp_send_json_success([

        'protocol_number' => $first['protocol_number'] ?? '',

        'protocol_url'    => $first['protocol_url'] ?? '',

        'protocol_date'   => $first['protocol_date'] ?? ''

    ]);

});





//kod będzie automatycznie dodawał _orlen_paczka_packcode po zmianie statusu zamówienia na processing.

add_action('woocommerce_order_status_processing', 'generate_orlen_paczka_packcode');



function generate_orlen_paczka_packcode($order_id) {

    $existing_packcode = get_post_meta($order_id, '_orlen_paczka_packcode', true);

    if (!empty($existing_packcode)) {

        return;

    }



    $packcode = 'ORLEN-' . strtoupper(wp_generate_password(8, false, false));



    update_post_meta($order_id, '_orlen_paczka_packcode', $packcode);

}





$auth_posts = get_posts([

    'post_type' => 'orlen_auth',

    'numberposts' => 1

]);



$map_token = '';

if (!empty($auth_posts)) {

    $map_token = get_option('orlen_map_token', '');

}





add_action('admin_enqueue_scripts', function() {

    wp_enqueue_script(

        'orlen-label-ajax',

        plugin_dir_url(__FILE__) . 'assets/js/orlen-label.js',

        ['jquery'],

        '1.0',

        true

    );



    wp_localize_script('orlen-label-ajax', 'OrlenLabelAjax', [

        'ajax_url' => admin_url('admin-ajax.php'),

        'nonce'    => wp_create_nonce('orlen_label_nonce'),

    ]);

});





// AJAX: ustaw nadawcę od razu po kliknięciu

add_action('wp_ajax_orlen_update_sender', function(){

    check_ajax_referer('orlen_update_sender');



    $order_id  = intval($_POST['order_id']);

    $sender_id = sanitize_text_field($_POST['sender_id']);



    if (!$order_id) {

        wp_send_json_error('Brak ID zamówienia.');

    }



    $order = wc_get_order($order_id);

    if (!$order) {

        wp_send_json_error('Nie znaleziono zamówienia.');

    }



    if ($sender_id !== '') {

        update_post_meta($order_id, '_selected_store', $sender_id);

    } else {

        delete_post_meta($order_id, '_selected_store');

    }



    wp_send_json_success('Nadawca został zapisany.');

});





// Do dodawania przesyłki do zamówienia 

add_action('admin_enqueue_scripts', function($hook){

    if (!in_array($hook, ['post.php', 'post-new.php'], true)) return;

    global $post;

    if (empty($post) || $post->post_type !== 'shop_order') return;



    wp_enqueue_script(

        'orlen-admin-scripts',

        plugin_dir_url(__FILE__) . 'assets/js/orlen-admin.js',

        ['jquery'],

        '1.0.0',

        true

    );



    // Przekazanie AJAX URL i nonce

    wp_localize_script('orlen-admin-scripts', 'orlen_ajax', [

        'ajax_url' => admin_url('admin-ajax.php'),

        'nonce'    => wp_create_nonce('orlen_ajax_nonce')

    ]);

});





// AJAX – dodaj paczkę

add_action('wp_ajax_orlen_add_package', function(){

    check_ajax_referer('orlen_ajax_nonce', '_ajax_nonce');



    $order_id = intval($_POST['order_id'] ?? 0);

    $size = sanitize_text_field($_POST['size'] ?? '');

    $etykieta = sanitize_text_field($_POST['etykieta'] ?? '');

    $shipping_data = $_POST['shipping_data'] ?? [];

    $insurance = sanitize_text_field($_POST['insurance'] ?? '');

    $sender_order_type = sanitize_text_field($_POST['sender_order_type'] ?? '');

    $custom_comment = sanitize_text_field($_POST['custom_comment'] ?? '');



    if (!$order_id || !$size) wp_send_json_error('Brak danych.');



    $order = wc_get_order($order_id);

    if (!$order) wp_send_json_error('Nie znaleziono zamówienia.');











    // --- [NOWE] dane punktu z frontu (jeśli przesłane) ---

    $posted_pickup = isset($_POST['pickup_point']) ? sanitize_text_field(wp_unslash($_POST['pickup_point'])) : '';

    $posted_pickup_name = isset($_POST['pickup_point_name']) ? sanitize_text_field(wp_unslash($_POST['pickup_point_name'])) : '';

    $posted_pickup_full_raw = isset($_POST['pickup_point_full']) ? wp_unslash($_POST['pickup_point_full']) : '';



    $posted_pickup_full = '';

    if (!empty($posted_pickup_full_raw)) {

        $maybe = json_decode($posted_pickup_full_raw, true);

        if (json_last_error() === JSON_ERROR_NONE && is_array($maybe)) {

            $posted_pickup_full = wp_json_encode($maybe, JSON_UNESCAPED_UNICODE);

        } else {

            $posted_pickup_full = wp_json_encode($posted_pickup_full_raw);

        }

    }



    // --- [ISTNIEJĄCE META] dane punktu z bazy ---

    $pickup_point_name = get_post_meta($order_id, 'orlen_paczka_pickup_point_name', true);

    $pickup_point      = get_post_meta($order_id, 'orlen_paczka_pickup_point', true);

    $pickup_point_full = get_post_meta($order_id, 'orlen_paczka_pickup_point_data', true);



    // --- [PRIORYTET] jeśli przesłano nowe dane, nadpisz nimi stare ---

    if (!empty($posted_pickup)) {

        $pickup_point = $posted_pickup;

        update_post_meta($order_id, 'orlen_paczka_pickup_point', $pickup_point);

    }

    if (!empty($posted_pickup_name)) {

        $pickup_point_name = $posted_pickup_name;

        update_post_meta($order_id, 'orlen_paczka_pickup_point_name', $pickup_point_name);

    }

    if (!empty($posted_pickup_full)) {

        $pickup_point_full = $posted_pickup_full;

        update_post_meta($order_id, 'orlen_paczka_pickup_point_data', wp_slash($pickup_point_full));

    }









   // $pickup_point_name = get_post_meta($order_id, 'orlen_paczka_pickup_point_name', true);

   // $pickup_point      = get_post_meta($order_id, 'orlen_paczka_pickup_point', true);

    $config_id  = Orlen_Auth_Helper::get_post_id();

    $partner_id = sanitize_text_field(get_option('orlen_partner_id', ''));

    $selected_store = get_post_meta($order_id, '_selected_store', true);



    

    if (empty($selected_store)) {

    update_post_meta($order_id, '_selected_store', 0);

    $selected_store_1 = 0;

    }else {

        $selected_store_1 = $selected_store;

    }



    $entry = [

        'id'         => uniqid('op_', true),

        'size'       => $size,

        'etykieta'   => $etykieta,

        'first_name' => sanitize_text_field($shipping_data['first_name'] ?? ''),

        'last_name'  => sanitize_text_field($shipping_data['last_name'] ?? ''),

        'address_1'  => sanitize_text_field($shipping_data['address_1'] ?? ''),

        'address_2'  => sanitize_text_field($shipping_data['address_2'] ?? ''),

        'city'       => sanitize_text_field($shipping_data['city'] ?? ''),

        'postcode'   => sanitize_text_field($shipping_data['postcode'] ?? ''),

        'phone'      => sanitize_text_field($shipping_data['phone'] ?? ''),

        'email'      => sanitize_text_field($shipping_data['email'] ?? ''),

        'timestamp'  => time(),

        'insurance'  => $insurance,

        'sender_order_type' => $sender_order_type,

        'custom_comment' => $custom_comment,

        'pickup_point_name' => $pickup_point_name,

        'pickup_point'      => $pickup_point,

        'orlen_partner_id'  => $partner_id ?: '-',

        'sender_id' => $selected_store,

    ];



    add_post_meta(

        $order_id,

        '_orlen_paczka_size',

        wp_json_encode($entry, JSON_UNESCAPED_UNICODE)

    );



    wp_send_json_success(['entry' => $entry]);

});





// add_action('wp_ajax_orlen_add_package', function() {

//     check_ajax_referer('orlen_ajax_nonce', '_ajax_nonce');



//     $order_id = intval($_POST['order_id'] ?? 0);

//     $size = sanitize_text_field($_POST['size'] ?? '');

//     $etykieta = sanitize_text_field($_POST['etykieta'] ?? '');

//     $shipping_data = $_POST['shipping_data'] ?? [];

//     $insurance = sanitize_text_field($_POST['insurance'] ?? '');

//     $sender_order_type = sanitize_text_field($_POST['sender_order_type'] ?? '');

//     $custom_comment = sanitize_text_field($_POST['custom_comment'] ?? '');



//     if (!$order_id || !$size) wp_send_json_error('Brak danych.');



//     $order = wc_get_order($order_id);

//     if (!$order) wp_send_json_error('Nie znaleziono zamówienia.');



//     // --- [NOWE] dane punktu z frontu (jeśli przesłane) ---

//     $posted_pickup = isset($_POST['pickup_point']) ? sanitize_text_field(wp_unslash($_POST['pickup_point'])) : '';

//     $posted_pickup_name = isset($_POST['pickup_point_name']) ? sanitize_text_field(wp_unslash($_POST['pickup_point_name'])) : '';

//     $posted_pickup_full_raw = isset($_POST['pickup_point_full']) ? wp_unslash($_POST['pickup_point_full']) : '';



//     $posted_pickup_full = '';

//     if (!empty($posted_pickup_full_raw)) {

//         $maybe = json_decode($posted_pickup_full_raw, true);

//         if (json_last_error() === JSON_ERROR_NONE && is_array($maybe)) {

//             $posted_pickup_full = wp_json_encode($maybe, JSON_UNESCAPED_UNICODE);

//         } else {

//             $posted_pickup_full = wp_json_encode($posted_pickup_full_raw);

//         }

//     }



//     // --- [ISTNIEJĄCE META] dane punktu z bazy ---

//     $pickup_point_name = get_post_meta($order_id, 'orlen_paczka_pickup_point_name', true);

//     $pickup_point      = get_post_meta($order_id, 'orlen_paczka_pickup_point', true);

//     $pickup_point_full = get_post_meta($order_id, 'orlen_paczka_pickup_point_data', true);



//     // --- [PRIORYTET] jeśli przesłano nowe dane, nadpisz nimi stare ---

//     if (!empty($posted_pickup)) {

//         $pickup_point = $posted_pickup;

//         update_post_meta($order_id, 'orlen_paczka_pickup_point', $pickup_point);

//     }

//     if (!empty($posted_pickup_name)) {

//         $pickup_point_name = $posted_pickup_name;

//         update_post_meta($order_id, 'orlen_paczka_pickup_point_name', $pickup_point_name);

//     }

//     if (!empty($posted_pickup_full)) {

//         $pickup_point_full = $posted_pickup_full;

//         update_post_meta($order_id, 'orlen_paczka_pickup_point_data', wp_slash($pickup_point_full));

//     }



//     // --- reszta Twojego kodu bez zmian ---

//     $config_id  = Orlen_Auth_Helper::get_post_id();

//     $partner_id = sanitize_text_field(get_option('orlen_partner_id', ''));

//     $selected_store = get_post_meta($order_id, '_selected_store', true);



//     if (empty($selected_store)) {

//         update_post_meta($order_id, '_selected_store', 0);

//         $selected_store_1 = 0;

//     } else {

//         $selected_store_1 = $selected_store;

//     }



//     $entry = [

//         'id'         => uniqid('op_', true),

//         'size'       => $size,

//         'etykieta'   => $etykieta,

//         'first_name' => sanitize_text_field($shipping_data['first_name'] ?? ''),

//         'last_name'  => sanitize_text_field($shipping_data['last_name'] ?? ''),

//         'address_1'  => sanitize_text_field($shipping_data['address_1'] ?? ''),

//         'address_2'  => sanitize_text_field($shipping_data['address_2'] ?? ''),

//         'city'       => sanitize_text_field($shipping_data['city'] ?? ''),

//         'postcode'   => sanitize_text_field($shipping_data['postcode'] ?? ''),

//         'phone'      => sanitize_text_field($shipping_data['phone'] ?? ''),

//         'email'      => sanitize_text_field($shipping_data['email'] ?? ''),

//         'timestamp'  => time(),

//         'insurance'  => $insurance,

//         'sender_order_type' => $sender_order_type,

//         'custom_comment' => $custom_comment,

//         'pickup_point_name' => $pickup_point_name,

//         'pickup_point'      => $pickup_point,

//         'pickup_point_full' => $pickup_point_full,

//         'orlen_partner_id'  => $partner_id ?: '-',

//         'sender_id' => $selected_store,

//     ];



//     add_post_meta(

//         $order_id,

//         '_orlen_paczka_size',

//         wp_json_encode($entry, JSON_UNESCAPED_UNICODE)

//     );



//     wp_send_json_success(['entry' => $entry]);

// });







// AJAX – usuń paczkę i pliki z katalogu

// add_action('wp_ajax_orlen_remove_package', function(){ 

//     check_ajax_referer('orlen_ajax_nonce', '_ajax_nonce');



//     $order_id   = intval($_POST['order_id'] ?? 0);

//     $package_id = sanitize_text_field($_POST['package_id'] ?? '');



//     if (!$order_id || !$package_id) wp_send_json_error('Brak danych.');



//     $meta_entries = get_post_meta($order_id, '_orlen_paczka_size');

//     $found = false;

//     $pack_code = ''; // tu przechowamy kod paczki



//     foreach ($meta_entries as $entry) {

//         $data = json_decode($entry, true);

//         if ($data && isset($data['id']) && $data['id'] === $package_id) {

//             // jeśli w meta jest pack_code, zapisz go do usunięcia pliku

//             if (isset($data['pack_code'])) {

//                 $pack_code = $data['pack_code'];

//             }

//             delete_post_meta($order_id, '_orlen_paczka_size', $entry);

//             $found = true;

//             break;

//         }

//     }



//     if ($found && $pack_code) {

//         $filename = 'order-' . $order_id . '-' . $pack_code . '.pdf';

//         $file_path = WP_CONTENT_DIR . '/uploads/orlen-labels/' . $filename;



//         if (file_exists($file_path)) {

//             if (!@unlink($file_path)) {

//                 wp_send_json_error(['message' => 'Nie udało się usunąć pliku']);

//             }

//         }

//     }



//     if ($found) {

//         wp_send_json_success('Usunięto paczkę i powiązany plik.');

//     } else {

//         wp_send_json_error('Nie znaleziono paczki do usunięcia.');

//     }

// });

add_action('wp_ajax_orlen_remove_package', function() {

    check_ajax_referer('orlen_ajax_nonce', '_ajax_nonce');



    $order_id   = intval($_POST['order_id'] ?? 0);

    $package_id = sanitize_text_field($_POST['package_id'] ?? '');



    if (!$order_id || !$package_id) {

        wp_send_json_error('Brak danych.');

    }



    $meta_entries = get_post_meta($order_id, '_orlen_paczka_size', false);

    if (empty($meta_entries)) {

        wp_send_json_error('Brak paczek w tym zamówieniu.');

    }



    $new_meta = [];

    $found = false;

    $pack_code = '';



    foreach ($meta_entries as $entry) {

        $data = json_decode($entry, true);

        if (!$data) continue;



        if (isset($data['id']) && $data['id'] === $package_id) {

            // znaleziono paczkę do usunięcia

            $found = true;

            $pack_code = $data['pack_code'] ?? '';

            continue;

        }



        $new_meta[] = $data; // zachowaj pozostałe

    }



    // Usuń wszystkie i dodaj tylko te, które zostają

    delete_post_meta($order_id, '_orlen_paczka_size');

    foreach ($new_meta as $data) {

        add_post_meta($order_id, '_orlen_paczka_size', wp_slash(wp_json_encode($data, JSON_UNESCAPED_UNICODE)));

    }



    // usuń plik PDF (jeśli istnieje)

    if ($found && $pack_code) {

        $upload_dir = wp_upload_dir();

        $file_path = $upload_dir['basedir'] . '/orlen-labels/order-' . $order_id . '-' . $pack_code . '.pdf';

        if (file_exists($file_path)) {

            @unlink($file_path);

        }

    }



    if ($found) {

        wp_send_json_success('Usunięto paczkę i powiązany plik.');

    } else {

        wp_send_json_error('Nie znaleziono paczki do usunięcia.');

    }

});







add_action('wp_ajax_orlen_get_package_data', function() {

    check_ajax_referer('orlen_ajax_nonce', '_ajax_nonce');

    $order_id = intval($_POST['order_id'] ?? 0);

    $package_id = sanitize_text_field($_POST['package_id'] ?? '');

    if (!$order_id || !$package_id) wp_send_json_error('Brak danych.');



    $packages = get_post_meta($order_id, '_orlen_paczka_size', false);

    foreach ($packages as $pkg) {

        $p = json_decode($pkg, true);

        if ($p && $p['id'] === $package_id) wp_send_json_success($p);

    }



    wp_send_json_error('Nie znaleziono paczki.');

});





// AJAX edycja danych w paczce

add_action('wp_ajax_orlen_update_package', function() {

    check_ajax_referer('orlen_ajax_nonce', '_ajax_nonce');



    $order_id    = intval($_POST['order_id'] ?? 0);

    $package_id  = sanitize_text_field($_POST['package_id'] ?? '');

    $shipping_data = $_POST['shipping_data'] ?? [];

    $insurance   = sanitize_text_field($_POST['insurance'] ?? '');

    $sender_order_type = sanitize_text_field($_POST['sender_order_type'] ?? '');

    $custom_comment = sanitize_text_field($_POST['custom_comment'] ?? '');

    $size        = sanitize_text_field($_POST['size'] ?? '');

    $label_format = sanitize_text_field($_POST['etykieta'] ?? 'PDF'); 

    $pickup_point_name = sanitize_text_field($_POST['pickup_point_name'] ?? '');

    $pickup_point      = sanitize_text_field($_POST['pickup_point'] ?? '');



    if (!$order_id || !$package_id) {

        wp_send_json_error('Brak danych.');

    }



    $all_packages = get_post_meta($order_id, '_orlen_paczka_size', false);

    $found = false;



    foreach ($all_packages as $index => $package_json) {

        $package = json_decode($package_json, true);



        if ($package && isset($package['id']) && $package['id'] === $package_id) {



            if (!empty($package['pack_code'])) {

                $filename  = 'order-' . $order_id . '-' . $package['pack_code'] . '.pdf';

                $file_path = WP_CONTENT_DIR . '/uploads/orlen-labels/' . $filename;

                if (file_exists($file_path)) {

                    @unlink($file_path);

                }



                unset($package['pack_code'], $package['label_url']);

            }



            $package['first_name']     = sanitize_text_field($shipping_data['first_name'] ?? '');

            $package['last_name']      = sanitize_text_field($shipping_data['last_name'] ?? '');

            $package['address_1']      = sanitize_text_field($shipping_data['address_1'] ?? '');

            $package['address_2']      = sanitize_text_field($shipping_data['address_2'] ?? '');

            $package['city']           = sanitize_text_field($shipping_data['city'] ?? '');

            $package['postcode']       = sanitize_text_field($shipping_data['postcode'] ?? '');

            $package['phone']          = sanitize_text_field($shipping_data['phone'] ?? '');

            $package['email']          = sanitize_text_field($shipping_data['email'] ?? '');

            $package['insurance']      = $insurance;

            $package['sender_order_type'] = $sender_order_type;

            $package['custom_comment'] = $custom_comment;

            $package['size']           = $size;

            $package['etykieta']       = $label_format;

            $package['pickup_point_name'] = $pickup_point_name;

            $package['pickup_point']      = $pickup_point;



            $all_packages[$index] = wp_json_encode($package, JSON_UNESCAPED_UNICODE);



            $found = true;

            break;

        }

    }



    if ($found) {

        delete_post_meta($order_id, '_orlen_paczka_size');

        foreach ($all_packages as $pkg) {

            add_post_meta($order_id, '_orlen_paczka_size', $pkg);

        }



        wp_send_json_success('Zaktualizowano paczkę!');

    } else {

        wp_send_json_error('Nie znaleziono paczki.');

    }

});











//new Orlen_Paczka_Admin_Pickup($map_token);



global $orlen_admin_pickup;

$orlen_admin_pickup = new Orlen_Paczka_Admin_Pickup($map_token); 



$map_type = get_option('orlen_map_type'); 

if ($map_type && $map_token) {

    new Orlen_Paczka_Pickup_Point_Field($map_token);

}

new Orlen_Paczka_Shipping_History();