<?php



class OrlenPaczka_SOAP {

    public $client;

    public $wsdl;



    public function __construct($env = 'test') {

        $this->wsdl = $env === 'prod'

            ? 'https://api.orlenpaczka.pl/WebServicePwRProd/WebServicePwR.asmx?wsdl'

            : 'https://api-test.orlenpaczka.pl/WebServicePwR/WebServicePwR.asmx?WSDL';



        $this->client = new SoapClient($this->wsdl, [

            'trace' => true,

            'exceptions' => true,

        ]);

    }



    public function call($method, $params) {

        return $this->client->__soapCall($method, [$params]);

    }



     public function getLastRequest() {

        return $this->client->__getLastRequest();

    }



    public function getLastResponse() {

        return $this->client->__getLastResponse();

    }

    public function getWsdl() {

        return $this->wsdl;

    }

}

