<?php

if (!defined('ABSPATH')) exit;



class Orlen_Label_Generator {



    const MAX_WEIGHT = 20; // maksymalna dopuszczalna waga paczki



    /**

     * Zarejestruj hooki (AJAX).

     */

    public static function bootstrap() {

        add_action('wp_ajax_orlen_generate_labels', [__CLASS__, 'ajax_generate_labels']);

    }



    /**

     * Widok strony z tabelą + akcjami.

     */

    public static function render_settings_page() {



        // === Obsługa wymuszonego pobierania ZIP-a ===

        if (isset($_GET['orlen_download_zip'])) {

            $file = wp_upload_dir()['basedir'] . '/orlen-labels/orlen-etykiety.zip';

            if (file_exists($file)) {

                nocache_headers();

                header('Content-Type: application/zip');

                header('Content-Disposition: attachment; filename="orlen-etykiety.zip"');

                header('Content-Length: ' . filesize($file));

                flush();

                readfile($file);

                exit;

            } else {

                wp_die('Plik ZIP nie istnieje.');

            }

        }



        $nonce = wp_create_nonce('orlen_generate_labels_nonce');

        ?>



<?php

    }



public static function ajax_generate_labels() {

    // Sprawdzenie uprawnień

    if (!current_user_can('manage_woocommerce')) {

        wp_send_json(['success' => false, 'message' => 'Brak uprawnień.']);

    }



    // Sprawdzenie nonce

    $nonce = isset($_POST['nonce']) ? sanitize_text_field($_POST['nonce']) : '';

    if (!wp_verify_nonce($nonce, 'orlen_generate_labels_nonce')) {

        wp_send_json(['success' => false, 'message' => 'Błędny token bezpieczeństwa.']);

    }



    $order_ids = [];

    if (!empty($_POST['order_ids'])) {

        $decoded = json_decode(stripslashes($_POST['order_ids']), true);

        if (is_array($decoded)) {

            $order_ids = array_map('intval', $decoded);

        }

    }



    // Jeśli brak konkretnych ID, pobieramy ostatnie 20 zamówień ORLEN Paczka

    if (empty($order_ids)) {

        $orders = wc_get_orders([

            'limit'   => 20,

            'orderby' => 'date',

            'order'   => 'DESC',

        ]);

        foreach ($orders as $o) {

            foreach ($o->get_shipping_methods() as $m) {

                if (strpos($m->get_method_id(), 'orlen_paczka') !== false) {

                    $order_ids[] = $o->get_id();

                    break;

                }

            }

        }

    }



    $order_ids = array_unique(array_filter($order_ids));

    if (empty($order_ids)) {

        wp_send_json(['success' => false, 'message' => 'Brak zamówień ORLEN do przetworzenia.']);

    }



    $generated = 0;

    $errors = [];

    $generated_labels = [];



    foreach ($order_ids as $order_id) {

        $order = wc_get_order($order_id);

        if (!$order) {

            $errors[] = "#$order_id: nie znaleziono zamówienia";

            continue;

        }



        $has_orlen = false;

        foreach ($order->get_shipping_methods() as $method) {

            if (strpos($method->get_method_id(), 'orlen_paczka') !== false) {

                $has_orlen = true;

                break;

            }

        }

        if (!$has_orlen) {

            $errors[] = "#{$order->get_order_number()}: nie jest ORLEN Paczka";

            continue;

        }



        try {

            $res = self::generate_label_for_order($order_id);

            if ($res) {

                $generated++;

                $generated_labels[$order_id] = $res;

            } else {

                $errors[] = "#{$order->get_order_number()}: błąd generowania etykiety";

            }

        } catch (Exception $e) {

            $errors[] = "#{$order->get_order_number()}: " . $e->getMessage();

        }

    }



    if ($generated > 0) {

        $msg = "Wygenerowano etykiety dla {$generated} zamówień.";

        if (!empty($errors)) {

            $msg .= " Część niepowodzeń: " . implode('; ', $errors);

        }

        wp_send_json(['success' => true, 'message' => $msg, 'labels' => $generated_labels]);

    } else {

        $msg = "Nie wygenerowano etykiet. " . (!empty($errors) ? implode('; ', $errors) : '');

        wp_send_json(['success' => false, 'message' => $msg]);

    }

}







    /**

     * Generowanie etykiety dla pojedynczego zamówienia  Generowanie etykiety (ListTwo) dla zamówienia

     */

   

   public static function generate_label_for_order($order_id, $package_id = '', $package_data = null, $label_format = null)

{

    $order = wc_get_order($order_id);

    if (!$order) {

        Orlen_Logger::error("Nie znaleziono zamówienia #$order_id");

        return false;

    }



    $auth = Orlen_Auth_Helper::get_credentials();



    if (!$package_data) {

        $packages = get_post_meta($order_id, '_orlen_paczka_size', false);

        foreach ($packages as $p) {

            $decoded = json_decode($p, true);

            if (!$decoded || empty($decoded['id'])) continue;

            if ((string)$decoded['id'] === (string)$package_id) {

                $package_data = $decoded;

                break;

            }

        }

        if (!$package_data) {

            throw new Exception('Nie znaleziono paczki o podanym ID.');

        }

    }



    $selected_index = get_post_meta($order_id, '_selected_store', true);

    $senders = get_option('orlen_senders', []);

    if (empty($selected_index) && !empty($senders)) {

        reset($senders);

        $selected_index = key($senders);

    }



    $sender = $senders[$selected_index] ?? (!empty($senders) ? $senders[0] : [

        'name'=>'','street'=>'','building'=>'','city'=>'','postcode'=>'','country'=>'',

        'firstname'=>'','lastname'=>'','phone'=>'','email'=>''

    ]);



    $point_code = get_post_meta($order_id, 'orlen_paczka_pickup_point', true);

    if (empty($point_code)) {

        $order->add_order_note("❌ Brak kodu punktu ORLEN Paczka.");

        return false;

    }



    $receiverPhone = preg_replace('/\D/', '', $order->get_billing_phone());

    if (strlen($receiverPhone) === 11 && substr($receiverPhone, 0, 2) === '48') $receiverPhone = substr($receiverPhone, 2);

    $senderPhone = preg_replace('/\D/', '', $sender['phone']);

    if (strlen($senderPhone) === 11 && substr($senderPhone, 0, 2) === '48') $senderPhone = substr($senderPhone, 2);



    $wp_version = get_bloginfo('version');

    $wc_version = defined('WC_VERSION') ? WC_VERSION : '0';

    $plugins = get_plugins();

    $plugin_file = 'orlen-paczka/orlen-paczka.php';

    $plugin_version = $plugins[$plugin_file]['Version'] ?? '1.0.0';

    $transfer_description = sprintf('WP%s-WC%s-OP%s', $wp_version, $wc_version, $plugin_version);



    $businessPack = [

        'DestinationCode'      => $package_data['pickup_point'],

        'BoxSize'              => $package_data['size'] ?? 'M',

        'PackValue'            => $package_data['value'] ?? 0,

        'CashOnDelivery'       => !empty($package_data['cod']) ? 'Y' : 'N',

        'AmountCashOnDelivery' => $package_data['cod_amount'] ?? 0,

        'Insurance'            => !empty($package_data['insurance']) ? 'Y' : 'N',

        'InsuranceValue'       => $package_data['insurance'] ?? 0,

        'EMail'                => $package_data['email'] ?? $order->get_billing_email(),

        'FirstName'            => $package_data['first_name'] ?? $order->get_billing_first_name(),

        'LastName'             => $package_data['last_name'] ?? $order->get_billing_last_name(),

        'CompanyName'          => $package_data['company'] ?? '',

        'StreetName'           => $package_data['address_1'] ?? $order->get_billing_address_1(),

        'BuildingNumber'       => $package_data['address_2'] ?? '',

        'City'                 => $package_data['city'] ?? $order->get_billing_city(),

        'PostCode'             => $package_data['postcode'] ?? $order->get_billing_postcode(),

        'PhoneNumber'          => $package_data['phone'] ?? $receiverPhone,

        'SenderEMail'          => $sender['email'],

        'SenderFirstName'      => $sender['firstname'],

        'SenderLastName'       => $sender['lastname'],

        'SenderCompanyName'    => $sender['name'] ?? '',

        'SenderStreetName'     => $sender['street'],

        'SenderBuildingNumber' => $sender['building'],

        'SenderCity'           => $sender['city'],

        'SenderPostCode'       => $sender['postcode'],

        'SenderPhoneNumber'    => $senderPhone,

        'SenderOrders'         => $package_data['sender_order_type'] === 'wlasny_opis'

                                    ? $package_data['custom_comment']

                                    : $order->get_id(),

        'PrintAdress'          => 1,

        'PrintType'            => 1,

        'TransferDescription'  => $transfer_description,

    ];



    $format = $label_format ?? 'PDF';

    $params = [

        'PartnerID'  => $auth['partner_id'],

        'PartnerKey' => $auth['partner_key'],

        'Format'     => $format,

        'BusinessPackList' => ['BusinessPack' => [$businessPack]],

    ];



    try {

        $env = get_option('orlen_env', 'test');

        $soap = new OrlenPaczka_SOAP($env);

        $response = $soap->client->__soapCall('GenerateLabelBusinessPackListTwo', [$params]);



        $soapRequestXml = $soap->client->__getLastRequest();

        $soapResponseXml = $soap->client->__getLastResponse();



         if ($soapRequestXml) {

            $dom = new DOMDocument('1.0', 'UTF-8');

            $dom->preserveWhiteSpace = false;

            $dom->formatOutput = true;

            try { $dom->loadXML($soapRequestXml); Orlen_Logger::info("SOAP REQUEST dla zamówienia #$order_id:\n" . $dom->saveXML()); } catch (Exception $e) { Orlen_Logger::info("SOAP REQUEST (raw) dla #$order_id:\n" . $soapRequestXml); }

        }

        if ($soapResponseXml) {

            $dom = new DOMDocument('1.0', 'UTF-8');

            $dom->preserveWhiteSpace = false;

            $dom->formatOutput = true;

            try { $dom->loadXML($soapResponseXml); Orlen_Logger::info("SOAP RESPONSE dla zamówienia #$order_id:\n" . $dom->saveXML()); } catch (Exception $e) { Orlen_Logger::info("SOAP RESPONSE (raw) dla #$order_id:\n" . $soapResponseXml); }

        }



       // Parsowanie błędów

        // Parsowanie odpowiedzi SOAP

        $xml = @simplexml_load_string($soapResponseXml);

        $errors = [];

        $pack_code = '';

        $label_base64 = '';

        $url = '';



        if ($xml !== false) {

            $xml->registerXPathNamespace('diffgr', 'urn:schemas-microsoft-com:xml-diffgram-v1');



            // --- Odczyt błędów ---

            $errNodes = $xml->xpath('//Err');

            $errDesNodes = $xml->xpath('//ErrDes');



            if (!empty($errNodes)) {

                foreach ($errNodes as $i => $errNode) {

                    $code = (string)$errNode;

                    $desc = isset($errDesNodes[$i]) ? (string)$errDesNodes[$i] : '';

                    $errors[] = ['code' => $code, 'desc' => $desc];

                }

            }



            // --- Odczyt PackCode ---

            $nodes = $xml->xpath('//*[local-name()="PackCode_RUCH"]') ?: $xml->xpath('//*[contains(local-name(), "PackCode")]');

            if (!empty($nodes)) {

                $pack_code = (string)$nodes[0];

            }



            // --- Odczyt LabelData (PDF) ---

            $labelNodes = $xml->xpath('//*[local-name()="LabelData"]');

            if (!empty($labelNodes)) {

                $label_base64 = (string)$labelNodes[0];

            }

        }



        // --- Jeśli etykieta istnieje, zapisz ją ---

        if (!empty($label_base64)) {

            $upload_dir = wp_upload_dir();

            $path = $upload_dir['basedir'] . "/orlen-labels/order-{$order_id}-{$pack_code}.pdf";

            wp_mkdir_p(dirname($path));

            file_put_contents($path, base64_decode($label_base64));

            $url = $upload_dir['baseurl'] . "/orlen-labels/order-{$order_id}-{$pack_code}.pdf";

        }



        // --- Jeśli API zwróciło błędy i nie udało się wygenerować etykiety ---

        if (!empty($errors) && (empty($pack_code) || empty($url))) {

            foreach ($errors as $err) {

                $errCode = esc_html($err['code']);

                $errDesc = esc_html($err['desc']);

                $message = "❌ Błąd ORLEN Paczka [Err={$errCode}]: {$errDesc}";

                Orlen_Logger::warning("{$message} dla zamówienia #{$order_id}");

                $order->add_order_note($message);

            }



               return [

        'errors' => $errors,

        'messages' => $messages,

        'inactive_point' => $inactivePointError,

        'error' => true

    ];

        }



        // --- Jeśli wszystko OK ---

        return [

            'label_url' => $url,

            'packcode'  => $pack_code,

            'errors'    => $errors,

            'error'     => false

        ];





    } catch (SoapFault $sf) {

        Orlen_Logger::error("SOAP Fault podczas generowania etykiety #$order_id: " . $sf->getMessage());

        $order->add_order_note("Błąd SOAP ORLEN Paczka: " . $sf->getMessage());

        return false;

    } catch (Exception $e) {

        Orlen_Logger::error("Błąd generowania etykiety dla #$order_id: " . $e->getMessage());

        $order->add_order_note("Błąd generowania etykiety ORLEN Paczka: " . $e->getMessage());

        return false;

    }

}













// Bedzie to do usunięcia !!!!!

//Generowanie etykiet dla wielu przesyłek

public static function generate_labels_for_packages($order_id, $package_id = '', $package_data = null, $label_format) {

    $order = wc_get_order($order_id);

    if (!$order) {

        Orlen_Logger::error("Nie znaleziono zamówienia #$order_id");

        return false;

    }



    $auth = Orlen_Auth_Helper::get_credentials();



    $packages = [];

    if ($package_data) {

        $packages[] = $package_data;

    } elseif (!empty($package_id)) {

        $all = get_post_meta($order_id, '_orlen_paczka_size', false);

        foreach ($all as $p) {

            $decoded = json_decode($p, true);

            if ($decoded && (string)$decoded['id'] === (string)$package_id) {

                $packages[] = $decoded;

                break;

            }

        }

    } else {

        $all = get_post_meta($order_id, '_orlen_paczka_size', false);

        foreach ($all as $p) {

            $decoded = json_decode($p, true);

            if ($decoded && !empty($decoded['id'])) {

                $packages[] = $decoded;

            }

        }

    }



    if (empty($packages)) {

        return false;

    }



    $selected_index = get_post_meta($order_id, '_selected_store', true);

    $senders = get_option('orlen_senders', []);

    if (empty($selected_index) && !empty($senders)) {

        reset($senders);

        $selected_index = key($senders);

    }

    $sender = $senders[$selected_index] ?? (!empty($senders) ? $senders[0] : [

        'name'=>'','street'=>'','building'=>'','city'=>'','postcode'=>'','country'=>'',

        'firstname'=>'','lastname'=>'','phone'=>'','email'=>''

    ]);



    $receiverPhone = preg_replace('/\D/', '', $order->get_billing_phone());

    $senderPhone   = preg_replace('/\D/', '', $sender['phone'] ?? '');



    $wp_version = get_bloginfo('version');                       

    $wc_version = defined('WC_VERSION') ? WC_VERSION : '0';      



    $plugins = get_plugins();

    $plugin_file = 'orlen-paczka-30-07/orlen-paczka.php'; 

    $plugin_version = isset($plugins[$plugin_file]['Version']) ? $plugins[$plugin_file]['Version'] : '0.0';                                  



    $transfer_description = sprintf('WP%s-WC%s-OP%s', $wp_version, $wc_version, $plugin_version);



    $businessPackList = ['BusinessPack' => []];

    foreach ($packages as $i => $decoded) {

        $businessPackList['BusinessPack'][$i] = [

            'DestinationCode'      => $decoded['pickup_point'],

            'BoxSize'              => $decoded['size'] ?? 'M',

            'PackValue'            => $decoded['value'] ?? 0,

            'CashOnDelivery'       => !empty($decoded['cod']) ? 'Y' : 'N',

            'AmountCashOnDelivery' => !empty($decoded['cod_amount']) ? $decoded['cod_amount'] : 0,

            'Insurance'            => !empty($decoded['insurance']) ? 'Y' : 'N',

            'InsuranceValue'       => $decoded['insurance'] ?? 0,

            'EMail'                => $decoded['email'] ?? $order->get_billing_email(),

            'FirstName'            => $decoded['first_name'] ?? $order->get_billing_first_name(),

            'LastName'             => $decoded['last_name'] ?? $order->get_billing_last_name(),

            'CompanyName'          => $decoded['company'] ?? '',

            'StreetName'           => $decoded['address_1'] ?? $order->get_billing_address_1(),

            'BuildingNumber'       => $decoded['address_2'] ?? '',

            'City'                 => $decoded['city'] ?? $order->get_billing_city(),

            'PostCode'             => $decoded['postcode'] ?? $order->get_billing_postcode(),

            'PhoneNumber'          => $decoded['phone'] ?? $receiverPhone,

            'SenderEMail'          => $sender['email'],

            'SenderFirstName'      => $sender['firstname'],

            'SenderLastName'       => $sender['lastname'],

            'SenderCompanyName'    => $sender['name'] ?? '',

            'SenderStreetName'     => $sender['street'],

            'SenderBuildingNumber' => $sender['building'],

            'SenderCity'           => $sender['city'],

            'SenderPostCode'       => $sender['postcode'],

            'SenderPhoneNumber'    => $senderPhone,

            'SenderOrders'         => $decoded['sender_order_type'] === 'wlasny_opis'

                                    ? $decoded['custom_comment']

                                    : $order->get_id(),

            'PrintAdress'          => 1,

            'PrintType'            => 1,

            'TransferDescription'  => $transfer_description,

        ];        

    }



    $format = $label_format;

    $params = [

        'PartnerID'  => $auth['partner_id'],

        'PartnerKey' => $auth['partner_key'],

        'Format'     => $format,

        'BusinessPackList' => $businessPackList

    ];



    try {

        $env = get_option('orlen_env', 'test');

        $soap = new OrlenPaczka_SOAP($env);



        if (!$soap || !isset($soap->client)) {

            throw new Exception('Nie udało się utworzyć klienta SOAP.');

        }



        $response = $soap->client->__soapCall('GenerateLabelBusinessPackListTwo', [$params]);



        $soapRequestXml = $soap->client->__getLastRequest();

        $soapResponseXml = $soap->client->__getLastResponse();



        if ($soapRequestXml) {

            $dom = new DOMDocument('1.0', 'UTF-8');

            $dom->preserveWhiteSpace = false;

            $dom->formatOutput = true;

            try { $dom->loadXML($soapRequestXml); Orlen_Logger::info("SOAP REQUEST dla zamówienia #$order_id:\n" . $dom->saveXML()); } catch (Exception $e) { Orlen_Logger::info("SOAP REQUEST (raw) dla #$order_id:\n" . $soapRequestXml); }

        }

        if ($soapResponseXml) {

            $dom = new DOMDocument('1.0', 'UTF-8');

            $dom->preserveWhiteSpace = false;

            $dom->formatOutput = true;

            try { $dom->loadXML($soapResponseXml); Orlen_Logger::info("SOAP RESPONSE dla zamówienia #$order_id:\n" . $dom->saveXML()); } catch (Exception $e) { Orlen_Logger::info("SOAP RESPONSE (raw) dla #$order_id:\n" . $soapResponseXml); }

        }



        $results = [];



        if ($soapResponseXml) {

            $xml = @simplexml_load_string($soapResponseXml);

            if ($xml !== false) {

                $packcodes = $xml->xpath('//*[local-name()="PackCode_RUCH"]');

                $labelNodes = $xml->xpath('//*[local-name()="LabelData"]');



                foreach ($packcodes as $idx => $pc) {

                    $packcode = (string)$pc;

                    $label_base64 = $labelNodes[$idx] ?? '';

                    $url = '';



                    if (!empty($label_base64)) {

                        $upload_dir = wp_upload_dir();



                        $ext_map = [

                            'PDF'   => 'pdf',

                            'PDF10' => 'pdf',

                            'EPL'   => 'epl',

                            'ZPL'   => 'zpl'

                        ];

                        $ext = $ext_map[strtoupper($label_format)] ?? 'pdf';



                        $file_name = "order-{$order_id}-{$packcode}.{$ext}";

                        $path = $upload_dir['basedir'] . "/orlen-labels/{$file_name}";

                        wp_mkdir_p(dirname($path));

                        file_put_contents($path, base64_decode($label_base64));



                        $url = $upload_dir['baseurl'] . "/orlen-labels/{$file_name}";



                        update_post_meta($order_id, '_orlen_paczka_label_url', $url);

                        update_post_meta($order_id, '_orlen_paczka_label_date', current_time('mysql'));



                        $all_packages = get_post_meta($order_id, '_orlen_paczka_size', false);

                        foreach ($all_packages as $key => $json) {

                            $decoded = json_decode($json, true);

                            if ($decoded && $decoded['id'] === $packages[$idx]['id']) {

                                $decoded['pack_code'] = $packcode;

                                $decoded['label_url'] = $url;

                                update_post_meta($order_id, '_orlen_paczka_size', json_encode($decoded, JSON_UNESCAPED_UNICODE), $json);

                                break;

                            }

                        }

                    }



                    $results[] = [

                        'packcode' => $packcode,

                        'url'      => $url,

                    ];

                }

            } else {

                Orlen_Logger::warning("Nie udało się sparsować XML SOAP dla zamówienia #$order_id");

            }

        }



        return $results;

    } catch (Exception $e) {

        Orlen_Logger::error("Błąd bulk etykiet dla #$order_id: " . $e->getMessage());

        return false;

    }

}





}



// Zainicjuj hooki AJAX

Orlen_Label_Generator::bootstrap();