<?php



if (!defined('ABSPATH')) exit;



class Orlen_API_Client {

    private $soap;

    private $partner_id;

    private $partner_key;



    public function __construct($env = 'prod') {

        $this->soap = new OrlenPaczka_SOAP($env);



        // Pobierz dane autoryzacyjne

        $auth = Orlen_Auth_Helper::get_credentials();

        $this->partner_id = $auth['partner_id'];

        $this->partner_key = $auth['partner_key'];

    }



    public function call($method, $additional_params = []) {

        if (empty($this->partner_id) || empty($this->partner_key)) {

            $msg = 'Brak PartnerID lub PartnerKey przy próbie wywołania ' . $method;

            Orlen_Logger::error($msg);

            return new WP_Error('orlen_api_auth', $msg);

        }



        $params = array_merge([

            'PartnerID'  => $this->partner_id,

            'PartnerKey' => $this->partner_key,

        ], $additional_params);



        Orlen_Logger::info("Wywołanie SOAP: {$method} - Parametry: " . json_encode($params));



        try {

            $response = $this->soap->call($method, $params);



            Orlen_Logger::info("Odpowiedź SOAP dla {$method}: " . json_encode($response));



            return $response;

        } catch (Exception $e) {

            Orlen_Logger::error("Błąd SOAP ({$method}): " . $e->getMessage());

            return new WP_Error('orlen_api_error', $e->getMessage());

        }

    }

}