<?php



class Orlen_Paczka_Admin_Settings {

     

    public static function render_logs_page() {

       

    ?>

<div class="wrap orlen-box">



    <h1 class="orlen-logo">

        <span class="logo-title">

            <span class="logo-icon"></span>

            Logi

        </span>

        <a href="<?php echo admin_url('admin.php?page=orlen-paczka-panel'); ?>" class="orlen-help-link">

            <i class="dashicons dashicons-info"></i>

            <span>Pomoc</span>

        </a>

    </h1>



    <?php $current_page = $_GET['page'] ?? ''; ?>

    <div class="orlen-icon-links">

        <a href="<?php echo admin_url('admin.php?page=orlen-auth-settings'); ?>"

            class="<?php echo $current_page === 'orlen-auth-settings' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-lock"></i>

            <span>Dane autoryzacyjne</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-sender-settings'); ?>"

            class="<?php echo $current_page === 'orlen-sender-settings' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-admin-users"></i>

            <span>Dane nadawcy</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-shipping-config'); ?>"

            class="<?php echo $current_page === 'orlen-shipping-config' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-admin-generic"></i>

            <span>Konfiguracja cen</span>

        </a>



                <a href="<?php echo admin_url('admin.php?page=orlen-shipping-history'); ?>"

            class="<?php echo $current_page === 'orlen-shipping-history' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-list-view"></i>

            <span>Historia nadań</span>

        </a>

        

        <a href="<?php echo admin_url('admin.php?page=orlen-paczka-pickup'); ?>"

            class="<?php echo $current_page === 'orlen-paczka-pickup' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-location-alt"></i>

            <span>Historia zamówień kuriera</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-paczka-logs'); ?>"

            class="<?php echo $current_page === 'orlen-paczka-logs' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-visibility"></i>

            <span>Logi</span>

        </a>

    </div>





    <?php

$upload_dir = wp_upload_dir();

$log_file = $upload_dir['basedir'] . '/orlen-logs/orlen-logs.log';



if (

    isset($_POST['orlen_clear_log']) &&

    current_user_can('manage_options') &&

    check_admin_referer('orlen_clear_log_action', 'orlen_clear_log_nonce')

) {

    file_put_contents($log_file, '');

    echo '<div class="updated"><p>Log został wyczyszczony.</p></div>';

}



$selected_level = $_GET['log_level'] ?? '';

$selected_date  = $_GET['log_date'] ?? '';



echo '<form method="get" style="margin-bottom:20px;">';

echo '<input type="hidden" name="page" value="orlen-paczka-logs" />';



echo '<label for="log_level">Poziom: </label>';

echo '<select name="log_level" id="log_level">';

echo '<option value="">– wszystkie –</option>';

foreach (['INFO', 'WARNING', 'ERROR'] as $level) {

    $selected = $selected_level === $level ? 'selected' : '';

    echo "<option value='{$level}' {$selected}>{$level}</option>";

}

echo '</select> ';



echo '<label for="log_date"> Data (YYYY-MM-DD): </label>';

echo '<input type="text" name="log_date" id="log_date" value="' . esc_attr($selected_date) . '" placeholder="np. 2025-05-27" /> ';



submit_button('Filtruj', 'secondary', '', false);

echo '</form>';



if (!file_exists($log_file)) {

    echo '<p><em>Brak pliku logów.</em></p></div>';

    return;

}



$log_content = file_get_contents($log_file);



if (!$log_content) {

    echo '<p><em>Plik logów jest pusty.</em></p>';

} else {



    preg_match_all('/\[\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}\] \[[A-Z]+\](.*?)(?=(\[\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}\] \[[A-Z]+\])|$)/si', $log_content, $matches);

    $entries = array_map('trim', $matches[0]);



    $filtered = array_filter($entries, function ($entry) use ($selected_level, $selected_date) {

        if (empty($selected_level) && empty($selected_date)) {

            return true;

        }



        if (!empty($selected_level)) {

            if (stripos($entry, '[' . strtoupper($selected_level) . ']') === false) {

                return false;

            }

        }



        if (!empty($selected_date)) {

            if (stripos($entry, $selected_date) === false) {

                return false;

            }

        }



        return true;

    });



    // Odwróć kolejność — najnowsze na górze

    //$filtered = array_reverse(array_values($filtered));



    // Maskowanie LabelData i PartnerKey w XML

    $filtered = array_map(function($entry) {

        $entry = preg_replace('#<LabelData\b[^>]*>.*?</LabelData>#is', '[LabelData removed]', $entry);

        $entry = preg_replace_callback('#<([^:>]+:)?PartnerKey\b[^>]*>(.*?)</([^:>]+:)?PartnerKey>#is', function($m) {

            $val = trim($m[2]);

            return '<' . ($m[1] ?? '') . 'PartnerKey>' . str_repeat('*', max(3, strlen($val))) . '</' . ($m[3] ?? '') . 'PartnerKey>';

        }, $entry);

        return $entry;

    }, $filtered);



    if (empty($filtered)) {

        echo '<p><em>Brak wpisów spełniających kryteria filtrowania.</em></p>';

    } else {

        echo '<textarea readonly style="width:100%; height:600px; font-family:monospace;">' .

            esc_textarea(implode("\n\n======================\n\n", $filtered)) .

            '</textarea>';

    }

}



echo '<form method="post" style="margin-top:20px;">';

wp_nonce_field('orlen_clear_log_action', 'orlen_clear_log_nonce');

submit_button('Wyczyść log', 'delete', 'orlen_clear_log');

echo '</form>';

        echo '</div>';



    }

        

}