﻿using Microsoft.IdentityModel.Tokens;
using System.Text;

namespace PackEventNotifierOAuth2Example.Models;

public class JwtOptions
{
    public string Issuer { get; set; } = string.Empty;
    public string Audience { get; set; } = string.Empty;
    public string Key
    {
        get { return key; }
        set
        {
            key = value;
            KeyBytes = Encoding.UTF8.GetBytes(key);

            SymmetricSecurityKey = new SymmetricSecurityKey(KeyBytes);
            SigningCredentials = new SigningCredentials(SymmetricSecurityKey, SecurityAlgorithms.HmacSha256Signature);
        }
    }
    public byte[] KeyBytes { get; private set; } = [];
    public SymmetricSecurityKey SymmetricSecurityKey { get; private set; } = null!;
    public SigningCredentials SigningCredentials { get; private set; } = null!;
    public int ExpirationSeconds
    {
        get { return expirationSeconds; }
        set
        {
            expirationSeconds = value;
            Expiration = TimeSpan.FromSeconds(expirationSeconds);
        }
    }
    public TimeSpan Expiration { get; private set; }

    private string key = "";
    private int expirationSeconds = 0;
}