﻿namespace PackEventNotifierBasicExample.Services;

public class FrontendData
{
    private bool acceptPackEventNotifications = true;
    public bool AcceptPackEventNotifications
    {
        get { return acceptPackEventNotifications; }
        set
        {
            acceptPackEventNotifications = value;
            description = acceptPackEventNotifications ? "OK    " : "REJECT";
        }
    }

    private string description = "OK    ";
    public string Description
    {
        get { return description; }
    }

    public List<string> ReceivedNotifications = new();

    public void AddPackNotification(string packNotification)
    {
        ReceivedNotifications.Insert(0, packNotification);
        if (ReceivedNotifications.Count > 200)
        {
            ReceivedNotifications.Remove(ReceivedNotifications.Last());
        }
    }
}
