using Microsoft.AspNetCore.Authentication;
using Microsoft.AspNetCore.Authorization;
using PackEventNotifierBasicExample;
using PackEventNotifierBasicExample.Models;
using PackEventNotifierBasicExample.Services;
using System.Text;
using System.Text.Json;

#region Not required, data used for Frontend
FrontendData frontendData = new();
#endregion

var builder = WebApplication.CreateBuilder(args);
builder.Services.AddAuthentication()
    .AddScheme<AuthenticationSchemeOptions, BasicAuthenticationHandler>(
        "SessionTokens",
        opts => { }
    );
builder.Services.AddAuthorization(options =>
{
    options.DefaultPolicy = new AuthorizationPolicyBuilder()
        .AddAuthenticationSchemes("SessionTokens")
        .RequireAuthenticatedUser()
        .Build();
});

var app = builder.Build();
app.UseAuthentication();
app.UseAuthorization();

app.MapPost("/notification", [Authorize] async (HttpRequest request) =>
{
    var body = await new StreamReader(request.Body).ReadToEndAsync();
    var deserialized = JsonSerializer.Deserialize<PackEventNotification>(body);

    // PL: obsuga notyfikacji np. zapis do bazy
    // EN: process notification ex. save to database

    var toLog = (deserialized?.PackCode == 0) ? body : (deserialized?.ToString() ?? "");
    var msg = $"{DateTime.Now:u} {frontendData.Description} {toLog}";
    frontendData.AddPackNotification(msg);
    return frontendData.AcceptPackEventNotifications ? Results.Ok() : Results.NotFound();
});

#region Not required, data used for Frontend
app.MapGet("/", () =>
{
    var manual = File.ReadAllText("Manual.html");
    return Results.Content(manual, "text/html");
});

app.MapGet("/received", () =>
{
    return Results.Content(string.Join("<br/>", frontendData.ReceivedNotifications), "text/html");
});

app.MapPost("/accept", async (HttpRequest request) =>
{
    frontendData.AcceptPackEventNotifications = await new StreamReader(request.Body).ReadToEndAsync() == "True";
});

app.MapGet("/postman", (string link) =>
{
    var fileName = "OrlenPaczkaPackEventNotifierExampleBasic.postman_collection.json";
    var content = File.ReadAllText(fileName).Replace("https://localhost:7047/", link);
    return Results.File(Encoding.UTF8.GetBytes(content), "text/json", $"{fileName}");

});
#endregion

app.Run();