﻿using Microsoft.AspNetCore.Authentication;
using Microsoft.Extensions.Options;
using Microsoft.Extensions.Primitives;
using System.Security.Claims;
using System.Text;
using System.Text.Encodings.Web;

namespace PackEventNotifierBasicExample;

public class BasicAuthenticationHandler : AuthenticationHandler<AuthenticationSchemeOptions>
{
    public BasicAuthenticationHandler(IOptionsMonitor<AuthenticationSchemeOptions> options, ILoggerFactory logger, UrlEncoder encoder, ISystemClock clock) : base(options, logger, encoder, clock)
    {
    }

    protected override Task<AuthenticateResult> HandleAuthenticateAsync()
    {
        if (!Request.Headers.ContainsKey("Authorization"))
        {
            return Task.FromResult(AuthenticateResult.Fail("Missing Authorization Header"));
        }
        // Add real authorization instead of checking one pair of username and password
        if (CheckAuthorized(Request.Headers["Authorization"], out string userName))
        {
            var claims = new[] {

                new Claim(ClaimTypes.Name, userName),
            };

            var identity = new ClaimsIdentity(claims, Scheme.Name);
            var principal = new ClaimsPrincipal(identity);
            var ticket = new AuthenticationTicket(principal, Scheme.Name);

            return Task.FromResult(AuthenticateResult.Success(ticket));
        }
        return Task.FromResult(AuthenticateResult.Fail("Invalid Username or Password"));
    }

    public bool CheckAuthorized(StringValues authHeader, out string userName)
    {
        userName = string.Empty;
        var parts = authHeader.FirstOrDefault("").Split(' ', 2);
        if (parts.Length != 2)
        {
            return false;
        }
        var credentialBytes = Convert.FromBase64String(parts[1]);
        var credentials = Encoding.UTF8.GetString(credentialBytes).Split(':', 2);
        if (credentials.Length != 2)
        {
            return false;
        }
        userName = credentials[0];
        return userName == "test" && credentials[1] == "password";
    }
}
