<?php



if ( ! defined('WP_UNINSTALL_PLUGIN') ) {

    exit;

}



global $wpdb;



/**

 * 1️⃣ Usuń wszystkie opcje z wp_options zawierające "orlen"

 */

$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '%orlen%'");



/**

 * 2️⃣ Usuń metadane powiązane z ORLEN z zamówień WooCommerce

 */

$wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE '%orlen%'");



/**

 * 3️⃣ Usuń ewentualne własne tabele ORLEN Paczka

 * (jeśli wtyczka je tworzyła)

 */

$tables = $wpdb->get_col("SHOW TABLES LIKE '{$wpdb->prefix}orlen%'");

foreach ( $tables as $table ) {

    $wpdb->query("DROP TABLE IF EXISTS {$table}");

}



/**

 * 4️⃣ Usuń ewentualne wpisy typu post (np. custom post type 'orlen_auth' lub inne)

 */

$post_types = ['orlen_auth', 'orlen_label', 'orlen_log'];

foreach ( $post_types as $type ) {

    $posts = get_posts([

        'post_type'   => $type,

        'numberposts' => -1,

        'post_status' => 'any',

        'fields'      => 'ids',

    ]);

    foreach ( $posts as $post_id ) {

        wp_delete_post( $post_id, true );

    }

}



/**

 * 5️⃣ Usuń transients (tymczasowe dane z cache)

 */

$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '%transient_orlen%' OR option_name LIKE '%_transient_timeout_orlen%'");



/**

 * 6️⃣ (opcjonalnie) Usuń wpisy z logów WooCommerce, jeśli używałeś ich do debugowania ORLEN

 */

// $wpdb->query("DELETE FROM {$wpdb->prefix}wc_order_notes WHERE note LIKE '%orlen%'");



