<?php

add_action('admin_menu', 'orlen_custom_settings_page');

function orlen_custom_settings_page() {

    add_menu_page(

        'ORLEN Paczka',

        'ORLEN Paczka',

        'manage_options',

        'orlen-paczka-panel',

        'orlen_render_main_page',

        'dashicons-admin-site-alt3',

        25

    );



    add_submenu_page(

        'orlen-paczka-panel',

        'Dane autoryzacyjne',

        'Dane autoryzacyjne',

        'manage_options',

        'orlen-auth-settings',

        'orlen_render_auth_page'

    );



    add_submenu_page(

        'orlen-paczka-panel',

        'Dane nadawcy',

        'Dane nadawcy',

        'manage_options',

        'orlen-sender-settings',

        'orlen_render_sender_page'

    );



    add_submenu_page(

        'orlen-paczka-panel',

        'Konfiguracja cen',

        'Konfiguracja cen',

        'manage_options',

        'orlen-shipping-config',

        'orlen_render_shipping_config_page'

    );

    

         add_submenu_page(

        'orlen-paczka-panel',

        'Historia nadań',

        'Historia nadań',

        'manage_options',

        'orlen-shipping-history',

        ['Orlen_Paczka_Shipping_History', 'render_shipping_history_page']

    );



    add_submenu_page(

        'orlen-paczka-panel',

        'Historia zamówień kuriera',

        'Historia zamówień kuriera',

        'manage_options',

        'orlen-paczka-pickup',

        ['OrlenPaczka_Pickup', 'orlen_paczka_pickup_page']

    );

 

    add_submenu_page(

            'orlen-paczka-panel',

            'Logi',

            'Logi',

            'manage_options',

            'orlen-paczka-logs',

            ['Orlen_Paczka_Admin_Settings', 'render_logs_page']

        );

        

}





function orlen_render_main_page() {

    ?>



<div class="wrap orlen-box">



    <h1 class="orlen-logo">

        <span class="logo-title">

            <span class="logo-icon"></span>

            ORLEN Paczka

        </span>

        <a href="<?php echo admin_url('admin.php?page=orlen-paczka-panel'); ?>" class="orlen-help-link">

            <i class="dashicons dashicons-info"></i>

            <span>Pomoc</span>

        </a>

    </h1>





    <?php $current_page = $_GET['page'] ?? ''; ?>

    <div class="orlen-icon-links">

        <a href="<?php echo admin_url('admin.php?page=orlen-auth-settings'); ?>"

            class="<?php echo $current_page === 'orlen-auth-settings' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-lock"></i>

            <span>Dane autoryzacyjne</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-sender-settings'); ?>"

            class="<?php echo $current_page === 'orlen-sender-settings' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-admin-users"></i>

            <span>Dane nadawcy</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-shipping-config'); ?>"

            class="<?php echo $current_page === 'orlen-shipping-config' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-admin-generic"></i>

            <span>Konfiguracja cen</span>

        </a>



           <a href="<?php echo admin_url('admin.php?page=orlen-shipping-history'); ?>"

            class="<?php echo $current_page === 'orlen-shipping-history' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-list-view"></i>

            <span>Historia nadań</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-paczka-pickup'); ?>"

            class="<?php echo $current_page === 'orlen-paczka-pickup' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-location-alt"></i>

            <span>Historia zamówień kuriera</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-paczka-logs'); ?>"

            class="<?php echo $current_page === 'orlen-paczka-logs' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-visibility"></i>

            <span>Logi</span>

        </a>

    </div>





    <div class="orlen-panel-wrapper">

        <div class="orlen-auth-form">

            <div class="header">

                <div>

                    <h2 id="orlen-welcome-title">Witamy w panelu ORLEN Paczka!</h2>

                    <p class="lead">To centrum zarządzania Twoimi przesyłkami – szybkie, proste i intuicyjne.</p>

                </div>

            </div>



            <ul class="features" aria-hidden="false">

                <li>

                    <div class="ico">📄</div>

                    <div>

                        <strong>Generowanie etykiet</strong>

                        <div class="desc">Twórz etykiety nadawcze dla pojedynczych i zbiorczych wysyłek.</div>

                    </div>

                </li>

                <li>

                    <div class="ico">🚚</div>

                    <div>

                        <strong>Zamów kuriera</strong>

                        <div class="desc">Zamów przyjazd kuriera bezpośrednio z panelu.</div>

                    </div>

                </li>

                <li>

                    <div class="ico">🗂️</div>

                    <div>

                        <strong>Protokoły zbiorcze</strong>

                        <div class="desc">Generuj protokoły zbiorcze dla nadawanych partii przesyłek.</div>

                    </div>

                </li>

                <li>

                    <div class="ico">📜</div>

                    <div>

                        <strong>Historia wysyłek</strong>

                        <div class="desc">Przeglądaj statusy i historię nadanych paczek w przejrzystym widoku.</div>

                    </div>

                </li>

            </ul>

        </div>

    </div>



    <?php

}







function orlen_render_auth_page() {

  

    $post_id = Orlen_Auth_Helper::get_post_id();





    $test_message = '';



    if (isset($_POST['orlen_auth_save'])) {

        check_admin_referer('orlen_auth_nonce');



        update_option('orlen_partner_id', sanitize_text_field($_POST['orlen_partner_id']));

        update_option('orlen_partner_key', sanitize_text_field($_POST['orlen_partner_key']));

        update_option('orlen_map_token', sanitize_text_field($_POST['orlen_map_token']));

        update_option('orlen_env', sanitize_text_field($_POST['orlen_env']));

        update_option('orlen_map_type', sanitize_text_field($_POST['orlen_map_type']));

        update_option( 'orlen_default_size', sanitize_text_field( $_POST['orlen_default_size'] ) );



       if ( isset($_POST['orlen_SenderOrders']) ) {

        $selected_option = sanitize_text_field($_POST['orlen_SenderOrders']);

        $comment = isset($_POST['orlen_custom_comment']) ? sanitize_text_field($_POST['orlen_custom_comment']) : '';



        update_option('orlen_sender_orders', $selected_option);

        update_option('orlen_custom_comment', $comment);

    }





        echo '<div class="updated"><p>Zapisano dane autoryzacyjne.</p></div>';

    }



    if (isset($_POST['orlen_auth_test'])) {

    check_admin_referer('orlen_auth_nonce');



    $partner_id = sanitize_text_field($_POST['orlen_partner_id']);

    $partner_key = sanitize_text_field($_POST['orlen_partner_key']);

        

        update_option('orlen_partner_id', sanitize_text_field($_POST['orlen_partner_id']));

        update_option('orlen_partner_key', sanitize_text_field($_POST['orlen_partner_key']));

        update_option('orlen_map_token', sanitize_text_field($_POST['orlen_map_token']));

        update_option('orlen_env', sanitize_text_field($_POST['orlen_env']));

        update_option('orlen_map_type', sanitize_text_field($_POST['orlen_map_type']));

        update_option( 'orlen_default_size', sanitize_text_field( $_POST['orlen_default_size'] ) );



        if ( isset($_POST['orlen_SenderOrders']) ) {

            $selected_option = sanitize_text_field($_POST['orlen_SenderOrders']);

            $comment = isset($_POST['orlen_custom_comment']) ? sanitize_text_field($_POST['orlen_custom_comment']) : '';



            update_option('orlen_sender_orders', $selected_option);

            update_option('orlen_custom_comment', $comment);

        }



        if (empty($partner_id) || empty($partner_key)) {

            $test_message = '<div class="error"><p>Proszę wprowadzić Partner ID i Partner Key przed testem.</p></div>';

        } else {

            

        try {

            

            $env = sanitize_text_field($_POST['orlen_env'] ?? get_option('orlen_env', 'test'));

        if (empty($env)) {

            $env = 'test'; 

        }





     

$orlen = new OrlenPaczka_SOAP($env);



            $response = $orlen->call('GivePartnerStatus', [

            'PartnerID' => $partner_id,

            'PartnerKey' => $partner_key,

]);





            if (isset($response->GivePartnerStatusResult->any)) {

                $xmlString = $response->GivePartnerStatusResult->any;

                $xml = simplexml_load_string($xmlString);

                $statusNode = $xml->NewDataSet->GivePartnerStatus;



                $err = (string) ($statusNode->Err ?? '');

                $errDes = (string) ($statusNode->ErrDes ?? '');



                if ($err === '000') {

                    $paymentType = (string) ($statusNode->PaymentType ?? 'brak');

                    $lastName = (string) ($statusNode->LastName ?? 'brak');

                    $companyName = (string) ($statusNode->CompanyName ?? 'brak');

                    $city = (string) ($statusNode->City ?? 'brak');



                    $message = "Połączenie powiodło się.<br>";

                 

                } else {

                    $message = "Błąd: $err - $errDes";

                }

            } else {

                $message = 'Brak odpowiedzi z serwera.';

            }



            $test_message = '<div class="updated"><p>' . wp_kses_post(nl2br($message)) . '</p></div>';



        } catch (SoapFault $e) {

            $test_message = '<div class="error"><p>Błąd połączenia: ' . esc_html($e->getMessage()) . '</p></div>';

        }

    }





}







    $partner_id  = sanitize_text_field(get_option('orlen_partner_id', ''));

    $partner_key = sanitize_text_field(get_option('orlen_partner_key', ''));





    $map_token = get_option('orlen_map_token', '');



    $sender_order   = get_option('orlen_sender_orders', 'nr_zamowienia_woo'); 

    $custom_comment = get_option('orlen_custom_comment', '');



    $env = get_option('orlen_env', 'test');

    if (empty($env)) {

        $env = 'test'; 

    }



    $map_type = get_option('orlen_map_type', 'popup'); 





    if (empty($partner_id) || empty($partner_key)) {

        Orlen_Logger::warning("Brak PartnerID/PartnerKey – sprawdź konfigurację autoryzacji");

    }

    ?>

    <div class="wrap orlen-box">



        <h1 class="orlen-logo">

            <span class="logo-title">

                <span class="logo-icon"></span>

                Dane autoryzacyjne

            </span>

            <a href="<?php echo admin_url('admin.php?page=orlen-paczka-panel'); ?>" class="orlen-help-link">

                <i class="dashicons dashicons-info"></i>

                <span>Pomoc</span>

            </a>

        </h1>





        <?php $current_page = $_GET['page'] ?? ''; ?>

        <div class="orlen-icon-links">

            <a href="<?php echo admin_url('admin.php?page=orlen-auth-settings'); ?>"

                class="<?php echo $current_page === 'orlen-auth-settings' ? 'active' : ''; ?>">

                <i class="dashicons dashicons-lock"></i>

                <span>Dane autoryzacyjne</span>

            </a>



            <a href="<?php echo admin_url('admin.php?page=orlen-sender-settings'); ?>"

                class="<?php echo $current_page === 'orlen-sender-settings' ? 'active' : ''; ?>">

                <i class="dashicons dashicons-admin-users"></i>

                <span>Dane nadawcy</span>

            </a>



            <a href="<?php echo admin_url('admin.php?page=orlen-shipping-config'); ?>"

                class="<?php echo $current_page === 'orlen-shipping-config' ? 'active' : ''; ?>">

                <i class="dashicons dashicons-admin-generic"></i>

                <span>Konfiguracja cen</span>

            </a>



               <a href="<?php echo admin_url('admin.php?page=orlen-shipping-history'); ?>"

                class="<?php echo $current_page === 'orlen-shipping-history' ? 'active' : ''; ?>">

                <i class="dashicons dashicons-list-view"></i>

                <span>Historia nadań</span>

            </a>



            <a href="<?php echo admin_url('admin.php?page=orlen-paczka-pickup'); ?>"

                class="<?php echo $current_page === 'orlen-paczka-pickup' ? 'active' : ''; ?>">

                <i class="dashicons dashicons-location-alt"></i>

                <span>Historia zamówień kuriera</span>

            </a>



            <a href="<?php echo admin_url('admin.php?page=orlen-paczka-logs'); ?>"

                class="<?php echo $current_page === 'orlen-paczka-logs' ? 'active' : ''; ?>">

                <i class="dashicons dashicons-visibility"></i>

                <span>Logi</span>

            </a>

        </div>







        <div class="orlen-auth-form"

            style="margin-bottom:20px; padding:15px; border:1px solid #ccc; position:relative; background:#f9f9f9; padding:20px; border-radius:8px;">



            <form method="post">

                <?php wp_nonce_field('orlen_auth_nonce'); ?>

                <table class="form-table">



                    <tr>

                        <th>Środowisko</th>

                        <td>

                            <label style="margin-right:20px;">

                                <input type="radio" name="orlen_env" value="test" <?php checked($env, 'test'); ?> />

                                Testowe

                            </label>

                            <label>

                                <input type="radio" name="orlen_env" value="prod" <?php checked($env, 'prod'); ?> />

                                Produkcyjne

                            </label>

                            <br><br>

                            <?php

                        $soap_tmp = new OrlenPaczka_SOAP($env);

                         ?>

                            <input type="text" id="orlen_wsdl_field" readonly

                                value="<?php echo esc_attr($soap_tmp->getWsdl()); ?>" class="regular-text"

                                style="width:100%;">



                            <p class="description">Adres WSDL używany w wybranym środowisku.</p>



                        </td>



                    </tr>



                    <tr>

                        <th><label for="orlen_partner_id">Partner ID</label></th>

                        <td><input type="text" name="orlen_partner_id" id="orlen_partner_id" required

                                value="<?php echo esc_attr($partner_id); ?>" class="regular-text"></td>

                    </tr>

                    <tr>

                        <th><label for="orlen_partner_key">Partner Key</label></th>

                        <td><input type="password" name="orlen_partner_key" id="orlen_partner_key" required

                                value="<?php echo esc_attr($partner_key); ?>" class="regular-text">

                            <input type="checkbox" onclick="myFunction()">Pokaż hasło

                        </td>

                    </tr>

                    <tr>

                        <th><label for="orlen_map_token">Token widżetu mapy</label></th>

                        <td>

                            <input type="text" name="orlen_map_token" id="orlen_map_token"

                                value="<?php echo esc_attr($map_token); ?>" class="regular-text">

                            <p class="description">W celu uzyskania tokenu mapy ORLEN Paczka skontaktuj się z działem

                                integracji pod adresem <a

                                    href="mailto:integracje@orlenpaczka.pl">integracje@orlenpaczka.pl</a>.</p>

                        </td>

                    </tr>



                    <tr>

                        <th>Typ mapy</th>

                        <td>

                            <label>

                                <input type="radio" name="orlen_map_type" value="embedded"

                                    <?php checked($map_type, 'embedded'); ?> />

                                Osadzona na stronie

                            </label><br>

                            <label>

                                <input type="radio" name="orlen_map_type" value="popup"

                                    <?php checked($map_type, 'popup'); ?> />

                                Popup z mapą

                            </label>

                        </td>

                    </tr>



                    <tr>

                        <th>Pole referencyjne (widoczne na etykiecie)</th>

                        <td>

                            <label>

                                <input type="radio" name="orlen_SenderOrders" value="nr_zamowienia_woo"

                                    <?php checked($sender_order, 'nr_zamowienia_woo'); ?>>

                                Numer zamówienia (Woo)

                            </label><br>



                            <label>

                                <input type="radio" name="orlen_SenderOrders" value="wlasny_opis"

                                    <?php checked($sender_order, 'wlasny_opis'); ?>>

                                Własne

                            </label><br>



                            <input type="text" name="orlen_custom_comment" id="orlen-custom-comment" maxlength="30"

                                placeholder="(max 30 znaków)"

                                style="width:300px; margin-top:8px; <?php echo ($sender_order === 'wlasny_opis' ? '' : 'display:none;'); ?>"

                                value="<?php echo esc_attr($custom_comment); ?>">



                        </td>

                    </tr>



                    <tr>

                    <th>Domyślny gabaryt przesyłki</th>

                    <td>

                        <label>

                            <select name="orlen_default_size" id="orlen_default_size" style="width:100%;">

                                <option value="S" <?php selected( get_option('orlen_default_size'), 'S' ); ?>>S - wymiary: 8 x 38 x 60 cm</option>

                                <option value="M" <?php selected( get_option('orlen_default_size'), 'M' ); ?>>M - wymiary: 19 x 38 x 60 cm</option>                                

                                <option value="L" <?php selected( get_option('orlen_default_size'), 'L' ); ?>>L - wymiary: 41 x 38 x 60 cm</option>

                            </select>

                        </label>

                        <p class="description">Jeśli konfiguracja cen jest ustawiona na „Według gabarytu paczki”, produkty bez zdefiniowanych wymiarów automatycznie otrzymają wybrany domyślny gabaryt.

W przypadku braku wagi, produktowi zostanie przypisana wartość 0.1 kg.</p>

                    </td>

                </tr>





                </table>

                <br><br>

                <input type="submit" name="orlen_auth_test" class="button button-secondary"

                    value="Testuj dane autoryzacyjne">

                <input type="submit" name="orlen_auth_save" class="button button-primary" value="Zapisz ustawienia">

            </form>

        </div>

        <?php

        if (!empty($test_message)) {

            echo $test_message;

        }

        ?>

    </div>





    <script>

    jQuery(document).ready(function($) {

        $('input[name="orlen_SenderOrders"]').on('change', function() {

            $('#orlen-custom-comment').toggle($(this).val() === 'wlasny_opis');

        });

    });





    function myFunction() {

        var x = document.getElementById("orlen_partner_key");

        if (x.type === "password") {

            x.type = "text";

        } else {

            x.type = "password";

        }

    }

    </script>



    <script>

    document.addEventListener("DOMContentLoaded", function() {

        const radios = document.querySelectorAll("input[name='orlen_env']");

        const wsdlField = document.querySelector("#orlen_wsdl_field");



        const wsdlUrls = {

            test: "https://api-test.orlenpaczka.pl/WebServicePwR/WebServicePwR.asmx?WSDL",

            prod: "https://api.orlenpaczka.pl/WebServicePwRProd/WebServicePwR.asmx?wsdl"

        };



        radios.forEach(radio => {

            radio.addEventListener("change", function() {

                wsdlField.value = wsdlUrls[this.value];

            });

        });

    });

    </script>



    <?php

}



    function orlen_render_sender_page() {

    $senders = get_option('orlen_senders', []);



    $fields = [

        'name' => 'Nazwa Nadawcy',

        'street' => 'Ulica',

        'building' => 'Numer budynku i lokal',

        'city' => 'Miejscowość',

        'postcode' => 'Kod pocztowy',

        'country' => 'Kraj',

        'firstname' => 'Imię',

        'lastname' => 'Nazwisko',

        'phone' => 'Telefon',

        'email' => 'E-mail',

    ];



if (isset($_POST['orlen_sender_save'])) {

    check_admin_referer('orlen_sender_nonce');



    $senders = $_POST['senders'] ?? [];

    $errors = [];



    foreach ($senders as $index => $sender) {

    foreach ($fields as $key => $label) {

        $value = sanitize_text_field($sender[$key] ?? '');

        if (empty($value)) {

            $errors[] = "Pole <strong>{$label}</strong> (nadawca #" . ($index+1) . ") jest wymagane.";

        } else {

            if ($key === 'postcode' && !preg_match('/^[0-9]{2}-[0-9]{3}$/', $value)) {

                $errors[] = "Pole <strong>Kod pocztowy</strong> (nadawca #" . ($index+1) . ") musi być w formacie 00-000.";

            }



            if ($key === 'phone' && !preg_match('/^[0-9]{9}$/', $value)) {

                $errors[] = "Pole <strong>Telefon</strong> (nadawca #" . ($index+1) . ") musi zawierać dokładnie 9 cyfr.";

            }

        }



        $senders[$index][$key] = $value;

    }

}



    if (!empty($errors)) {

        echo '<div class="error"><p>' . implode('<br>', $errors) . '</p></div>';

    } else {

        update_option('orlen_senders', $senders);

        echo '<div class="updated"><p>Zapisano dane nadawców.</p></div>';

    }

}



    ?>





    <div class="wrap orlen-box">



        <h1 class="orlen-logo">

            <span class="logo-title">

                <span class="logo-icon"></span>

                Dane nadawcy

            </span>

            <a href="<?php echo admin_url('admin.php?page=orlen-paczka-panel'); ?>" class="orlen-help-link">

                <i class="dashicons dashicons-info"></i>

                <span>Pomoc</span>

            </a>

        </h1>



        <?php $current_page = $_GET['page'] ?? ''; ?>

        <div class="orlen-icon-links">

            <a href="<?php echo admin_url('admin.php?page=orlen-auth-settings'); ?>"

                class="<?php echo $current_page === 'orlen-auth-settings' ? 'active' : ''; ?>">

                <i class="dashicons dashicons-lock"></i>

                <span>Dane autoryzacyjne</span>

            </a>



            <a href="<?php echo admin_url('admin.php?page=orlen-sender-settings'); ?>"

                class="<?php echo $current_page === 'orlen-sender-settings' ? 'active' : ''; ?>">

                <i class="dashicons dashicons-admin-users"></i>

                <span>Dane nadawcy</span>

            </a>



            <a href="<?php echo admin_url('admin.php?page=orlen-shipping-config'); ?>"

                class="<?php echo $current_page === 'orlen-shipping-config' ? 'active' : ''; ?>">

                <i class="dashicons dashicons-admin-generic"></i>

                <span>Konfiguracja cen</span>

            </a>



               <a href="<?php echo admin_url('admin.php?page=orlen-shipping-history'); ?>"

                class="<?php echo $current_page === 'orlen-shipping-history' ? 'active' : ''; ?>">

                <i class="dashicons dashicons-list-view"></i>

                <span>Historia nadań</span>

            </a>



            <a href="<?php echo admin_url('admin.php?page=orlen-paczka-pickup'); ?>"

                class="<?php echo $current_page === 'orlen-paczka-pickup' ? 'active' : ''; ?>">

                <i class="dashicons dashicons-location-alt"></i>

                <span>Historia zamówień kuriera</span>

            </a>



            <a href="<?php echo admin_url('admin.php?page=orlen-paczka-logs'); ?>"

                class="<?php echo $current_page === 'orlen-paczka-logs' ? 'active' : ''; ?>">

                <i class="dashicons dashicons-visibility"></i>

                <span>Logi</span>

            </a>

        </div>





        <div class="orlen-auth-form">

            <form method="post">

                <?php wp_nonce_field('orlen_sender_nonce'); ?>



                <div id="senders-wrapper">

                    <?php

            if (!empty($senders)) {

                foreach ($senders as $index => $sender) {

                    echo '<div class="sender-block" style="margin-bottom:20px; padding:15px; border:1px solid #ccc; position:relative; background:#f9f9f9; border-radius:8px;">';

                    echo '<table class="form-table">';

                    foreach ($fields as $key => $label) {

                        $value = $sender[$key] ?? '';

                        echo "<tr>

                                <th><label>{$label}</label></th>

                                <td><input type='text' name='senders[{$index}][{$key}]' 

                                           value='" . esc_attr($value) . "' 

                                           class='regular-text' required></td>

                              </tr>";

                    }

                    echo '</table>';

                    echo '<button type="button" class="remove-sender button" style="position:absolute; top:10px; right:10px;">Usuń tego nadawcę</button>';

                    echo '</div>';

                }

            } else {

                echo '<div class="sender-block" style="margin-bottom:20px; padding:15px; border:1px solid #ccc; position:relative; background:#f9f9f9; border-radius:8px;">';

                echo '<table class="form-table">';

                foreach ($fields as $key => $label) {

                    echo "<tr>

                            <th><label>{$label}</label></th>

                            <td><input type='text' name='senders[0][{$key}]' 

                                       value='' 

                                       class='regular-text' required></td>

                          </tr>";

                }

                echo '</table>';

                echo '<button type="button" class="remove-sender button" style="position:absolute; top:10px; right:10px;">Usuń tego nadawcę</button>';

                echo '</div>';

            }

            ?>

                </div>



                <button type="button" id="add-sender" class="button">Dodaj kolejnego nadawcę</button>



                <?php submit_button('Zapisz ustawienia'); ?>

                <input type="hidden" name="orlen_sender_save" value="1">

            </form>

        </div>



        <script>

        jQuery(document).ready(function($) {

            var index = <?php echo count($senders) ?: 1; ?>;

            var fields = <?php echo json_encode($fields); ?>;



            $('#add-sender').on('click', function() {

                var html =

                    '<div class="sender-block" style="margin-bottom:20px; padding:15px; border:1px solid #ccc; position:relative; background:#f9f9f9; border-radius:8px;">';

                html += '<table class="form-table">';

                $.each(fields, function(key, label) {

                    html += '<tr>' +

                        '<th><label>' + label + '</label></th>' +

                        '<td><input type="text" name="senders[' + index + '][' + key +

                        ']" value="" class="regular-text" required></td>' +

                        '</tr>';

                });

                html += '</table>';

                html +=

                    '<button type="button" class="remove-sender button" style="position:absolute; top:10px; right:10px;">Usuń tego nadawcę</button>';

                html += '</div>';

                $('#senders-wrapper').append(html);

                index++;

            });



            $(document).on('click', '.remove-sender', function() {

                $(this).closest('.sender-block').remove();

            });



            $('form').on('submit', function(e) {

                var valid = true;

                var errors = [];



                $('input[name*="[postcode]"]').each(function() {

                    var val = $(this).val().trim();

                    if (!/^[0-9]{2}-[0-9]{3}$/.test(val)) {

                        valid = false;

                        errors.push('Kod pocztowy "' + val +

                            '" ma niepoprawny format (wymagany 00-000).');

                        $(this).css('border-color', 'red');

                    } else {

                        $(this).css('border-color', '');

                    }

                });



                $('input[name*="[phone]"]').each(function() {

                    var val = $(this).val().trim();

                    if (!/^[0-9]{9}$/.test(val)) {

                        valid = false;

                        errors.push('Telefon "' + val + '" musi zawierać 9 cyfr.');

                        $(this).css('border-color', 'red');

                    } else {

                        $(this).css('border-color', '');

                    }

                });



                if (!valid) {

                    e.preventDefault();

                    alert("Wykryto błędy w formularzu:\n\n" + errors.join("\n"));

                }

            });

        });

        </script>



        <?php

}