<?php



if (!defined('ABSPATH')) {

    exit; // Exit if accessed directly

}



if (!class_exists('WC_Shipping_Method')) {

    return; 

}



class OrlenPaczka_Shipping extends WC_Shipping_Method {

    public function __construct($instance_id = 0) {

        $this->id                 = 'orlen_paczka';

        $this->instance_id        = absint($instance_id); 

        $this->method_title       = __('Orlen Paczka', 'woocommerce');

        $this->method_description = __('Wysyłka przez Orlen Paczka według wagi lub wartości.', 'woocommerce');

        $this->enabled            = "yes";

        $this->title              = "Orlen Paczka";



        $this->supports = ['shipping-zones', 'instance-settings'];

        $this->init();

    }



    public function init() {

        $this->init_form_fields();

        $this->init_settings();

        $this->title = $this->get_option('title', $this->title);

        $this->enabled = $this->get_option('enabled', 'yes');



        add_action('woocommerce_update_options_shipping_' . $this->id, [$this, 'process_admin_options']);

    }



    public function init_form_fields() {

        $this->form_fields = [

            'enabled' => [

                'title' => __('Włącz', 'woocommerce'),

                'type' => 'checkbox',

                'label' => __('Aktywuj metodę ORLEN Paczka'),

                'default' => 'yes',

            ],

            'title' => [

                'title' => __('Tytuł metody', 'woocommerce'),

                'type' => 'text',

                'default' => __('ORLEN Paczka', 'woocommerce'),

            ],

        ];

    }





    



  public function calculate_shipping($package = array()) {

    $gabaryt_rules = get_option('orlen_gabaryt_rules', []);

    $weight_rules  = get_option('orlen_weight_rules', []);

    $value_rules   = get_option('orlen_value_rules', []);



    $dostawa_type        = get_option('orlen_dostawa_type', 'gabaryt');

    $przekroczenie_type  = get_option('orlen_przekroczenie_type', 'ukryjmet');

    $przekroczenie_token = get_option('orlen_przekroczenie_token', '');



    $total_cost = 0;

    $label = $this->title;

    $exceeded_info = [];



    



    if ($dostawa_type === 'gabaryt') {



        // helper: czy produkt mieści się w paczce przy dowolnej rotacji

        $fits_box = function($l, $w, $h, $box_l, $box_w, $box_h) {

            $perms = [

                [$l,$w,$h], [$l,$h,$w],

                [$w,$l,$h], [$w,$h,$l],

                [$h,$l,$w], [$h,$w,$l]

            ];

            foreach ($perms as $p) {

                if ($p[0] <= $box_l && $p[1] <= $box_w && $p[2] <= $box_h) return true;

            }

            return false;

        };



        // Gabaryty

        $gabaryt_dims = [

            'S' => ['length'=>60,'width'=>38,'height'=>8],

            'M' => ['length'=>60,'width'=>38,'height'=>19],

            'L' => ['length'=>60,'width'=>38,'height'=>41],

        ];

        $gabaryt_volumes = [

            'S' => 60*38*8,

            'M' => 60*38*19,

            'L' => 60*38*41,

        ];



        $efficiency = 0.7;

        $max_weight_limit = 20.0;



        $items = [];



        // Rozbijamy produkty na pojedyncze egzemplarze

        foreach ($package['contents'] as $entry) {

            $product = $entry['data'];

            $qty = (int) $entry['quantity'];



            $length = floatval($product->get_length());

            $width  = floatval($product->get_width());

            $height = floatval($product->get_height());

            $weight = floatval($product->get_weight()) ?: 0.1;





            // --- Zmniejsz wymiary produktu

            if ($length >= 48 && $length <= 60) {

                $length = 48;

            }

            if ($width >= 32 && $width <= 38) {

                $width = 32;

            }

            //$height = max(0, $height - 1);







            

        if (!$length || !$width || !$height) {

            $default_size = get_option('orlen_default_size','M');

            $dims = $gabaryt_dims[$default_size] ?? $gabaryt_dims['M'];

            $length = $dims['length'];

            $width  = $dims['width'];

            $height = $dims['height'];

            $exceeded_info[] = sprintf(

                __('Produkt "%s" nie ma wymiarów – zastosowano domyślny gabaryt %s.', 'orlen-paczka'),

                $product->get_name(), $default_size

            );



            $volume = $length * $width * $height * $efficiency;

        } else {

            $volume = $length * $width * $height;

        }





            for ($i=0; $i<$qty; $i++) {

                $items[] = [

                    'length'=>$length,

                    'width'=>$width,

                    'height'=>$height,

                    'weight'=>$weight,

                    'volume'=>$volume,

                    'name'=>$product->get_name()

                ];

            }



        }



            // ---Sprawdzenie maksymalnych wymiarów produktu ---

            $max_length_limit = floatval(get_option('orlen_max_length', 60)); // np. 60 cm

            $max_width_limit  = floatval(get_option('orlen_max_width', 38));  // np. 38 cm

            $max_height_limit = floatval(get_option('orlen_max_height', 41)); // np. 41 cm



            $exceeded_max_dimensions = false;

            $exceeded_products = [];



            foreach ($items as $it) {

                if (

                    $it['length'] > $max_length_limit ||

                    $it['width']  > $max_width_limit  ||

                    $it['height'] > $max_height_limit

                ) {

                    $exceeded_max_dimensions = true;

                    $exceeded_products[] = sprintf(

                        __('%s (%.1fx%.1fx%.1f cm)', 'orlen-paczka'),

                        $it['name'], $it['length'], $it['width'], $it['height']

                    );

                }

            }



            // --- Sprawdzenie maksymalnych wymiarów produktu ---

            $exceeded_max_dimensions = false;

            foreach ($items as $it) {

                if ($it['length'] > $max_length_limit ||

                    $it['width']  > $max_width_limit  ||

                    $it['height'] > $max_height_limit) {

                    $exceeded_max_dimensions = true;

                    break;

                }

            }



                // sortujemy malejąco po objętości

                usort($items, fn($a,$b)=> $b['volume'] <=> $a['volume']);



            // --- Inteligentne pakowanie w wiele paczek z wyborem najlepszego gabarytu ---

            $gabaryty_summary = [];

            $total_cost = 0;



            // funkcja pomocnicza: policz ile paczek potrzeba dla danego gabarytu

            $pack_items_for_gabaryt = function($items, $gabaryt_dims, $gabaryt_volumes, $g, $efficiency, $max_weight_limit, $fits_box) {

                $remaining = $items;

                $box_volume_limit = $gabaryt_volumes[$g] * $efficiency;

                $packages = 0;



                while (!empty($remaining)) {

                    $current_volume = 0;

                    $current_weight = 0;

                    $current_package = [];



                    foreach ($remaining as $idx => $it) {

                        if (!$fits_box(

                            $it['length'], $it['width'], $it['height'],

                            $gabaryt_dims[$g]['length'],

                            $gabaryt_dims[$g]['width'],

                            $gabaryt_dims[$g]['height']

                        )) {

                            continue; // nie pasuje wymiarowo

                        }



                        $new_volume = $current_volume + $it['volume'];

                        $new_weight = $current_weight + $it['weight'];



                        if ($new_volume <= $box_volume_limit && $new_weight <= $max_weight_limit) {

                            $current_volume = $new_volume;

                            $current_weight = $new_weight;

                            $current_package[$idx] = $it;

                        }

                    }



                    // usuń spakowane produkty

                    foreach ($current_package as $idx => $it) {

                        unset($remaining[$idx]);

                    }

                    $remaining = array_values($remaining);



                    $packages++;

                    if ($packages > 500) break; // bezpieczeństwo na wypadek błędu

                }



                return $packages;

            };





            // --- Kaskadowe pakowanie: najpierw S, potem M, potem L ---

            $gabaryty_summary = ['S'=>0, 'M'=>0, 'L'=>0];

            $total_cost = 0;



            // pomocnicze: cena danego gabarytu

            $get_gabaryt_price = function($g, $gabaryt_rules) {

                foreach ($gabaryt_rules as $rule) {

                    if ($rule['gabaryt'] === $g) return floatval($rule['price']);

                }

                return 0;

            };



            // Najpierw próbujemy zapakować produkty do najmniejszych gabarytów

            $remaining = $items;



            $pack_into_gabaryt = function(&$remaining, $g, $gabaryt_dims, $gabaryt_volumes, $efficiency, $max_weight_limit, $fits_box) {

                $box_volume_limit = $gabaryt_volumes[$g] * $efficiency;

                $packages = 0;



                while (!empty($remaining)) {

                    $current_volume = 0;

                    $current_weight = 0;

                    $current_package = [];



                    foreach ($remaining as $idx => $it) {

                        if (!$fits_box(

                            $it['length'], $it['width'], $it['height'],

                            $gabaryt_dims[$g]['length'],

                            $gabaryt_dims[$g]['width'],

                            $gabaryt_dims[$g]['height']

                        )) continue;



                        $new_volume = $current_volume + $it['volume'];

                        $new_weight = $current_weight + $it['weight'];



                        if ($new_volume <= $box_volume_limit && $new_weight <= $max_weight_limit) {

                            $current_volume = $new_volume;

                            $current_weight = $new_weight;

                            $current_package[$idx] = $it;

                        }

                    }



                    if (empty($current_package)) break;



                    foreach ($current_package as $idx => $it) unset($remaining[$idx]);

                    $remaining = array_values($remaining);

                    $packages++;

                }



                return $packages;

            };



            // --- DODANE: sprawdź, czy wszystkie produkty mieszczą się w jednym gabarycie (najpierw S, potem M, potem L) ---

            $total_volume = array_sum(array_column($items, 'volume'));

            $total_weight = array_sum(array_column($items, 'weight'));



            $chosen_single = null;

            foreach (['S','M','L'] as $g) {

                $fits_all = true;

                foreach ($items as $it) {

                    if (!$fits_box(

                        $it['length'], $it['width'], $it['height'],

                        $gabaryt_dims[$g]['length'],

                        $gabaryt_dims[$g]['width'],

                        $gabaryt_dims[$g]['height']

                    )) {

                        $fits_all = false;

                        break;

                    }

                }



                if (!$fits_all) continue;



                // sprawdź limit objętości i wagi dla tego gabarytu

                $box_volume_limit = $gabaryt_volumes[$g] * $efficiency;

                if ($total_volume <= $box_volume_limit && $total_weight <= $max_weight_limit) {

                    $chosen_single = $g;

                    break; // wybieramy pierwszy (najmniejszy) pasujący gabaryt

                }

            }



            if ($chosen_single !== null) {

                // Wszystkie produkty mieszczą się w jednym pudełku typu $chosen_single

                $gabaryty_summary = ['S'=>0, 'M'=>0, 'L'=>0];

                $gabaryty_summary[$chosen_single] = 1;

                $total_cost = $get_gabaryt_price($chosen_single, $gabaryt_rules);

                $label .= " (1x gab. {$chosen_single})";

            } else {

                // Pakujemy do S, potem M, potem L

                $gabaryty_summary['S'] = $pack_into_gabaryt($remaining, 'S', $gabaryt_dims, $gabaryt_volumes, $efficiency, $max_weight_limit, $fits_box);



                if (!empty($remaining))

                    $gabaryty_summary['M'] = $pack_into_gabaryt($remaining, 'M', $gabaryt_dims, $gabaryt_volumes, $efficiency, $max_weight_limit, $fits_box);



                if (!empty($remaining))

                    $gabaryty_summary['L'] = $pack_into_gabaryt($remaining, 'L', $gabaryt_dims, $gabaryt_volumes, $efficiency, $max_weight_limit, $fits_box);



                    // NOWOŚĆ: ekonomiczny wybór kombinacji paczek

                $priceS = $get_gabaryt_price('S', $gabaryt_rules);

                $priceM = $get_gabaryt_price('M', $gabaryt_rules);

                $priceL = $get_gabaryt_price('L', $gabaryt_rules);



                $volS = $gabaryt_volumes['S'] * $efficiency;

                $volM = $gabaryt_volumes['M'] * $efficiency;

                $volL = $gabaryt_volumes['L'] * $efficiency;



                $total_volume = array_sum(array_column($items, 'volume'));

                $total_weight = array_sum(array_column($items, 'weight'));



                $max_weight_limit = 20.0;



                $best_combo = null;

                $best_cost = INF;



                



                // przygotuj kolejność itemów (największe volume pierwsze) zmienione 06-11

                $sorted_items = $items;

                usort($sorted_items, fn($a,$b)=> $b['volume'] <=> $a['volume']);



                // testujemy wszystkie sensowne kombinacje (do 10 paczek z każdego typu)

                for ($s = 0; $s <= 10; $s++) {

                    for ($m = 0; $m <= 10; $m++) {

                        for ($l = 0; $l <= 10; $l++) {

                            if ($s + $m + $l == 0) continue;



                            $capacity_vol = $s * $volS + $m * $volM + $l * $volL;

                            $capacity_weight = ($s + $m + $l) * $max_weight_limit;



                            // szybkie odrzucenie globalne (objętość/waga)

                            if (!($total_volume <= $capacity_vol && $total_weight <= $capacity_weight)) continue;



                            // --- symulacja pakowania do pojedynczych pudeł ---

                            $boxes = [];

                            // każde pudełko: ['type'=>'S'|'M'|'L','vol_rem'=>..., 'weight_rem'=>..., 'dims'=>[l,w,h]]

                            for ($i=0;$i<$s;$i++) {

                                $boxes[] = [

                                    'type'=>'S',

                                    'vol_rem' => $volS,

                                    'weight_rem' => $max_weight_limit,

                                    'dims' => $gabaryt_dims['S']

                                ];

                            }

                            for ($i=0;$i<$m;$i++) {

                                $boxes[] = [

                                    'type'=>'M',

                                    'vol_rem' => $volM,

                                    'weight_rem' => $max_weight_limit,

                                    'dims' => $gabaryt_dims['M']

                                ];

                            }

                            for ($i=0;$i<$l;$i++) {

                                $boxes[] = [

                                    'type'=>'L',

                                    'vol_rem' => $volL,

                                    'weight_rem' => $max_weight_limit,

                                    'dims' => $gabaryt_dims['L']

                                ];

                            }



                            // Klucz: dla każdego itemu spróbuj znaleźć pudełko, w którym zmieści się wymiarowo i wagowo/objętościowo

                            $all_placed = true;

                            foreach ($sorted_items as $it) {

                                $placed = false;

                                // spróbuj umieścić w pudełkach w porządku od najmniejszego do największego (daje preferencję mniejszych)

                                // ale możesz zmienić priorytet, jeśli chcesz inną heurystykę

                                usort($boxes, function($a,$b){

                                    $rank = ['S'=>0,'M'=>1,'L'=>2];

                                    return $rank[$a['type']] <=> $rank[$b['type']];

                                });

                                foreach ($boxes as $bi => $box) {

                                    // wymiarowo

                                    if (!$fits_box($it['length'],$it['width'],$it['height'],

                                                $box['dims']['length'],$box['dims']['width'],$box['dims']['height'])) {

                                        continue;

                                    }

                                    // objętościowo i wagowo (vol_rem trzymamy w jednostkach objętości)

                                    if ($it['volume'] <= $box['vol_rem'] && $it['weight'] <= $box['weight_rem']) {

                                        // umieszczamy element — aktualizujemy pozostałe zasoby pudełka

                                        $boxes[$bi]['vol_rem'] -= $it['volume'];

                                        $boxes[$bi]['weight_rem'] -= $it['weight'];

                                        $placed = true;

                                        break;

                                    }

                                }

                                if (!$placed) { $all_placed = false; break; }

                            }



                            if ($all_placed) {

                                // dopuszczalna kombinacja — policz koszt i ewentualnie zapisz najlepszą

                                $cost = $s * $priceS + $m * $priceM + $l * $priceL;

                                if ($cost < $best_cost) {

                                    $best_cost = $cost;

                                    $best_combo = ['S' => $s, 'M' => $m, 'L' => $l];

                                }

                            }

                        }

                    }

                }





                if ($best_combo) {

                    $gabaryty_summary = $best_combo;

                    $total_cost = $best_cost;



                    $label_parts = [];

                    foreach ($gabaryty_summary as $g => $count) {

                        if ($count > 0) $label_parts[] = "{$count}x gab. {$g}";

                    }

                    $label .= ' (' . implode(', ', $label_parts) . ')';

                } else {

                    // awaryjnie: jeśli nic nie pasuje

                    $label .= ' (błąd pakowania)';

                    $total_cost = $get_gabaryt_price('L', $gabaryt_rules);

                    $gabaryty_summary = ['S'=>0,'M'=>0,'L'=>1];

                }



            }



      

                if (!empty($exceeded_info)) {

                    WC()->session->set('orlen_exceeded_info', implode('; ', $exceeded_info));

                }



            } else {

                // tryb waga/wartość

                $package_weight=0; $package_value=0;

                foreach ($package['contents'] as $item) {

                    $product = $item['data'];

                    $package_weight += (floatval($product->get_weight())?:1)*$item['quantity'];

                    $package_value  += floatval($product->get_price())*$item['quantity'];

                }



                $cost = null;

                if ($dostawa_type==='waga') {

                    foreach ($weight_rules as $rule) {

                        if ($package_weight>=$rule['min'] && $package_weight<=$rule['max']) { $cost=$rule['price']; break; }

                    }

                } elseif ($dostawa_type==='wartosc') {

                    foreach ($value_rules as $rule) {

                        if ($package_value>=$rule['min'] && $package_value<=$rule['max']) { $cost=$rule['price']; break; }

                    }

                }



                if ($cost===null && $przekroczenie_type==='stalacena' && $przekroczenie_token!=='') {

                    $cost=floatval($przekroczenie_token);

                } elseif ($cost===null) return;

                $total_cost = floatval($cost);

            }





            // --- SPRAWDŹ, CZY PRZEKROCZONO MAKSYMALNE WYMIARY LUB WAGĘ ---

            $exceeded_max_dimensions = false;

            $exceeded_max_weight = false;

            $too_heavy_products = [];



            // Sprawdź, czy jakiś produkt przekracza maksymalne wymiary L

            foreach ($items as $it) {

                if (

                    $it['length'] > $gabaryt_dims['L']['length'] ||

                    $it['width']  > $gabaryt_dims['L']['width']  ||

                    $it['height'] > $gabaryt_dims['L']['height']

                ) {

                    $exceeded_max_dimensions = true;

                    break;

                }

            }



            // Sprawdź, czy któryś produkt przekracza maksymalną wagę pojedynczej paczki

            foreach ($items as $it) {

                if ($it['weight'] > $max_weight_limit) {

                    $exceeded_max_weight = true;

                    $too_heavy_products[] = sprintf(

                        __('%s (%.1f kg)', 'orlen-paczka'),

                        $it['name'], $it['weight']

                    );

                }

            }



            //  Jeśli jakiś produkt przekracza dopuszczalną wagę (np. 25 kg) — tylko wtedy blokujemy metodę

            if ($exceeded_max_dimensions || $exceeded_max_weight) {



                $exceeded_info = [];

                if ($exceeded_max_dimensions) $exceeded_info[] = 'Przekroczone maksymalne wymiary paczki';

                if ($exceeded_max_weight) {

                    $exceeded_info[] = 'Przekroczona maksymalna waga produktu: ' . implode(', ', $too_heavy_products);

                }



                if (!empty($exceeded_info)) {

                    WC()->session->set('orlen_exceeded_info', implode('; ', $exceeded_info));

                }



                // Jeśli ustawiono „stała cena” → pokaż ofertę z dopłatą

                if (trim(strtolower($przekroczenie_type)) === 'stalacena') {

                    $this->add_rate([

                        'id'        => $this->id . '_oversize',

                        'label'     => __('ORLEN Paczka – Przekroczony limit wagi/wymiarów', 'orlen-paczka'),

                        'cost'      => floatval($przekroczenie_token) ?: 0,

                        'calc_tax'  => 'per_order',

                    ]);

                }



                // Jeśli „ukryjmet” → nie pokazujemy w ogóle

                return;

            }







            // w tym fragmencie ustawiasz $total_cost i $label

            if ($exceeded_max_dimensions) {

                

                if (trim(strtolower($przekroczenie_type)) === 'stalacena') {

                $this->add_rate([

                    'id'    => $this->id . '_oversize',

                    'label' => __('ORLEN Paczka – Przekroczone maksymalne wymiary', 'orlen-paczka'),

                    'cost'  => floatval($przekroczenie_token) ?: 0,

                    'calc_tax' => 'per_order',

                ]);

                }



                if (trim(strtolower($przekroczenie_type)) === 'ukryjmet') {

            

                }

            }else{



            // dodajemy **tylko jedną paczkę standardową** jeśli metoda nie jest ukryta

            $this->add_rate([

                'id'    => $this->id,

                'label' => $label,

                'cost'  => $total_cost,

                'calc_tax' => 'per_order',

            ]);

            }



            }









}











function orlen_render_shipping_config_page() {

    if (isset($_POST['orlen_settings_nonce']) && wp_verify_nonce($_POST['orlen_settings_nonce'], 'save_orlen_settings')) {

       

        





        $gabaryt_rules = [];

if (!empty($_POST['gabaryt_type'])) {

    for ($i = 0; $i < count($_POST['gabaryt_type']); $i++) {

        $gabaryt_rules[] = [

            'gabaryt' => sanitize_text_field($_POST['gabaryt_type'][$i]),

            'price'   => floatval($_POST['gabaryt_price'][$i])

        ];

    }

}

update_option('orlen_gabaryt_rules', $gabaryt_rules);











        $value_rules = [];

        if (!empty($_POST['value_min'])) {

            for ($i = 0; $i < count($_POST['value_min']); $i++) {

                $value_rules[] = [

                    'min' => floatval($_POST['value_min'][$i]),

                    'max' => floatval($_POST['value_max'][$i]),

                    'price' => floatval($_POST['value_price'][$i])

                ];

            }

        }

        update_option('orlen_value_rules', $value_rules);



        $dostawa_type = sanitize_text_field($_POST['orlen_dostawa_type'] ?? 'waga');

        update_option('orlen_dostawa_type', $dostawa_type);



        $przekroczenie_type = sanitize_text_field($_POST['orlen_przekroczenie_type'] ?? 'ukryjmet');

        update_option('orlen_przekroczenie_type', $przekroczenie_type);



        $przekroczenie_token = sanitize_text_field($_POST['orlen_przekroczenie_token'] ?? '');

        update_option('orlen_przekroczenie_token', $przekroczenie_token);



        echo '<div class="updated"><p>Ustawienia zapisane.</p></div>';

    }



    $weight_rules = get_option('orlen_weight_rules', []);

    $value_rules = get_option('orlen_value_rules', []);



    $dostawa_type = get_option('orlen_dostawa_type', 'gabaryt');



    $przekroczenie_type = get_option('orlen_przekroczenie_type', 'ukryjmet');

    $przekroczenie_token = get_option('orlen_przekroczenie_token', '');



    ?>

<div class="wrap orlen-box">



    <h1 class="orlen-logo">

        <span class="logo-title">

            <span class="logo-icon"></span>

            Konfiguracja cen dostawy

        </span>

        <a href="<?php echo admin_url('admin.php?page=orlen-paczka-panel'); ?>" class="orlen-help-link">

            <i class="dashicons dashicons-info"></i>

            <span>Pomoc</span>

        </a>

    </h1>





    <?php $current_page = $_GET['page'] ?? ''; ?>

    <div class="orlen-icon-links">

        <a href="<?php echo admin_url('admin.php?page=orlen-auth-settings'); ?>"

            class="<?php echo $current_page === 'orlen-auth-settings' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-lock"></i>

            <span>Dane autoryzacyjne</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-sender-settings'); ?>"

            class="<?php echo $current_page === 'orlen-sender-settings' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-admin-users"></i>

            <span>Dane nadawcy</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-shipping-config'); ?>"

            class="<?php echo $current_page === 'orlen-shipping-config' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-admin-generic"></i>

            <span>Konfiguracja cen</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-shipping-history'); ?>"

            class="<?php echo $current_page === 'orlen-shipping-history' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-list-view"></i>

            <span>Historia nadań</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-paczka-pickup'); ?>"

            class="<?php echo $current_page === 'orlen-paczka-pickup' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-location-alt"></i>

            <span>Historia zamówień kuriera</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-paczka-logs'); ?>"

            class="<?php echo $current_page === 'orlen-paczka-logs' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-visibility"></i>

            <span>Logi</span>

        </a>

    </div>







    <div class="orlen-shipping-form"

        style="margin-bottom:20px; padding:15px; border:1px solid #ccc; position:relative; background:#f9f9f9; padding:20px; border-radius:8px;">



        <form method="post">

            <?php wp_nonce_field('save_orlen_settings', 'orlen_settings_nonce'); ?>









            <label>

                <h3>

                    <input type="radio" name="orlen_dostawa_type" value="gabaryt"

                        <?php checked($dostawa_type, 'gabaryt'); ?> />

                    Według gabarytu paczki

                </h3>



                <table class="widefat fixed" data-type="gabaryt">

                    <thead>

                        <tr>

                            <th>Gabaryt</th>

                            <th>Wymiary maksymalne (cm)</th>

                            <th>Waga maksymalna</th>

                            <th>Cena przesyłki (zł)</th>

                        </tr>

                    </thead>

                    <tbody>

                        <?php

            $gabaryt_rules = get_option('orlen_gabaryt_rules', []);



            // ustaw wartości domyślne (jeśli brak)

           

$default_rules = [

    [

        'gabaryt' => 'S',

        'price'   => isset($gabaryt_rules[0]['price']) ? $gabaryt_rules[0]['price'] : '11.99',

        'dims'    => '8 × 38 × 60',

        'dims_desc' => '(wys. × szer. × dł.)',

        'weight'  => 'do 20 kg'

    ],

    [

        'gabaryt' => 'M',

        'price'   => isset($gabaryt_rules[1]['price']) ? $gabaryt_rules[1]['price'] : '12.99',

        'dims'    => '19 × 38 × 60',

        'dims_desc' => '(wys. × szer. × dł.)',

        'weight'  => 'do 20 kg'

    ],

    [

        'gabaryt' => 'L',

        'price'   => isset($gabaryt_rules[2]['price']) ? $gabaryt_rules[2]['price'] : '13.99',

        'dims'    => '41 × 38 × 60',

        'dims_desc' => '(wys. × szer. × dł.)',

        'weight'  => 'do 20 kg'

    ],

];



            foreach ($default_rules as $rule): ?>

                        <tr>

                            <td><strong><?php echo esc_html($rule['gabaryt']); ?></strong></td>

                            <td><?php echo $rule['dims'] . '<br><small>' . $rule['dims_desc'] . '</small>'; ?></td>

                            <td><?php echo esc_html($rule['weight']); ?></td>

                            <td>

                                <input type="number" step="0.01" name="gabaryt_price[]"

                                    value="<?php echo esc_attr($rule['price']); ?>" />

                                <input type="hidden" name="gabaryt_type[]"

                                    value="<?php echo esc_attr($rule['gabaryt']); ?>" />

                            </td>

                        </tr>

                        <?php endforeach; ?>

                    </tbody>

                </table>



                <p class="description">

                    <em>Gabaryty paczek zgodne z wytycznymi ORLEN Paczka. Edytuj tylko ceny przesyłek.</em>

                </p>

            </label>











            <br><br>

            <label>

                <h3><input type="radio" name="orlen_dostawa_type" value="wartosc"

                        <?php checked($dostawa_type, 'wartosc'); ?> />

                    Według przedziału ceny paczki</h3>



                <table class="widefat fixed dynamic-table" data-type="value">

                    <thead>

                        <tr>

                            <th>Wartość minimalna (zł)</th>

                            <th>Wartość maksymalna (zł)</th>

                            <th>Cena przesyłki (zł)</th>

                            <th>Usuń</th>

                        </tr>

                    </thead>

                    <tbody>

                        <?php if (empty($value_rules)) $value_rules[] = ['min'=>'', 'max'=>'', 'price'=>'']; ?>

                        <?php foreach ($value_rules as $rule): ?>

                        <tr>

                            <td><input type="number" step="0.01" name="value_min[]"

                                    value="<?php echo esc_attr($rule['min']); ?>" /></td>

                            <td><input type="number" step="0.01" name="value_max[]"

                                    value="<?php echo esc_attr($rule['max']); ?>" /></td>

                            <td><input type="number" step="0.01" name="value_price[]"

                                    value="<?php echo esc_attr($rule['price']); ?>" /></td>

                            <td><button type="button" class="button remove-row">Usuń</button></td>

                        </tr>

                        <?php endforeach; ?>

                    </tbody>

                </table>

                <button type="button" class="button add-row" data-type="value">+ Dodaj wiersz</button>



            </label>



            <br><br><br>

            <h3>Jeśli zamówienie przekroczy progi maksymalne w konfiguracji cen wysyłki</h3>



            <label>

                <input type="radio" name="orlen_przekroczenie_type" value="ukryjmet"

                    <?php checked($przekroczenie_type, 'ukryjmet'); ?> />

                Ukryj metodę dostawy ORLEN Paczka w kasie sklepu

            </label><br><br>

            <label>

                <input type="radio" name="orlen_przekroczenie_type" value="stalacena"

                    <?php checked($przekroczenie_type, 'stalacena'); ?> />

                Wyświetl stałą cenę wysyłki wynoszącą (zł)

                <input type="number" name="orlen_przekroczenie_token" id="orlen_przekroczenie_token"

                    value="<?php echo esc_attr($przekroczenie_token); ?>">

            </label>



            <?php submit_button('Zapisz ustawienia'); ?>

        </form>

    </div>

</div>



<script>

jQuery(document).ready(function($) {

    $('.add-row').on('click', function() {

        var type = $(this).data('type');

        var table = $('.dynamic-table[data-type="' + type + '"] tbody');

        var row = `

                <tr>

                    <td><input type="number" step="0.01" name="${type}_min[]" /></td>

                    <td><input type="number" step="0.01" name="${type}_max[]" /></td>

                    <td><input type="number" step="0.01" name="${type}_price[]" /></td>

                    <td><button type="button" class="button remove-row">Usuń</button></td>

                </tr>`;

        table.append(row);

    });



    $(document).on('click', '.remove-row', function() {

        $(this).closest('tr').remove();

    });

});

</script>

<?php

}