<?php 



class OrlenPaczka_Pickup {



public static function call_pickup($orders) {

    $soap = new OrlenPaczka_SOAP();

    $packs = [];



    foreach ($orders as $order_id) {

        $packcode = get_post_meta($order_id, '_orlen_paczka_packcode', true);

        if (!empty($packcode)) {

            $packs[] = $packcode;

        }

    }



    if (empty($packs)) {

        return [

            'success' => false,

            'message' => 'Brak numerów przesyłek (PackCode) do wysłania.'

        ];

    }



    $creds = Orlen_Auth_Helper::get_credentials();

    

    $partner_id = $creds['partner_id'];

    $partner_key = $creds['partner_key'];



    if (empty($partner_id) || empty($partner_key)) {

        return [

            'success' => false,

            'message' => 'Brak danych logowania ORLEN Paczka. Uzupełnij je w zakładce „Dane autoryzacyjne”.'

        ];

    }



    $params = [

        'PartnerID'   => $partner_id,

        'PartnerKey'  => $partner_key,

        'ReadyDate'   => date('c', strtotime('+1 day 08:00')),

        'PickupDate'  => date('c', strtotime('+1 day 10:00')),

        'packList'    => ['string' => $packs]

    ];



    try {

        $response = $soap->call('CallPickupNew', $params);

        return [

            'success' => true,

            'message' => 'Zamówienie kuriera zostało wysłane do ORLEN Paczka.',

            'response' => $response

        ];

    } catch (Exception $e) {

        error_log('[ORLEN Pickup] Błąd: ' . $e->getMessage());

        return [

            'success' => false,

            'message' => 'Błąd podczas zamawiania kuriera: ' . $e->getMessage()

        ];

    }

}





public static function orlen_paczka_pickup_page() {



    if (!function_exists('wc_get_orders')) {

        echo '<div class="notice notice-error"><p>WooCommerce nie jest aktywny lub wc_get_orders() nie jest dostępne.</p></div>';

        return;

    }

       

    if (isset($_POST['pickup_submit']) && !empty($_POST['order_ids'])) {

        $order_ids = array_map('intval', $_POST['order_ids']);

        $result = self::call_pickup($order_ids);



        echo '<div class="' . ($result['success'] ? 'updated' : 'error') . ' notice"><p>' . esc_html($result['message']) . '</p></div>';



        if (!empty($result['response'])) {

            echo '<pre>' . esc_html(print_r($result['response'], true)) . '</pre>';

        }

    }



    $args = [

        'limit'   => 50,

        'status'  => ['processing', 'on-hold', 'completed'],

        'orderby' => 'date',

        'order'   => 'DESC',

    ];

    $orders = wc_get_orders($args);



$orders_with_packcode = array_filter($orders, function($order) {

    $packcode = get_post_meta($order->get_id(), '_orlen_paczka_packcode', true);

    return !empty($packcode);

});

    ?>



<div class="wrap orlen-box">



    <h1 class="orlen-logo">

        <span class="logo-title">

            <span class="logo-icon"></span>

            Zamawianie kuriera

        </span>

        <a href="<?php echo admin_url('admin.php?page=orlen-paczka-panel'); ?>" class="orlen-help-link">

            <i class="dashicons dashicons-info"></i>

            <span>Pomoc</span>

        </a>

    </h1>



    <?php $current_page = $_GET['page'] ?? ''; ?>

    <div class="orlen-icon-links">

        <a href="<?php echo admin_url('admin.php?page=orlen-auth-settings'); ?>"

            class="<?php echo $current_page === 'orlen-auth-settings' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-lock"></i>

            <span>Dane autoryzacyjne</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-sender-settings'); ?>"

            class="<?php echo $current_page === 'orlen-sender-settings' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-admin-users"></i>

            <span>Dane nadawcy</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-shipping-config'); ?>"

            class="<?php echo $current_page === 'orlen-shipping-config' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-admin-generic"></i>

            <span>Konfiguracja cen</span>

        </a>



          <a href="<?php echo admin_url('admin.php?page=orlen-shipping-history'); ?>"

            class="<?php echo $current_page === 'orlen-shipping-history' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-list-view"></i>

            <span>Historia nadań</span>

        </a>

        

        <a href="<?php echo admin_url('admin.php?page=orlen-paczka-pickup'); ?>"

            class="<?php echo $current_page === 'orlen-paczka-pickup' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-location-alt"></i>

            <span>Historia zamówień kuriera</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-paczka-logs'); ?>"

            class="<?php echo $current_page === 'orlen-paczka-logs' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-visibility"></i>

            <span>Logi</span>

        </a>

    </div>



    <div class="custom-table-wrapper">



        <div style="

            clear: both; 

            width: 100%; 

            box-sizing: border-box; 

            margin: 20px 0; 

            padding: 20px; 

            background: #f0f4f7; 

            text-align: center; 

            font-size: 24px; 

            font-weight: bold; 

            border: 2px solid #0073aa; 

            border-radius: 6px;

        ">

            <p class="cell-muted" style="margin-top:8px;">

                Anulowanie podjazdu kuriera możliwe jest poprzez kontakt z opiekunem handlowym lub z infolinią ORLEN

                Paczka podając numer zamówienia kuriera.

            </p>

        </div>



        <div class="history-actions">

            <select id="bulk-action-courier">

                <option value="">-- Wybierz akcję --</option>

                <option value="generate-protocol">Generuj protokół zbiorczy</option>

            </select>

        <button id="apply-bulk-courier" class="button button-primary">Zastosuj</button>    

        </div><br>



        <div class="custom-table-wrapper">

            <table class="widefat custom-table" id="table-order-courier">

                <thead>

                    <tr>

                        <th class="col-small"><input type="checkbox" id="select-all-courier"></th>

                        <th class="col-small">ID</th>

                        <th>Numer zamówienia <br> kuriera</th>

                        <th>Data przyjazdu kuriera</th>

                        <th>Odbiór od godziny</th>

                        <th>Odbiór do godziny</th>

                        <th>Data zamówienia</th>

                        <th>Nr protokołu</th>

                        <th>Utworzono protok</th>

                        <th>Przesyłki</th>

                        <th>Akcje</th>

                    </tr>

                    <tr class="filters">

                        <th></th>

                        <th></th>

                        <th><input type="text" placeholder="Szukaj"></th>

                        <th><input type="date"></th>

                        <th>

                            <select id="filter-hour-from">

                                <option value="">--</option>

                                <?php for ($h = 8; $h <= 20; $h++) echo "<option value='{$h}'>{$h}</option>"; ?>

                            </select>

                        </th>



                        <th>

                            <select id="filter-hour-to">

                                <option value="">--</option>

                                <?php for ($h = 8; $h <= 20; $h++) echo "<option value='{$h}'>{$h}</option>"; ?>

                            </select>

                        </th>



                        <th><input type="date"></th>

                        <th><input type="text" placeholder="Szukaj"></th>

                        <th><input type="date"></th>

                        <th><input type="text" id="filter-tracking" placeholder="Szukaj"></th>

                        <th><button id="clear-filters-courier" class="clear-filters-btn"

                                title="Wyczyść filtry">✖</button></th>

                    </tr>

                </thead>

              <tbody>

<?php

$orders = wc_get_orders([

    'limit'   => -1,

    'orderby' => 'date',

    'order'   => 'DESC',

]);



if ($orders) :

    $courier_orders = [];



    foreach ($orders as $order) {

        if (!$order instanceof WC_Order) continue;

        $order_id = $order->get_id();



        $has_orlen = false;

        foreach ($order->get_shipping_methods() as $method) {

            if (strpos($method->get_method_id(), 'orlen_paczka') !== false) {

                $has_orlen = true;

                break;

            }

        }

        if (!$has_orlen) continue;



        $all_packages = get_post_meta($order_id, '_orlen_courier_packages', true);

        if (empty($all_packages) || !is_array($all_packages)) continue;



        foreach ($all_packages as $courier_order_number => $courier_packages) {

            foreach ($courier_packages as $pack_code => $package) {

                $courier_orders[$courier_order_number][] = [

                    'order_id'      => $order_id,

                    'pack_code'     => $pack_code,

                    'date'          => $package['date'] ?? '-',

                    'pickup_date'   => $package['pickup']['date'] ?? '-',

                    'pickup_time'   => $package['pickup']['time'] ?? '-',

                    'protocol'      => $package['protocol_number'] ?? '-',  

                    'protocol_date' => $package['protocol_date']   ?? '-', 

                    'protocol_url'  => $package['protocol_url'] ?? '',

                ];

            }

        }

    }



    $counter = 1;

    //$courier_orders = array_reverse($courier_orders, true);
	krsort($courier_orders, SORT_NATURAL);


    foreach ($courier_orders as $courier_order_number => $packages) :

        $first_package = reset($packages);

        $order_ids     = array_unique(array_column($packages, 'order_id')); // wszystkie ID zamówień



        $package_date = $first_package['date'] !== '-' ? explode(' ', $first_package['date'])[0] : '-';

        $pickup_date  = $first_package['pickup_date'];

        $pickup_time  = $first_package['pickup_time'];

        $time_from = $time_to = '';

        if ($pickup_time && strpos($pickup_time, '-') !== false) {

            list($time_from, $time_to) = explode('-', $pickup_time);

        }



        $pack_codes_html = implode('<br>', array_map(function($p){

            return '<a href="https://www.orlenpaczka.pl/sledz-paczke/?numer='.esc_attr($p).'" target="_blank">'.esc_html($p).'</a>';

        }, array_column($packages, 'pack_code')));

?>

<tr data-order-ids="<?php echo esc_attr(implode(',', $order_ids)); ?>">

    <td class="col-small"><input type="checkbox" class="row-select" value="<?php echo esc_attr($courier_order_number); ?>"></td>

    <td class="col-small"><?php echo esc_html($counter); ?></td>

    <td><?php echo esc_html($courier_order_number); ?></td>

    <td><?php echo esc_html($pickup_date ?: '-'); ?></td>

    <td class="hour-from"><?php echo esc_html($time_from ?: '-'); ?></td>

    <td class="hour-to"><?php echo esc_html($time_to ?: '-'); ?></td>

    <td><?php echo esc_html($package_date ?: '-'); ?></td>

    <td><?php echo esc_html($first_package['protocol'] ?: '-'); ?></td>

    <td><?php echo esc_html($first_package['protocol_date'] ?: '-'); ?></td>

    <td><?php echo $pack_codes_html; ?></td>

    <td>

        <?php if (!empty($first_package['protocol_url']) && !empty($first_package['protocol'])) : ?>

            <a href="<?php echo esc_url($first_package['protocol_url']); ?>" target="_blank" class="button button-secondary" title="Drukuj protokół">

                🖨️

            </a>

        <?php else : ?>

            <button class="button button-secondary generate-single-protocol"

                data-order-ids="<?php echo esc_attr(implode(',', $order_ids)); ?>"

                data-courier-order="<?php echo esc_attr($courier_order_number); ?>"

                title="Generuj protokół">

                &#x2B07;

            </button>

        <?php endif; ?>

    </td>

</tr>

<?php 

    $counter++;

    endforeach; 

else: ?>

<tr>

    <td colspan="10">Brak zamówień ORLEN Paczka.</td>

</tr>

<?php endif; ?>

</tbody>



            </table>

        </div>



        <div id="courier-pagination" class="pagination"></div>

    </div>

    <br><br>



    <style>

    .pagination {

        margin: 15px 0;

        text-align: center;

    }



    .pagination .page-link {

        display: inline-block;

        margin: 0 4px;

        padding: 6px 12px;

        background: #f1f1f1;

        border: 1px solid #ccc;

        cursor: pointer;

        border-radius: 4px;

        transition: background 0.2s, color 0.2s;

    }



    .pagination .page-link:hover {

        background: #0073aa;

        color: #fff;

    }



    .pagination .page-link.active {

        background: #0073aa;

        color: #fff;

        font-weight: bold;

    }

    </style>





    <script>

    //Paginacja i Filtry

    jQuery(document).ready(function($) {

        var rowsPerPage = 20;

        var table = $('#table-order-courier');

        var tbody = table.find('tbody');

        var allRows = tbody.find('tr');

        var filteredRows = allRows;

        var numRows = filteredRows.length;

        var numPages = Math.ceil(numRows / rowsPerPage);

        var currentPage = 1;



        function showPage(page) {

            currentPage = page;

            filteredRows.hide();

            var start = (page - 1) * rowsPerPage;

            var end = start + rowsPerPage;

            filteredRows.slice(start, end).show();

            renderPagination();

        }



        function renderPagination() {

            var container = $('#courier-pagination');

            container.empty();

            if (numPages <= 1) return;



            for (var i = 1; i <= numPages; i++) {

                var pageLink = $('<span class="page-link" data-page="' + i + '">' + i + '</span>');

                if (i === currentPage) pageLink.addClass('active');

                container.append(pageLink);

            }



            container.off('click').on('click', '.page-link', function() {

                showPage($(this).data('page'));

            });

        }



        function filterCourierTable() {

            var startHour = parseInt($('#filter-hour-from').val());

            var endHour = parseInt($('#filter-hour-to').val());



            allRows.each(function() {

                var row = $(this);

                var show = true;



                table.find('thead tr.filters th').each(function(index) {

                    var input = $(this).find('input, select');

                    if (input.length && !input.is('#filter-hour-from, #filter-hour-to')) {

                        var filterVal = input.val().toLowerCase().trim();

                        var cellVal = row.find('td').eq(index).text().toLowerCase().trim();

                        if (filterVal && cellVal.indexOf(filterVal) === -1) {

                            show = false;

                            return false;

                        }

                    }

                });



                if (show && (!isNaN(startHour) || !isNaN(endHour))) {

                    var cellFrom = parseInt(row.find('.hour-from').text());

                    var cellTo = parseInt(row.find('.hour-to').text());



                    if (!isNaN(startHour) && cellTo < startHour) show = false;

                    if (!isNaN(endHour) && cellFrom > endHour) show = false;

                }



                row.toggle(show);

            });



            filteredRows = allRows.filter(':visible');

            numRows = filteredRows.length;

            numPages = Math.ceil(numRows / rowsPerPage);

            showPage(1);

        }



        table.find('thead tr.filters input, thead tr.filters select').on('keyup change', function() {

            filterCourierTable();

        });



        $('#select-all-courier').on('change', function() {

            var checked = $(this).is(':checked');

            $('#table-order-courier .row-select').prop('checked', checked);

        });



        $('#clear-filters-courier').on('click', function() {

            table.find('thead tr.filters input').val('');

            table.find('thead tr.filters select').prop('selectedIndex', 0);

            filterCourierTable();

        });





        // --- Automatyczne filtrowanie po numerze przesyłki z parametru URL ---

        var urlParams = new URLSearchParams(window.location.search);

        var trackingFilter = urlParams.get('filter_tracking');

        if (trackingFilter) {

            $('#filter-tracking').val(trackingFilter);

            filterCourierTable();

        }







        showPage(1);

    });







    // Generowanie protokołu dla pojedynczej 

 jQuery(document).ready(function ($) {

    const ajaxurl = '<?php echo admin_url("admin-ajax.php"); ?>';

    const orlen_nonce = '<?php echo wp_create_nonce("orlen_generate_protocol_nonce"); ?>';



    $('.generate-single-protocol').on('click', function (e) {

        e.preventDefault();



        const $btn = $(this);

        const orderIds = $btn.data('order-ids'); // wszystkie ID zamówień

        const courierOrder = $btn.data('courier-order');



        if (!orderIds || !courierOrder) return;



        const parcels = [{

            order_id: orderIds,

            courier_order: courierOrder

        }];



        // Overlay i modal ładowania

        const $overlay = $('<div class="orlen-overlay"></div>').appendTo('body');

        const $modal = $('<div class="orlen-protocol-modal"><p>Generuję protokół… ⏳</p></div>').appendTo('body');

        $('body').css('overflow','hidden');



        $overlay.css({

            position: 'fixed',

            top: 0,

            left: 0,

            width: '100%',

            height: '100%',

            background: 'rgba(0,0,0,0.5)',

            zIndex: 9998

        });



        $modal.css({

            position: 'fixed',

            top: '50%',

            left: '50%',

            transform: 'translate(-50%, -50%)',

            background: '#fff',

            padding: '20px',

            zIndex: 9999,

            border: '1px solid #ccc',

            borderRadius: '8px',

            textAlign: 'center',

            width: '450px',

            maxWidth: '90vw'

        });



        $.post(ajaxurl, {

            action: 'orlen_generate_protocol',

            parcels: parcels,

            _ajax_nonce: orlen_nonce

        }, function (response) {

            $modal.empty();



            if (!response.success) {

                let errorHtml = `<div class="orlen-modal error">

                    <p class="orlen-modal-text"><strong>Błąd generowania protokołu:</strong><br>${response.data?.message || 'Nieznany błąd'}</p>`;



                if (response.data?.errors?.length) {

                    errorHtml += '<ul class="orlen-modal-errors">';

                    response.data.errors.forEach(err => {

                        const opis = err.status_opis ? ` – <em>${err.status_opis}</em>` : '';

                        errorHtml += `<li><strong>${err.pack_code}</strong>: ${err.description} (Err ${err.err})${opis}</li>`;

                    });

                    errorHtml += '</ul>';

                }



                errorHtml += `<div class="orlen-modal-buttons">

                                <button id="close-modal" class="orlen-modal-button secondary">Zamknij</button>

                              </div></div>`;



                $modal.html(errorHtml);



                $('#close-modal').on('click', function () {

                    $modal.remove();

                    $overlay.remove();

                    $('body').css('overflow','auto');

                });

                return;

            }



            // Sukces – wyświetlamy tabelę

            const protocolNumber = response.data.protocol_number || 'brak';

            let html = `<p style="font-weight:bold; font-size:16px;">✅ Wygenerowano protokół ${protocolNumber}</p>`;



            html += `<table style="width:100%; border-collapse:collapse; margin-top:10px; font-size:14px;">

                        <thead>

                            <tr style="border-bottom:1px solid #ddd; text-align:left;">

                                <th style="padding:6px;">Kod paczki</th>

                                <th style="padding:6px;">Status</th>

                            </tr>

                        </thead>

                        <tbody>`;



            // dodane paczki

            if (response.data.packs_added && response.data.packs_added.length) {

                response.data.packs_added.forEach(pack => {

                    html += `<tr style="border-bottom:1px solid #eee;">

                                <td style="padding:6px;">${pack}</td>

                                <td style="padding:6px; color:green;">OK</td>

                             </tr>`;

                });

            }



            // błędy

            if (response.data.errors && response.data.errors.length) {

                response.data.errors.forEach(err => {

                    const desc = err.description ? ` – ${err.description}` : '';

                    const opis = err.status_opis ? ` (${err.status_opis})` : '';

                    html += `<tr style="border-bottom:1px solid #eee;">

                                <td style="padding:6px;">${err.pack_code}</td>

                                <td style="padding:6px; color:red;">Błąd${desc}${opis}</td>

                             </tr>`;

                });

            }



            html += `</tbody></table>`;



            // przyciski

            html += `<div style="margin-top:20px;">

                        ${response.data.protocol_url ? '<button id="print-protocol" class="orlen-modal-button primary">Drukuj</button>' : ''}

                        <button id="close-modal" class="orlen-modal-button secondary">Zamknij</button>

                     </div>`;



            $modal.html(html);



            if (response.data.protocol_url) {

                $('#print-protocol').on('click', function () {

                    const pdfWindow = window.open(response.data.protocol_url, '_blank');

                    if (pdfWindow) { pdfWindow.focus(); pdfWindow.print(); }

                });

            }



            $('#close-modal, .orlen-overlay').on('click', function () {

                $modal.remove(); $overlay.remove(); $('body').css('overflow','auto'); location.reload();

            });



        }).fail(function(xhr,status,error){

            $modal.empty().append(`<p>Wystąpił błąd AJAX: ${error}</p>`);

            const $closeBtn = $('<button>Zamknij</button>').appendTo($modal);

            $closeBtn.on('click', function(){ $modal.remove(); $overlay.remove(); $('body').css('overflow','auto'); });

        });

    });

});









    

    //Obsługa generowania protokołu dla wielu zamówień 

    jQuery(document).ready(function($) {

    const ajaxurl = '<?php echo admin_url("admin-ajax.php"); ?>';

    const orlen_nonce = '<?php echo wp_create_nonce("orlen_generate_protocol_nonce"); ?>';





     $('#apply-bulk-courier').on('click', function(e) {

        e.preventDefault();



        if ($('#bulk-action-courier').val() !== 'generate-protocol') {

            alert('Wybierz akcję "Generuj protokół zbiorczy"');

            return;

        }



        const parcels = [];

        $('#table-order-courier .row-select:checked').each(function() {

            parcels.push({

                courier_order: $(this).val(),

                order_id: $(this).closest('tr').data('order-ids')

            });

        });



        if (parcels.length === 0) {

            alert('Zaznacz przynajmniej jedną paczkę!');

            return;

        }



        const $overlay = $('<div class="orlen-overlay"></div>').appendTo('body');

        const $modal = $('<div class="orlen-protocol-modal"><p>Generuję protokół… ⏳</p></div>').appendTo('body');

        $('body').css('overflow', 'hidden');



        $overlay.css({ position:'fixed', top:0, left:0, width:'100%', height:'100%', background:'rgba(0,0,0,0.5)', zIndex:9998 });

        $modal.css({ position:'fixed', top:'50%', left:'50%', transform:'translate(-50%, -50%)', background:'#fff', padding:'20px', zIndex:9999, border:'1px solid #ccc', borderRadius:'8px', textAlign:'center', width:'450px', maxWidth:'90vw' });



        $.post(ajaxurl, {

            action: 'orlen_generate_protocol',

            parcels: parcels,

            _ajax_nonce: orlen_nonce

        }, function(response) {

            $modal.empty();



            if (!response.success) {

                $modal.html('<p style="color:red;"><strong>Błąd generowania protokołu:</strong> ' + (response.data?.message || 'Nieznany błąd') + '</p>');

                const $closeBtn = $('<button class="orlen-modal-button secondary">Zamknij</button>').appendTo($modal);

                $closeBtn.on('click', function(){ $modal.remove(); $overlay.remove(); $('body').css('overflow','auto'); });

                return;

            }



            const protocolNumber = response.data.protocol_number || 'brak';

            let html = `<p style="font-weight:bold; font-size:16px;">✅ Wygenerowano protokół ${protocolNumber}</p>`;



            // Tabela paczek z dodanymi paczkami i błędami

            html += `<table style="width:100%; border-collapse:collapse; margin-top:10px; font-size:14px;">

                        <thead>

                            <tr style="border-bottom:1px solid #ddd; text-align:left;">

                                <th style="padding:6px;">Kod paczki</th>

                                <th style="padding:6px;">Status</th>

                            </tr>

                        </thead>

                        <tbody>`;



            // dodane paczki

            if (response.data.packs_added && response.data.packs_added.length) {

                response.data.packs_added.forEach(pack => {

                    html += `<tr style="border-bottom:1px solid #eee;">

                                <td style="padding:6px;">${pack}</td>

                                <td style="padding:6px; color:green;">OK</td>

                             </tr>`;

                });

            }



            // błędy

            if (response.data.errors && response.data.errors.length) {

                response.data.errors.forEach(err => {

                    const desc = err.description ? ` – ${err.description}` : '';

                    const opis = err.status_opis ? ` (${err.status_opis})` : '';

                    html += `<tr style="border-bottom:1px solid #eee;">

                                <td style="padding:6px;">${err.pack_code}</td>

                                <td style="padding:6px; color:red;">Błąd${desc}${opis}</td>

                             </tr>`;

                });

            }



            html += `</tbody></table>`;



            // przyciski

            html += `<div style="margin-top:20px;">

                        ${response.data.protocol_url ? '<button id="print-protocol" class="orlen-modal-button primary">Drukuj</button>' : ''}

                        <button id="close-modal" class="orlen-modal-button secondary">Zamknij</button>

                     </div>`;



            $modal.html(html);



            if (response.data.protocol_url) {

                $('#print-protocol').on('click', function() {

                    const pdfWindow = window.open(response.data.protocol_url, '_blank');

                    if (pdfWindow) { pdfWindow.focus(); pdfWindow.print(); }

                });

            }



            $('#close-modal, .orlen-overlay').on('click', function() {

                $modal.remove(); $overlay.remove(); $('body').css('overflow','auto'); location.reload();

            });



        }).fail(function(xhr,status,error){

            $modal.empty().append('<p>Wystąpił błąd AJAX: ' + error + '</p>');

            const $closeBtn = $('<button>Zamknij</button>').appendTo($modal);

            $closeBtn.on('click', function(){ $modal.remove(); $overlay.remove(); $('body').css('overflow','auto'); });

        });



    });

});



    </script>

    <?php

}



}







add_action('wp_ajax_orlen_generate_protocol', 'orlen_generate_protocol_callback');



function orlen_generate_protocol_callback() {

    check_ajax_referer('orlen_generate_protocol_nonce');



    $parcels = $_POST['parcels'] ?? [];

    if (empty($parcels) || !is_array($parcels)) {

        wp_send_json_error(['message' => 'Brak paczek do wysłania']);

    }



    $partner_id  = get_option('orlen_partner_id', '');

    $partner_key = get_option('orlen_partner_key', '');

    $env         = get_option('orlen_env', 'test');



    $all_parcels = [];



    // Pobieranie paczek z bazy

    foreach ($parcels as $p) {

        $order_ids = explode(',', $p['order_id'] ?? '');

        $courier_order_number = sanitize_text_field($p['courier_order'] ?? '');

        foreach ($order_ids as $order_id) {

            $order_id = intval($order_id);

            if (!$order_id) continue;

            $packages = get_post_meta($order_id, '_orlen_courier_packages', true);

            if (empty($packages[$courier_order_number])) continue;

            foreach ($packages[$courier_order_number] as $packData) {

                if (!empty($packData['pack_code'])) {

                    $all_parcels[] = sanitize_text_field($packData['pack_code']);

                }

            }

        }

    }



    $all_parcels = array_unique(array_filter($all_parcels));

    Orlen_Logger::info('[DEBUG] Paczki do protokołu: ' . json_encode($all_parcels));



    if (empty($all_parcels)) {

        wp_send_json_error(['message' => 'Brak paczek do protokołu']);

    }



    try {

        if (!class_exists('SoapClient')) {

            throw new Exception('SoapClient nie jest dostępny na serwerze');

        }



        $soap = new OrlenPaczka_SOAP($env);



        // Tworzenie poprawnego XML dla paczek

        $parcel_items = [];

        foreach ($all_parcels as $pc) {

            $parcel_items[] = new SoapVar(

                $pc,

                XSD_UNSIGNEDLONG,

                null,

                'http://www.w3.org/2001/XMLSchema',

                'unsignedLong',

                'https://91.242.220.103/WebServicePwR'

            );

        }



        $params = [

            'PartnerID'  => $partner_id,

            'PartnerKey' => $partner_key,

            'parcels'    => $parcel_items

        ];



        // Wywołanie GenerateProtocol

        $response = $soap->call('GenerateProtocol', $params);



        // Logowanie request/response XML

        foreach (['REQUEST' => $soap->getLastRequest(), 'RESPONSE' => $soap->getLastResponse()] as $type => $xml) {

            if (!$xml) continue;

            try {

                $dom = new DOMDocument('1.0', 'UTF-8');

                $dom->preserveWhiteSpace = false;

                $dom->formatOutput = true;

                $dom->loadXML($xml);

                Orlen_Logger::info("SOAP {$type} [GENERATE PROTOCOL]\n" . $dom->saveXML());

            } catch (Exception $e) {

                Orlen_Logger::error("Błąd formatowania XML {$type}: " . $e->getMessage());

            }

        }



        // Parsowanie odpowiedzi

        $soapResponseXml = $soap->getLastResponse();

        $dom = new DOMDocument();

        $dom->loadXML($soapResponseXml);

        $xpath = new DOMXPath($dom);

        $xpath->registerNamespace('soap', 'http://schemas.xmlsoap.org/soap/envelope/');

        $xpath->registerNamespace('ns', 'https://91.242.220.103/WebServicePwR');

        $xpath->registerNamespace('diffgr', 'urn:schemas-microsoft-com:xml-diffgram-v1');



        // Parsujemy tabele paczek (jeśli są)

        $tables = $xpath->query('//soap:Body/ns:GenerateProtocolResponse/ns:GenerateProtocolResult/diffgr:diffgram/NewDataSet/Table');



        $valid_parcels  = [];

        $errored_codes  = [];

        $errors         = [];

        $protocolNumber = '';

        $protocolDate   = current_time('mysql');

        $protocolBase64 = '';



        foreach ($tables as $table) {

            $err          = trim($table->getElementsByTagName('Err')->item(0)?->nodeValue ?? '0');

            $errDes       = trim($table->getElementsByTagName('ErrDes')->item(0)?->nodeValue ?? '');

            $packCode     = trim($table->getElementsByTagName('PackCodeRUCH')->item(0)?->nodeValue ?? '');

            $statusOpis   = trim($table->getElementsByTagName('status_opis')->item(0)?->nodeValue ?? '');

            $protocolCode = trim($table->getElementsByTagName('ProtocolCode')->item(0)?->nodeValue ?? '');



            if (!empty($protocolCode)) {

                $protocolNumber = $protocolCode; 

            }



            if ($err === '0') {

                $valid_parcels[] = $packCode;

            } else {

                $errored_codes[] = $packCode;

                $errors[] = [

                    'pack_code'   => $packCode ?: '-',

                    'description' => $errDes,

                    'status_opis' => $statusOpis,

                ];

            }

        }



        // Globalne błędy (GenerateProtocol elementy)

        $globalErrors = $xpath->query('//soap:Body/ns:GenerateProtocolResponse/ns:GenerateProtocolResult/diffgr:diffgram/NewDataSet/GenerateProtocol');

        foreach ($globalErrors as $ge) {

            $err = trim($ge->getElementsByTagName('Err')->item(0)?->nodeValue ?? '0');

            $errDes = trim($ge->getElementsByTagName('ErrDes')->item(0)?->nodeValue ?? '');

            if ($err !== '0') {

                $errors[] = [

                    'pack_code' => '-',

                    'description' => $errDes ?: 'Błąd API',

                    'status_opis' => "Kod błędu: {$err}"

                ];

            }

        }



        // Pobranie LabelData (PDF)

        $labelNode = $dom->getElementsByTagName('LabelData')->item(0);

        if ($labelNode) {

            $protocolBase64 = $labelNode->nodeValue;

        }



        $protocolFileUrl = null;

        if ($protocolBase64 && $protocolNumber) {

            $upload_dir = wp_upload_dir();

            $dir = trailingslashit($upload_dir['basedir']) . 'orlen-protocols/';

            if (!is_dir($dir)) wp_mkdir_p($dir);

            $file_path = $dir . "protocol-{$protocolNumber}.pdf";

            file_put_contents($file_path, base64_decode($protocolBase64));

            $protocolFileUrl = trailingslashit($upload_dir['baseurl']) . "orlen-protocols/protocol-{$protocolNumber}.pdf";

        }



        // ***************

        // ZAPIS DO BAZY — ZAWSZE dla WSZYSTKICH paczek pod danym courier_order_number

        // ***************

        foreach ($parcels as $p) {

            $order_ids = explode(',', $p['order_id'] ?? '');

            $courier_order_number = sanitize_text_field($p['courier_order'] ?? '');

            foreach ($order_ids as $order_id) {

                $order_id = intval($order_id);

                if (!$order_id) continue;



                $packages = get_post_meta($order_id, '_orlen_courier_packages', true);

                if (empty($packages[$courier_order_number])) continue;



                // jeśli struktura pakietów jest asocjacyjna lub indeksowa — iterujemy po kluczach

                foreach ($packages[$courier_order_number] as $key => $packData) {

                    // upewnij się, że mamy tablicę

                    if (!is_array($packData)) continue;



                    // ZAPISUJEMY NAWET JEŚLI paczka miała błąd — ustawiamy protokół (może być pusty)

                    $packages[$courier_order_number][$key]['protocol_number'] = $protocolNumber;

                    $packages[$courier_order_number][$key]['protocol_date']   = $protocolDate;

                    $packages[$courier_order_number][$key]['protocol_url']    = $protocolFileUrl;

                }



                // zapisujemy zaktualizowaną strukturę

                update_post_meta($order_id, '_orlen_courier_packages', $packages);

            }

        }



        // Przygotowanie komunikatu do popup

        $message = '';

        if (!empty($protocolNumber)) {

            $message .= '✅ Wynik generowania protokołu<br>';

            $message .= '<strong>Numer protokołu:</strong> ' . esc_html($protocolNumber) . '<br>';

        } else {

            $message .= 'Wynik generowania protokołu<br>';

            $message .= '<strong>Numer protokołu:</strong> brak<br>';

        }



        if (!empty($errors)) {

            $message .= sprintf('<br><strong>Uwaga:</strong> %d przesyłek nie dodano do protokołu:', count($errors));

            foreach ($errors as $e) {

                $message .= sprintf(

                    '<br>📦 <code>%s</code> — %s (%s)',

                    esc_html($e['pack_code']),

                    esc_html($e['description']),

                    esc_html($e['status_opis'])

                );

            }

        }



        if (!empty($errors)) {

            Orlen_Logger::warning('[GENERATE_PROTOCOL] Błędy dla paczek: ' . json_encode($errors, JSON_UNESCAPED_UNICODE));

        }



        wp_send_json_success([

            'message'         => $message,

            'protocol_number' => $protocolNumber,

            'protocol_url'    => $protocolFileUrl,

            'protocol_date'   => $protocolDate,

            'errors'          => $errors,

            'packs_added'     => array_values($valid_parcels),

            'packs_failed'    => array_values($errored_codes),

        ]);



    } catch (Exception $e) {

        $msg = "Błąd GENERATEPROTOCOL: " . $e->getMessage();

        if (class_exists('Orlen_Logger')) {

            Orlen_Logger::error($msg);

        } else {

            error_log($msg);

        }

        wp_send_json_error(['message' => $e->getMessage()]);

    }

}













