<?php



class Orlen_Paczka_Shipping_History {



    const MAX_WEIGHT = 20; // maksymalna dopuszczalna waga paczki



    public static function render_shipping_history_page() {

        ?>

<div class="wrap orlen-box">



    <h1 class="orlen-logo">

        <span class="logo-title">

            <span class="logo-icon"></span>

            Historia nadań

        </span>

        <a href="<?php echo admin_url('admin.php?page=orlen-paczka-panel'); ?>" class="orlen-help-link">

            <i class="dashicons dashicons-info"></i>

            <span>Pomoc</span>

        </a>

    </h1>



    <?php $current_page = $_GET['page'] ?? ''; ?>

    <div class="orlen-icon-links">

        <a href="<?php echo admin_url('admin.php?page=orlen-auth-settings'); ?>"

            class="<?php echo $current_page === 'orlen-auth-settings' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-lock"></i>

            <span>Dane autoryzacyjne</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-sender-settings'); ?>"

            class="<?php echo $current_page === 'orlen-sender-settings' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-admin-users"></i>

            <span>Dane nadawcy</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-shipping-config'); ?>"

            class="<?php echo $current_page === 'orlen-shipping-config' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-admin-generic"></i>

            <span>Konfiguracja cen</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-shipping-history'); ?>"

            class="<?php echo $current_page === 'orlen-shipping-history' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-list-view"></i>

            <span>Historia nadań</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-paczka-pickup'); ?>"

            class="<?php echo $current_page === 'orlen-paczka-pickup' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-location-alt"></i>

            <span>Historia zamówień kuriera</span>

        </a>



        <a href="<?php echo admin_url('admin.php?page=orlen-paczka-logs'); ?>"

            class="<?php echo $current_page === 'orlen-paczka-logs' ? 'active' : ''; ?>">

            <i class="dashicons dashicons-visibility"></i>

            <span>Logi</span>

        </a>

    </div>



    <div class="history-actions">

        <select id="bulk-action">

            <option value="">-- Wybierz akcję --</option>

            <option value="zbiorcze-generowanie-labels">Zbiorcze generowanie etykiet</option>

            <option value="generate-protocol-history">Generuj protokół zbiorczy</option>

            <option value="zamow-kuriera">Zamów przyjazd kuriera</option>

        </select>

        <button id="apply-bulk" class="button button-primary">Zastosuj</button>

    </div><br>



    <div class="custom-table-wrapper">

        <table class="widefat custom-table" id="table-label-generator">

            <thead>

                <tr class="small-header">

                    <th class="col-small"><input type="checkbox" id="select-all-label"></th>

                    <th class="col-small">ID</th>

                    <th>Id <br> zamówienia</th>

                    <th>Login</th>

                    <th>Adres nadania</th>

                    <th>Nr<br> przesyłki</th>

                    <th>Kod<br> PUDO/APM</th>

                    <th class="col-small-1">Gabaryt</th>

                    <th>Pole <br>referencyjne</th>

                    <th>Nr <br>telefonu</th>

                    <th>Email</th>

                    <th>Data<nr> zamówienia</th>

                    <th>Data<nr> etykiety</th>

                    <th class="col-small-1">Etykieta</th>

                    <th class="col-small-1">Protokół</th>

                    <th class="col-small-1">Zamówienie<br> kuriera</th>

                    <th>Akcje</th>

                </tr>

                <tr class="filters">

                    <th></th>

                    <th></th>

                    <th><input type="text" id="filter-order-id" placeholder="Id zamówienia"></th>

                    <th><input type="text" placeholder="Login"></th>

                    <th><input type="text" placeholder="Login"></th>

                    <th><input type="text" placeholder="Nr przesyłki"></th>

                    <th><input type="text" placeholder="Kod PUDO/APM"></th>

                    <th> <select>

                            <option value="">--</option>

                            <option value="S">S</option>

                            <option value="M">M</option>

                            <option value="L">L</option>

                        </select> </th>

                    <th><input type="text" placeholder="Pole ref"></th>

                    <th><input type="text" placeholder="Nr tel"></th>

                    <th><input type="text" placeholder="Email"></th>

                    <th><input type="date"></th>

                    <th><input type="date"></th>

                    <th> <select>

                            <option value="">--</option>

                            <option value="Tak">Tak</option>

                            <option value="Nie">Nie</option>

                        </select> </th>

                    <th> <select>

                            <option value="">--</option>

                            <option value="Tak">Tak</option>

                            <option value="Nie">Nie</option>

                        </select> </th>

                    <th> <select>

                            <option value="">--</option>

                            <option value="Tak">Tak</option>

                            <option value="Nie">Nie</option>

                        </select> </th>

                    <th><button id="clear-filters" class="clear-filters-btn" title="Wyczyść filtry">✖</button></th>

                </tr>



            </thead>



            <tbody>

                <?php

   $orders = wc_get_orders([

    'limit'   => 20,

    'orderby' => 'date',

    'order'   => 'DESC',

]);



if ($orders) {

    $count = 0;



    $order_colors = [];

    $color_palette = ['#F8F8F9', '#ffffff'];

    $color_index = 0;



    foreach ($orders as $order) {

        $order_id = $order->get_id();



        $has_orlen = false;

        foreach ($order->get_shipping_methods() as $method) {

            if (strpos($method->get_method_id(), 'orlen_paczka') !== false) {

                $has_orlen = true;

                break;

            }

        }

        if (!$has_orlen) continue;



        $gabaryty = get_post_meta($order_id, '_orlen_paczka_size', false);

        $sender_order = get_post_meta($order_id, '_orlen_courier_packages', true);



        $has_packages = false;

        if (!empty($gabaryty) && is_array($gabaryty)) {

            foreach ($gabaryty as $g) {

                $decoded_test = is_array($g) ? $g : json_decode($g, true);

                if (!empty($decoded_test) && is_array($decoded_test)) {

                    $has_packages = true;

                    break;

                }

            }

        }



        // kolor wierszy wg zamówienia

        if (!isset($order_colors[$order_id])) {

            $order_colors[$order_id] = $color_palette[$color_index % count($color_palette)];

            $color_index++;

        }

        $row_color = $order_colors[$order_id];



        // ==========================================

        // jeśli zamówienie ma paczki ORLEN

        // ==========================================

        if ($has_packages) {

            $gabaryty = array_reverse($gabaryty);



            foreach ($gabaryty as $json) {

                $count++;

                $decoded = is_array($json) ? $json : json_decode($json, true);

                if (empty($decoded) || !is_array($decoded)) continue;



                $size = $decoded['size'] ?? '-';

                $pack = $decoded['pack_code'] ?? '-';

                $phone = $decoded['phone'] ?? '';

                $email = $decoded['email'] ?? '';

                $sender_order_type = $decoded['sender_order_type'] ?? '';

                $custom_comment = $decoded['custom_comment'] ?? '';

                $orlen_partner_id = $decoded['orlen_partner_id'] ?? '';



                $protocol_number = '';

                $protocol_url = '';

                $has_protocol = false;



                if (!empty($sender_order) && is_array($sender_order)) {

                    foreach ($sender_order as $sender_id => $packages_list) {

                        if (isset($packages_list[$pack]) && is_array($packages_list[$pack])) {

                            $pack_data = $packages_list[$pack];

                            if (!empty($pack_data['protocol_number'])) {

                                $protocol_number = $pack_data['protocol_number'];

                                $protocol_url = $pack_data['protocol_url'] ?? '';

                                $has_protocol = true;

                                break;

                            }

                        }

                    }

                }



                if (!$has_protocol) {

                    $protocols = get_post_meta($order_id, '_orlen_protocols', true);

                    if (!empty($protocols) && is_array($protocols)) {

                        foreach ($protocols as $protocol_data) {

                            if (

                                isset($protocol_data['packs']) &&

                                is_array($protocol_data['packs']) &&

                                in_array($pack, $protocol_data['packs'], true)

                            ) {

                                $protocol_number = $protocol_data['protocol_number'] ?? '';

                                $protocol_url = $protocol_data['protocol_url'] ?? '';

                                $has_protocol = true;

                                break;

                            }

                        }

                    }

                }



                $already_ordered = false;

                if (!empty($sender_order) && is_array($sender_order)) {

                    foreach ($sender_order as $courier_order_number => $packages) {

                        if (isset($packages[$pack]) && ($packages[$pack]['status'] ?? '') === 'ordered') {

                            $already_ordered = true;

                            break;

                        }

                    }

                }



                $senders = get_option('orlen_senders', []);

                $selected_store = get_post_meta($order_id, '_selected_store', true);

                $sender_name = '-';

                if (!empty($senders) && $selected_store !== '' && isset($senders[$selected_store])) {

                    $sender_data = $senders[$selected_store];

                    $sender_name = $sender_data['name'] ?? '-';

                }



                echo '<tr data-order-id="' . esc_attr($order_id) . '" style="background-color:' . esc_attr($row_color) . ';">';

                echo '<td class="col-small"><input type="checkbox" class="row-select" '

                    . 'value="' . esc_attr($order_id . '|' . $decoded['id']) . '" '

                    . 'data-pack="' . esc_attr($pack) . '"></td>';



                echo '<td class="col-small">' . $count . '</td>';

               $order_edit_link = get_edit_post_link( $order_id );

                echo '<td><a href="' . esc_url( $order_edit_link ) . '" title="Idź do zamówienia">' . esc_html( $order->get_order_number() ) . '</a></td>';

                echo '<td>' . esc_html($orlen_partner_id ?: '-') . '</td>';

                echo '<td>' . esc_html($sender_name) . '</td>';

                echo '<td>' . ($pack ? '<a href="https://www.orlenpaczka.pl/sledz-paczke/?numer=' . esc_attr($pack) . '" target="_blank">' . esc_html($pack) . '</a>' : '-') . '</td>';

                echo '<td>' . esc_html($decoded['pickup_point'] ?? '-') . '</td>';

                echo '<td>' . esc_html($size) . '</td>';



                echo '<td>';

                if ($sender_order_type === 'nr_zamowienia_woo') {

                    echo esc_html($order->get_order_number());

                } elseif ($sender_order_type === 'wlasny_opis') {

                    echo esc_html($custom_comment ?: '-');

                } else {

                    echo '-';

                }

                echo '</td>';



                echo '<td>' . esc_html($phone ?: '-') . '</td>';

                echo '<td>' . esc_html($email ?: '-') . '</td>';

                echo '<td>' . esc_html($order->get_date_created() ? $order->get_date_created()->date('Y-m-d') : '-') . '</td>';

                echo '<td>' . (!empty($decoded['timestamp']) ? date('Y-m-d', $decoded['timestamp']) : '-') . '</td>';

                echo '<td>' . (!empty($decoded['label_url']) ? 'Tak' : 'Nie') . '</td>';



                echo '<td>';

                if ($has_protocol) {

                    echo '<a href="' . esc_url($protocol_url) . '" target="_blank" title="Drukuj protokół">Tak</a>';

                } else {

                    echo 'Nie';

                }

                echo '</td>';



                        $filter_url = add_query_arg(

                array(

                    'page' => 'orlen-paczka-pickup',

                    'filter_tracking' => $pack,

                ),

                admin_url('admin.php')

            );



            echo '<td>';

            if ( $already_ordered ) {

                echo '<a href="' . esc_url( $filter_url ) . '">Tak</a>';

            } else {

                echo 'Nie';

            }

            echo '</td>';





                echo '<td>';

            if (!empty($decoded['label_url'])) {

                    echo '<button class="button button-secondary print-label" '

                        . 'data-label-url="' . esc_url($decoded['label_url']) . '" '

                        . 'title="Drukuj etykietę">🖨️</button>';

                } else {

                    echo '<button class="button button-secondary generate-label-history" '

                        . 'data-order-id="' . esc_attr($order_id) . '" '

                        . 'data-package-id="' . esc_attr($decoded['id']) . '" '

                        . 'title="Generuj etykietę">&#x2B07;</button>';

                }



                echo '</td>';

                echo '</tr>';

            }



        // ==========================================

        // zamówienie BEZ paczki ORLEN

        // ==========================================

        } else {

            $count++;

            echo '<tr data-order-id="' . esc_attr($order_id) . '" style="background-color:' . esc_attr($row_color) . ';">';

            echo '<td class="col-small"><input type="checkbox" class="row-select" value="' . esc_attr($order_id) . '"></td>';

            echo '<td class="col-small">' . $count . '</td>';

            $order_edit_link = get_edit_post_link( $order_id );

            echo '<td><a href="' . esc_url( $order_edit_link ) . '">' . esc_html( $order->get_order_number() ) . '</a></td>';

            echo '<td>-</td>';

            echo '<td>-</td>';

            echo '<td>-</td>';

            echo '<td>-</td>';

            echo '<td>-</td>';

            echo '<td>-</td>';

            echo '<td>-</td>';

            echo '<td>-</td>';

            echo '<td>' . esc_html($order->get_date_created() ? $order->get_date_created()->date('Y-m-d') : '-') . '</td>';

            echo '<td>-</td>';

            echo '<td>Nie</td>';

            echo '<td>Nie</td>';

            echo '<td>Nie</td>';

            echo '<td>-</td>';

            echo '</tr>';

        }

    }

} else {

    echo '<tr><td colspan="16">Brak zamówień ORLEN Paczka.</td></tr>';

}





    ?>

            </tbody>

        </table>

    </div>



    <div id="pagination-container" class="pagination"></div>

    <br><br>

</div>

</div>







<div id="orlen-popup" style="display:none;">

    <div id="orlen-popup-content"

        style="padding:20px; background:#fff; max-width:600px; margin:50px auto; border-radius:8px;">

        <h2>Dostępne terminy podjazdu kuriera</h2>

        <div id="orlen-popup-body">

            <!-- Tutaj JS wstawi inputy i selecty -->

        </div>

        <div style="text-align:right; margin-top:20px;">

            <button id="orlen-popup-save" class="button button-primary">Zamów</button>

            <button id="orlen-popup-close" class="button">Zamknij</button>

        </div>

    </div>





    <style>

    .pagination {

        margin: 15px 0;

        text-align: center;

    }



    .pagination .page-link {

        display: inline-block;

        margin: 0 4px;

        padding: 6px 12px;

        background: #f1f1f1;

        border: 1px solid #ccc;

        cursor: pointer;

        border-radius: 4px;

        transition: background 0.2s, color 0.2s;

    }



    .pagination .page-link:hover {

        background: #0073aa;

        color: #fff;

    }



    .pagination .page-link.active {

        background: #0073aa;

        color: #fff;

        font-weight: bold;

    }

    </style>







    <script>

    //Paginacja i Filtry

    jQuery(document).ready(function($) {

        var rowsPerPage = 20;

        var table = $('#table-label-generator');

        var tbody = table.find('tbody');

        var allRows = tbody.find('tr');

        var filteredRows = allRows;

        var numRows = filteredRows.length;

        var numPages = Math.ceil(numRows / rowsPerPage);

        var currentPage = 1;



        function showPage(page) {

            currentPage = page;

            filteredRows.hide();

            var start = (page - 1) * rowsPerPage;

            var end = start + rowsPerPage;

            filteredRows.slice(start, end).show();

            renderPagination();

        }



        function renderPagination() {

            var container = $('#pagination-container');

            container.empty();

            if (numPages <= 1) return;



            for (var i = 1; i <= numPages; i++) {

                var pageLink = $('<span class="page-link" data-page="' + i + '">' + i + '</span>');

                if (i === currentPage) pageLink.addClass('active');

                container.append(pageLink);

            }



            container.off('click').on('click', '.page-link', function() {

                showPage($(this).data('page'));

            });

        }



        // Filtrowanie

        function filterTable() {

            allRows.each(function() {

                var row = $(this);

                var show = true;



                table.find('thead tr.filters th').each(function(index) {

                    var input = $(this).find('input, select');

                    if (input.length) {

                        var filterVal = input.val().toLowerCase().trim();

                        var cellVal = row.find('td').eq(index).text().toLowerCase().trim();

                        if (filterVal && cellVal.indexOf(filterVal) === -1) {

                            show = false;

                            return false;

                        }

                    }

                });



                row.toggle(show);

            });



            filteredRows = allRows.filter(':visible');

            numRows = filteredRows.length;

            numPages = Math.ceil(numRows / rowsPerPage);

            showPage(1);

        }



        table.find('thead tr.filters input, thead tr.filters select').on('keyup change', function() {

            filterTable();

        });



        $('#select-all-label').on('change', function() {

            var checked = $(this).is(':checked');

            filteredRows.find('.row-select').prop('checked', checked);

        });



        $('#clear-filters').on('click', function() {

            table.find('thead tr.filters input').val('');

            table.find('thead tr.filters select').prop('selectedIndex', 0);

            filterTable();

        });





        // --- Automatyczne filtrowanie po ID zamówienia z URL ---

        var urlParams = new URLSearchParams(window.location.search);

        var orderFilter = urlParams.get('filter_order_id');

        if (orderFilter) {

            $('#filter-order-id').val(orderFilter);

            filterTable();

        }



        showPage(1);

    });

    </script>



    <style>

    #orlen-popup {

        display: none;

        position: fixed;

        top: 0;

        left: 0;

        width: 100%;

        height: 100%;

        background: rgba(0, 0, 0, 0.6);

        z-index: 9999;

    }



    #orlen-popup-content {

        background: #fff;

        max-width: 600px;

        margin: 10% auto;

        padding: 20px;

        border-radius: 8px;

        position: relative;

        z-index: 10000;

    }



    .orlen-field {

        display: flex;

        align-items: center;

        margin-bottom: 10px;

    }



    .orlen-field label {

        flex: 0 0 150px;

        font-weight: bold;

    }



    .orlen-field input,

    .orlen-field select {

        flex: 1;

        padding: 5px;

    }

    </style>





    <script>

    // Generowanie protokołów zbiorczych

    jQuery(document).ready(function($) {

        $('#apply-bulk').on('click', function(e) {

            e.preventDefault();

            const action = $('#bulk-action').val();

            if (!action) return;



            if (action === 'generate-protocol-history') {

                const parcels = [];

                $('.row-select:checked').each(function() {

                    const orderId = $(this).closest('tr').data('order-id');

                    const packCode = $(this).data('pack');

                    if (orderId && packCode) {

                        parcels.push({

                            order_id: orderId,

                            pack_code: packCode

                        });

                    }

                });



                if (parcels.length === 0) {

                    alert('⚠️ Nie wybrano paczek do protokołu');

                    return;

                }



                // Tworzymy overlay i modal

                const $overlay = $('<div class="orlen-overlay"></div>').appendTo('body');

                const $modal = $('<div class="orlen-protocol-modal"></div>').appendTo('body');

                $('body').css('overflow', 'hidden'); // blokuje scroll strony



                $overlay.css({

                    position: 'fixed',

                    top: 0,

                    left: 0,

                    width: '100%',

                    height: '100%',

                    background: 'rgba(0,0,0,0.5)',

                    'z-index': 9998

                });



                $modal.css({

                    position: 'fixed', top: '50%', left: '50%', transform: 'translate(-50%, -50%)',

                    background: '#fff', padding: '20px', 'z-index': 9999, border: '1px solid #ccc',

                    'border-radius': '10px', 'text-align': 'center', width: '500px',

                    'box-shadow': '0 4px 15px rgba(0,0,0,0.2)'

                });



                $modal.html('<p>Generuję protokół… ⏳</p>');



                // Wysyłamy AJAX

                $.post(ajaxurl, {

                    action: 'orlen_generate_protocol_history',

                    parcels: parcels,

                    _ajax_nonce: '<?php echo wp_create_nonce("orlen_generate_protocol_history_nonce"); ?>'

                }, function(response) {

                    $modal.empty();



                    if (response.success) {

                        const msg = response.data.message || '✅ Protokół wygenerowany';

                        const protocolUrl = response.data.protocol_url || null;

                        const packageResults = response.data.package_results || {};



                        let resultsHtml = '';



                        if (Object.keys(packageResults).length > 0) {

                            resultsHtml = `

                            <table style="width:100%;border-collapse:collapse;margin-top:8px;font-size:14px;">

                                <thead>

                                    <tr style="border-bottom:1px solid #ddd;text-align:left;">

                                        <th style="padding:6px;">Kod paczki</th>

                                        <th style="padding:6px;">Status</th>

                                    </tr>

                                </thead>

                                <tbody>

                        `;



                            Object.entries(packageResults).forEach(([pack, info]) => {

                                const ok = info.err === '0';

                                const color = ok ? 'green' : 'red';

                                const text = info.errDes ?

                                    `${info.errDes}${info.status_opis ? ' (' + info.status_opis + ')' : ''}` :

                                    (info.status_opis || '');

                                resultsHtml += `

                                <tr style="border-bottom:1px solid #eee;">

                                    <td style="padding:6px;">${pack}</td>

                                    <td style="padding:6px;color:${color};">${text}</td>

                                </tr>

                            `;

                            });



                            resultsHtml += '</tbody></table>';

                        }



                        $modal.html(`

                        <div class="orlen-modal-content">

                            <p style="font-weight:bold;font-size:16px;">${msg}</p>

                            ${resultsHtml}

                            <div class="orlen-modal-buttons" style="margin-top:20px;">

                                ${protocolUrl ? 

                                    '<button id="print-protocol" class="orlen-modal-button primary">Drukuj</button>' 

                                    : ''

                                }

                                <button id="close-modal" class="orlen-modal-button secondary">Zamknij</button>

                            </div>

                        </div>

                    `);



                        // Style przycisków

                        $('.orlen-modal-btn').css({

                            padding: '8px 16px',

                            border: 'none',

                            'border-radius': '6px',

                            cursor: 'pointer',

                            'font-weight': 'bold',

                            'font-size': '14px'

                        });

                        $('.orlen-modal-btn.primary').css({

                            background: '#2271b1',

                            color: '#fff',

                            marginRight: '10px'

                        });

                        $('.orlen-modal-btn.secondary').css({

                            background: '#f0f0f0',

                            color: '#333'

                        });



                        // Drukowanie PDF

                        if (protocolUrl) {

                            $('#print-protocol').on('click', function() {

                                const w = window.open(protocolUrl, '_blank');

                                if (w) {

                                    w.focus();

                                    w.print();

                                }

                            });

                        }



                        // Zamknięcie modala

                        $('#close-modal, .orlen-overlay').on('click', function() {

                            $modal.remove();

                            $overlay.remove();

                            $('body').css('overflow', 'auto');

                            location.reload();

                        });



                    } else {

                        $modal.html(`

                        <p style="color:red;font-weight:bold;">⚠️ ${response.data?.message || 'Nie udało się wygenerować protokołu.'}</p>

                        <button id="close-modal" class="orlen-modal-btn secondary" style="margin-top:15px;">Zamknij</button>

                    `);



                        $('#close-modal').on('click', function() {

                            $modal.remove();

                            $overlay.remove();

                            $('body').css('overflow', 'auto');

                        });

                    }



                }).fail(function() {

                    $modal.html(`

                    <p style="color:red;">❌ Błąd połączenia AJAX</p>

                    <button id="close-modal" class="orlen-modal-btn secondary" style="margin-top:15px;">Zamknij</button>

                `);

                    $('#close-modal').on('click', function() {

                        $modal.remove();

                        $overlay.remove();

                        $('body').css('overflow', 'auto');

                    });

                });

            }

        });

    });

    </script>



    <?php

    }

}







// Generowanie protokołu

add_action('wp_ajax_orlen_generate_protocol_history', 'orlen_generate_protocol_history_callback');



function orlen_generate_protocol_history_callback() {

    if (!isset($_POST['_ajax_nonce']) || !wp_verify_nonce($_POST['_ajax_nonce'], 'orlen_generate_protocol_history_nonce')) {

        Orlen_Logger::error("Nieprawidłowy nonce AJAX.");

        wp_send_json_error(['message' => 'Nieprawidłowy nonce AJAX.']);

    }



    $parcels = $_POST['parcels'] ?? [];



    $parcels = array_filter($parcels, function($p) {

        $pack_code = trim($p['pack_code'] ?? '');

        return $pack_code !== '' && $pack_code !== '-';

    });



    if (empty($parcels)) {

        Orlen_Logger::info("Brak paczek do protokołu.");

        wp_send_json_error(['message' => 'Brak paczek do protokołu']);

    }



    try {

        $parcelItems = [];

        foreach ($parcels as $p) {

            $parcelItems[] = new SoapVar($p['pack_code'], XSD_STRING, null, null, 'packCode', 'https://91.242.220.103/WebServicePwR');

        }



        $partner_id  = get_option('orlen_partner_id', '');

        $partner_key = get_option('orlen_partner_key', '');

        $env         = get_option('orlen_env', 'test');



        $soap = new OrlenPaczka_SOAP($env);

        $soap->call('GenerateProtocol', [

            'PartnerID'  => $partner_id,

            'PartnerKey' => $partner_key,

            'parcels'    => $parcelItems,

        ]);



        // 🔹 Formatowanie XML do loga (kopertowo)

        $prettyXml = function ($xml) {

            if (empty($xml)) return '';

            libxml_use_internal_errors(true);

            $dom = new DOMDocument('1.0', 'UTF-8');

            $dom->preserveWhiteSpace = false;

            $dom->formatOutput = true;

            if (@$dom->loadXML($xml)) return $dom->saveXML();

            return substr($xml, 0, 2000);

        };



        // 🔹 Pobranie i anonimizacja zapytań SOAP

        $requestXml  = $soap->getLastRequest();

        $responseXml = $soap->getLastResponse();

        if ($requestXml && str_contains($requestXml, '<PartnerKey>')) {

            $requestXml = preg_replace('/<PartnerKey>.*?<\/PartnerKey>/', '<PartnerKey>***REDACTED***</PartnerKey>', $requestXml);

        }



        Orlen_Logger::info("\n==================== 📨 SOAP REQUEST ====================\n" .

            $prettyXml($requestXml) . "\n==================== 📦 SOAP RESPONSE ====================\n" .

            $prettyXml($responseXml) . "\n==========================================================="

        );



        // 🔹 Parsowanie odpowiedzi SOAP

        $dom = new DOMDocument();

        $dom->loadXML($responseXml);

        $xpath = new DOMXPath($dom);



        $protocolNumber = '';

        $protocolBase64 = '';

        $protocolDate   = current_time('mysql');

        $packageResults = [];

        $errors         = [];



        // 🔹 Odczyt numeru protokołu

        $nodes = $xpath->query('//*[local-name()="ProtocolCode"]');

        if ($nodes->length > 0) {

            $protocolNumber = $nodes->item(0)->nodeValue;

        }



        // 🔹 Odczyt PDF protokołu

        $pdfNodes = $xpath->query('//*[local-name()="LabelData"]');

        if ($pdfNodes->length > 0) {

            $protocolBase64 = $pdfNodes->item(0)->nodeValue;

        }



        // 🔹 Parsowanie tabeli paczek

        $rows = $xpath->query('//*[local-name()="Table"]');

        foreach ($rows as $row) {

            $packCode  = $xpath->evaluate('string(./*[local-name()="PackCodeRUCH"])', $row);

            $err       = $xpath->evaluate('string(./*[local-name()="Err"])', $row);

            $errDes    = $xpath->evaluate('string(./*[local-name()="ErrDes"])', $row);

            $statusOp  = $xpath->evaluate('string(./*[local-name()="status_opis"])', $row);



            $packageResults[$packCode] = [

                'err'         => $err,

                'errDes'      => $errDes,

                'status_opis' => $statusOp,

            ];



            if ($err !== '0') {

                $errors[] = "Paczka {$packCode}: {$errDes} ({$statusOp})";

            }

        }



        // 🔹 Parsowanie globalnych błędów (np. PartnerKey błędny)

        $globalErrs = $xpath->query('//*[local-name()="GenerateProtocol"]');

        foreach ($globalErrs as $ge) {

            $err    = $xpath->evaluate('string(./*[local-name()="Err"])', $ge);

            $errDes = $xpath->evaluate('string(./*[local-name()="ErrDes"])', $ge);

            if ($err && $err !== '0') {

                $errors[] = "Globalny błąd API ({$err}): {$errDes}";

            }

        }



        // 🔹 Logowanie błędów API

        if (!empty($errors)) {

            Orlen_Logger::error("[GenerateProtocol] Błędy API:\n" . implode("\n", $errors));

        }



        // 🔹 Zapis PDF

        $file_url = null;

        if ($protocolBase64 && $protocolNumber) {

            $upload_dir = wp_upload_dir();

            $dir = trailingslashit($upload_dir['basedir']) . 'orlen-protocols/';

            if (!is_dir($dir)) wp_mkdir_p($dir);

            $file_path = $dir . "protocol-{$protocolNumber}.pdf";

            file_put_contents($file_path, base64_decode($protocolBase64));

            $file_url = trailingslashit($upload_dir['baseurl']) . "orlen-protocols/protocol-{$protocolNumber}.pdf";

            Orlen_Logger::info("PDF protokołu zapisany: $file_url");

        }



        // 🔹 Zapis meta do zamówień tylko dla poprawnych paczek

        foreach ($parcels as $p) {

            $pack_code = $p['pack_code'];

            if (!isset($packageResults[$pack_code])) continue;

            if ($packageResults[$pack_code]['err'] !== '0') continue;



            $order_id = intval($p['order_id']);

            if (!$order_id) continue;



            $protocols = get_post_meta($order_id, '_orlen_protocols', true);

            if (!is_array($protocols)) $protocols = [];



            $protocols[] = [

                'protocol_number' => $protocolNumber,

                'protocol_url'    => $file_url,

                'protocol_date'   => $protocolDate,

                'packs'           => [$pack_code],

            ];



            update_post_meta($order_id, '_orlen_protocols', $protocols);

        }



// 🔹 Komunikat końcowy

if (!empty($errors)) {

    // jeśli są globalne błędy (np. autoryzacja), pokazujemy je wprost

    $message = "<br>" . implode('<br>', array_map('esc_html', $errors));

} elseif ($protocolNumber) {

    $message = "✅ Wygenerowano protokół <strong>{$protocolNumber}</strong>.";

} else {

    $message = "⚠️ Częściowy sukces: nie wszystkie paczki dodano.";

}





        wp_send_json_success([

            'protocol_number'  => $protocolNumber,

            'protocol_url'     => $file_url,

            'protocol_date'    => $protocolDate,

            'package_results'  => $packageResults,

            'message'          => $message,

            'errors'           => $errors,

        ]);



    } catch (Exception $e) {

        Orlen_Logger::error("Błąd GENERATEPROTOCOL_HISTORY: " . $e->getMessage());

        wp_send_json_error(['message' => $e->getMessage()]);

    }

}













//Generowanie Etykiet dla wielu i zapis w jednym PDF

add_action('wp_ajax_orlen_bulk_generate_labels', 'orlen_bulk_generate_labels_handler');



function orlen_bulk_generate_labels_handler() {

    if (empty($_POST['packages']) || !is_array($_POST['packages'])) {

        Orlen_Logger::warning("Brak danych przesłanych do bulk_generate_labels.");

        wp_send_json_error('Brak danych.');

    }



    $map = [

        'PDF'   => 'PDF',

        'PDF10' => 'PDF10',

        'EPL'   => 'EPL',

        'ZPL'   => 'ZPL',

    ];



    $label_format = isset($_POST['label_format']) ? sanitize_text_field($_POST['label_format']) : 'PDF';

    $label_format = $map[$label_format] ?? 'PDF';



    $selected = array_map('sanitize_text_field', $_POST['packages']);



    

    





 $orders = [];

$orders_without_packages = [];



foreach ($selected as $item) {

    if (strpos($item, '|') === false) {

        // Próbujemy wyciągnąć ID zamówienia z $item

        $order_id = preg_replace('/\D/', '', $item);



        if ($order_id) {

            $orders_without_packages[] = $order_id;

            //Orlen_Logger::warning("Zamówienie #$order_id nie posiada zdefiniowanych paczek.");

        } else {

            Orlen_Logger::warning("Niepoprawny format paczki: $item");

        }



        continue;

    }



    list($order_id, $package_id) = explode('|', $item);

    $orders[$order_id][] = $package_id;

}



// Dalej przetwarzamy tylko zamówienia z paczkami

$orders_with_packages = $orders;

$businessPackList = [];

$package_map = [];

$skipped = [];



foreach ($orders_with_packages as $order_id => $package_ids) {

    $order = wc_get_order($order_id);

    if (!$order) continue;



    $selected_index = get_post_meta($order_id, '_selected_store', true);

    $senders = get_option('orlen_senders', []);

    if (empty($selected_index) && !empty($senders)) {

        reset($senders);

        $selected_index = key($senders);

    }



    $sender = $senders[$selected_index] ?? $senders[0] ?? [

        'name' => '', 'street' => '', 'building' => '', 'city' => '',

        'postcode' => '', 'country' => '', 'firstname' => '', 'lastname' => '',

        'phone' => '', 'email' => ''

    ];



    $receiverPhone = preg_replace('/\D/', '', $order->get_billing_phone());

    $senderPhone   = preg_replace('/\D/', '', $sender['phone'] ?? '');



    foreach ($package_ids as $package_id) {

        $package_data = null;

        $packages_meta = get_post_meta($order_id, '_orlen_paczka_size', false);



        foreach ($packages_meta as $p) {

            $decoded = json_decode($p, true);

            if ($decoded && $decoded['id'] === $package_id) {

                $package_data = $decoded;

                break;

            }

        }



        if (!$package_data) continue;



        $pack_code = $package_data['pack_code'] ?? '';

        if (!empty($pack_code)) {

            $skipped[] = [

                'order_id'   => $order_id,

                'package_id' => $package_id,

                'pack_code'  => $pack_code,

                'reason'     => 'already_has_pack_code'

            ];

            continue;

        }



        $wp_version = get_bloginfo('version');                       

        $wc_version = defined('WC_VERSION') ? WC_VERSION : '0';      

        $plugins = get_plugins();

        $plugin_file = 'orlen-paczka/orlen-paczka.php'; 

        $plugin_version = isset($plugins[$plugin_file]['Version']) ? $plugins[$plugin_file]['Version'] : '1.0.0';



        $transfer_description = sprintf('WP%s-WC%s-OP%s', $wp_version, $wc_version, $plugin_version);



        $businessPackList[] = [

            'DestinationCode'      => $package_data['pickup_point'],

            'BoxSize'              => $package_data['size'] ?? 'M',

            'PackValue'            => $package_data['value'] ?? 0,

            'CashOnDelivery'       => !empty($package_data['cod']) ? 'Y' : 'N',

            'AmountCashOnDelivery' => $package_data['cod_amount'] ?? 0,

            'Insurance'            => !empty($package_data['insurance']) ? 'Y' : 'N',

            'InsuranceValue'       => $package_data['insurance'] ?? 0,

            'EMail'                => $package_data['email'] ?? $order->get_billing_email(),

            'FirstName'            => $package_data['first_name'] ?? $order->get_billing_first_name(),

            'LastName'             => $package_data['last_name'] ?? $order->get_billing_last_name(),

            'CompanyName'          => $package_data['company'] ?? '',

            'StreetName'           => $package_data['address_1'] ?? $order->get_billing_address_1(),

            'BuildingNumber'       => $package_data['address_2'] ?? '',

            'City'                 => $package_data['city'] ?? $order->get_billing_city(),

            'PostCode'             => $package_data['postcode'] ?? $order->get_billing_postcode(),

            'PhoneNumber'          => $package_data['phone'] ?? $receiverPhone,

            'SenderEMail'          => $sender['email'] ?? '',

            'SenderFirstName'      => $sender['firstname'] ?? '',

            'SenderLastName'       => $sender['lastname'] ?? '',

            'SenderCompanyName'    => $sender['name'] ?? '',

            'SenderStreetName'     => $sender['street'] ?? '',

            'SenderBuildingNumber' => $sender['building'] ?? '',

            'SenderCity'           => $sender['city'] ?? '',

            'SenderPostCode'       => $sender['postcode'] ?? '',

            'SenderPhoneNumber'    => $senderPhone,

            'SenderOrders'         => $order->get_id(),

            'PrintAdress'          => 1,

            'PrintType'            => 1,

            'TransferDescription'  => $transfer_description,

        ];



        $package_map[] = [

            'order_id'   => $order_id,

            'package_id' => $package_id,

        ];

    }

}



// Jeśli nie mamy paczek do wygenerowania, ale są zamówienia bez paczek

if (empty($businessPackList) && !empty($orders_without_packages)) {

    $orders_links = array_map(function($id){

        $url = get_edit_post_link($id);

        return "Przejdź do zamówienia <a href='$url' target='_blank'> #$id </a> i dodaj przesyłki";

    }, $orders_without_packages);



    // każdy link w nowej linii

    $orders_list_html = implode('<br>', $orders_links);



    wp_send_json_error([

        'message' => "<strong>Wybrane zamówienie/a nie posiada paczek dla których można wygenerować etykiety:</strong><br>$orders_list_html",

        'skipped' => $orders_without_packages

    ]);

}





// Jeśli mamy paczki do wygenerowania **i jednocześnie zamówienia bez paczek**, dodajemy info do komunikatu

$additional_message = '';

if (!empty($orders_without_packages)) {

    $orders_links = array_map(function($id){

        return "Przejdź do zamówienia <a href='" . get_edit_post_link($id) . "' target='_blank'>#$id</a> i dodaj przesyłki";

    }, $orders_without_packages);



    // każdy numer zamówienia w nowej linii

    $orders_list_html = implode('<br>', $orders_links);



    $user_message .= "<br><strong>Wybrane zamówienie/a nie posiada paczek dla których można wygenerować etykiety:</strong><br>$orders_list_html";



}







    $auth = Orlen_Auth_Helper::get_credentials();

    $params = [

        'PartnerID'        => $auth['partner_id'],

        'PartnerKey'       => $auth['partner_key'],

        'Format'           => $label_format,

        'BusinessPackList' => ['BusinessPack' => $businessPackList],

    ];



    try {

        $env = get_option('orlen_env', 'test');

        $soap = new OrlenPaczka_SOAP($env);



        $response = $soap->client->__soapCall('GenerateLabelBusinessPackListTwo', [$params]);



        $soapRequestXml  = $soap->client->__getLastRequest();

        $soapResponseXml = $soap->client->__getLastResponse();







         $pretty_format_xml = function ($xml_string) {

            try {

                $dom = new DOMDocument('1.0');

                $dom->preserveWhiteSpace = false;

                $dom->formatOutput = true;

                $dom->loadXML($xml_string);

                return $dom->saveXML();

            } catch (Exception $e) {

                return $xml_string;

            }

        };



        $req_pretty = $pretty_format_xml($soapRequestXml);

        $res_pretty = $pretty_format_xml($soapResponseXml);

        $res_masked = preg_replace('/<LabelData>.*<\/LabelData>/s', '<LabelData>[BASE64_CONTENT]</LabelData>', $res_pretty);



        Orlen_Logger::info("[SOAP REQUEST ENVELOPE]\n=============================\n$req_pretty\n=============================");

        Orlen_Logger::info("[SOAP RESPONSE ENVELOPE]\n=============================\n$res_masked\n=============================");





        



        $xml = @simplexml_load_string($soapResponseXml);

        if ($xml === false) {

            throw new Exception('Niepoprawna odpowiedź SOAP.');

        }



        $labelNodes = $xml->xpath('//*[local-name()="LabelData"]');

        $packNodes  = $xml->xpath('//GenerateLabelBusinessPackListTwo');



        $label_base64 = '';

        if (!empty($labelNodes)) {

            $label_base64 = (string)$labelNodes[0];

        }



        $pdf_url = '';

        if (!empty($label_base64) && base64_decode($label_base64, true) !== false) {

            $upload_dir = wp_upload_dir();

            $pdf_dir = $upload_dir['basedir'] . '/orlen-labels';

            wp_mkdir_p($pdf_dir);



            $pdf_filename = 'bulk_labels_' . time() . '.pdf';

            $pdf_path = $pdf_dir . '/' . $pdf_filename;



            file_put_contents($pdf_path, base64_decode($label_base64));

            $pdf_url = $upload_dir['baseurl'] . '/orlen-labels/' . $pdf_filename;

        }



$generated_pack_codes = [];

$error_messages = [];



foreach ($packNodes as $index => $node) {

    $map = $package_map[$index] ?? null;

    if (!$map) continue;



    $order_id = $map['order_id'];

    $package_id = $map['package_id'];



    $err_code = (string)($node->Err ?? '');

    $err_desc = (string)($node->ErrDes ?? '');

    $pack_code = (string)($node->PackCode ?? $node->PackCode_RUCH ?? '');



    // Domyślnie zakładamy sukces, jeśli brak kodu błędu

    if (empty($err_code)) {

        $err_code = '000';

        $err_desc = 'OK';

    }



    // Budujemy komunikat w formacie: Zamówienie → PackCode → API

    $status_text = "Zamówienie #$order_id";

    if (!empty($pack_code)) {

        $status_text .= " — Nr przesyłki: $pack_code";

    }

    $status_text .= " — Odpowiedź API: ($err_code) $err_desc";



    // Zawsze dodajemy do listy komunikatów

    $error_messages[] = $status_text;



    // Zapis do bazy jeśli jest pack_code (nawet przy błędzie)

    if (!empty($pack_code)) {

        $packages_meta = get_post_meta($order_id, '_orlen_paczka_size', false);

        $new_meta = [];

        foreach ($packages_meta as $p) {

            $decoded = json_decode($p, true);

            if (!$decoded) continue;

            if ((string)$decoded['id'] === (string)$package_id) {

                $decoded['pack_code'] = $pack_code;

                $decoded['label_url'] = $pdf_url;

            }

            $new_meta[] = wp_slash(wp_json_encode($decoded, JSON_UNESCAPED_UNICODE));

        }

        delete_post_meta($order_id, '_orlen_paczka_size');

        foreach ($new_meta as $meta_value) {

            add_post_meta($order_id, '_orlen_paczka_size', $meta_value);

        }

        update_post_meta($order_id, '_orlen_paczka_packcode_' . $package_id, $pack_code);

        update_post_meta($order_id, '_orlen_paczka_label_url_' . $package_id, $pdf_url);

    }



    // Dane do odpowiedzi JSON

    $generated_pack_codes[] = [

        'order_id'   => $order_id,

        'package_id' => $package_id,

        'pack_code'  => $pack_code,

        'error_code' => $err_code,

        'error_desc' => $err_desc,

    ];

}



// Komunikat zbiorczy (czytelny i wyrównany)

if (!empty($generated_pack_codes)) {

    $formatted = '<div style="text-align:left; line-height:1.5;">';

    $formatted .= '<strong>Wynik generowania etykiet:</strong>';

    $formatted .= '<table style="width:100%; border-collapse:collapse; margin-top:5px;">';

    $formatted .= '<thead>

        <tr style="border-bottom:1px solid #ccc;">

            <th style="padding:6px;">Zamówienie</th>

            <th style="padding:6px;">Nr przesyłki</th>

            <th style="padding:6px;">Odpowiedź API</th>

        </tr>

    </thead><tbody>';



    foreach ($generated_pack_codes as $p) {

        $apiStatus = sprintf('(%s) %s', $p['error_code'], $p['error_desc']);

        $formatted .= sprintf(

            '<tr style="border-bottom:1px solid #eee;">

                <td style="padding:6px;">#%s</td>

                <td style="padding:6px;">%s</td>

                <td style="padding:6px;">%s</td>

            </tr>',

            esc_html($p['order_id']),

            esc_html($p['pack_code'] ?: '-'),

            esc_html($apiStatus)

        );

    }



    $formatted .= '</tbody></table></div>';



    $user_message = $formatted;

} else {

    $user_message = '<div style="text-align:left;"><strong>Brak komunikatów z API.</strong></div>';

}



// 🔹 Dodajemy informację o zamówieniach bez paczek

if (!empty($orders_without_packages)) {

    $orders_links = array_map(function($id){

        return "Przejdź do zamówienia <a href='" . get_edit_post_link($id) . "' target='_blank'>#$id</a> i dodaj przesyłki";

    }, $orders_without_packages);

    $orders_list_html = implode('<br>', $orders_links);



    $user_message .= "<br><strong>Wybrane zamówienie/a nie posiada paczek dla których można wygenerować etykiety:</strong><br>$orders_list_html";

}





wp_send_json_success([

    'message'    => $user_message,

    'label_url'  => $pdf_url,

    'pack_codes' => $generated_pack_codes,

    'errors'     => $error_messages,

]);





    } catch (Exception $e) {

        Orlen_Logger::error("❌ Błąd generowania bulk etykiet: " . $e->getMessage());

        wp_send_json_error([

            'message' => '❌ Błąd generowania bulk etykiet: ' . $e->getMessage(),

            'errors' => [],

        ]);

    }

}

































add_action('wp_ajax_orlen_zamow_kuriera', 'orlen_zamow_kuriera_callback');

function orlen_zamow_kuriera_callback() {

    $postcode = isset($_POST['postcode']) ? sanitize_text_field($_POST['postcode']) : '';

    $orders   = isset($_POST['orders']) ? array_map('intval', $_POST['orders']) : [];

    

    if (empty($orders)) wp_send_json_error(['message'=>'Brak zamówień.']);



    $senders = get_option('orlen_senders', []);

    $senderData = null;

    $differentSenders = false;



    foreach ($orders as $order_id) {

        $order = wc_get_order($order_id);

        if (!$order) continue;



        $selected_index = get_post_meta($order_id, '_selected_store', true);

        if (empty($selected_index) && !empty($senders)) { 

            reset($senders); 

            $selected_index = key($senders); 

        }



        $senderTmp = $senders[$selected_index] ?? [

            'name'=>'','street'=>'','building'=>'','city'=>'','postcode'=>'',

            'firstname'=>'','lastname'=>'','phone'=>'','email'=>''

        ];



        if (is_null($senderData)) {

            $senderData = $senderTmp; 

        } else {

            if ($senderData !== $senderTmp) {

                $differentSenders = true;

                break;

            }

        }

    }



if ($differentSenders || empty($senderData)) {

    wp_send_json_success([       

        'message' => 'Wybrałeś różne adresy podjazdu kuriera. Aby zamówić kuriera, wszystkie przesyłki muszą pochodzić z jednego magazynu.'

    ]);

}



    $sender = $senderData;



    $partner_id  = get_post_meta($order_id, '_orlen_partner_id', true) ?: get_option('orlen_partner_id', '');

    $partner_key = get_post_meta($order_id, '_orlen_partner_key', true) ?: get_option('orlen_partner_key', '');



    $receiverPhone = preg_replace('/\D/', '', $order->get_billing_phone());

    if (strlen($receiverPhone) === 11 && substr($receiverPhone,0,2) === '48') $receiverPhone = substr($receiverPhone,2);

    $senderPhone = preg_replace('/\D/', '', $sender['phone']);

    if (strlen($senderPhone) === 11 && substr($senderPhone,0,2) === '48') $senderPhone = substr($senderPhone,2);



    $env = get_option('orlen_env', 'test');



    try {

        $soap = new OrlenPaczka_SOAP($env);

    if (empty($postcode)) $postcode = $sender['postcode'];



    $params = [

        'PartnerID'    => $partner_id,

        'PartnerKey'   => $partner_key,

        'PostCode'     => $postcode,

        'City'         => $sender['city'],

        'Street'       => $sender['street'],

        'BuildingNo'   => $sender['building'],

        'Email'        => $sender['email'],

        'PartnerName'  => $sender['name'],

        'PersonName'   => $sender['firstname'],

        'PersonSurname'=> $sender['lastname'],

        'Telephone'    => $senderPhone

    ];



    $result = $soap->call('GetAvailablePickups', $params);



            $soapRequestXml  = $soap->getLastRequest();

            $soapResponseXml = $soap->getLastResponse();



            foreach (['REQUEST' => $soapRequestXml, 'RESPONSE' => $soapResponseXml] as $type => $xml) {

                if ($xml) {

                    $dom = new DOMDocument('1.0', 'UTF-8');

                    $dom->preserveWhiteSpace = false;

                    $dom->formatOutput = true;

                    try {

                        $dom->loadXML($xml);

                        Orlen_Logger::info("SOAP $type dla paczki $pack_code:\n" . $dom->saveXML());

                    } catch (Exception $e) {

                        Orlen_Logger::info("SOAP $type (raw) dla paczki $pack_code:\n" . $xml);

                    }

                }

            }

    

        $data = [];

        $error_message = '';



       if (isset($result->GetAvailablePickupsResult->Err) && (int)$result->GetAvailablePickupsResult->Err !== 0) {

    $error_message = (string)$result->GetAvailablePickupsResult->ErrDes;



    wp_send_json_success([

        'data' => [],      // brak dostępnych terminów

        'sender' => $senderData,

        'message' => 'Odpowiedź API: ' . $error_message

    ]);

} else {

            if (isset($result->GetAvailablePickupsResult->Data->AvailablePickupDay)) {

                foreach ($result->GetAvailablePickupsResult->Data->AvailablePickupDay as $day) {

                    $data[] = [

                        'Date' => (string)$day->Date,

                        'MinReadyDate' => (string)$day->MinReadyDate,

                        'MaxPickupDate' => (string)$day->MaxPickupDate,

                        'MinimumInterval' => (string)$day->MinimumInterval

                    ];

                }

            }            

        }



        $senderData = [

    'PartnerID'    => $params['PartnerID'],

    'PartnerKey'   => $params['PartnerKey'],

    'PostCode'     => $params['PostCode'],

    'City'         => $params['City'],

    'Street'       => $params['Street'],

    'BuildingNo'   => $params['BuildingNo'],

    'Email'        => $params['Email'],

    'PartnerName'  => $params['PartnerName'],

    'PersonName'   => $params['PersonName'],

    'PersonSurname'=> $params['PersonSurname'],

    'Telephone'    => $params['Telephone'],

];



wp_send_json_success([

    'data'   => $data,

    'sender' => $senderData

]);



    } catch (Exception $e) {

        wp_send_json_error(['message'=>"Błąd SOAP: ".$e->getMessage()]);

    }

}









add_action('wp_ajax_orlen_zapisz_kuriera', 'orlen_zapisz_kuriera_callback');

function orlen_zapisz_kuriera_callback() {

    $orders = isset($_POST['orders']) ? $_POST['orders'] : [];



    if (empty($orders)) {

        wp_send_json_error('Brak zamówień do zapisania.');

    }



    $orders = array_filter($orders, function($o) {

        return !empty($o['pack_code']);

    });



    if (empty($orders)) {

        wp_send_json_error('Żadne z wybranych zamówień nie ma przypisanego kodu paczki (pack_code).');

    }       



    foreach ($orders as $order) {

    $order_id   = intval($order['order_id']);

    $package_id = sanitize_text_field($order['package_id']); 

    $pack_code  = sanitize_text_field($order['pack_code']);



    if (empty($pack_code) || $pack_code === '-') {

        Orlen_Logger::info("Pominięto zamówienie $order_id bez poprawnego pack_code.");

        continue;

    }



     $env = get_option('orlen_env', 'test');

    try {

        $soap = new OrlenPaczka_SOAP($env);

        $pickup_date = sanitize_text_field($_POST['pickup_date']);

        $pickup_time = sanitize_text_field($_POST['pickup_time']);

        $postcode    = sanitize_text_field($_POST['postcode']);

        $city        = sanitize_text_field($_POST['city']);

        $street      = sanitize_text_field($_POST['street']);

        $building    = sanitize_text_field($_POST['building']);

        $email       = sanitize_email($_POST['email']);

        $partnername = sanitize_text_field($_POST['partnername']);

        $firstname   = sanitize_text_field($_POST['firstname']);

        $lastname    = sanitize_text_field($_POST['lastname']);

        $phone       = preg_replace('/\D/', '', sanitize_text_field($_POST['phone']));



        $partner_id  = get_post_meta($order_id, '_orlen_partner_id', true) ?: get_option('orlen_partner_id', '');

        $partner_key = get_post_meta($order_id, '_orlen_partner_key', true) ?: get_option('orlen_partner_key', '');



        list($ready_hour, $pickup_hour) = explode('-', $pickup_time);

        $ready_date_iso  = $pickup_date . 'T' . str_pad($ready_hour, 2, '0', STR_PAD_LEFT) . ':00:00+02:00';

        $pickup_date_iso = $pickup_date . 'T' . str_pad($pickup_hour, 2, '0', STR_PAD_LEFT) . ':00:00+02:00';



        $params = [

            'PartnerID'     => $partner_id,

            'PartnerKey'    => $partner_key,

            'PackList'      => ['string' => [$pack_code]],

            'ReadyDate'     => $ready_date_iso,

            'PickupDate'    => $pickup_date_iso,

            'PostCode'      => $postcode,

            'City'          => $city,

            'Street'        => $street,

            'BuildingNo'    => $building,

            'Email'         => $email,

            'PartnerName'   => $partnername,

            'PersonName'    => $firstname,

            'PersonSurname' => $lastname,

            'Telephone'     => $phone

        ];



        $response = $soap->call('CallPickupNew', $params);



        $courier_order_number = isset($response->CallPickupNewResult->Data) ? (string) $response->CallPickupNewResult->Data : '';



        if ($courier_order_number) {

            $ordered_packages = get_post_meta($order_id, '_orlen_courier_packages', true);

            if (!is_array($ordered_packages)) {

                $ordered_packages = [];

            }



            if (!isset($ordered_packages[$courier_order_number])) {

                $ordered_packages[$courier_order_number] = [];

            }



            $ordered_packages[$courier_order_number][$pack_code] = [

                'status' => 'ordered',

                'date'   => current_time('mysql'),

                'pack_code' => $pack_code,

                'pickup' => [

                    'date' => $pickup_date,

                    'time' => $pickup_time

                ]

            ];



            update_post_meta($order_id, '_orlen_courier_packages', $ordered_packages);

           

            $soapRequestXml  = $soap->getLastRequest();

            $soapResponseXml = $soap->getLastResponse();



            foreach (['REQUEST' => $soapRequestXml, 'RESPONSE' => $soapResponseXml] as $type => $xml) {

                if ($xml) {

                    $dom = new DOMDocument('1.0', 'UTF-8');

                    $dom->preserveWhiteSpace = false;

                    $dom->formatOutput = true;

                    try {

                        $dom->loadXML($xml);

                        Orlen_Logger::info("SOAP $type dla paczki $pack_code:\n" . $dom->saveXML());

                    } catch (Exception $e) {

                        Orlen_Logger::info("SOAP $type (raw) dla paczki $pack_code:\n" . $xml);

                    }

                }

            }

          

        }



    } catch (Exception $e) {

        Orlen_Logger::error("Błąd AJAX/Soap dla paczki $pack_code: " . $e->getMessage());

        wp_send_json_error(['message' => 'Błąd AJAX/Soap: ' . $e->getMessage()]);

    }

}



    wp_send_json_success(['message' => 'Zamówienie kuriera zapisane w bazie i wysłane do logów.']);





    

}