<?php 

if (!defined('ABSPATH')) {

    exit;

}





 

            

$map_type = get_option('orlen_map_type'); 



if ($map_type && $map_type === 'popup') {



class Orlen_Paczka_Pickup_Point_Field {



    private $token;



    public function __construct($token) {

        $this->token = $token;



        add_action('woocommerce_checkout_update_order_meta', [$this, 'save_pickup_point']);



        //add_action('woocommerce_after_order_notes', [$this, 'display_pickup_point_field']);

        add_action('woocommerce_review_order_before_payment', [$this, 'display_pickup_point_field']);





        add_action('wp_enqueue_scripts', [$this, 'enqueue_orlen_widget_script']);



        add_action('wp_ajax_save_orlen_paczka_pickup_point', [$this, 'ajax_save_pickup_point_to_session']);

        add_action('wp_ajax_nopriv_save_orlen_paczka_pickup_point', [$this, 'ajax_save_pickup_point_to_session']);



    }



    public function enqueue_orlen_widget_script() {

        if (!is_checkout()) return;



        wp_enqueue_script(

            'orlenpaczka-widget',

            'https://mapa.orlenpaczka.pl/widget.js?token=' . esc_js($this->token) . '&v=1.3.0&t=' . time(),

            [],

            null,

            true

        );

    }



    public function display_pickup_point_field() {

        ?>

        <div id="orlen_paczka_pickup_point_field" style="margin-top:20px;">

            <h3><?php _e('Wybierz punkt ORLEN Paczka', 'woocommerce'); ?></h3>



            <input type="hidden" id="orlen_paczka_pickup_point" name="orlen_paczka_pickup_point" value="">

            <input type="hidden" id="orlen_paczka_pickup_point_name_input" name="orlen_paczka_pickup_point_name" value="">

            <input type="hidden" id="orlen_paczka_pickup_point_data" name="orlen_paczka_pickup_point_data" value="">



            <?php if ( is_user_logged_in() ) : ?>



    <!-- WERSJA DLA ZALOGOWANYCH -->

    <button type="button" class="orlen-widget button orlen-modal-button primary"

        style="background-color:#D91C00; color:#fff; border-color:#D91C00;"

        data-type="pickup"

        data-layout="tabs"

        data-modal="true"

        data-target="#orlen_paczka_pickup_point"

        data-label="#orlen_paczka_pickup_point_name_input"

        data-address="<?php 

            echo esc_attr(

                WC()->customer->get_billing_address_1() . ', ' .

                WC()->customer->get_billing_postcode() . ' ' .

                WC()->customer->get_billing_city()

            ); 

        ?>">

        <?php _e('Wybierz punkt z mapy', 'woocommerce'); ?>

    </button>



<?php else : ?>



    <!-- WERSJA DLA NIEZALOGOWANYCH -->

    <button type="button" class="orlen-widget button orlen-modal-button primary"

        style="background-color:#D91C00; color:#fff; border-color:#D91C00;"

        data-type="pickup"

        data-layout="tabs"

        data-modal="true"

        data-target="#orlen_paczka_pickup_point"

        data-label="#orlen_paczka_pickup_point_name_input"

        data-address="">

        <?php _e('Wybierz punkt z mapy', 'woocommerce'); ?>

    </button>



<?php endif; ?>





            <div id="orlen_paczka_pickup_point_label" style="margin-top:10px; font-weight:bold; color:#0073aa;">

                <?php _e('Nie wybrano punktu', 'woocommerce'); ?>

            </div>

        </div>



        <script>

jQuery(function($) {

    function toggleOrlenField() {

        const selectedMethod = $('input[name^="shipping_method"]:checked').val();

        const $field = $('#orlen_paczka_pickup_point_field');



        if (selectedMethod && selectedMethod.includes('orlen_paczka')) {

            $field.slideDown(200);

        } else {

            $field.slideUp(200);



            $('#orlen_paczka_pickup_point').val('');

            $('#orlen_paczka_pickup_point_name_input').val('');

            $('#orlen_paczka_pickup_point_data').val('');

            $('#orlen_paczka_pickup_point_label').text('Nie wybrano punktu');



            const button = $('.orlen-widget.button');

            if (button.length) {

                button.text('Wybierz punkt z mapy');

            }

        }

    }



    toggleOrlenField();

    $(document.body).on('updated_checkout change', 'input[name^="shipping_method"]', toggleOrlenField);

});





document.addEventListener("DOMContentLoaded", function() {

    document.querySelectorAll('.orlen-widget-modal').forEach(function(widget) {

        widget.addEventListener('orlenSelectPoint', function(e) {

            const point = e.detail.marker.options; // punkt wybrany z mapy

            //console.log("📦 ODEBRANO DANE PUNKTU:", point);



            // zapis do pól hidden

            document.querySelector('#orlen_paczka_pickup_point').value = point.id || '';

            document.querySelector('#orlen_paczka_pickup_point_name_input').value =

                `${point.physicalNamePsd || point.name || ''}, ${point.addressLine || ''}, ${point.postalCode || ''} ${point.city || ''}`;

            document.querySelector('#orlen_paczka_pickup_point_data').value = JSON.stringify(point);



            // aktualizacja labela

            const html = `

                <div style="line-height:1.6; color:#000; font-weight: normal;">

                    <strong>Nazwa punktu:</strong> ${point.physicalNamePsd || point.name || '-'}<br>

                    <strong>Adres:</strong> ${point.addressLine || ''}, ${point.postalCode || ''} ${point.city || ''} (${point.province || ''})<br>

                    <strong>Lokalizacja:</strong> ${point.location || point.physicalLocationPsd || '-'}<br>

                    <strong>Godziny otwarcia:</strong> ${point.openingHours || '-'}<br>

                    <strong>Kod miejsca docelowego:</strong> ${point.destinationCode || '-'}<br>

                </div>

            `;

            document.querySelector('#orlen_paczka_pickup_point_label').innerHTML = html;



            // zmiana przycisku

            const button = document.querySelector('.orlen-widget.button');

            if (button) {

                button.textContent = 'Wybierz inny punkt';

            }



            // zapis do sesji WooCommerce

            jQuery.ajax({

                url: wc_checkout_params.ajax_url,

                type: 'POST',

                dataType: 'json',

                data: {

                    action: 'save_orlen_paczka_pickup_point',

                    point: JSON.stringify(point)

                },

                success: function(response) {

                    //console.log("✅ ORLEN PACZKA zapis do sesji:", response);

                    jQuery('form.checkout').trigger('update_checkout');

                },

                error: function() {

                    //console.warn("⚠️ Błąd podczas zapisu punktu ORLEN Paczka do sesji.");

                }

            });

        });

    });

});







</script>







                <?php

            }







            /**

         * AJAX – zapisuje dane punktu ORLEN Paczka do sesji WooCommerce

         */

        public function ajax_save_pickup_point_to_session() {

            if (!isset($_POST['point']) || empty($_POST['point'])) {

                wp_send_json_error('Brak danych punktu.');

            }



            $point = json_decode(stripslashes($_POST['point']), true);



            if (empty($point) || !is_array($point)) {

                wp_send_json_error('Nieprawidłowe dane.');

            }



            WC()->session->set('orlen_paczka_pickup_point_data', $point);



            wp_send_json_success('Punkt zapisany w sesji.');

        }











            /**

         * Zapisuje dane punktu ORLEN Paczka po złożeniu zamówienia

         */

        public function save_pickup_point($order_id) {

            $point_data = WC()->session->get('orlen_paczka_pickup_point_data');



            if (empty($point_data) || !is_array($point_data)) {

                return;

            }



            if (!empty($point_data['id'])) {

                update_post_meta($order_id, 'orlen_paczka_pickup_point_id', sanitize_text_field($point_data['id']));

            }



            $full_address = trim(sprintf(

                '%s, %s, %s %s, %s',

                $point_data['physicalNamePsd'] ?? $point_data['name'] ?? '',

                $point_data['addressLine'] ?? '',

                $point_data['postalCode'] ?? '',

                $point_data['city'] ?? '',

                $point_data['province'] ?? ''

            ));

            update_post_meta($order_id, 'orlen_paczka_pickup_point_name', sanitize_text_field($full_address));



            if (!empty($point_data['destinationCode'])) {

                update_post_meta($order_id, 'orlen_paczka_pickup_point', sanitize_text_field($point_data['destinationCode']));

            }



            //update_post_meta($order_id, 'orlen_paczka_pickup_point_data', wp_json_encode($point_data));

        }



}





}





elseif ($map_type === 'embedded') {

    

if (!defined('ABSPATH')) {

    exit;

}



class Orlen_Paczka_Pickup_Point_Field {



    private $token;



    public function __construct($token) {

        $this->token = $token;



        add_action('wp_enqueue_scripts', [$this, 'enqueue_orlen_widget_script']);

        //add_action('woocommerce_checkout_shipping', [$this, 'display_pickup_point_field']);

        add_action('woocommerce_review_order_after_shipping', [$this, 'display_pickup_point_field']);



        add_action('wp_ajax_save_orlen_paczka_pickup_point', [$this, 'ajax_save_pickup_point_to_session']);

        add_action('wp_ajax_nopriv_save_orlen_paczka_pickup_point', [$this, 'ajax_save_pickup_point_to_session']);

        add_action('woocommerce_checkout_update_order_meta', [$this, 'save_pickup_point']);

        add_action('woocommerce_admin_order_data_after_shipping_address', [$this, 'display_pickup_point_in_admin']);

    }



    public function enqueue_orlen_widget_script() {

        if (!is_checkout()) return;



        wp_enqueue_script(

            'orlenpaczka-widget',

            'https://mapa.orlenpaczka.pl/widget.js?token=' . esc_js($this->token) . '&v=1.3.0&t=' . time(),

            [],

            null,

            true

        );

    }



    public function display_pickup_point_field() {

        ?>

        <div id="orlen_paczka_pickup_point_field" style="margin-top:20px; display:none;">

            <h3><?php _e('Wybierz punkt ORLEN Paczka', 'woocommerce'); ?></h3>



            <input type="hidden" id="orlen_paczka_pickup_point" name="orlen_paczka_pickup_point" value="">

            <input type="hidden" id="orlen_paczka_pickup_point_name" name="orlen_paczka_pickup_point_name" value="">

            <input type="hidden" id="orlen_paczka_pickup_point_data" name="orlen_paczka_pickup_point_data" value="">



            <div style="margin-bottom:10px;">

                <button type="button" id="load-orlen-widget" class="button button-secondary" style="background-color:#D91C00; color:#fff; border-color:#D91C00;">

                    <?php _e('Wybierz punkt z mapy', 'woocommerce'); ?>

                </button>

                <span id="orlen_selected_text" style="display:none; color:green; font-weight:bold;">

                    ✅ Punkt wybrany

                </span>

            </div>



            <div id="orlen_paczka_pickup_point_label" style="font-weight:normal; color:#000;">

                <?php _e('Nie wybrano punktu', 'woocommerce'); ?>

            </div>



            <div id="orlen-widget-container" style="margin-top:15px; display:none;"></div>

        </div>



        <script>

        jQuery(function($) {



            function toggleOrlenField() {

                const selectedMethod = $('input[name^="shipping_method"]:checked').val();

                if (selectedMethod && selectedMethod.includes('orlen_paczka')) {

                    $('#orlen_paczka_pickup_point_field').show();

                } else {

                    $('#orlen_paczka_pickup_point_field').hide();

                }

            }

            toggleOrlenField();

            $(document.body).on('updated_checkout change', toggleOrlenField);



            $('#load-orlen-widget').on('click', function() {

                const street = $('input[name="billing_address_1"]').val() || '';

                const postcode = $('input[name="billing_postcode"]').val() || '';

                const city = $('input[name="billing_city"]').val() || '';



                if (!postcode || !city) {

                    alert('Uzupełnij adres i kod pocztowy, aby wyszukać punkty.');

                    return;

                }



                const address = `${street}, ${postcode} ${city}`;

                const $container = $('#orlen-widget-container');



                $container.show().html(`

                    <div id="orlen-widget-embedded" class="orlen-widget"

                        data-type="pickup"

                        data-layout="tabs"

                        data-target="#orlen_paczka_pickup_point"

                        data-label="#orlen_paczka_pickup_point_name"

                        data-address="${address}">

                    </div>

                `);



                const script = document.createElement('script');

                script.src = "https://mapa.orlenpaczka.pl/widget.js?token=<?php echo esc_js($this->token); ?>&v=1.3.0&t=" + Math.floor(Date.now()/1000);

                script.async = true;

                document.head.appendChild(script);



                setTimeout(() => {

                    const widget = document.getElementById('orlen-widget-embedded');

                    if (!widget) return;



                    widget.addEventListener('orlenSelectPoint', function(e) {

                        const point = e.detail?.marker?.options;

                        if (!point) return;

                        //console.log("📦 Wybrano punkt ORLEN (embedded):", point);



                        $('#orlen_paczka_pickup_point').val(point.id || '');

                        $('#orlen_paczka_pickup_point_name').val(

                            `${point.physicalNamePsd || point.name || ''}, ${point.addressLine || ''}, ${point.postalCode || ''} ${point.city || ''}`

                        );

                        $('#orlen_paczka_pickup_point_data').val(JSON.stringify(point));



                        jQuery.ajax({

                            url: wc_checkout_params.ajax_url,

                            type: 'POST',

                            dataType: 'json',

                            data: {

                                action: 'save_orlen_paczka_pickup_point',

                                point: JSON.stringify(point)

                            },

                            success: function(response) {

                                //console.log("✅ Punkt zapisany w sesji:", response);

                                jQuery('form.checkout').trigger('update_checkout');

                            },

                            error: function() {

                                //console.warn("⚠️ Błąd zapisu punktu ORLEN Paczka do sesji.");

                            }

                        });



                        const html = `

                                <div style="line-height:1.6; color:#000; font-weight: normal;">

                                    <strong>Nazwa punktu:</strong> ${point.physicalNamePsd || point.name || '-'}<br>

                                    <strong>Adres:</strong> ${point.addressLine || ''}, ${point.postalCode || ''} ${point.city || ''} (${point.province || ''})<br>

                                    <strong>Lokalizacja:</strong> ${point.location || point.physicalLocationPsd || '-'}<br>

                                    <strong>Godziny otwarcia:</strong> ${point.openingHours || '-'}<br>

                                    <strong>Kod miejsca docelowego:</strong> ${point.destinationCode || '-'}<br>

                                </div>

                        `;

                        $('#orlen_paczka_pickup_point_label').html(html);

                        $('#load-orlen-widget').text('Wybierz inny punkt');

                        $('#orlen_selected_text').fadeIn(300);

                    });

                }, 800); 

            });





            function handleOrlenSelectPoint(e) {

                const point = e.detail?.marker?.options || e.originalEvent?.detail?.marker?.options;

                if (!point) return;



                //console.log("📦 Wybrano punkt ORLEN:", point);



                $('#orlen_paczka_pickup_point').val(point.id || '');

                $('#orlen_paczka_pickup_point_name').val(

                    `${point.physicalNamePsd || point.name || ''}, ${point.addressLine || ''}, ${point.postalCode || ''} ${point.city || ''}`

                );

                $('#orlen_paczka_pickup_point_data').val(JSON.stringify(point));



                jQuery.ajax({

                    url: wc_checkout_params.ajax_url,

                    type: 'POST',

                    dataType: 'json',

                    data: {

                        action: 'save_orlen_paczka_pickup_point',

                        point: JSON.stringify(point)

                    },

                    success: function(response) {

                        //console.log("✅ Punkt zapisany w sesji:", response);

                        jQuery('form.checkout').trigger('update_checkout');

                    },

                    error: function() {

                        //console.warn("⚠️ Błąd zapisu punktu ORLEN Paczka do sesji.");

                    }

                });



                const html = `

                        <div style="line-height:1.6; color:#000; font-weight: normal;">

                        <strong>${point.physicalNamePsd || point.name || '-'}</strong><br>

                        ${point.addressLine || ''}, ${point.postalCode || ''} ${point.city || ''} (${point.province || ''})<br>

                        <em>${point.physicalLocationPsd || point.location || ''}</em><br>

                        Godziny otwarcia: ${point.openingHours || '-'}<br>

                        Kod miejsca docelowego: ${point.destinationCode || '-'}<br>

                        Grupa: ${point.groupName || '-'}

                    </div>

                `;

                jQuery('#orlen_paczka_pickup_point_label').html(html);

                jQuery('#load-orlen-widget').text('Wybierz inny punkt');

                jQuery('#orlen_selected_text').fadeIn(300);

            }



            window.addEventListener('orlenSelectPoint', handleOrlenSelectPoint);

            jQuery(document).on('orlenSelectPoint', '.orlen-widget', handleOrlenSelectPoint);



                    });

                    </script>

                    <?php

                }



            public function ajax_save_pickup_point_to_session() {

                if (empty($_POST['point'])) {

                    wp_send_json_error('Brak danych punktu.');

                }

                $point = json_decode(stripslashes($_POST['point']), true);

                if (empty($point) || !is_array($point)) {

                    wp_send_json_error('Nieprawidłowe dane.');

                }



                WC()->session->set('orlen_paczka_pickup_point_data', $point);

                wp_send_json_success('Punkt zapisany w sesji.');

            }



            public function save_pickup_point($order_id) {

                $point_data = WC()->session->get('orlen_paczka_pickup_point_data');

                if (empty($point_data)) return;



                $full_address = sprintf(

                    '%s, %s, %s %s, %s',

                    $point_data['physicalNamePsd'] ?? $point_data['name'] ?? '',

                    $point_data['addressLine'] ?? '',

                    $point_data['postalCode'] ?? '',

                    $point_data['city'] ?? '',

                    $point_data['province'] ?? ''

                );



                update_post_meta($order_id, 'orlen_paczka_pickup_point_id', $point_data['id'] ?? '');

                update_post_meta($order_id, 'orlen_paczka_pickup_point_name', $full_address);

                update_post_meta($order_id, 'orlen_paczka_pickup_point', $point_data['destinationCode'] ?? '');

                update_post_meta($order_id, 'orlen_paczka_pickup_point_data', wp_json_encode($point_data));

            }



            public function display_pickup_point_in_admin($order) {

                $pickup_name = get_post_meta($order->get_id(), 'orlen_paczka_pickup_point_name', true);

                $pickup_id = get_post_meta($order->get_id(), 'orlen_paczka_pickup_point_id', true);

                if ($pickup_name) {

                    echo '<p><strong>Punkt ORLEN Paczka:</strong><br>' . esc_html($pickup_name) . '<br>';

                    if ($pickup_id) echo 'ID: ' . esc_html($pickup_id);

                    echo '</p>';

                }

            }

}



}