<?php



if ( ! defined( 'ABSPATH' ) ) exit;





add_action('add_meta_boxes', function () {

    $screen = function_exists('wc_get_page_screen_id') ? wc_get_page_screen_id('shop-order') : 'shop_order';



    add_meta_box(

        'orlen_paczka_box',

        __('ORLEN Paczka', 'twoj-textdomain'),

        'orlen_paczka_box_content',

        $screen,

        'normal',

        'high'

    );

});



function orlen_paczka_box_content($post) {

    $order = wc_get_order($post->ID);

    if (!$order) {

        echo '<p>Brak danych zamówienia.</p>';

        return;

    }



    $has_orlen = false;

    foreach ($order->get_shipping_methods() as $method) {

        if (strpos($method->get_method_id(), 'orlen_paczka') !== false) {

            $has_orlen = true;

            break;

        }

    }



    if (!$has_orlen) {

        echo '<p>To zamówienie nie ma metody wysyłki ORLEN Paczka.</p>';

        return;

    }



    $total_weight   = 0;

    $missing_weight = false;

    foreach ($order->get_items() as $item) {

        $product = $item->get_product();

        if ($product) {

            $weight = (float) $product->get_weight();

            $qty    = (int) $item->get_quantity();

            if (!$weight) $missing_weight = true;

            $total_weight += $weight * $qty;

        }

    }



    if ($total_weight > 20) {

        echo '<div style="margin-bottom:10px; padding:10px; background-color:#f8d7da; color:#721c24; font-weight:bold; border:1px solid #f5c6cb; border-radius:6px;">

            ⚠️ Łączna waga zamówienia ' . esc_html($total_weight) . ' kg przekracza dopuszczalny limit 20 kg. Podziel zamówienie na mniejsze paczki.

        </div>';

    } elseif ($missing_weight) {

        echo '<div style="margin-bottom:10px; padding:10px; background-color:#fff3cd; color:#856404; font-weight:bold; border:1px solid #ffeeba; border-radius:6px;">

            ⚠️ Zamówienie zawiera produkty, które nie mają zdefiniowanej wagi. Upewnij się, że

waga pojedynczej przesyłki ORLEN Paczka nie przekracza 20 kg.

        </div>';

    }

   

    

    $senders = get_option('orlen_senders', []);

    $selected_store = get_post_meta($order->get_id(), '_selected_store', true);



    echo '<div style="margin-top:20px; padding:15px; border:1px solid #ccd0d4; border-radius:6px; background:#f9f9f9;">';

    echo '<h4 style="margin:0 0 10px; font-size:14px; font-weight:600; color:#23282d;">📦 Wybierz nadawcę</h4>';

    echo '<hr style="margin:20px 0;">';

   if (!empty($senders)) {

   

    $first = true;





echo '<div style="display:flex; flex-wrap:wrap; gap:20px;">';



foreach ($senders as $index => $sender) {

 $label = '<strong>' . esc_html($sender['name']) . '</strong><br>' .

         esc_html($sender['street'] . ' ' . $sender['building']) . '<br>' .

         esc_html($sender['postcode'] . ' ' . $sender['city']);



if (($selected_store === '' || $selected_store === null) && $first) {

    $is_selected = true;

} else {

    $is_selected = ((string)$selected_store === (string)$index);

}



echo '<div class="orlen-sender-box" style="flex:1; min-width:45%; padding:12px; border:1px solid #ddd; border-radius:6px; background:#fff;">';

    echo '<div style="margin-bottom:10px;">' . $label . '</div>';

    echo '<button type="button" class="button button-secondary orlen-set-sender"

            data-order-id="' . esc_attr($order->get_id()) . '"

            data-sender-id="' . esc_attr($index) . '">' 

            . ( $is_selected ? '✅ Ustawiony' : 'Ustaw jako nadawcę' ) . 

         '</button>';

echo '</div>';



$first = false;



}





} else {

    echo '<p>⚠️ Brak zapisanych nadawców. Najpierw dodaj nadawcę w ustawieniach ORLEN Paczka.</p>';

}

echo '</div>';

echo '</div>';

?>



<script>

jQuery(document).ready(function($) {

    $('.orlen-set-sender').on('click', function() {

        var button = $(this);

        var orderId = button.data('order-id');

        var senderId = button.data('sender-id');

        var packageId = jQuery(this).data('package-id');



        button.prop('disabled', true).text('Zapisywanie...');



        $.post(ajaxurl, {

            action: 'orlen_update_sender',

            order_id: orderId,

            sender_id: senderId,

            package_id: packageId,

            _ajax_nonce: '<?php echo wp_create_nonce("orlen_update_sender"); ?>'

        }, function(response) {

            if (response.success) {

                $('.orlen-set-sender').text('Ustaw jako nadawcę').prop('disabled',

                    false);

                button.text('✅ Ustawiony').prop('disabled', false);

            } else {

                alert('Błąd: ' + response.data);

                button.prop('disabled', false).text('Ustaw jako nadawcę');

            }

        });

    });

});

</script>

<?php





    $order_id   = $order->get_id();

    $labels_dir = WP_CONTENT_DIR . '/uploads/orlen-labels/';

    $pattern    = $labels_dir . 'order-' . $order_id . '-*.pdf';

    $files      = is_dir($labels_dir) ? glob($pattern) : [];



    $pickup_id   = get_post_meta($order->get_id(), 'orlen_paczka_pickup_point', true);

    $pickup_name = get_post_meta($order->get_id(), 'orlen_paczka_pickup_point_name', true);

?>

<div style="margin-top:20px; padding:15px; border:1px solid #ccd0d4; border-radius:6px; background:#f9f9f9;">

    <h4 style="margin:0 0 10px; font-size:14px; font-weight:600; color:#23282d;">📦 Przesyłki do zamówienia</h4>

    <hr style="margin:20px 0;">



    <?php



$shipping_first_name = esc_html($order->get_shipping_first_name());

$shipping_last_name  = esc_html($order->get_shipping_last_name());

$shipping_address_1  = esc_html($order->get_shipping_address_1());

$shipping_address_2  = esc_html($order->get_shipping_address_2());

$shipping_city       = esc_html($order->get_shipping_city());

$shipping_postcode   = esc_html($order->get_shipping_postcode());

$shipping_phone      = esc_html($order->get_billing_phone());

$shipping_email      = esc_html($order->get_billing_email());



?>



    <div style="margin-top:20px; padding:15px; border:1px solid #ccd0d4; border-radius:6px; background:#f9f9f9;">



        <script>

        var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';

        var orlen_nonce = '<?php echo wp_create_nonce("orlen_ajax_nonce"); ?>';

        </script>





        <?php



            $sender_order   = get_option('orlen_sender_orders', 'nr_zamowienia_woo'); 

            $custom_comment = get_option('orlen_custom_comment', '');



            ?>





        <div class="orlen-buttons-row" style="display:flex; align-items:center; gap:10px; margin-top:10px;">

            <button type="button" class="orlen-edit-shipping button button-secondary"

                data-order-id="<?php echo $order->get_id(); ?>">

                ➕ Dodaj przesyłkę do zamówienia

            </button>



            <?php

                $protocols = get_post_meta($order->get_id(), '_orlen_protocols', true);

                if (!empty($protocols)) {

                    $latest = end($protocols);

                    echo '<a href="' . esc_url($latest['protocol_url']) . '" target="_blank" 

            class="button" 

            style="background-color:#28a745;color:#fff;border:none;">🖨️ Drukuj protokół przekazania</a>';

                }

              





            $filter_url = add_query_arg(

                array(

                    'page' => 'orlen-shipping-history',

                    'filter_order_id' => $order_id,

                ),

                admin_url( 'admin.php' )

            );

            ?>



            <div class="orlen-order-container">

                <p>

                    <button type="button" class="button button-secondary"

                        onclick="window.location.href='<?php echo esc_url( $filter_url ); ?>'">

                        Przejdź do zamówienia w historii nadania

                    </button>

                </p>

            </div>





        </div>





        <div class="orlen-shipping-popup" id="popup-<?php echo $order->get_id(); ?>"

            data-pickup-name="<?php echo esc_attr($pickup_name ?? ''); ?>"

            data-pickup-id="<?php echo esc_attr($pickup_id ?? ''); ?>"

            style="display:none; position:fixed; top:10%; left:50%; transform:translateX(-50%);

            background:#fff; padding:60px; border:1px solid #ccc; z-index:1000; max-width:900px; max-height:90%; overflow-y:auto;">





            <span class="orlen-close-popup" style="position:absolute; top:10px; right:15px; font-size:28px; 

          font-weight:bold; color:#333; cursor:pointer;">&times;</span>



            <h3>Dane do przesyłki</h3>

            <div style="display:flex; gap:15px; align-items:flex-start;">

                <div style="flex:1; max-width:50%;">

                    <label>Imię:

                        <input type="text" id="orlen-shipping-first-name-<?php echo esc_attr($order->get_id()); ?>"

                            value="<?php echo esc_attr($shipping_first_name); ?>" style="width:100%;" required

                            pattern="^[A-Za-zÀ-ÿżźćńółęąśŻŹĆĄŚĘŁÓŃ -]{2,}$" title="Wpisz poprawne imię (min. 2 znaki)">

                    </label><br>



                    <label>Nazwisko:

                        <input type="text" id="orlen-shipping-last-name-<?php echo esc_attr($order->get_id()); ?>"

                            value="<?php echo esc_attr($shipping_last_name); ?>" style="width:100%;" required

                            pattern="^[A-Za-zÀ-ÿżźćńółęąśŻŹĆĄŚĘŁÓŃ -]{2,}$"

                            title="Wpisz poprawne nazwisko (min. 2 znaki)">

                    </label><br>



                    <label>Ulica:

                        <input type="text" id="orlen-shipping-address-1-<?php echo esc_attr($order->get_id()); ?>"

                            value="<?php echo esc_attr($shipping_address_1); ?>" style="width:100%;" required

                            title="Podaj nazwę ulicy">

                    </label><br>



                    <label>Nr budynku/lokalu:

                        <input type="text" id="orlen-shipping-address-2-<?php echo esc_attr($order->get_id()); ?>"

                            value="<?php echo esc_attr($shipping_address_2); ?>" style="width:100%;">

                    </label><br>



                    <label>Miejscowość:

                        <input type="text" id="orlen-shipping-city-<?php echo esc_attr($order->get_id()); ?>"

                            value="<?php echo esc_attr($shipping_city); ?>" style="width:100%;" required

                            pattern="^[A-Za-zÀ-ÿżźćńółęąśŻŹĆĄŚĘŁÓŃ -]{2,}$" title="Podaj nazwę miasta">

                    </label><br>



                    <label>Kod pocztowy:

                        <input type="text" id="orlen-shipping-postcode-<?php echo esc_attr($order->get_id()); ?>"

                            value="<?php echo esc_attr($shipping_postcode); ?>" style="width:100%;"

                            pattern="^[0-9]{2}-[0-9]{3}$" title="Format: 00-000" required maxlength="6">

                    </label><br>



                    <label>Telefon:

                        <input type="tel" id="orlen-shipping-phone-<?php echo esc_attr($order->get_id()); ?>"

                            value="<?php echo esc_attr($shipping_phone); ?>" style="width:100%;"

                            title="Podaj 9 cyfr bez spacji, np. 501234567" required maxlength="12">

                    </label><br>



                    <label>Email:

                        <input type="email" id="orlen-shipping-email-<?php echo esc_attr($order->get_id()); ?>"

                            value="<?php echo esc_attr($shipping_email); ?>" style="width:100%;" required

                            title="Podaj poprawny adres e-mail">

                    </label>



                </div>



                <div style="flex:1; max-width:50%; display:flex; flex-direction:column; gap:15px;">

                    <label>Format etykiety:

                        <select id="orlen-new-package-etykieta-<?php echo esc_attr($order->get_id()); ?>"

                            style="width:100%;">

                            <option value="PDF">PDF</option>

                        </select>

                    </label>



                    <label>Pole referencyjne (widoczne na etykiecie):<br><br>

                        <input type="radio" name="orlen_SenderOrders_<?php echo esc_attr($order->get_id()); ?>"

                            value="nr_zamowienia_woo"

                            <?php echo ($sender_order === 'nr_zamowienia_woo' ? 'checked' : ''); ?>>

                        Numer zamówienia (Woo)

                    </label>



                    <label>

                        <input type="radio" name="orlen_SenderOrders_<?php echo esc_attr($order->get_id()); ?>"

                            value="wlasny_opis" <?php echo ($sender_order === 'wlasny_opis' ? 'checked' : ''); ?>>

                        Własne

                    </label>



                    <input type="text" id="orlen-custom-comment-<?php echo esc_attr($order->get_id()); ?>"

                        name="custom_comment_<?php echo esc_attr($order->get_id()); ?>" maxlength="30"

                        placeholder="(max 30 znaków)"

                        style="width:300px;margin-top:5px; <?php echo ($sender_order === 'wlasny_opis' ? '' : 'display:none;'); ?>"

                        value="<?php echo esc_attr($custom_comment); ?>">



                    <label>Gabaryt przesyłki:

                        <select id="orlen-new-package-size-<?php echo esc_attr($order->get_id()); ?>"

                            style="width:100%;">                            

                            <option value="S" <?php selected( get_option('orlen_default_size'), 'S' ); ?>>S - wymiary: 8 x 38 x 60 cm</option>

                            <option value="M" <?php selected( get_option('orlen_default_size'), 'M' ); ?>>M - wymiary: 19 x 38 x 60 cm</option>

                            <option value="L" <?php selected( get_option('orlen_default_size'), 'L' ); ?>>L - wymiary: 41 x 38 x 60 cm</option>

                        </select>

                    </label>



                    <div style="display:flex; flex-wrap:wrap; gap:20px;">

                        <div id="orlen-paczka-current-point"

                            style="flex:1 1 300px; padding:12px; border-radius:6px; background:#f9f9f9;">

                            <h4 style="margin:0 0 8px; font-size:14px; font-weight:600;">Punkt ORLEN Paczka</h4>

                            <?php   

                        if (!empty($pickup_name)) echo '<p style="margin:0;"><strong>' . esc_html($pickup_name) . '</strong></p>';

                        if ($pickup_id) echo '<p style="margin:0; color:#555;">ID: ' . esc_html($pickup_id) . '</p>';

                    ?>

                        </div>

                        <?php

                    global $orlen_admin_pickup;

                    if ($orlen_admin_pickup instanceof Orlen_Paczka_Admin_Pickup) {

                        $orlen_admin_pickup->display_admin_pickup_selector($order);

                    }

                ?>

                    </div>

                </div>

            </div>



            <button type="button" class="button button-secondary orlen-add-package"

                data-order-id="<?php echo esc_attr($order->get_id()); ?>">Zapisz</button>



            <input type="hidden" id="orlen-popup-mode-<?php echo esc_attr($order->get_id()); ?>" value="add">

            <input type="hidden" id="orlen-popup-package-id-<?php echo esc_attr($order->get_id()); ?>" value="">



            <br><br>

            <button type="button" class="orlen-close-popup">Zamknij</button>



        </div>







        <div id="orlen-tabs-wrapper-<?php echo esc_attr($order_id) ?>" class="orlen-tabs-wrapper"

            style="margin-top:20px; display:none;">

            <ul class="orlen-tabs-nav"></ul>

            <div class="orlen-tabs-content"></div>

        </div>









        <?php 

        $packages = get_post_meta($order->get_id(), '_orlen_paczka_size', false);

        $packageCount = 0;

        $first = true;



        $pickup_point_name = get_post_meta($order_id, 'orlen_paczka_pickup_point_name', true);

        $pickup_point      = get_post_meta($order_id, 'orlen_paczka_pickup_point', true);



        $senders = get_option('orlen_senders', []);

        $selected_store = get_post_meta($order_id, '_selected_store', true);





if ($packages) {

     foreach ($packages as $p) {

    $decoded = json_decode($p, true);

    if (!$decoded) continue;



    $packageCount++;

    $tabId = 'tab-' . $order->get_id() . '-' . $packageCount;

    $liClass = $first ? 'active' : '';

    $paneClass = $first ? 'tab-pane active' : 'tab-pane';



    $size            = esc_html($decoded['size']);

    $first_name      = esc_html($decoded['first_name'] ?? '');

    $last_name       = esc_html($decoded['last_name'] ?? '');

    $address_1       = esc_html($decoded['address_1'] ?? '');

    $address_2       = esc_html($decoded['address_2'] ?? '');

    $city            = esc_html($decoded['city'] ?? '');

    $postcode        = esc_html($decoded['postcode'] ?? '');

    $phone           = esc_html($decoded['phone'] ?? '');

    $email           = esc_html($decoded['email'] ?? '');

    $insurance       = esc_html($decoded['insurance'] ?? '');

    $custom_comment  = esc_html($decoded['custom_comment'] ?? '');

    $label_url       = esc_url($decoded['label_url'] ?? '');

    $pack_code       = esc_html($decoded['pack_code'] ?? '');

    $package_id      = esc_html($decoded['id'] ?? '');

    $pickup_point_name = esc_html($decoded['pickup_point_name'] ?? '');

    $pickup_point    = esc_html($decoded['pickup_point'] ?? '');

    $etykieta        = esc_html($decoded['etykieta'] ?? '');

    ?>





        <script>

        jQuery(document).ready(function($) {

            var wrapper = $("#orlen-tabs-wrapper-<?php echo $order->get_id(); ?>");

            wrapper.show();



            var li = $("<li></li>").attr("data-package-id", "<?php echo esc_attr($package_id); ?>");

            var a = $("<a/>", {

                href: "#<?php echo $tabId; ?>",

                class: "<?php echo $liClass; ?>",

                html: "Przesyłka #<?php echo $size; ?>" +

                    <?php if (!empty($pack_code)) : ?>

                        " (<?php echo $pack_code; ?>)" +

                    <?php endif; ?>

                    " <span class='remove-tab' style='color:red; cursor:pointer; margin-left:6px;'>❌</span>"

            });



            li.append(a);

            wrapper.find(".orlen-tabs-nav").append(li);



            var paneHtml = '<div id="<?php echo $tabId; ?>" class="<?php echo $paneClass; ?>">';

            paneHtml += '<div class="package-info" style="display:flex; gap:20px;">';



            paneHtml += '<div class="package-info-left" style="flex:1;">';



            function addRow(label, value, extraClass = '') {

                return '<div class="package-row ' + extraClass + '" style="padding:6px 0;">' +

                    '<strong>' + label + '</strong><span>' + value + '</span></div>';

            }



            paneHtml += addRow('Gabaryt przesyłki: ', '<?php echo $size; ?>', 'recipient-header');

            paneHtml += addRow('Wysyłka: ', '', 'recipient-data');

            paneHtml += addRow('', '<?php echo $first_name .' ' . $last_name; ?>', 'recipient-data');

            paneHtml += addRow('',

                '<?php echo $postcode . ' ' . $city . ', ul. ' . $address_1 . ' ' . $address_2; ?>',

                'recipient-data');

            paneHtml += addRow('Telefon: ', '<?php echo $phone; ?>', 'recipient-data');

            paneHtml += addRow('Email: ', '<?php echo $email; ?>', 'recipient-data');

            paneHtml += addRow('', '', 'recipient-header');



            paneHtml += addRow('Punkt ORLEN Paczka: ', '', 'pickup-data');

            paneHtml += addRow('', '<?php echo $pickup_point_name ?>', 'pickup-data');

            paneHtml += addRow('ID punktu: ', '<?php echo $pickup_point; ?>', 'pickup-data');



            <?php if (!empty($custom_comment)) : ?>

            paneHtml += addRow('Pole referencyjne (widoczne na etykiecie): ', '<?php echo $custom_comment; ?>');

            <?php endif; ?>



            paneHtml += '</div>';



            paneHtml +=

                '<div class="package-info-right" style="flex:0 0 200px; display:flex; flex-direction:column; gap:6px;">';



            <?php if (!empty($pack_code)) : ?>

            paneHtml += '<strong class="pack-code">Numer przesyłki: <?php echo $pack_code; ?></strong>';

            paneHtml += '<button type="button" class="button button-secondary print-label" ' +

                'data-label-url="<?php echo esc_js($label_url); ?>" ' +

                'style="width:100%; text-align:center; margin-top:10px;">🖨️ Drukuj etykietę</button>';



            paneHtml +=

                '<a href="https://www.orlenpaczka.pl/sledz-paczke/?numer=<?php echo $pack_code; ?>" target="_blank" class="button button-secondary" style="width:100%; text-align:center; margin-top:10px;">🔎📦 Śledź przesyłkę</a>';





            paneHtml +=

                '<a href="#" class="button button-secondary edit-package-btn" style="width:100%; text-align:center;"' +

                'data-order-id="<?php echo $order_id; ?>" ' +

                'data-package-id="<?php echo $package_id; ?>" ' +

                'data-first-name="<?php echo esc_js($first_name); ?>" ' +

                'data-last-name="<?php echo esc_js($last_name); ?>" ' +

                'data-address1="<?php echo esc_js($address_1); ?>" ' +

                'data-address2="<?php echo esc_js($address_2); ?>" ' +

                'data-city="<?php echo esc_js($city); ?>" ' +

                'data-postcode="<?php echo esc_js($postcode); ?>" ' +

                'data-phone="<?php echo esc_js($phone); ?>" ' +

                'data-email="<?php echo esc_js($email); ?>" ' +

                'data-pickup-id="<?php echo esc_js($pickup_point); ?>" ' +

                'data-pickup-name="<?php echo esc_js($pickup_point_name); ?>">📝 Edytuj dane</a>';



            <?php endif; ?>

            <?php if (empty($pack_code)) : ?>

            paneHtml += '<strong class="pack-code">Format etykiety: <?php echo $etykieta; ?></strong>';

            paneHtml += '<button type="button" class="button button-secondary generate-label" ' +

                'data-order-id="<?php echo $order_id; ?>" ' +

                'data-package-id="<?php echo $package_id ?? ""; ?>" ' +

                'style="width:100%; text-align:center; margin-top:10px;">📬 Generuj etykietę</button>';



            paneHtml +=

                '<a href="#" class="button button-secondary edit-package-btn" style="width:100%; text-align:center;" ' +

                'data-order-id="<?php echo $order_id; ?>" ' +

                'data-package-id="<?php echo $package_id; ?>" ' +

                'data-first-name="<?php echo esc_js($first_name); ?>" ' +

                'data-last-name="<?php echo esc_js($last_name); ?>" ' +

                'data-address1="<?php echo esc_js($address_1); ?>" ' +

                'data-address2="<?php echo esc_js($address_2); ?>" ' +

                'data-city="<?php echo esc_js($city); ?>" ' +

                'data-postcode="<?php echo esc_js($postcode); ?>" ' +

                'data-phone="<?php echo esc_js($phone); ?>" ' +

                'data-email="<?php echo esc_js($email); ?>" ' +

                'data-pickup-id="<?php echo esc_js($pickup_point); ?>" ' +

                'data-pickup-name="<?php echo esc_js($pickup_point_name); ?>">📝 Edytuj dane</a>';

            <?php endif; ?>



            paneHtml += '</div>';

            paneHtml +=

                '<div class="orlen-label-error" style="color:red; font-weight:bold; margin-top:8px; display:none;"></div>';

            paneHtml += '</div>';

            paneHtml += '</div>';

            wrapper.find(".orlen-tabs-content").append(paneHtml);



            jQuery(document).on('click', '.edit-package-btn', function(e) {

                e.preventDefault();

                const $btn = jQuery(this);

                const orderId = <?php echo $order->get_id(); ?>;



                jQuery('#popup-' + orderId + ' #orlen-shipping-first-name-' + orderId).val($btn.data(

                    'first-name'));

                jQuery('#popup-' + orderId + ' #orlen-shipping-last-name-' + orderId).val($btn.data(

                    'last-name'));

                jQuery('#popup-' + orderId + ' #orlen-shipping-address-1-' + orderId).val($btn.data(

                    'address1'));

                jQuery('#popup-' + orderId + ' #orlen-shipping-address-2-' + orderId).val($btn.data(

                    'address2'));

                jQuery('#popup-' + orderId + ' #orlen-shipping-city-' + orderId).val($btn.data('city'));

                jQuery('#popup-' + orderId + ' #orlen-shipping-postcode-' + orderId).val($btn.data(

                    'postcode'));

                jQuery('#popup-' + orderId + ' #orlen-shipping-phone-' + orderId).val($btn.data(

                    'phone'));

                jQuery('#popup-' + orderId + ' #orlen-shipping-email-' + orderId).val($btn.data(

                    'email'));



                jQuery('#popup-' + orderId + ' #orlen-paczka-current-point strong').text($btn.data(

                    'pickup-name'));

                jQuery('#popup-' + orderId + ' #orlen-paczka-current-point p:last').text('ID: ' + $btn

                    .data('pickup-id'));

                jQuery('#popup-' + orderId + ' #edit-package-pickup-point').val($btn.data('pickup-id'));

                jQuery('#popup-' + orderId + ' #edit-package-pickup-point-name').val($btn.data(

                    'pickup-name'));



                jQuery('#popup-' + orderId).fadeIn();

            });

        });

        </script>



        <?php

    $first = false;

} 

}

echo '</div>';

?>



        <script>

        jQuery(document).ready(function($) {

            var packageCount = typeof initialPackageCount !== 'undefined' ? initialPackageCount :

                <?php echo intval($packageCount ?? 0); ?>;



            function addRow(label, value, extraClass = '') {

                return '<div class="package-row ' + extraClass + '" style="padding:6px 0;"><strong>' + label +

                    '</strong><span>' + value + '</span></div>';

            }



            // ---------------------

            // Otwieranie popupu (dodawanie / edycja)

            // ---------------------

            $(document).on('click', '.orlen-edit-shipping, .edit-package-btn', function(e) {

                e.preventDefault();

                var $btn = $(this);

                var orderId = $btn.data('order-id');

                var $popup = $('#popup-' + orderId);



                $('#orlen-popup-mode-' + orderId).val('add');

                $('#orlen-popup-package-id-' + orderId).val('');



                if ($btn.hasClass('edit-package-btn')) {

                    $('#orlen-popup-mode-' + orderId).val('edit');

                    var packageId = $btn.data('package-id');

                    $('#orlen-popup-package-id-' + orderId).val(packageId);



                    $('#orlen-shipping-first-name-' + orderId).val($btn.data('first-name') || '');

                    $('#orlen-shipping-last-name-' + orderId).val($btn.data('last-name') || '');

                    $('#orlen-shipping-address-1-' + orderId).val($btn.data('address1') || '');

                    $('#orlen-shipping-address-2-' + orderId).val($btn.data('address2') || '');

                    $('#orlen-shipping-city-' + orderId).val($btn.data('city') || '');

                    $('#orlen-shipping-postcode-' + orderId).val($btn.data('postcode') || '');

                    $('#orlen-shipping-phone-' + orderId).val($btn.data('phone') || '');

                    $('#orlen-shipping-email-' + orderId).val($btn.data('email') || '');

                    $('#orlen-custom-comment-' + orderId).val($btn.data('custom-comment') || '');



                    $('#orlen-paczka-current-point strong').text($btn.data('pickup-name') || '');

                    $('#orlen-paczka-current-point p:last').text('ID: ' + ($btn.data('pickup-id') ||

                        ''));

                } else {

                    var orderPrefix = orderId;

                }



                $popup.fadeIn(200);

            });



            $(document).on('click', '.orlen-close-popup', function() {

                $(this).closest('.orlen-shipping-popup').fadeOut(200);

            });



            $(document).on('change', 'input[name^="orlen_SenderOrders_"]', function() {

                var orderIdMatch = $(this).attr('name').match(/\d+$/);

                if (!orderIdMatch) return;

                var orderId = orderIdMatch[0];

                $('#orlen-custom-comment-' + orderId).toggle($(this).val() === 'wlasny_opis');

            });





            $(document).on('click', '.orlen-close-popup', function() {

                const popup = $(this).closest('.orlen-shipping-popup');

                const box = popup.find('#orlen-paczka-current-point');



                const defaultHTML = `

                        <h4 style="margin:0 0 8px; font-size:14px; font-weight:600;">Punkt ORLEN Paczka</h4>

                        <p style="margin:0;"><strong>${popup.data('pickup-name') || ''}</strong></p>

                        <p style="margin:0; color:#555;">ID: ${popup.data('pickup-id') || ''}</p>

                    `;



                if (box.length) {

                    box.html(defaultHTML).fadeIn(200);

                }



                // Wyczyść hiddeny

                popup.find('#admin_orlen_paczka_pickup_point').val('');

                popup.find('#admin_orlen_paczka_pickup_point_code').val('');

                popup.find('#admin_orlen_paczka_pickup_point_name').val('');

                popup.find('#admin_orlen_paczka_pickup_point_full').val('');



                popup.find('#admin_orlen_paczka_pickup_point_label').empty();

            });





            // ---------------------

            // Przełączanie tabów (bez zmiany URL i bez doklejania całego current URL)

            // ---------------------

            $(document).on('click', '.orlen-tabs-nav a', function(e) {

                e.preventDefault();

                if ($(e.target).hasClass('remove-tab')) return;

                var $a = $(this);

                var $wrapper = $a.closest('.orlen-tabs-wrapper');

                var rawHref = $a.attr('href') || '';

                var target = rawHref.replace(/^[^#]*/, ''); // zostaw tylko część od #

                if (!target) return;

                $wrapper.find('.orlen-tabs-nav a').removeClass('active');

                $wrapper.find('.tab-pane').removeClass('active');

                $a.addClass('active');

                $wrapper.find(target).addClass('active');

            });



            // ---------------------

            // Dodawanie / edycja paczki (AJAX)

            // ---------------------

            $(document).on('click', '.orlen-add-package', function(ev) {

                ev.preventDefault();



                var $btn = $(this);

                var orderId = $btn.data('order-id');

                var mode = $('#orlen-popup-mode-' + orderId).val();

                var packageId = $('#orlen-popup-package-id-' + orderId).val();

                var $popup = $('#popup-' + orderId);



                console.log('TRYB:', mode, 'PACZKA:', packageId);



                // --- WALIDACJA FORMULARZA ---

                var valid = true;

                $popup.find('.validation-error').remove();



                var fields = [{

                        id: '#orlen-shipping-first-name-',

                        name: 'Imię',

                        pattern: /^[A-Za-zÀ-ÿżźćńółęąśŻŹĆĄŚĘŁÓŃ -]{2,}$/

                    },

                    {

                        id: '#orlen-shipping-last-name-',

                        name: 'Nazwisko',

                        pattern: /^[A-Za-zÀ-ÿżźćńółęąśŻŹĆĄŚĘŁÓŃ -]{2,}$/

                    },

                    {

                        id: '#orlen-shipping-address-1-',

                        name: 'Ulica',

                        pattern: /.+/

                    },

                    {

                        id: '#orlen-shipping-city-',

                        name: 'Miejscowość',

                        pattern: /^[A-Za-zÀ-ÿżźćńółęąśŻŹĆĄŚĘŁÓŃ -]{2,}$/

                    },

                    {

                        id: '#orlen-shipping-postcode-',

                        name: 'Kod pocztowy',

                        pattern: /^[0-9]{2}-[0-9]{3}$/

                    },

                    {

                        id: '#orlen-shipping-phone-',

                        name: 'Telefon',

                        pattern: /^\+48[0-9]{9}$/

                    },



                    {

                        id: '#orlen-shipping-email-',

                        name: 'Email',

                        pattern: /^[^\s@]+@[^\s@]+\.[^\s@]+$/

                    }

                ];



                fields.forEach(function(f) {

                    var $input = $(f.id + orderId);

                    var value = $.trim($input.val());



                    $input.next('.validation-error').remove();



                    if (!f.pattern.test(value)) {

                        valid = false;



                        var message = (f.name === 'Telefon') ?

                            'Podaj numer w formacie +48123456789' :

                            'Niepoprawne ' + f.name;



                        $('<span class="validation-error" style="color:red; font-size:12px; display:block; margin-top:3px;">' +

                            message + '</span>').insertAfter($input);

                    }

                });



                if (!valid) {

                    alert('⚠️ Uzupełnij pola w formularzu przed zapisaniem paczki.');

                    return false;

                }



                var shippingData = {

                    first_name: $('#orlen-shipping-first-name-' + orderId).val(),

                    last_name: $('#orlen-shipping-last-name-' + orderId).val(),

                    address_1: $('#orlen-shipping-address-1-' + orderId).val(),

                    address_2: $('#orlen-shipping-address-2-' + orderId).val(),

                    city: $('#orlen-shipping-city-' + orderId).val(),

                    postcode: $('#orlen-shipping-postcode-' + orderId).val(),

                    phone: $('#orlen-shipping-phone-' + orderId).val(),

                    email: $('#orlen-shipping-email-' + orderId).val()

                };



                var senderOrder = $('input[name="orlen_SenderOrders_' + orderId + '"]:checked').val() ||

                    '';

                var customComment = $('#orlen-custom-comment-' + orderId).val();

                if (senderOrder === 'nr_zamowienia_woo') {

                    customComment = '';

                }

                var size = $('#orlen-new-package-size-' + orderId).val();

                var labelFormat = $('#orlen-new-package-etykieta-' + orderId).val();

                var pickupName = $('#admin_orlen_paczka_pickup_point_name').val() || $(

                    '#orlen-paczka-current-point strong').text();

                var pickupId = $('#admin_orlen_paczka_pickup_point').val() || $(

                    '#orlen-paczka-current-point p:last').text().replace('ID: ', '');



                var action = (mode === 'edit' && packageId) ? 'orlen_update_package' :

                    'orlen_add_package';



                $btn.prop('disabled', true).text('⏳ Zapisywanie paczki...');



                $.ajax({

                    url: '<?php echo admin_url("admin-ajax.php"); ?>',

                    type: 'POST',

                    dataType: 'json',

                    data: {

                        action: action,

                        _ajax_nonce: '<?php echo wp_create_nonce("orlen_ajax_nonce"); ?>',

                        order_id: orderId,

                        package_id: packageId,

                        shipping_data: shippingData,

                        sender_order_type: senderOrder,

                        custom_comment: customComment,

                        size: size,

                        etykieta: labelFormat,

                        pickup_point_name: pickupName,

                        pickup_point: pickupId

                    },

                    success: function(resp) {

                        $btn.prop('disabled', false).text('Zapisz');

                        if (!resp || !resp.success) {

                            alert('❌ Błąd: ' + (resp && resp.data ? resp.data :

                                'Nieznany błąd'));

                            return;

                        }



                        var entry = resp.data.entry || {

                            id: packageId || 'pkg-' + Date.now(),

                            first_name: shippingData.first_name,

                            last_name: shippingData.last_name,

                            address_1: shippingData.address_1,

                            address_2: shippingData.address_2,

                            city: shippingData.city,

                            postcode: shippingData.postcode,

                            phone: shippingData.phone,

                            email: shippingData.email,

                            size: size,

                            etykieta: labelFormat,

                            pickup_point_name: pickupName,

                            pickup_point: pickupId,

                            sender_order_type: senderOrder || '',

                            custom_comment: customComment,

                            pack_code: resp.data.pack_code || '',

                            label_url: resp.data.label_url || ''

                        };



                        var $wrapper = $('#orlen-tabs-wrapper-' + orderId);

                        var $nav = $wrapper.find('.orlen-tabs-nav');

                        var $content = $wrapper.find('.orlen-tabs-content');



                        if (mode === 'edit') {

                            var $li = $nav.find('li[data-package-id="' + packageId + '"]');

                            if ($li.length) {

                                var href = $li.find('a').attr('href').replace(/^[^#]*/,

                                    '');

                                var $existingPane = $content.find(href);

                                var $newPane = buildPane(entry, orderId);

                                $existingPane.replaceWith($newPane);

                                $li.find('a').html('Przesyłka #' + entry.size +

                                    ' <span class="remove-tab" style="color:red; cursor:pointer; margin-left:6px;">❌</span>'

                                );

                                $nav.find('a').removeClass('active');

                                $li.find('a').addClass('active');

                                $content.find('.tab-pane').removeClass('active');

                                $content.find(href).addClass('active');

                            }

                            alert('Zmieniono pomyślnie');

                            location.reload();

                        } else {

                            packageCount++;

                            var tabId = 'tab-' + orderId + '-' + packageCount;



                            var $li = $('<li/>', {

                                'data-package-id': entry.id

                            });

                            var $a = $('<a/>', {

                                href: '#' + tabId,

                                class: 'active',

                                html: 'Przesyłka #' + entry.size +

                                    ' <span class="remove-tab" style="color:red; cursor:pointer; margin-left:6px;">❌</span>'

                            });

                            $li.append($a);



                            $nav.find('a').removeClass('active');

                            $content.find('.tab-pane').removeClass('active');



                            $nav.append($li);



                            var $pane = buildPane(entry, orderId);

                            $pane.attr('id', tabId);

                            $content.append($pane);



                            $a.addClass('active');

                            $pane.addClass('active');



                            $wrapper.show();

                        }





                        // Przywrócenie stanu początkowego popupu ORLEN Paczka

                        var popup = $('#popup-' + orderId); // lub dowolny właściwy wrapper

                        var box = popup.find('#orlen-paczka-current-point');



                        const defaultHTML = `

                                <h4 style="margin:0 0 8px; font-size:14px; font-weight:600;">Punkt ORLEN Paczka</h4>

                                <p style="margin:0;"><strong>${popup.data('pickup-name') || ''}</strong></p>

                                <p style="margin:0; color:#555;">ID: ${popup.data('pickup-id') || ''}</p>

                            `;



                        if (box.length) {

                            box.html(defaultHTML).fadeIn(200);

                        }



                        // Wyczyść hiddeny

                        popup.find('#admin_orlen_paczka_pickup_point').val('');

                        popup.find('#admin_orlen_paczka_pickup_point_code').val('');

                        popup.find('#admin_orlen_paczka_pickup_point_name').val('');

                        popup.find('#admin_orlen_paczka_pickup_point_full').val('');

                        popup.find('#admin_orlen_paczka_pickup_point_label').empty();





                        $('#popup-' + orderId).fadeOut(200);

                    },

                    error: function() {

                        $btn.prop('disabled', false).text('Zapisz');

                        alert('❌ Błąd połączenia AJAX.');

                    }

                });



                return false;

            });



            // ---------------------

            // Pomoc: budowanie panelu (pane) dla paczki — użyte przy add i edit

            // ---------------------

            function buildPane(entry, orderId) {

                var $pane = $('<div/>', {

                    class: 'tab-pane'

                });

                var $container = $('<div/>', {

                    class: 'package-info',

                    style: 'display:flex; gap:20px;'

                });



                var $left = $('<div/>', {

                    class: 'package-info-left',

                    style: 'flex:1;'

                });

                $left.append(addRow('Gabaryt przesyłki: ', entry.size, 'recipient-header'));

                $left.append(addRow('Wysyłka: ', '', 'recipient-data'));

                $left.append(addRow('', (entry.first_name || '') + ' ' + (entry.last_name || ''),

                    'recipient-data'));

                $left.append(addRow('', (entry.postcode || '') + ' ' + (entry.city || '') + ', ul. ' + (entry

                    .address_1 || '') + ' ' + (entry.address_2 || ''), 'recipient-data'));

                $left.append(addRow('Telefon: ', entry.phone || '', 'recipient-data'));

                $left.append(addRow('Email: ', entry.email || '', 'recipient-data'));

                $left.append(addRow('', '', 'recipient-header'));

                $left.append(addRow('Punkt ORLEN Paczka: ', '', 'pickup-data'));

                $left.append(addRow('', entry.pickup_point_name || '', 'pickup-data'));

                $left.append(addRow('ID punktu: ', entry.pickup_point || '', 'pickup-data'));

                if (entry.custom_comment) $left.append(addRow('Pole referencyjne (widoczne na etykiecie): ',

                    entry

                    .custom_comment));

                $container.append($left);



                var $right = $('<div/>', {

                    class: 'package-info-right',

                    style: 'flex:0 0 200px; display:flex; flex-direction:column; gap:6px;'

                });



                if (entry.pack_code && entry.label_url) {

                    $right.append('<strong class="pack-code">Numer przesyłki: ' + entry.pack_code +

                    '</strong>');

                    $right.append('<a href="' + entry.label_url +

                        '" target="_blank" class="button button-secondary" style="width:100%; text-align:center; margin-top:10px;">🖨️ Drukuj etykietę</a>'

                    );

                    $right.append('<a href="https://www.orlenpaczka.pl/sledz-paczke/?numer=' + entry.pack_code +

                        '" target="_blank" class="button button-secondary" style="width:100%; text-align:center; margin-top:10px;">🔎📦 Śledź przesyłkę</a>'

                    );

                } else {

                    $right.append('<strong class="pack-code">Format etykiety: ' + (entry.etykieta || '') +

                        '</strong>');

                    $right.append(

                        '<button type="button" class="button button-secondary generate-label" data-order-id="' +

                        orderId + '" data-package-id="' + entry.id +

                        '" style="width:100%; text-align:center; margin-top:10px;">📬 Generuj etykietę</button>'

                    );

                }



                var $edit = $(

                    '<a href="#" class="button button-secondary edit-package-btn" style="width:100%; text-align:center;"' +

                    'data-order-id="' + orderId + '" ' +

                    'data-package-id="' + entry.id + '" ' +

                    'data-first-name="' + htmlspecialchars_attr(entry.first_name) + '" ' +

                    'data-last-name="' + htmlspecialchars_attr(entry.last_name) + '" ' +

                    'data-address1="' + htmlspecialchars_attr(entry.address_1) + '" ' +

                    'data-address2="' + htmlspecialchars_attr(entry.address_2) + '" ' +

                    'data-city="' + htmlspecialchars_attr(entry.city) + '" ' +

                    'data-postcode="' + htmlspecialchars_attr(entry.postcode) + '" ' +

                    'data-phone="' + htmlspecialchars_attr(entry.phone) + '" ' +

                    'data-email="' + htmlspecialchars_attr(entry.email) + '" ' +

                    'data-pickup-id="' + htmlspecialchars_attr(entry.pickup_point) + '" ' +

                    'data-pickup-name="' + htmlspecialchars_attr(entry.pickup_point_name) +

                    '">📝 Edytuj dane</a>');



                $right.append($edit);

                $container.append($right);

                $pane.append($container);

                $pane.append(

                    '<div class="orlen-label-error" style="color:red; font-weight:bold; margin-top:8px; display:none;"></div>'

                );



                return $pane;

            }



            function htmlspecialchars_attr(s) {

                if (typeof s === 'undefined' || s === null) return '';

                return String(s).replace(/"/g, '&quot;').replace(/'/g, '&#39;');

            }



            // ---------------------

            // Generowanie etykiety: wynik wstawiany do właściwego panelu (po packageId)

            // ---------------------

            $(document).on('click', '.generate-label', function(e) {

                e.preventDefault();

                var $btn = $(this);

                var orderId = $btn.data('order-id');

                var packageId = $btn.data('package-id');



                $btn.prop('disabled', true).text('⏳ Generowanie etykiety...');



                $('.orlen-overlay, .orlen-protocol-modal').remove();

                var $overlay = $('<div class="orlen-overlay"></div>').appendTo('body');

                var $modal = $('<div class="orlen-modal success"><p>Generuję etykietę… ⏳</p></div>')

                    .appendTo('body');

                $overlay.css({

                    position: 'fixed',

                    top: 0,

                    left: 0,

                    width: '100%',

                    height: '100%',

                    background: 'rgba(0,0,0,0.5)',

                    'z-index': 9998

                });





                $modal

                    .addClass('orlen-modal')

                    .css({

                        position: 'fixed',

                        top: '50%',

                        left: '50%',

                        transform: 'translate(-50%,-50%)',

                        'z-index': 9999,

                        border: '1px solid #ccc',

                        'border-radius': '8px',

                        'text-align': 'center',

                        background: '#fff'

                    });





                if (!$('#orlen-inline-styles').length) {

                    $('head').append(`

                    <style id="orlen-inline-styles">

                    .orlen-modal {

                        display: flex;

                        flex-direction: column;

                        align-items: center;

                        gap: 16px;

                        padding: 20px;

                        border-radius: 12px;

                        box-sizing: border-box;

                    }

                    

                    }    

                    .orlen-modal-text {

                        font-size: 15px;

                        line-height: 1.5;

                        color: #333;

                    }

                    .orlen-modal-buttons {

                        display: flex;

                        gap: 10px;

                        justify-content: center;

                        margin-top: 10px;

                        flex-wrap: wrap;

                    }

                    .orlen-modal-button {

                        padding: 8px 16px;

                        border-radius: 6px;

                        font-weight: 600;

                        cursor: pointer;

                        border: none;

                        min-width: 100px;

                        transition: all 0.2s ease;

                    }

                    .orlen-modal-button.primary {

                        background: #c50f3c;

                        color: #fff;

                    }

                    .orlen-modal-button.primary:hover {

                        background: #a10d33;

                    }

                    .orlen-modal-button.secondary {

                        background: #f2f2f2;

                        color: #333;

                    }

                    .orlen-modal-button.secondary:hover {

                        background: #e0e0e0;

                    }

                    </style>

                `);

                }



                if (!$('#orlen-inline-styles').length) {

                    $('head').append(modalStyles);

                }



                var ajaxUrl = (typeof orlen_ajax !== 'undefined' && orlen_ajax.ajax_url) ? orlen_ajax

                    .ajax_url : (typeof ajaxurl !== 'undefined' ? ajaxurl :

                        '<?php echo admin_url("admin-ajax.php"); ?>');

                var ajaxNonce = (typeof orlen_ajax !== 'undefined' && orlen_ajax.nonce) ? orlen_ajax

                    .nonce : '<?php echo wp_create_nonce("orlen_ajax_nonce"); ?>';



                $.ajax({

                    url: ajaxUrl,

                    method: 'POST',

                    dataType: 'json',

                    data: {

                        action: 'generate_orlen_label',

                        order_id: orderId,

                        package_id: packageId,

                        _ajax_nonce: ajaxNonce

                    },



                    success: function(response) {



                        //  Przygotuj podsumowanie błędów z API (Err + ErrDes)

                        let errorSummary = '';

                        if (response?.data?.errors && Array.isArray(response.data.errors) &&

                            response.data.errors.length > 0) {

                            errorSummary =

                                '<div class="orlen-error-summary" style="margin-top:10px; text-align:left;">';

                            response.data.errors.forEach(err => {

                                const code = err.code || '000';

                                const desc = err.desc || 'Nieznany błąd';

                                errorSummary +=

                                    `<p style="margin:4px 0;">(<strong>${code}</strong>) ${desc}</p>`;

                            });

                            errorSummary += '</div>';

                        }



                        //  Jeśli błąd (wp_send_json_error z PHP)

                        if (!response || response.success === false || response.success ===

                            'false') {

                            let msg = response?.data?.message ||

                                '❌ Błąd generowania etykiety.';



                            // Jeśli są błędy z API, dodaj je poniżej komunikatu

                            if (errorSummary) msg += '<br>' + errorSummary;



                            $modal.html(`

                <div class="orlen-modal">

                    <p class="orlen-modal-text">${msg}</p>

                    <div class="orlen-modal-buttons">

                        ${response?.data?.label_url ? `<a href="${response.data.label_url}" target="_blank" class="orlen-modal-button primary">Podgląd etykiety</a>` : ''}

                        <button id="close-modal" class="orlen-modal-button secondary">Zamknij</button>

                    </div>

                </div>

            `);



                            $modal.find('#close-modal').on('click', function() {

                                $modal.remove();

                                $overlay.remove();

                                location.reload();

                                $btn.prop('disabled', false).text(

                                    '🖨️ Generuj etykietę');

                            });



                            return;

                        }



                        //  Sukces — etykieta wygenerowana

                        const packcode = response.data.packcode || '';

                        const labelUrl = response.data.label_url || '';

                        const msg = response.data.message ||

                            'Etykieta wygenerowana pomyślnie ✅';



                        //  Znajdź odpowiedni kontener w zamówieniu

                        const paneSelector = '#orlen-tabs-wrapper-' + orderId + ' #tab-' +

                            orderId + '-' + packageId;

                        let $pane = $(paneSelector);



                        if ($pane.length === 0) {

                            const $li = $('#orlen-tabs-wrapper-' + orderId).find(

                                'li[data-package-id="' + packageId + '"]');

                            if ($li.length) {

                                let href = $li.find('a').attr('href') || '';

                                href = href.replace(/^[^#]*/, '');

                                $pane = $('#orlen-tabs-wrapper-' + orderId).find(href);

                            }

                        }



                        const $targetRight = $pane.length ? $pane.find(

                            '.package-info-right').first() : $btn.closest(

                            '.package-info-right');



                        // Usuń poprzedni numer przesyłki, jeśli istnieje

                        $targetRight.find('.pack-code-row').remove();



                        // Dodaj nowy numer przesyłki i przyciski

                        const codeRow = $(`

            <div class="pack-code-row" style="margin-top:10px;">

                <strong class="pack-code">Numer przesyłki: ${packcode}</strong>

                <button type="button" class="button button-secondary print-label" 

                    data-label-url="${labelUrl}" 

                    style="width:100%; text-align:center; margin-top:10px;">🖨️ Drukuj etykietę</button>

                <a href="https://www.orlenpaczka.pl/sledz-paczke/?numer=${packcode}" 

                    target="_blank" 

                    class="button button-secondary" 

                    style="width:100%; text-align:center; margin-top:10px;">🔎📦 Śledź przesyłkę</a>

            </div>

        `);



                        $targetRight.append(codeRow);





                        // Dodaj numer przesyłki również do nazwy zakładki

const $tabLi = $('#orlen-tabs-wrapper-' + orderId).find('li[data-package-id="' + packageId + '"]');

if ($tabLi.length) {

    const $tabLink = $tabLi.find('a');

    const originalText = $tabLink.text().replace(/\(.*\)/, '').trim(); // usuń ewentualny poprzedni numer

    $tabLink.html(originalText + ' (' + packcode + ')' + 

        ' <span class="remove-tab" style="color:red; cursor:pointer; margin-left:6px;">❌</span>');

}







                        // Zablokuj przycisk generowania po sukcesie

                        if ($pane.length) {

                            $pane.find('.generate-label[data-package-id="' + packageId +

                                    '"]')

                                .prop('disabled', true)

                                .text('✅ Etykieta wygenerowana!');

                        } else {

                            $btn.prop('disabled', true).text('✅ Etykieta wygenerowana!');

                        }



                        // Modal z informacją o sukcesie

                        $modal.html(`

            <div class="orlen-modal success">

                <p class="orlen-modal-text">${msg}<br></p>

               

                <div class="orlen-modal-buttons">

                    ${labelUrl ? '<button id="print-label-now" class="orlen-modal-button primary">Drukuj</button>' : ''}

                    <button id="close-modal" class="orlen-modal-button secondary">Zamknij</button>

                </div>

            </div>

        `);



                        // Obsługa kliknięć w modalu

                        $modal.find('#print-label-now').on('click', function() {

                            if (labelUrl) window.open(labelUrl, '_blank');

                        });



                        $modal.find('#close-modal').on('click', function() {

                            $modal.remove();

                            $overlay.remove();

                        });

                    },



                    error: function() {

                        alert('❌ Błąd połączenia (AJAX).');

                        $btn.prop('disabled', false).text('🖨️ Generuj etykietę');

                        $modal.remove();

                        $overlay.remove();

                    }

                });



            });



            // ---------------------

            // Usuwanie paczki

            // ---------------------

            $(document).on('click', '.remove-tab', function(e) {

                e.stopPropagation();

                if (!confirm("Czy na pewno usunąć przesyłkę?")) return;

                var $span = $(this);

                var $a = $span.closest('a');

                var $li = $a.closest('li');

                var $wrapper = $li.closest('.orlen-tabs-wrapper');

                var rawHref = $a.attr('href') || '';

                var target = rawHref.replace(/^[^#]*/, '');

                var orderId = $wrapper.attr('id').replace('orlen-tabs-wrapper-', '');

                var packageId = $li.data('package-id');



                $.post(ajaxurl, {

                    action: 'orlen_remove_package',

                    order_id: orderId,

                    package_id: packageId,

                    _ajax_nonce: '<?php echo wp_create_nonce("orlen_ajax_nonce"); ?>'

                }, function(resp) {

                    if (resp && resp.success) {

                        $li.remove();

                        if (target) $wrapper.find(target).remove();

                        var $first = $wrapper.find('.orlen-tabs-nav a').first();

                        $wrapper.find('.orlen-tabs-nav a').removeClass('active');

                        $wrapper.find('.tab-pane').removeClass('active');

                        if ($first.length) {

                            $first.addClass('active');

                            var firstHref = ($first.attr('href') || '').replace(/^[^#]*/, '');

                            if (firstHref) $wrapper.find(firstHref).addClass('active');

                        } else {

                            $wrapper.hide();

                        }

                    } else {

                        alert('Błąd: ' + (resp && resp.data ? resp.data : 'Nieznany błąd'));

                    }

                });

            });





        });



        jQuery(document).on('click', '.orlen-save-btn', function() {

            const $btn = jQuery(this);

            const $popup = $btn.closest('.orlen-shipping-popup');

            const orderId = $popup.attr('id').replace('popup-', '');

            const mode = $popup.find('#orlen-popup-mode-' + orderId).val();

            const packageId = $popup.find('#orlen-popup-package-id-' + orderId).val();



            const shippingData = {

                first_name: $popup.find('#orlen-shipping-first-name-' + orderId).val(),

                last_name: $popup.find('#orlen-shipping-last-name-' + orderId).val(),

                address_1: $popup.find('#orlen-shipping-address-1-' + orderId).val(),

                address_2: $popup.find('#orlen-shipping-address-2-' + orderId).val(),

                city: $popup.find('#orlen-shipping-city-' + orderId).val(),

                postcode: $popup.find('#orlen-shipping-postcode-' + orderId).val(),

                phone: $popup.find('#orlen-shipping-phone-' + orderId).val(),

                email: $popup.find('#orlen-shipping-email-' + orderId).val(),

            };



            const data = {

                action: mode === 'edit' ? 'orlen_update_package' : 'orlen-add-package',

                _ajax_nonce: orlen_ajax.nonce,

                order_id: orderId,

                shipping_data: shippingData,

                package_id: packageId,

                size: $popup.find('#orlen-new-package-size-' + orderId).val(),

                label_format: $popup.find('#orlen-new-package-etykieta-' + orderId).val(),

                custom_comment: $popup.find('#orlen-custom-comment-' + orderId).val(),

            };



            $btn.prop('disabled', true).text('Zapisywanie...');



            jQuery.post(orlen_ajax.ajax_url, data, function(response) {

                $btn.prop('disabled', false).text('💾 Zapisz');

                if (response.success) {

                    alert(response.data || 'Zaktualizowano paczkę!');

                    location.reload();

                } else {

                    alert('❌ Błąd: ' + (response.data || 'Nie udało się zapisać'));

                }

            });

        });

        </script>







        <style>

        /* Nawigacja zakładek */

        .orlen-tabs-nav {

            list-style: none;

            padding: 0;

            margin: 0 0 0px 0;

            display: flex;

            border-bottom: 0px solid #e0e0e0;

            gap: 6px;

        }



        .orlen-tabs-nav li {

            margin: 0;

        }



        .orlen-tabs-nav a {

            display: block;

            padding: 10px 16px;

            background: #f5f7fa;

            border: 1px solid #ddd;

            border-bottom: none;

            margin-right: 0;

            text-decoration: none;

            color: #333;

            border-radius: 0px 0px 0 0;

            transition: all 0.2s ease-in-out;

            font-weight: 500;

        }



        .orlen-tabs-nav a:hover {

            background: #e9eff7;

            color: #000;

        }



        .orlen-tabs-nav a.active {

            background: #fff;

            font-weight: 600;

            border-color: #ddd;

            border-bottom: 2px solid #fff;

        }



        .orlen-tabs-content .tab-pane {

            display: none;

            border: 1px solid #ddd;

            padding: 18px;

            border-radius: 0 8px 8px 8px;

            background: #fff;

            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);

        }



        .orlen-tabs-content .tab-pane.active {

            display: block;

        }



        .package-row.recipient-header {

            font-weight: bold;

            margin-top: 8px;

        }



        .package-row.recipient-data {

            background: #f0f8ff;

            padding: 6px;

            border-radius: 4px;

            margin-bottom: 2px;

        }



        .package-row.pickup-data {

            background: #e6ffe6;

            padding: 6px;

            border-radius: 4px;

            margin-bottom: 2px;

            font-weight: 500;

        }

        </style>



        <?php



$order = $post->ID; 

$order_number = '#' . $order_id; 



$upload_dir = wp_upload_dir();

$log_file = $upload_dir['basedir'] . '/orlen-logs/orlen-logs.log';



echo '<div style="margin-top:20px; padding:15px; border:1px solid #ccd0d4; border-radius:6px; background:#f9f9f9;">';

echo '<h4 style="margin:0 0 10px; font-size:14px; font-weight:600; color:#23282d;">📦 Logi ORLEN Paczka</h4>';

echo '<hr style="margin:20px 0;">';



if (!file_exists($log_file)) {

    echo '<p><em>Brak pliku logów.</em></p>';

    echo '</div>';

    return;

}



$log_content = file_get_contents($log_file);



if (!$log_content) {

    echo '<p><em>Brak logów.</em></p>';

} else {

    $entries = explode("======================", $log_content);



    $entries = array_filter(array_map('trim', $entries));



    $filtered = array_filter($entries, function($entry) use ($order_number) {

        return strpos($entry, $order_number) !== false;

    });



    // Odwróć kolejność – najnowsze na górze

    //$filtered = array_reverse($filtered);



    $filtered = array_map(function($entry) {

        $entry = preg_replace('#<LabelData>.*?</LabelData>#si', '[...]', $entry);

        $entry = preg_replace_callback('#<ns1:PartnerKey\s*>(.*?)</ns1:PartnerKey>#si', function($matches) {

            $value = trim($matches[1]);

            return '<ns1:PartnerKey>' . str_repeat('*', strlen($value)) . '</ns1:PartnerKey>';

        }, $entry);

        return $entry;

    }, $filtered);



    if (empty($filtered)) {

        echo '<p><em>Brak logów dla tego zamówienia.</em></p>';

    } else {

        echo '<button type="button" class="button button-secondary" onclick="toggleOrlenLogs(this)">Pokaż logi</button>';



        echo '<div class="orlen-logs-container" style="display:none; margin-top:15px;">';

        echo '<textarea readonly style="width:100%; height:800px; font-family:monospace;">' .

            esc_textarea(implode("\n======================\n", $filtered)) .

            '</textarea>';

        echo '</div>';

    }

}



echo '</div>';

    ?>



        <script>

        function toggleOrlenLogs(button) {

            const container = button.nextElementSibling;

            if (container.style.display === "none") {

                container.style.display = "block";

                button.textContent = "Ukryj logi";

            } else {

                container.style.display = "none";

                button.textContent = "Pokaż logi";

            }

        }

        </script>



        <?php

}







// AJAX – generowanie etykiety dla pojedynczego zamówienia

add_action('wp_ajax_generate_orlen_label', 'op_generate_orlen_label_callback');

function op_generate_orlen_label_callback() {

    if (!current_user_can('manage_woocommerce')) {

        wp_send_json_error(['message' => 'Brak uprawnień.']);

    }



    $order_id     = intval($_POST['order_id'] ?? 0);

    $package_id   = sanitize_text_field($_POST['package_id'] ?? '');

    $label_format = sanitize_text_field($_POST['label_format'] ?? '');



    if (!$order_id || !$package_id) {

        wp_send_json_error(['message' => 'Brak danych do wygenerowania etykiety.']);

    }



    $order = wc_get_order($order_id);

    if (!$order) wp_send_json_error(['message' => 'Nie znaleziono zamówienia.']);



    //  Sprawdzenie czy zamówienie korzysta z ORLEN Paczka

    $has_orlen = false;

    foreach ($order->get_shipping_methods() as $method) {

        if (strpos($method->get_method_id(), 'orlen_paczka') !== false) {

            $has_orlen = true;

            break;

        }

    }

    if (!$has_orlen) {

        wp_send_json_error(['message' => 'Zamówienie nie korzysta z ORLEN Paczka.']);

    }



    //  Wyszukanie właściwej paczki

    $packages = get_post_meta($order_id, '_orlen_paczka_size', false);

    $target_package = null;

    foreach ($packages as $pkg_json) {

        $pkg = json_decode($pkg_json, true);

        if (!empty($pkg['id']) && (string)$pkg['id'] === (string)$package_id) {

            $target_package = $pkg;

            break;

        }

    }

    if (!$target_package) {

        wp_send_json_error(['message' => 'Nie znaleziono paczki o podanym ID.']);

    }



    //  Mapowanie formatu etykiety

    $map = [

        'PDF'   => 'PDF',

        'PDF10' => 'PDF10',

        'EPL'   => 'EPL',

        'ZPL'   => 'ZPL',

    ];



    if (!empty($label_format) && isset($map[$label_format])) {

        $format = $map[$label_format];

    } else {

        $format = $target_package['etykieta'] ?? 'PdfA4';

    }



    //  Główna logika generowania etykiety

    try {

        $res = Orlen_Label_Generator::generate_label_for_order(

            $order_id,

            $target_package['size'],

            $target_package,

            $format

        );



        if (empty($res) || !empty($res['error'])) {

            wp_send_json_error([

                'message'   => $res['errors'][0]['desc'] ?? 'Błąd generowania etykiety.',

                'errors'    => $res['errors'] ?? [],

                'label_url' => $res['label_url'] ?? '',

                'packcode'  => $res['packcode'] ?? '',

            ]);

        }



        $inactive_point = false;

        if (!empty($res['errors'])) {

            foreach ($res['errors'] as $err) {

                if (in_array($err['code'], ['006', '007', '008'])) {

                    $inactive_point = true;

                    break;

                }

            }

        }



        $packcode   = $res['packcode'] ?? '';

        $label_url  = $res['label_url'] ?? '';

        $errors     = $res['errors'] ?? [];



        // Wyciągnięcie kodu i opisu błędu (Err i ErrDes)

        $err_code = '';

        $err_desc = '';

        if (!empty($errors)) {

            $first_err = $errors[0];

            $err_code  = $first_err['code'] ?? '';

            $err_desc  = $first_err['desc'] ?? '';

        }



        //  Zaktualizowanie metadanych paczki

        foreach ($packages as $index => $pkg_json) {

            $pkg = json_decode($pkg_json, true);

            if ($pkg['id'] === $package_id) {

                $pkg['pack_code'] = $packcode;

                $pkg['label_url'] = $label_url;

                $packages[$index] = wp_json_encode($pkg, JSON_UNESCAPED_UNICODE);

                break;

            }

        }



        delete_post_meta($order_id, '_orlen_paczka_size');

        foreach ($packages as $pkg_json) {

            add_post_meta($order_id, '_orlen_paczka_size', $pkg_json);

        }



        //  Notatka w zamówieniu

        $order->add_order_note(

            '<span style="color:green; font-weight:bold;">📄 Etykieta ORLEN została wygenerowana dla paczki ' . esc_html($target_package['size']) . '.</span>',

            false

        );



   

        if (empty($label_url)) {

            wp_send_json_error(['message' => 'Nie udało się uzyskać adresu etykiety.']);

        }



        // Formatowany komunikat z Err / ErrDes obok numeru przesyłki

        $formatted  = '<div style="text-align:left; line-height:1.5;">';

        $formatted .= '<strong>Wynik generowania etykiety:</strong>';

        $formatted .= '<table style="width:100%; border-collapse:collapse; margin-top:5px;">';

        $formatted .= '<thead><tr style="border-bottom:1px solid #ccc;">

            <th style="padding:6px;">Zamówienie</th>

            <th style="padding:6px;">Nr przesyłki</th>

            <th style="padding:6px;">Odpowiedź API</th>

        </tr></thead><tbody>';

        $formatted .= '<tr style="border-bottom:1px solid #eee;">

            <td style="padding:6px;">#' . esc_html($order_id) . '</td>

            <td style="padding:6px;">' . esc_html($packcode ?: '-') . '</td>

            <td style="padding:6px;">(' . esc_html($err_code ?: '000') . ') ' . esc_html($err_desc ?: 'OK') . '</td>

        </tr>';

        $formatted .= '</tbody></table></div>';



        wp_send_json_success([

            'message'   => $formatted,

            'packcode'  => $packcode,

            'label_url' => $label_url,

            'errors'    => $errors,

        ]);



    } catch (Exception $e) {

        wp_send_json_error(['message' => '❌ Błąd: ' . $e->getMessage()]);

    }

}









class Orlen_Paczka_Admin_Pickup {



    private $token;



    public function __construct($token) {

        $this->token = $token;



        //add_action('woocommerce_process_shop_order_meta', [$this, 'save_pickup_point']);



        add_action('wp_ajax_orlen_save_pickup_point', [$this, 'ajax_save_pickup_point']);



    }





   public function display_admin_pickup_selector($order) {

    $has_orlen = false;

    foreach ($order->get_shipping_methods() as $method) {

        if (strpos($method->get_method_id(), 'orlen_paczka') !== false) {

            $has_orlen = true;

            break;

        }

    }



    if (!$has_orlen) {

        return; 

    }



 

     $pickup_code   = get_post_meta($order->get_id(), 'orlen_paczka_pickup_point', true);



    $meta = get_post_meta($order->get_id(), '_orlen_paczka_size', true);

    $pickup_full = '';



    if ($meta) {

        $data = json_decode($meta, true);



        if (is_array($data)) {

            $street   = $data['address_1'] ?? '';

            $postcode = $data['postcode'] ?? '';

            $city     = $data['city'] ?? '';



            if ($street && $postcode && $city) {

                $pickup_full = "{$street}, {$postcode} {$city}";

            } elseif ($street) {

                $pickup_full = $street;

            }



            $pickup_full = mb_convert_encoding($pickup_full, 'UTF-8', 'UTF-8');

        }

    }





    global $post;

    $order_id = $order->get_id();



    ?>

     <div class="order_orlen_paczka_meta" data-order-id="<?php echo esc_attr($order_id); ?>"

    style="margin-top:14px; padding:4px; border:0px solid #ddd;">

    <button type="button" class="orlen-widget button"

        data-target="#admin_orlen_paczka_pickup_point"

        data-label="#admin_orlen_paczka_pickup_point_name"

        data-modal="true"

        data-type="pickup"

        data-layout="tabs"

        style="width:100%;"

        data-address="<?php echo esc_attr($pickup_full); ?>">

        <?php _e('Wybierz inny punkt ORLEN Paczka', 'woocommerce'); ?>

    </button>



    <input type="hidden" id="admin_orlen_paczka_pickup_point" name="orlen_paczka_pickup_point_widget"

        value="<?php echo esc_attr($pickup_code); ?>" />

    <input type="hidden" id="admin_orlen_paczka_pickup_point_code" name="orlen_paczka_pickup_point_code"

        value="<?php echo esc_attr($pickup_code ?? ''); ?>" />

    <input type="hidden" id="admin_orlen_paczka_pickup_point_name" name="orlen_paczka_pickup_point_name"

        value="<?php echo esc_attr($pickup_name); ?>" />



    <p>

        <span id="admin_orlen_paczka_pickup_point_label">

            <?php echo !empty($pickup_name) ? esc_html($pickup_name) : ''; ?>

        </span>

    </p>

</div>



<script>

jQuery(function($) {

    //console.log('[ORLEN] Startuję nasłuch ORLEN PACZKA');



    function attachOrlenListener() {

        const widgets = document.querySelectorAll('.orlen-widget-modal');



        if (!widgets.length) {

            //console.log('[ORLEN] Widget jeszcze się nie załadował — retry za 500ms');

            return setTimeout(attachOrlenListener, 500);

        }



        //console.log('[ORLEN] Widget gotowy, podpinam nasłuch');



        widgets.forEach(function(widget) {

            // Usuwamy poprzedni nasłuch, żeby nie dublować

            widget.removeEventListener('orlenSelectPoint', onSelectPoint);

            widget.addEventListener('orlenSelectPoint', onSelectPoint);

        });

    }



    function onSelectPoint(e) {

        const point = e.detail?.marker?.options || {};

        if (!point.id) {

            //console.warn('[ORLEN] Nieprawidłowy punkt:', e.detail);

            return;

        }



        //console.log('[ORLEN] Wybrano punkt:', point);



        // Wypełnianie inputów

        $('#admin_orlen_paczka_pickup_point').val(point.destinationCode);

        $('#admin_orlen_paczka_pickup_point_code').val(point.destinationCode);

        $('#admin_orlen_paczka_pickup_point_name').val(

            `${point.physicalNamePsd || point.name || ''}, ${point.addressLine || ''}, ${point.postalCode || ''} ${point.city || ''} (${point.province || ''})`

        );



        // Ukryte pełne dane

        let hiddenFull = document.querySelector('#admin_orlen_paczka_pickup_point_full');

        if (!hiddenFull) {

            const wrapper = document.querySelector('.order_orlen_paczka_meta');

            hiddenFull = document.createElement('input');

            hiddenFull.type = 'hidden';

            hiddenFull.id = 'admin_orlen_paczka_pickup_point_full';

            hiddenFull.name = 'orlen_paczka_pickup_point_full';

            wrapper.appendChild(hiddenFull);

        }

        hiddenFull.value = JSON.stringify(point);



        // Wyświetlanie danych punktu

        const label = document.querySelector('#admin_orlen_paczka_pickup_point_label');

        if (label) {

            label.innerHTML = `

                <div style="line-height:1.6;">

                    <strong>Nazwa punktu:</strong> ${point.physicalNamePsd || point.name || '-'}<br>

                    <strong>Adres:</strong> ${point.addressLine || ''}, ${point.postalCode || ''} ${point.city || ''} (${point.province || ''})<br>

                    <strong>Lokalizacja:</strong> ${point.location || point.physicalLocationPsd || '-'}<br>

                    <strong>Godziny otwarcia:</strong> ${point.openingHours || '-'}<br>

                    <strong>Kod miejsca docelowego:</strong> ${point.destinationCode || '-'}<br>

                </div>

            `;

        }

    }



    // Start pierwszego sprawdzania

    attachOrlenListener();

});

</script>





<script>

(function() {

    (function(o, r, l, e, n) {

        o[l] = o[l] || [];

        var f = r.getElementsByTagName('head')[0];

        var j = r.createElement('script');

        j.async = true;

        j.src = e + 'widget.js?token=<?php echo esc_js($this->token); ?>&v=1.3.0&t=' + Math.floor(Date.now() / 1000);

        f.insertBefore(j, f.firstChild);

    })(window, document, 'orlenpaczka', 'https://mapa.orlenpaczka.pl/');

})();

</script>







        <?php

}







}