<?php



 if (!defined('ABSPATH')) exit;



class Orlen_Logger {



    protected static function get_log_file() {

        $upload_dir = wp_upload_dir();

        $log_dir = $upload_dir['basedir'] . '/orlen-logs';

        wp_mkdir_p($log_dir);

        return $log_dir . '/orlen-logs.log';

    }



    public static function log($message, $level = 'info') {

        $file = self::get_log_file();



        if (!is_writable(dirname($file))) {

            error_log('[ORLEN_Logger] Katalog logów nie jest zapisywalny: ' . dirname($file));

            return;

        }



        if (file_exists($file) && filesize($file) > 1024 * 1024) {

            rename($file, $file . '.bak');

            file_put_contents($file, "");

        }



        if (is_array($message) || is_object($message)) {

            $message = print_r($message, true);

        }



        if (strpos(trim($message), '<') === 0) {

            libxml_use_internal_errors(true);

            $dom = new DOMDocument('1.0', 'UTF-8');

            $dom->preserveWhiteSpace = false;

            $dom->formatOutput = true;



            if ($dom->loadXML($message)) {

                $message = $dom->saveXML();

            }

        }



        $timestamp = date('Y-m-d H:i:s');

        $entry = PHP_EOL . "======================" . PHP_EOL;

        $entry .= "[{$timestamp}] [" . strtoupper($level) . "]" . PHP_EOL;

        $entry .= $message . PHP_EOL;

        $entry .= "======================" . PHP_EOL;



        file_put_contents($file, $entry, FILE_APPEND);

    }



    public static function error($message)   { self::log($message, 'error'); }

    public static function warning($message) { self::log($message, 'warning'); }

    public static function info($message)    { self::log($message, 'info'); }

    public static function debug($message)   { self::log($message, 'debug'); }

}



