jQuery(document).ready(function($){

    $(document).on('click', '.generate-orlen-label', function(e){

        e.preventDefault();



        var $btn = $(this);

        var orderId = $btn.data('order-id');

        var packageId = $btn.data('package-id');



        $btn.prop('disabled', true).text('⏳ Generowanie...');



        $.post(ajaxurl, {

            action: 'generate_orlen_label',

            order_id: orderId,

            package_id: packageId,

            _ajax_nonce: '<?php echo wp_create_nonce("orlen_ajax_nonce"); ?>'

        }, function(response){

            $btn.prop('disabled', false).text('📬 Generuj nową etykietę');



            if(response.success && response.data.label_url){

                var labelUrl = response.data.label_url;

                var packCode = response.data.packcode;



                var $pane = $btn.closest('.tab-pane');

                var $existingLink = $pane.find('.download-label');

                var $existingPackCode = $pane.find('.pack-code');



                 if($existingPackCode.length){

                    $existingPackCode.text('Pack code: ' + packCode); 

                } else {

                    $btn.before('<p><strong class="pack-code">Pack code: ' + packCode + '</strong></p>');

                }



                if($existingLink.length){

                    $existingLink.attr('href', labelUrl); 

                } else {

                    // jeśli nie ma linku, dodaj nowy

                    $btn.before('<a href="' + labelUrl + '" target="_blank" class="button button-secondary download-label" style="margin-left:6px;">⬇ Pobierz etykietę</a><br><br>');

                }               

            } else {

                alert('Błąd generowania etykiety: ' + response.data.message);

            }

        });

    });

});















//////////////////////////////////////////////////////////////

// START Zbiorcze generowanie etykiet



jQuery(document).ready(function($) {



    $('#apply-bulk').on('click', function(e) {

        e.preventDefault();



        var action = $('#bulk-action').val();

        if (action !== 'zbiorcze-generowanie-labels') return;



        var selected = [];

        $('.row-select:checked').each(function() {

            selected.push($(this).val()); 

        });



        // if (selected.length === 0) {

        //     alert('Nie wybrano żadnych paczek.');

        //     return;

        // }



        // 🔹 Overlay + modal

        const $overlay = $('<div class="orlen-overlay"></div>').appendTo('body');

        const $modal = $('<div class="orlen-protocol-modal"></div>').appendTo('body');



        $overlay.css({

            position: 'fixed', top: 0, left: 0, width: '100%', height: '100%',

            background: 'rgba(0,0,0,0.5)', 'z-index': 9998

        });



        $modal.css({

            position: 'fixed', top: '50%', left: '50%', transform: 'translate(-50%, -50%)',

            background: '#fff', padding: '20px', 'z-index': 9999, border: '1px solid #ccc',

            'border-radius': '10px', 'text-align': 'center', width: '500px',

            'box-shadow': '0 4px 15px rgba(0,0,0,0.2)'

        });



        // 🔹 Od razu generuj etykiety bez wyboru formatu

        $modal.html('<p>Generuję etykiety… ⏳</p>');



        $.post(ajaxurl, {

            action: 'orlen_bulk_generate_labels',

            packages: selected,

            label_format: 'PDF' // domyślnie PDF

        }, function(response) {



            if (response.success) {



                const isInactivePoint = response.data.inactive_point === true;

                const hasErrors = response.data.errors && response.data.errors.length > 0;

                const message = response.data.message || 'Etykieta wygenerowana ✅';



                //  Lista etykiet

                let packCodeHtml = '';

                if (response.data.pack_codes && response.data.pack_codes.length > 0) {

                    packCodeHtml = '<ul style="text-align:left; list-style-type:none; padding:0;">' +

                        response.data.pack_codes.map((p, i) => {

                            // dopasowanie błędów do indeksu

                            const err = (response.data.errors && response.data.errors[i]) 

                                ? ` <br><small style="color:red;">Błąd: ${response.data.errors[i].code} – ${response.data.errors[i].desc}</small>`

                                : '';

                            return ``;

                        }).join('') +

                        '</ul>';

                }



                // Jeśli są błędy, pokaż też listę zbiorczą

                let errorSummary = '';

                if (hasErrors) {

                    errorSummary = `

                      

                    `;

                }



                //  Określenie koloru modala:

                const modalClass = isInactivePoint ? 'error' : 'success';



                // Modal

                $modal.html(`

                    <div class="orlen-modal ${modalClass}">

                        <p class="orlen-modal-text">${message}</p>

                        ${packCodeHtml}

                        ${errorSummary}

                        <div class="orlen-modal-buttons" style="margin-top:15px;">

                            <button id="print-label-now" class="orlen-modal-button primary">Drukuj</button>

                            <button id="close-modal" class="orlen-modal-button secondary">Zamknij</button>

                        </div>

                    </div>

                `);



                $('#print-label-now').on('click', function() {

                    if (response.data.label_url) {

                        const w = window.open(response.data.label_url, '_blank');

                        w?.focus();

                        w?.print();

                    } else {

                        alert('Nie znaleziono linku do etykiety.');

                    }

                });



                $('#close-modal').on('click', function() {

                    $modal.remove();

                    $overlay.remove();

                    location.reload();

                });

} else {

    const errorMessage = response.data?.message || 'Nieznany błąd';

    const errors = response.data?.errors || [];

    let errorSummary = '';

    if (errors.length > 0) {

        errorSummary = `

            <div style="margin-top:10px; text-align:left;">

                <b>Odpowiedź API:</b>

                <ul style="margin-top:5px; list-style-type:disc; padding-left:20px;">

                    ${errors.map(e => `<li><b>${e.code}</b>: ${e.desc}</li>`).join('')}

                </ul>

            </div>

        `;

    }







    //  if (errorMessage.includes('Brak paczek do generowania')) {

    //     alert(errorMessage);

    //     return;

    // }





    

    $modal.html(`

        <div class="orlen-modal error">

        <br>

            <p class="orlen-modal-text">${errorMessage}</p>

            ${errorSummary}

            <div class="orlen-modal-buttons" style="margin-top:15px;">

                <button id="close-modal" class="orlen-modal-button secondary">Zamknij</button>

            </div>

            <br>

        </div>

    `);



    $('#close-modal').on('click', function() {

        $modal.remove();

        $overlay.remove();

    });

}







        }).fail(function() {

            $modal.html(`

                <div class="orlen-modal">

                    <p class="orlen-modal-text">Błąd połączenia (AJAX).</p>

                    <div class="orlen-modal-buttons">

                        <button id="orlen-close3" class="orlen-modal-button secondary">Zamknij</button>

                    </div>

                </div>

            `);

            $(document).off('click', '#orlen-close3').on('click', '#orlen-close3', function() {

                $modal.remove();

                $overlay.remove();

            });

        });

    });

});







// Obsługa drukowania etykiety z historii

jQuery(document).on('click', '.print-label', function(e) {

    e.preventDefault();

    const url = jQuery(this).data('label-url');

    if (url) {

        window.open(url, '_blank');

    } else {

        alert('Brak adresu etykiety.');

    }

});









////// Generowanie pojedynczej etykiety Historia Nadań

jQuery(document).on('click', '.generate-label-history', function() {

    var btn = jQuery(this);

    var orderId = btn.data('order-id');

    var packageId = btn.data('package-id');



    btn.prop('disabled', true).text('⏳');



    const $overlay = jQuery('<div class="orlen-overlay"></div>').appendTo('body');

    const $modal = jQuery('<div class="orlen-modal"></div>').appendTo('body');



    $modal.html('<p>Generuję etykietę… ⏳</p>');



    jQuery.post(OrlenLabelAjax.ajax_url, {

        action: 'generate_orlen_label',

        order_id: orderId,

        package_id: packageId,

        label_format: 'PDF',

        _ajax_nonce: OrlenLabelAjax.nonce

    }, function(response) {



        const errors = response.data?.errors || [];

        let errorSummary = '';



        if (errors.length > 0) {

            errorSummary = '<div class="orlen-error-summary" style="margin-top:10px; text-align:left;">';

            errors.forEach(err => {

                const code = err.code || '000';

                const desc = err.desc || 'Nieznany błąd';

                errorSummary += `<p style="margin:4px 0;">(<strong>${code}</strong>) ${desc}</p>`;

            });

            errorSummary += '</div>';

        }



        // NIE POWIODŁO SIĘ

        if (!response || response.success === false || response.success === 'false') {

            let msg = response.data?.message || 'Nieznany błąd';

            if (errorSummary) msg += '<br>' + errorSummary;



            $modal.html(`

                <div class="orlen-modal ${response.data?.inactive_point ? '' : ''}">

                    <p class="orlen-modal-text">${msg}</p>

                    <div class="orlen-modal-buttons">

                        ${response.data?.label_url ? `<a href="${response.data.label_url}" target="_blank" class="orlen-modal-button primary">Drukuj</a>` : ''}

                        <button id="close-modal" class="orlen-modal-button secondary">Zamknij</button>

                    </div>

                </div>

            `);



            $modal.find('#close-modal').on('click', function() {

                $modal.remove();

                $overlay.remove();

                location.reload();

                btn.prop('disabled', false).text('⬇');

            });



            return;

        }



        // POWIODŁO SIĘ

        const packcode = response.data.packcode || '';

        const labelUrl = response.data.label_url || '';

        const msg = response.data.message || 'Etykieta wygenerowana ✅';



        btn.replaceWith(

            `<button class="button button-secondary print-label" data-label-url="${labelUrl}" style="font-size:16px;">🖨️</button>`

        );



        $modal.html(`

            <div class="orlen-modal success">

                <p class="orlen-modal-text">${msg}</p>

                <div class="orlen-modal-buttons">

                    ${labelUrl ? '<button id="print-label-now" class="orlen-modal-button primary">Drukuj</button>' : ''}

                    <button id="close-modal" class="orlen-modal-button secondary">Zamknij</button>

                </div>

            </div>

        `);



        $modal.find('#close-modal').on('click', function() {

            $modal.remove();

            $overlay.remove();

            location.reload();

        });



        $modal.find('#print-label-now').on('click', function() {

            if (labelUrl) window.open(labelUrl, '_blank');

        });



    }, 'json').fail(function() {

        alert('Błąd połączenia (AJAX).');

        btn.prop('disabled', false).text('⬇');

        $modal.remove();

        $overlay.remove();

    });

});







//Sprawdzanie dostępności i zamawianie kuriera

jQuery(document).ready(function($) {



    function loadPickupDates(postcode, orders) {

        $('#orlen-bulk-spinner').addClass('is-active');



        let orderIds = [];

        if (Array.isArray(orders)) {

            if (orders.length && typeof orders[0] === 'object') {

                orderIds = orders.map(o => parseInt(o.order_id || o, 10)).filter(Boolean);

            } else {

                orderIds = orders.map(o => parseInt(o, 10)).filter(Boolean);

            }

        }



        $.post(ajaxurl, {

            action: 'orlen_zamow_kuriera',

            orders: orderIds,

            postcode: postcode

        }, function(response) {

            $('#orlen-bulk-spinner').removeClass('is-active');



            if (!response.success) {

               let msg = (response.data && response.data.message) ? response.data.message : (response.data || 'Nieznany błąd');

                let sender = (response.data && response.data.sender) ? response.data.sender : {};



                let html = '<p style="color:red;">Błąd: ' + msg + '</p>';



                html += '<h3>Dane zamawiającego</h3>';

                html += '<div class="orlen-field"><label>Miejscowość:</label><input type="text" id="orlen-city" value="' + (sender.City || sender.city || '') + '" readonly></div>';

                html += '<div class="orlen-field"><label>Ulica:</label><input type="text" id="orlen-street" value="' + (sender.Street || sender.street || '') + '" readonly></div>';

                html += '<div class="orlen-field"><label>Numer budynku i lokal:</label><input type="text" id="orlen-building" value="' + (sender.BuildingNo || sender.building || '') + '" readonly></div>';

                html += '<div class="orlen-field"><label>Email:</label><input type="email" id="orlen-email" value="' + (sender.Email || sender.email || '') + '"></div>';

                html += '<div class="orlen-field"><label>Nazwa Nadawcy:</label><input type="text" id="orlen-partnername" value="' + (sender.PartnerName || sender.name || '') + '" readonly></div>';

                html += '<div class="orlen-field"><label>Imię:</label><input type="text" id="orlen-firstname" value="' + (sender.PersonName || sender.firstname || '') + '" readonly></div>';

                html += '<div class="orlen-field"><label>Nazwisko:</label><input type="text" id="orlen-lastname" value="' + (sender.PersonSurname || sender.lastname || '') + '" readonly></div>';

                html += '<div class="orlen-field"><label>Telefon:</label><input type="text" id="orlen-phone" value="' + (sender.Telephone || sender.phone || '') + '" readonly></div>';



                $('#orlen-popup-body').html(html);

                $('#orlen-popup').fadeIn();



                return;

            }



            let sender = response.data.sender || {};

            let html = '';



if (response.data.message) {

    html += '<p style="color:red;">' + response.data.message + '</p>';

} else {



   html += '<div class="orlen-field"><label>Kod pocztowy:</label>' +

        '<input type="text" id="orlen-postcode" ' +

        'value="' + (response.data.PostCode || sender.PostCode || postcode || '') + '" ' +

        'placeholder="00-010" ' +

        'pattern="\\d{2}-\\d{3}" ' +   

        'maxlength="6" ' +              

        'title="Kod pocztowy w formacie 00-000">' +

        '</div>';



    if (Array.isArray(response.data.data) && response.data.data.length > 0) {

        html += '<div class="orlen-field"><label>Data odbioru:</label><select id="orlen-pickup-date"></select></div>';

        html += '<div class="orlen-field"><label>Godzina odbioru:</label><select id="orlen-pickup-time"></select></div>';

     

        html += '<div id="orlen-info-message" style="display:none; color:red;">Prezentowane godziny nie są ostatecznymi, a jedynie sugerowanymi godzinami odbioru.</div>';

    } else {

        html += '<p>Kod pocztowy niedostępny, sprawdź wprowadzone dane.</p>';

    }



    html += '<h3>Dane zamawiającego</h3>';

    html += '<div class="orlen-field"><label>Miejscowość:</label><input type="text" id="orlen-city" value="' + (sender.City || '') + '" readonly></div>';

    html += '<div class="orlen-field"><label>Ulica:</label><input type="text" id="orlen-street" value="' + (sender.Street || '') + '" readonly></div>';

    html += '<div class="orlen-field"><label>Numer budynku i lokal:</label><input type="text" id="orlen-building" value="' + (sender.BuildingNo || '') + '" readonly></div>';

    html += '<div class="orlen-field"><label>Email:</label><input type="email" id="orlen-email" value="' + (sender.Email || '') + '" readonly></div>';

    html += '<div class="orlen-field"><label>Nazwa Nadawcy:</label><input type="text" id="orlen-partnername" value="' + (sender.PartnerName || '') + '" readonly></div>';

    html += '<div class="orlen-field"><label>Imię:</label><input type="text" id="orlen-firstname" value="' + (sender.PersonName || '') + '" readonly></div>';

    html += '<div class="orlen-field"><label>Nazwisko:</label><input type="text" id="orlen-lastname" value="' + (sender.PersonSurname || '') + '" readonly></div>';

    html += '<div class="orlen-field"><label>Telefon:</label><input type="text" id="orlen-phone" value="' + (sender.Telephone || '') + '" readonly></div>';

}



setTimeout(function() {

    const dateSelect = document.getElementById('orlen-pickup-date');

    const timeSelect = document.getElementById('orlen-pickup-time');

    const infoMessage = document.getElementById('orlen-info-message');



    function checkSelection() {

        if (dateSelect.value && timeSelect.value) {

            infoMessage.style.display = 'block';

        } else {

            infoMessage.style.display = 'none';

        }

    }



    if (dateSelect && timeSelect && infoMessage) {

        dateSelect.addEventListener('change', checkSelection);

        timeSelect.addEventListener('change', checkSelection);

    }

}, 100);



            $('#orlen-popup-body').html(html);

            $('#orlen-popup').fadeIn();



            if (!Array.isArray(response.data.data) || response.data.data.length === 0) {

                $('#orlen-popup-save').hide();

            } else {

                $('#orlen-popup-save').show();

           

            if (Array.isArray(response.data.data) && response.data.data.length > 0) {

                let $date = $('#orlen-pickup-date').empty();

                $date.append('<option value="">Wybierz datę</option>'); 



                response.data.data.forEach(function(d) {

                    $date.append('<option value="'+d.Date+'">'+d.Date+'</option>');

                });



                let $time = $('#orlen-pickup-time').empty();

                $time.append('<option value="">Wybierz godzinę</option>'); 



                $date.off('change').on('change', function() {

                    let selected = $(this).val();

                    let dayData = response.data.data.find(dd => dd.Date === selected);

                    let $time = $('#orlen-pickup-time').empty();

                    $time.append('<option value="">-- Wybierz godzinę --</option>'); 



                    if (dayData) {

                        let minHour = parseInt(dayData.MinReadyDate.substr(11,2), 10);

                        let maxHour = parseInt(dayData.MaxPickupDate.substr(11,2), 10);

                        let step = parseInt(dayData.MinimumInterval, 10) / 60;



                        let today = new Date();

                        if (today.toISOString().substr(0,10) === selected) {

                            let nowHour = today.getHours();

                            minHour = Math.max(minHour, Math.ceil((nowHour + step) / step) * step);

                        }



                        for (let h = minHour; h < maxHour; h += step) {

                            let endH = h + step;

                            $time.append('<option value="'+h+'-'+endH+'">'+h+':00 - '+endH+':00</option>');

                        }



                        if ($time.children().length === 1) { 

                            $time.append('<option disabled>Brak dostępnych terminów</option>');

                        }

                    }

                });

            }



        }







        }, 'json').fail(function(xhr, status, err){

            $('#orlen-bulk-spinner').removeClass('is-active');

            $('#orlen-popup-body').html('<p style="color:red;">Błąd sieci: ' + err + '</p>');

            $('#orlen-popup').fadeIn();

        });

    } 



    // klik na "Zamów kuriera" - zbieramy zaznaczone wiersze i wywołujemy

    $('#apply-bulk').on('click', function() {

    let action = $('#bulk-action').val();

    let selectedOrders = $('.row-select:checked').map(function() {

        let parts = $(this).val().split('|');

        return { 

            order_id: parts[0], 

            package_id: parts[1] || null, 

            pack_code: $(this).data('pack') || '' 

        };

    }).get();



    if (action === 'zamow-kuriera') {

        if (selectedOrders.length === 0) { 

            alert('Wybierz przynajmniej jedno zamówienie.'); 

            return; 

        }

        

        let missingPackOrders = selectedOrders.filter(o => !o.pack_code || o.pack_code === '-');



        if (missingPackOrders.length > 0) {

            $('#orlen-popup-body').html(

                '<p style="color:red;">Nie można zamówić kuriera. ' +

                'Następujące zamówienia nie mają wygenerowanej etykiety:<br>' +

                missingPackOrders.map(o => 'ID: ' + o.order_id).join('<br>') +

                '</p>'

            );

            $('#orlen-popup-save').hide(); 

            $('#orlen-popup').fadeIn();

            return;

        }



        // POKAŻ MAŁY POPUP Z LOADEREM

        $('body').append(`

          <div id="orlen-loader" style="

                position: fixed;

                top: 0;

                left: 0;

                width: 100%;

                height: 100%;

                background: rgba(0,0,0,0.5);

                z-index: 9998;

                display: flex;

                align-items: center;

                justify-content: center;

            ">

                <div style="

                    position: fixed;

                    top: 50%;

                    left: 50%;

                    transform: translate(-50%, -50%);

                    background: #fff;

                    padding: 30px;

                    border: 1px solid #ccc;

                    border-radius: 10px;

                    text-align: center;

                    width: 500px;

                    box-shadow: 0 4px 15px rgba(0,0,0,0.2);

                    z-index: 9999;

                    font-size: 15px;

                ">

                    ⏳ Proszę czekać... trwa pobieranie terminów odbioru

                </div>

            </div>



        `);



        // Uruchom API

        loadPickupDates('', selectedOrders);



        // Nasłuch — gdy pojawi się popup #orlen-popup, usuń loader

        let observer = new MutationObserver(function() {

            if ($('#orlen-popup').is(':visible')) {

                $('#orlen-loader').fadeOut(200, function() { $(this).remove(); });

                observer.disconnect();

            }

        });



        observer.observe(document.body, { childList: true, subtree: true });

    }

});





// Automatyczne pobieranie dostępnych terminów po wpisaniu kodu pocztowego

jQuery(document).on('input', '#orlen-postcode', function() {

    let postcode = jQuery(this).val().trim();



    // Sprawdzamy format kodu pocztowego 00-000

    if (!/^\d{2}-\d{3}$/.test(postcode)) return;



    // Pobieramy zaznaczone zamówienia

    let selectedOrders = jQuery('.row-select:checked').map(function() {

        let parts = jQuery(this).val().split('|');

        return { 

            order_id: parts[0], 

            package_id: parts[1] || null, 

            pack_code: jQuery(this).data('pack') || '' 

        };

    }).get();



    if (selectedOrders.length === 0) {

        alert('Wybierz przynajmniej jedno zamówienie.');

        return;

    }



    // Sprawdzamy, czy wszystkie przesyłki mają wygenerowane etykiety

    let missingPackOrders = selectedOrders.filter(o => !o.pack_code || o.pack_code === '-');

    if (missingPackOrders.length > 0) {

        jQuery('#orlen-popup-body').html(

            '<p style="color:red;">Nie można zamówić kuriera. ' +

            'Następujące zamówienia nie mają wygenerowanej etykiety:<br>' +

            missingPackOrders.map(o => 'ID: ' + o.order_id).join('<br>') +

            '</p>'

        );

        jQuery('#orlen-popup-save').hide(); 

        return;

    }



    // Wywołujemy AJAX do pobrania dostępnych dat i godzin

    loadPickupDates(postcode, selectedOrders);

});





    $('#orlen-popup-close').on('click', function(){ $('#orlen-popup').fadeOut(); });



    $('#orlen-popup-save').off('click').on('click', function(e){

    e.preventDefault();



    let selectedOrders = $('.row-select:checked').map(function(){

        let parts = $(this).val().split('|');

        return { order_id: parts[0], pack_code: $(this).data('pack') || '' };

    }).get();

    if (selectedOrders.length === 0) { alert('Wybierz przynajmniej jedno zamówienie3.'); return; }



    let postcode = $('#orlen-postcode').val().trim();

    let pickupDate = $('#orlen-pickup-date').val();

    let pickupTime = $('#orlen-pickup-time').val();

    let city = $('#orlen-city').val().trim();

    let street = $('#orlen-street').val().trim();

    let building = $('#orlen-building').val().trim();

    let email = $('#orlen-email').val().trim();

    let partnername = $('#orlen-partnername').val().trim();

    let firstname = $('#orlen-firstname').val().trim();

    let lastname = $('#orlen-lastname').val().trim();

    let phone = $('#orlen-phone').val().trim();



    if (!postcode || !pickupDate || !pickupTime || !city || !street || !building ||

        !email || !partnername || !firstname || !lastname || !phone) {

        alert('❌ Wypełnij wszystkie pola, włącznie z datą i godziną odbioru.');

        return;

    }



    let dataToSave = {

        action: 'orlen_zapisz_kuriera',

        orders: selectedOrders,

        postcode: postcode,

        pickup_date: pickupDate,

        pickup_time: pickupTime,

        city: city,

        street: street,

        building: building,

        email: email,

        partnername: partnername,

        firstname: firstname,

        lastname: lastname,

        phone: phone

    };



    $.post(ajaxurl, dataToSave, function(response){

        if (response.success) {

            alert('✅ Zamówiono poprawnie!');

            location.reload(); 

        } else {

            let msg = (typeof response.data === 'object' && response.data.message) ? response.data.message : JSON.stringify(response.data);

            alert('❌ Błąd zapisu: ' + msg);

        }

    }, 'json').fail(function(){ alert('Błąd połączenia AJAX.'); });

});

}); 







jQuery(document).ready(function($) {

    $('#apply-bulk').on('click', function() {

        let action = $('#bulk-action').val();

      let selectedOrders = $('.row-select:checked').map(function() {

    let parts = $(this).val().split('|');

    return {

        order_id: parts[0],

        package_id: parts[1] || null

    };

}).get();



        if (action === 'zamow-kuriera') {

          

            $('#orlen-bulk-spinner').addClass('is-active');



            $.post(ajaxurl, {

                action: 'orlen_zamow_kuriera',

                orders: selectedOrders

            }, function(response) {

                $('#orlen-bulk-spinner').removeClass('is-active');



                if (response.success) {

                    let html = '<ul>';

                    response.data.forEach(function(day) {

                        html += '<li><strong>' + day.Date + '</strong>: '

                             + day.MinReadyDate + ' - ' + day.MaxPickupDate

                             + ' (min. ' + day.MinimumInterval + ' min)</li>';

                    });

                    html += '</ul>';

                    $('#orlen-popup-body').html(html);

                    $('#orlen-popup').fadeIn();

                } else {

                    

                }

            });

        }

    });



    $('#orlen-popup-close').on('click', function() {

        $('#orlen-popup').fadeOut();

    });

});



/////////////////////////////////////////////////////////



























