const initOrlenWidget = () => {
  document.addEventListener('orlenWidgetInit', function() {
    const widgets = document.querySelectorAll('.orlen-widget-modal');
    const triggerWidgets = document.querySelectorAll('.orlen-widget');

    if (!widgets.length) {
      console.warn('No Orlen widgets found');
      return;
    }

    // Update point details in the UI
    const adjustCarrierExtraContentHeight = (carrierId) => {
      const pickupContainer = document.getElementById(`orlen-pickup-container-${carrierId}`);

      if (!pickupContainer) {
        return;
      }

      const extraContentWrapper = pickupContainer.closest('.js-carrier-extra-content');
      extraContentWrapper.style.maxHeight = 'none';
      extraContentWrapper.style.maxHeight = `${extraContent.scrollHeight}px`;
    };

    const updatePointDetails = (carrierId, pointData) => {
      console.log(carrierId);
      // Get elements
      const detailsContainer = document.getElementById(`orlen-point-details-${carrierId}`);
      const pointCodeEl = document.getElementById(`point-code-${carrierId}`);
      const pointNameEl = document.getElementById(`point-name-${carrierId}`);
      const pointAddressEl = document.getElementById(`point-address-${carrierId}`);
      const pointCityEl = document.getElementById(`point-city-${carrierId}`);
      const pointPostalCodeEl = document.getElementById(`point-postal-code-${carrierId}`);
      const pointProvinceEl = document.getElementById(`point-province-${carrierId}`);
      const selectedPointInput = document.getElementById(`selected-point-${carrierId}`);
      const idPointInput = document.getElementById(`id-point-${carrierId}`);

      // Update hidden inputs
      if (selectedPointInput) selectedPointInput.value = pointData.destinationCode || '';
      if (idPointInput) idPointInput.value = pointData.id || '';

      // Update visible fields
      if (pointCodeEl) pointCodeEl.textContent = pointData.destinationCode || '';
      if (pointNameEl) pointNameEl.textContent = pointData.physicalNamePsd || '';
      if (pointAddressEl) pointAddressEl.textContent = pointData.addressLine || '';
      if (pointCityEl) pointCityEl.textContent = pointData.city || '';
      if (pointPostalCodeEl) pointPostalCodeEl.textContent = pointData.postalCode || '';
      if (pointProvinceEl) pointProvinceEl.textContent = pointData.province || '';

      // Show details container
      if (detailsContainer) {
        detailsContainer.style.display = '';
      }

      // Update button text
      const btnEl = document.querySelector(`.orlen-widget[data-carrier-id="${carrierId}"]`);


      adjustCarrierExtraContentHeight(carrierId);
    };

    // Link trigger widgets with carrier IDs
    triggerWidgets.forEach(trigger => {
      const carrierId = trigger.getAttribute('data-carrier-id');
      if (carrierId) {
        trigger.setAttribute('data-target-carrier', carrierId);
      }
    });

    // Listen for point selection events
    widgets.forEach((widget) => {
      widget.addEventListener('orlenSelectPoint', (event) => {
        const pointData = event.detail.marker.options;
        console.log('Selected point data:', pointData);

        // Try to determine which carrier this selection is for
        const triggerWidget = document.querySelector('.orlen-widget[data-target-carrier]');
        const carrierId = triggerWidget ? triggerWidget.getAttribute('data-target-carrier') : null;
        //
        // // Update UI immediately to give user feedback
        // if (carrierId) {
        //   updatePointDetails(carrierId, pointData);
        // }

        // Send point data to server via AJAX
        $.ajax({
          url: saveSelectedPointUrl,
          method: 'POST',
          dataType: 'json',
          data: {
            id: pointData.id,
            name: pointData.physicalNamePsd,
            destinationCode: pointData.destinationCode,
            address: pointData.addressLine,
            city: pointData.city,
            postalCode: pointData.postalCode,
            province: pointData.province,
            latitude: pointData.latitude,
            longitude: pointData.longitude,
            carrierId: carrierId
          },
          success: function(response) {
            console.log('Point data sent successfully', response);
            console.log(response.carrierId);

            updatePointDetails(response.carrierId, pointData);
            // If server response contains carrier ID (in case it wasn't available earlier)

          },
          error: function(xhr, status, error) {
            console.error('Error sending point data:', error);
          }
        });
      });
    });
  });
};

initOrlenWidget();


// const initOrlenWidget = () => {
//   // Warsaw coordinates as fallback
//   const warsawCoordinates = {
//     latitude: 52.2297,
//     longitude: 21.0122
//   };
//
//   // Function to get user's geolocation
//   const getUserLocation = (widget) => {
//     if (navigator.geolocation) {
//       navigator.geolocation.getCurrentPosition(
//         // Success callback
//         (position) => {
//           const { latitude, longitude } = position.coords;
//           // Update data-address attribute with location information
//           widget.setAttribute('data-address', `${latitude},${longitude}`);
//           console.log('Geolocation successful:', latitude, longitude);
//         },
//         // Error callback
//         (error) => {
//           console.warn('Geolocation error:', error);
//           // Use Warsaw coordinates as fallback
//           widget.setAttribute('data-address', `${warsawCoordinates.latitude},${warsawCoordinates.longitude}`);
//         },
//         // Options
//         {
//           enableHighAccuracy: true,
//           timeout: 5000,
//           maximumAge: 0
//         }
//       );
//     } else {
//       console.warn('Geolocation not supported by this browser');
//       // Use Warsaw coordinates as fallback
//       widget.setAttribute('data-address', `${warsawCoordinates.latitude},${warsawCoordinates.longitude}`);
//     }
//   };
//
//   document.addEventListener('orlenWidgetInit', function() {
//     const widgets = document.querySelectorAll('.orlen-widget');
//     const widgetModals = document.querySelectorAll('.orlen-widget-modal');
//
//     if (!widgets.length) {
//       console.warn('No Orlen widgets found');
//       return;
//     }
//
//     // Request geolocation for each widget
//     widgets.forEach((widget) => {
//       getUserLocation(widget);
//     });
//
//     if (!widgetModals.length) {
//       console.warn('No Orlen widget modals found');
//       return;
//     }
//
//     widgetModals.forEach((widget) => {
//       widget.addEventListener('orlenSelectPoint', (event) => {
//         const pointData = event.detail.marker.options;
//         console.log(pointData);
//
//         // Get the AJAX URL from data attribute
//         // const ajaxUrl = widget.getAttribute('data-ajax-url') || '/modules/orlenpaczka/ajax.php';
//
//         // Send point data to server via AJAX
//         $.ajax({
//           url: saveSelectedPointUrl,
//           method: 'POST',
//           dataType: 'json',
//           data: {
//             id: pointData.id,
//             destinationCode: pointData.destinationCode
//           },
//           success: function(response) {
//             console.log('Point data sent successfully', response);
//             // Additional handling on success if needed
//           },
//           error: function(xhr, status, error) {
//             console.error('Error sending point data:', error);
//           }
//         });
//       });
//     });
//   });
// }
// initOrlenWidget();
