/**
 * Orlen Paczka Pickup Form
 * Main entry point for pickup form functionality
 */
import { hideAllErrors } from "./utils/form-utils.js";
import { initPickupForm } from "./components/pickup-form-component.js";

window.orlenpaczkaGrid = null;

document.addEventListener("DOMContentLoaded", () => {
  // Initialize the pickup form - this handles all the functionality
  initPickupForm();

  // Setup additional modal event handler for callPickupModal
  const callPickupModal = document.getElementById("callPickupModal");
  if (callPickupModal) {
    callPickupModal.addEventListener("show.bs.modal", () => {
      const form = callPickupModal.querySelector("form");
      if (form) {
        hideAllErrors(form);

        const dateSelect = form.querySelector("#orlen_pickup_pickup_date, [name=\"orlen_pickup[pickup_date]\"]");
        const hourSelect = form.querySelector("#orlen_pickup_pickup_hours, [name=\"orlen_pickup[pickup_hours]\"]");

        if (dateSelect) {
          dateSelect.disabled = true;
          dateSelect.innerHTML = "<option value=\"\">Wybierz datę</option>";
        }

        if (hourSelect) {
          hourSelect.disabled = true;
          hourSelect.innerHTML = "<option value=\"\">Wybierz godzinę</option>";
        }
      }
    });
  }
});