$(document).ready(function() {
  // Zmienna do przechowywania timera dla automatycznego ukrywania komunikatów
  var messageTimer = null;
  
  // Funkcja do wyświetlania komunikatów
  function displayMessage(success, message) {
    var container = $('#ajax-response-container');
    var messageElement = $('#ajax-response-message');
    
    // Ustaw klasę stylową w zależności od sukcesu lub błędu
    if (success) {
      container.removeClass('d-none alert-danger').addClass('alert alert-success');
    } else {
      container.removeClass('d-none alert-success').addClass('alert alert-danger');
    }
    
    // Ustaw treść komunikatu
    messageElement.html(message);
    
    // Przewiń do komunikatu (opcjonalnie)
    $('html, body').animate({
      scrollTop: container.offset().top - 100
    }, 200);
    
    // Wyczyść poprzedni timer, jeśli istnieje
    if (messageTimer) {
      clearTimeout(messageTimer);
    }
    
    // Ustaw nowy timer na 5 sekund (5000 ms)
    messageTimer = setTimeout(function() {
      hideMessage();
    }, 5000);
  }
  
  // Funkcja do ukrywania komunikatu
  function hideMessage() {
    $('#ajax-response-container').addClass('d-none').removeClass('alert alert-success alert-danger');
    $('#ajax-response-message').html('');
  }
  
  // Obsługa przycisku Ping
  $('#ping').click(function(e) {
    e.preventDefault();

    // Pobierz URL z atrybutu data-url
    var pingUrl = $(this).attr('data-url');

    // Wykonaj żądanie Ajax dla Ping
    $.ajax({
      url: pingUrl,
      type: 'POST',
      dataType: 'json',
      success: function(response) {
        // Wyświetl komunikat w kontenerze HTML
        if (response.success) {
          displayMessage(true, response.message || '');
        } else {
          displayMessage(false, response.error || '');
        }
      },
      error: function(xhr, status, error) {
        displayMessage(false, error);
      }
    });
  });

  // Obsługa przycisku Test Credentials
  $('#test-connection').click(function(e) {
    e.preventDefault();

    // Pobierz URL z atrybutu data-url
    var testUrl = $(this).attr('data-url');

    // Pobierz wartości potrzebne do testu połączenia
    var sandboxMode = $('input[name="authorization[sandbox]"]:checked').val();
    var partnerId = $('#authorization_partner_id').val();
    var partnerKey = $('#authorization_partner_key').val();

    // Wykonaj żądanie Ajax dla Test Credentials
    $.ajax({
      url: testUrl,
      type: 'POST',
      data: {
        sandbox: sandboxMode,
        partnerId: partnerId,
        partnerKey: partnerKey
      },
      dataType: 'json',
      success: function(response) {
        // Wyświetl komunikat w kontenerze HTML
        if (response.success) {
          displayMessage(true, response.message || '');
        } else {
          displayMessage(false, response.error || '');
        }
      },
      error: function(xhr, status, error) {
        displayMessage(false, error);
      }
    });
  });

  // Obsługa zmiany stanu przełącznika Sandbox
  $('#authorization_sandbox_0, #authorization_sandbox_1').change(function() {
    // Pobierz wartość zaznaczonego przełącznika
    var sandboxMode = $('input[name="authorization[sandbox]"]:checked').val();
    var partnerId = $('#authorization_partner_id').val();
    var partnerKey = $('#authorization_partner_key').val();
    var token = $('#authorization__token').val();

    // Ukryj poprzedni komunikat
    hideMessage();

    // Pobierz URL z atrybutu data-url
    var ajaxUrl = $('#authorization_sandbox_0').attr('data-url');

    // Wykonaj żądanie Ajax
    $.ajax({
      url: ajaxUrl, // URL z atrybutu data-url
      type: 'POST',
      data: {
        action: 'updateSandboxMode',
        sandbox: sandboxMode,
        partnerId: partnerId,
        partnerKey: partnerKey,
        token: token
      },
      dataType: 'json',

      success: function(response) {

        // Obsłuż odpowiedź z serwera - bez wyświetlania komunikatów
        if (response.success) {
          // Aktualizuj pola formularza danymi z odpowiedzi
          if (response.partner_id !== undefined) {
            $('#authorization_partner_id').val(response.partner_id);
          }

          if (response.partner_key !== undefined) {
            $('#authorization_partner_key').val(response.partner_key);
          }
          // Nie wyświetlamy komunikatów dla przycisków sandbox
        } else {
          // Nie wyświetlamy komunikatów o błędach dla sandbox
        }
      },
      error: function(xhr, status, error) {
        // Nie wyświetlamy komunikatów o błędach dla sandbox
      }
    });
  });
});
