const initOrlenWidget = () => {
  document.addEventListener('orlenWidgetInit', function() {
    const widgets = document.querySelectorAll('.orlen-widget-modal');
    const triggerWidgets = document.querySelectorAll('.orlen-widget');
    // Przechowujemy informację o aktywnym przycisku/paczce
    let activePackageIndex = 1;

    if (!widgets.length) {
      console.warn('No Orlen widgets found');
      return;
    }

    // Obsługa kliknięcia przycisku zmiany punktu - zapamiętujemy indeks paczki
    triggerWidgets.forEach((triggerBtn) => {
      triggerBtn.addEventListener('click', function() {
        activePackageIndex = this.getAttribute('data-package-index') || 1;

        // Przełącz widoczność ostrzeżeń przy kliknięciu przycisku
        const allWarnings = document.querySelectorAll('[id^="pickup-warning-"]');
        allWarnings.forEach(warning => {
          warning.classList.add('d-none');
        });

        const selectedWarning = document.getElementById(`pickup-warning-${activePackageIndex}`);
        if (selectedWarning) {
          selectedWarning.classList.remove('d-none');
        }
      });
    });

    // Obsługa przycisków zmiany paczki (zakładek)
    const packageTabs = document.querySelectorAll('.package-tab');
    packageTabs.forEach((tab) => {
      tab.addEventListener('click', function() {
        const packageIndex = this.getAttribute('data-package-index') || 1;
        activePackageIndex = packageIndex;

        // Przełącz tylko widoczność szczegółów paczek
        const allPackageDetails = document.querySelectorAll('[id^="package-details-"]');
        allPackageDetails.forEach(detail => {
          detail.style.display = 'none';
        });

        // Pokaż szczegóły dla wybranej paczki
        const selectedPackageDetails = document.getElementById(`package-details-${packageIndex}`);
        if (selectedPackageDetails) {
          selectedPackageDetails.style.display = 'block';
        }

        // Przełącz widoczność akcji etykiet
        const allLabelActions = document.querySelectorAll('[id^="label-actions-"]');
        allLabelActions.forEach(action => {
          action.style.display = 'none';
        });

        // Pokaż akcje etykiet dla wybranej paczki
        const selectedLabelActions = document.getElementById(`label-actions-${packageIndex}`);
        if (selectedLabelActions) {
          selectedLabelActions.style.display = 'block';
        }

        // Przełącz widoczność informacji o protokole
        const allProtocolInfo = document.querySelectorAll('[id^="protocol-info-"]');
        allProtocolInfo.forEach(info => {
          info.style.display = 'none';
        });

        // Pokaż informacje o protokole dla wybranej paczki
        const selectedProtocolInfo = document.getElementById(`protocol-info-${packageIndex}`);
        if (selectedProtocolInfo) {
          selectedProtocolInfo.style.display = 'block';
        }

        // Przełącz widoczność ostrzeżeń
        const allWarnings = document.querySelectorAll('[id^="pickup-warning-"]');
        allWarnings.forEach(warning => {
          warning.classList.add('d-none');
        });

        // Pokaż ostrzeżenie dla wybranej paczki (jeśli istnieje i jest widoczne)
        const selectedWarning = document.getElementById(`pickup-warning-${packageIndex}`);
        if (selectedWarning) {
          selectedWarning.classList.remove('d-none');
        }

        // Przełącz widoczność przycisków "Zmień punkt odbioru"
        const allChangePickupButtons = document.querySelectorAll('.change-pickup-button');
        allChangePickupButtons.forEach(btn => {
          btn.classList.add('d-none');
        });

        // Pokaż przycisk dla wybranej paczki
        const selectedChangePickupButton = document.querySelector(`.change-pickup-button[data-package-index="${packageIndex}"]`);
        if (selectedChangePickupButton) {
          selectedChangePickupButton.classList.remove('d-none');
        }

        // Przełącz tylko style przycisków zakładek
        packageTabs.forEach(tabBtn => {
          tabBtn.classList.remove('btn-primary');
          tabBtn.classList.add('btn-outline-primary');
        });

        // Ustaw aktywny styl dla klikniętej zakładki
        this.classList.remove('btn-outline-primary');
        this.classList.add('btn-primary');
      });
    });

    const updatePointDetailsTable = (pointData, packageIndex) => {
      // Aktualizujemy tylko wybraną paczkę, a nie wszystkie
      const packageDetail = document.getElementById(`package-details-${packageIndex}`);

      if (!packageDetail) {
        console.error(`Nie znaleziono szczegółów paczki ${packageIndex}`);
        return;
      }

      // Znajdź wiersze tabeli dla wybranej paczki
      const tableRows = packageDetail.querySelectorAll('.table-striped tbody tr');

      tableRows.forEach(row => {
        const dataField = row.getAttribute('data-field');
        const dataCell = row.querySelector('td');

        // Używamy atrybutu data-field zamiast indeksu
        switch(dataField) {
          case 'pickup-point':
            // Używamy id jako nazwy punktu, bo pointData.name nie istnieje
            dataCell.textContent = pointData.id || '';
            break;
          case 'destination-code':
            dataCell.textContent = pointData.destinationCode || '';
            break;
          case 'point-address':
            dataCell.textContent = pointData.addressLine || '';
            break;
          case 'city':
            dataCell.textContent = pointData.city || '';
            break;
          case 'postal-code':
            dataCell.textContent = pointData.postalCode || '';
            break;
        }
      });

      // Aktualizujemy ukryte inputy tylko dla wybranej paczki
      const selectedPointInput = document.getElementById(`selected-point-${packageIndex}`);
      const idPointInput = document.getElementById(`id-point-${packageIndex}`);
      const packageIdInput = document.getElementById(`package-id-${packageIndex}`);

      if (selectedPointInput) selectedPointInput.value = pointData.destinationCode || '';
      // if (idPointInput) idPointInput.value = pointData.id || '';

      // Pobierz ID paczki i zaktualizuj formularz dla tej konkretnej paczki
      if (packageIdInput) {
        const formId = packageIdInput.value;
        const modal = document.getElementById(`generateLabelModal-${formId}`);
        
        if (modal) {
          const destinationCodeInput = modal.querySelector('.js_destination-code');
          if (destinationCodeInput) {
            destinationCodeInput.value = pointData.destinationCode || '';
          }
        }
      }

    };

    // Listen for point selection events
    widgets.forEach((widget) => {
      widget.addEventListener('orlenSelectPoint', (event) => {
        const pointData = event.detail.marker.options;
        console.log('pointData structure:', pointData);

        // Używamy zapamiętanego indeksu paczki

        // Pobierz id punktu dla konkretnej paczki
        const currentIdPoint = document.getElementById(`id-point-${activePackageIndex}`).value;
        // Pobierz id paczki (package ID) dla konkretnej paczki
        const packageId = document.getElementById(`package-id-${activePackageIndex}`).value;

        $.ajax({
          url: saveSelectedPointUrl,
          method: 'POST',
          dataType: 'json',
          data: {
            id_point: currentIdPoint, // Wysyłamy wartość z ukrytego pola
            package_id: packageId,    // ID paczki (formId)
            id: pointData.id,       // Wartość id z pointData
            destinationCode: pointData.destinationCode,
            address: pointData.addressLine,
            city: pointData.city,
            postalCode: pointData.postalCode,
            province: pointData.province,
            latitude: pointData.latitude,
            longitude: pointData.longitude,
            name: pointData.physicalNamePsd
          },
          success: function(response) {
            // Aktualizujemy tabelkę tylko gdy serwer zwrócił sukces
            if (response.success) {
              // Przekazujemy zapamiętany indeks paczki do funkcji aktualizującej
              updatePointDetailsTable(pointData, activePackageIndex);

              // Obsługa ostrzeżenia - pokazuj/ukryj alert
              const warningAlert = document.getElementById(`pickup-warning-${activePackageIndex}`);
              if (warningAlert) {
                if (response.warning && response.warning !== false) {
                  // Pokazujemy ostrzeżenie z komunikatem - dodajemy "Uwaga:" przed tekstem
                  warningAlert.querySelector('.warning-message').innerHTML = '<strong>Uwaga:</strong> ' + response.warning;
                  warningAlert.style.display = 'block';
                } else {
                  // Ukrywamy ostrzeżenie
                  warningAlert.style.display = 'none';
                }
              }

              // Wyświetl powiadomienie PrestaShop
              if (typeof $.growl !== 'undefined') {
                $.growl.notice({ title: '', message: response.message });
              }
            } else {
              if (typeof $.growl !== 'undefined') {
                $.growl.error({ title: '', message: response.error });
              }
            }
          },
          error: function(xhr, status, error) {
            console.error('Error sending point data:', error);
            if (typeof $.growl !== 'undefined') {
              $.growl.error({ title: '', message: 'Wystąpił błąd podczas aktualizacji punktu odbioru' });
            }
          }
        });
      });
    });
  });
};

initOrlenWidget();
