<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Soap\ExtSoapEngine\Metadata;

use Orlen\OrlenPaczka\Soap\Engine\Metadata\Collection\PropertyCollection;
use Orlen\OrlenPaczka\Soap\Engine\Metadata\Collection\TypeCollection;
use Orlen\OrlenPaczka\Soap\Engine\Metadata\Collection\XsdTypeCollection;
use Orlen\OrlenPaczka\Soap\Engine\Metadata\Model\Property;
use Orlen\OrlenPaczka\Soap\Engine\Metadata\Model\Type;
use Orlen\OrlenPaczka\Soap\Engine\Metadata\Model\XsdType;

final class TypesParser
{
    /**
     * @var XsdTypeCollection
     */
    private $xsdTypes;

    public function __construct(XsdTypeCollection $xsdTypes)
    {
        $this->xsdTypes = $xsdTypes;
    }

    public function parse(\SoapClient $client): TypeCollection
    {
        $collected = [];
        $soapTypes = (array) $client->__getTypes();
        foreach ($soapTypes as $soapType) {
            $properties = [];
            $lines = explode("\n", $soapType);
            if (!preg_match('/struct (?P<typeName>.*) {/', $lines[0], $matches)) {
                continue;
            }
            $xsdType = XsdType::create($matches['typeName']);

            foreach (array_slice($lines, 1) as $line) {
                if ('}' === $line) {
                    continue;
                }
                preg_match('/\s* (?P<propertyType>.*) (?P<propertyName>.*);/', $line, $matches);
                $properties[] = new Property(
                    $matches['propertyName'],
                    $this->xsdTypes->getByNameWithFallback($matches['propertyType'])
                );
            }

            $collected[] = new Type($xsdType, new PropertyCollection(...$properties));
        }

        return new TypeCollection(...$collected);
    }
}
