<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Soap\ExtSoapEngine;

use Orlen\OrlenPaczka\Soap\Engine\Engine;
use Orlen\OrlenPaczka\Soap\Engine\TransportInterface;
use Orlen\OrlenPaczka\Soap\ExtSoapEngine\Transport\ExtSoapClientTransport;

final class ExtSoapEngineFactory
{
    public static function fromOptions(ExtSoapOptions $options): Engine
    {
        $driver = ExtSoapDriver::createFromOptions($options);
        $handler = new ExtSoapClientTransport($driver->getClient());

        return new Engine($driver, $handler);
    }

    public static function fromOptionsWithTransport(ExtSoapOptions $options, TransportInterface $transport): Engine
    {
        $driver = ExtSoapDriver::createFromOptions($options);

        return new Engine($driver, $transport);
    }
}
