<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Soap\Client\Soap;

use Orlen\OrlenPaczka\Soap\Client\Soap\Metadata\MetadataFactory;
use Orlen\OrlenPaczka\Soap\Engine\Engine;
use Orlen\OrlenPaczka\Soap\Engine\EngineInterface;
use Orlen\OrlenPaczka\Soap\Engine\LazyEngine;
use Orlen\OrlenPaczka\Soap\Engine\TransportInterface;
use Orlen\OrlenPaczka\Soap\ExtSoapEngine\AbusedClient;
use Orlen\OrlenPaczka\Soap\ExtSoapEngine\ExtSoapDriver;
use Orlen\OrlenPaczka\Soap\ExtSoapEngine\ExtSoapMetadata;
use Orlen\OrlenPaczka\Soap\ExtSoapEngine\ExtSoapOptions;
use Orlen\OrlenPaczka\Soap\ExtSoapEngine\Transport\ExtSoapClientTransport;

final class DefaultEngineFactory
{
    public static function create(ExtSoapOptions $options, ?TransportInterface $transport = null): EngineInterface
    {
        return new LazyEngine(static function () use ($options, $transport) {
            $client = AbusedClient::createFromOptions($options);
            $transport = $transport ?? new ExtSoapClientTransport($client);
            $driver = ExtSoapDriver::createFromClient(
                $client,
                MetadataFactory::lazy(new ExtSoapMetadata($client))
            );

            return new Engine($driver, $transport);
        });
    }
}
