<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Soap\Client\Exception;

class SoapFault extends SoapException
{
    private $faultCode;
    private $faultActor;
    private $detail;

    /**
     * @param mixed $detail
     */
    public function __construct(string $faultString, ?string $faultCode = null, ?string $faultActor = null, $detail = null, ?\Throwable $previous = null)
    {
        parent::__construct($faultString, 0, $previous);

        $this->faultCode = $faultCode;
        $this->faultActor = $faultActor;
        $this->detail = $detail;
    }

    public static function fromNative(\SoapFault $fault): self
    {
        return new self($fault->faultstring, $fault->faultcode, $fault->faultactor, $fault->detail, $fault);
    }

    public function getFaultCode(): ?string
    {
        return $this->faultCode;
    }

    public function getFaultActor(): ?string
    {
        return $this->faultActor;
    }

    /**
     * @return mixed
     */
    public function getDetail()
    {
        return $this->detail;
    }
}
