<?php

namespace Orlen\OrlenPaczka\Repository;

use Orlen\OrlenPaczka\Entity\ShipmentType;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\OptimisticLockException;
use Doctrine\ORM\ORMException;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<ShipmentType>
 *
 * @method ShipmentType|null find($id, $lockMode = null, $lockVersion = null)
 * @method ShipmentType|null findOneBy(array $criteria, array $orderBy = null)
 * @method ShipmentType[]    findAll()
 * @method ShipmentType[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ShipmentTypeRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ShipmentType::class);
    }

    /**
     * @throws ORMException
     * @throws OptimisticLockException
     */
    public function add(ShipmentType $entity, bool $flush = true): void
    {
        $this->_em->persist($entity);
        if ($flush) {
            $this->_em->flush();
        }
    }

    /**
     * @throws ORMException
     * @throws OptimisticLockException
     */
    public function remove(ShipmentType $entity, bool $flush = true): void
    {
        $this->_em->remove($entity);
        if ($flush) {
            $this->_em->flush();
        }
    }

    public function getAllGrid()
    {
        $entities = $this->findAll();
        $data = [];
        foreach ($entities as $entity) {
            $data[$entity->getSize()] = $entity->getId();
        }
        return $data;

    }

    // /**
    //  * @return ShipmentType[] Returns an array of ShipmentType objects
    //  */
    /*
    public function findByExampleField($value)
    {
        return $this->createQueryBuilder('s')
            ->andWhere('s.exampleField = :val')
            ->setParameter('val', $value)
            ->orderBy('s.id', 'ASC')
            ->setMaxResults(10)
            ->getQuery()
            ->getResult()
        ;
    }
    */

    /*
    public function findOneBySomeField($value): ?ShipmentType
    {
        return $this->createQueryBuilder('s')
            ->andWhere('s.exampleField = :val')
            ->setParameter('val', $value)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
    */
}
