<?php

namespace Orlen\OrlenPaczka\Protocol\Voter;

use Orlen\OrlenPaczka\Voter\Interfaces\VoterInterface;

class CanGenerateProtocolVoter implements VoterInterface
{
    const PACKAGES_HAS_NOT_PROTOCOL = 'PACKAGES_HAS_PROTOCOL';
    const PACKAGES_HAS_LABEL  = 'PACKAGES_HAS_LABEL';
    public function supports(string $type, $params): ?string
    {
        switch ($type) {
            case self::PACKAGES_HAS_NOT_PROTOCOL:
                return (is_array($params))?
                    'votePackagesHasNotProtocol':
                    null;
            case self::PACKAGES_HAS_LABEL:
                return (is_array($params))?
                    'votePackagesHasLabel':
                    null;
            default:
                return null;
        }
    }

    /* @var \Orlen\OrlenPaczka\Entity\Package[] $packages */
    public function votePackagesHasNotProtocol(array $packages)
    {
        foreach ($packages as $package) {
            if ($package->getProtocol() !== null) {
                return false;
            }
        }
        return true;
    }
    /* @var \Orlen\OrlenPaczka\Entity\Package[] $packages */
    public function votePackagesHasLabel(array $packages)
    {
        foreach ($packages as $package) {
            if ($package->getLabelName() === null || empty($package->getLabelName())) {
                return false;
            }
        }
        return true;
    }
}
