<?php

namespace Orlen\OrlenPaczka\Protocol\Settings;

use Symfony\Component\OptionsResolver\OptionsResolver;

class GenerateProtocolSettings
{
    private OptionsResolver $resolver;
    private array $settings;

    public function __construct()
    {
        $this->resolver = new OptionsResolver();
    }

    public function setSettings($settings)
    {
        $this->settings = $this->_configureOptions($settings);
    }

    public function getSettings()
    {
        return $this->settings;
    }

    private function _configureOptions($settings)
    {
        $this->resolver->setDefault('provider', []);
        $this->resolver->setDefault('package_order', []);
        // Pozwalamy na dowolne klucze w tablicy provider
        $this->resolver->setAllowedTypes('provider', 'array');
        $this->resolver->setAllowedTypes('package_order', 'array');

        return $this->resolver->resolve($settings);
    }
}
