<?php

namespace Orlen\OrlenPaczka\Logger\Handler;

use Monolog\Handler\AbstractProcessingHandler;
use Monolog\Logger;
use Orlen\OrlenPaczka\Entity\Log;
use Orlen\OrlenPaczka\Repository\LogRepository;

/**
 * Handler for Monolog that uses Doctrine to store log messages
 */
class DoctrineHandler extends AbstractProcessingHandler
{
    /**
     * @var LogRepository
     */
    private $logRepository;

    /**
     * @param LogRepository $logRepository
     * @param int $level The minimum logging level at which this handler will be triggered
     * @param bool $bubble Whether the messages that are handled can bubble up the stack or not
     */
    public function __construct(LogRepository $logRepository, $level = Logger::DEBUG, bool $bubble = true)
    {
        parent::__construct($level, $bubble);
        $this->logRepository = $logRepository;
    }

    /**
     * Writes the record down to the log of the implementing handler
     */
    protected function write(array $record): void
    {
        // Tworzymy nowy obiekt Log
        $logEntity = new Log();
        $logEntity->setDate(new \DateTime());
        $logEntity->setType($record['level_name']);
        $logEntity->setMessage($record['message']);
        $logEntity->setContext(json_encode($record['context']));

        // Zapisujemy do bazy danych
        try {
            $this->logRepository->add($logEntity);
        } catch (\Exception $e) {
            // W przypadku błędu zapisu do bazy, logujemy do pliku error.log
            error_log('Nie można zapisać logu do bazy danych: ' . $e->getMessage());
        }
    }
}
