<?php

namespace Orlen\OrlenPaczka\Label\Translator;

use Orlen\OrlenPaczka\Translator\Adapter\Translator;

class TranslateResult
{
    private Translator $translator;
    private  $translatedResult = [];

    public function __construct(Translator $translator)
    {

        $this->translator = $translator;
    }
    public function translateResult(array $result)
    {
        $this->translatedResult = [];
        foreach ($result as $status => $row) {
            foreach ($row as $item) {
                $this->_translateResult($status, $item);
            }

        }
        return $this->translatedResult;
    }

    public function translateResultOrder(array $result)
    {
        $this->translatedResult = [];
        foreach ($result as $status => $row) {
            foreach ($row as $item) {
                $this->_translateResultOrder($status, $item);
            }

        }
        return $this->translatedResult;
    }

    public function getSuccess()
    {
        return $this->translatedResult['success']?? [];
    }

    public function getErrors()
    {
        return $this->translatedResult['error']?? [];
    }

    public function hasErrors()
    {
        if (isset($this->translatedResult['error'])){
            return count($this->translatedResult['error']);
        }
        return 0;
    }

    public function hasWarnings()
    {
        if (isset($this->translatedResult['warning'])){
            return count($this->translatedResult['warning']);
        }
        return 0;
    }

    public function getWarnings()
    {
        return $this->translatedResult['warning']?? [];
    }

    private function _translateResult($status, $row)
    {
        switch ($status) {
            case '000':
                $this->translatedResult['success'][] = $this->translator->trans('Label genereted for id %id%', ['%id%' => $row['id']], 'Modules.Orlenpaczka.Label');
                break;
            case '006':
                $this->translatedResult['warning'][] = $this->translator->trans('Label genereted for id %id%. changed DestinationCode', ['%id%' => $row['id']], 'Modules.Orlenpaczka.Label');
                break;
            case '007':
                $this->translatedResult['warning'][] = $this->translator->trans('Label genereted for id %id%. changed ReturnDestinationCode', ['%id%' => $row['id']], 'Modules.Orlenpaczka.Label');
                break;
            case '008':
                $this->translatedResult['warning'][] = $this->translator->trans('Label genereted for id %id%. changed DestinationCode and ReturnDestinationCode', ['%id%' => $row['id']], 'Modules.Orlenpaczka.Label');
                break;
            case '206':
                $this->translatedResult['error'][] = $this->translator->trans('Error generate label for id %id%. Selected point is inactive. Please select other point', ['%id%' => $row['id']], 'Modules.Orlenpaczka.Label');
                $this->translatedResult['error'][] = 'unknown destinationcode';
                break;
            default:
                $this->translatedResult['error'][] = $this->translator->trans('Error generate label for id %id%.', ['%id%' => $row['id']], 'Modules.Orlenpaczka.Label');
                $this->translatedResult['error'][] = $row['description'];
                break;
        }
    }

    private function _translateResultOrder($status, $row)
    {
        switch ($status) {
            case '000':
                $this->translatedResult['success'][] = $this->translator->trans('Saved', [], 'Modules.Orlenpaczka.Label');
                break;
            case '006':
                $this->translatedResult['warning'][] = $this->translator->trans('Saved changed DestinationCode', [], 'Modules.Orlenpaczka.Label');
                break;
            case '007':
                $this->translatedResult['warning'][] = $this->translator->trans('Saved changed ReturnDestinationCode', [], 'Modules.Orlenpaczka.Label');
                break;
            case '008':
                $this->translatedResult['warning'][] = $this->translator->trans('Saved changed DestinationCode and ReturnDestinationCode', [], 'Modules.Orlenpaczka.Label');
                break;
            case '206':
                $this->translatedResult['error'][] = $this->translator->trans('Error generate label. Selected point is inactive. Please select other point', [], 'Modules.Orlenpaczka.Label');
                $this->translatedResult['error'][] = 'unknown destinationcode';
                break;
            default:
                $this->translatedResult['error'][] = $this->translator->trans('Error generate label.', [], 'Modules.Orlenpaczka.Label');
                $this->translatedResult['error'][] = $row['description'];
                break;
        }
    }
}
