<?php

namespace Orlen\OrlenPaczka\Label\Settings;

use Symfony\Component\OptionsResolver\OptionsResolver;

class GenerateLabelSettings
{
    private OptionsResolver $resolver;
    /**
     * @var null
     */
    private $settings = [];

    public function __construct()
    {
        $this->resolver = new OptionsResolver();
    }

    public function setSettings($settings)
    {
        $this->settings = $this->_configureOptions($settings);
    }

    public function getSettings()
    {
        return $this->settings;
    }

    private function _configureOptions($settings)
    {
        // Ustawienia podstawowe
        $this->resolver->setDefault('allow_regenerate', false);
        $this->resolver->setDefault('PrintAdress', 1);
        $this->resolver->setDefault('PrintType', 1);
        $this->resolver->setDefault('format', 'PDF');

        // Ustawienie tablicy provider jako pustej tablicy domyślnie
        $this->resolver->setDefault('provider', []);
        $this->resolver->setDefault('package_order', []);
        $this->resolver->setDefault('sender_orders', []);

        // Pozwalamy na dowolne klucze w tablicy provider
        $this->resolver->setAllowedTypes('allow_regenerate', 'bool');
        $this->resolver->setAllowedTypes('provider', 'array');
        $this->resolver->setAllowedTypes('package_order', 'array');
        $this->resolver->setAllowedTypes('sender_orders', 'array');

        // Walidacja wartości
        $this->resolver->setAllowedValues('PrintAdress', [1, 2]);
        $this->resolver->setAllowedValues('PrintType', [1, 2, 3]);



        return $this->resolver->resolve($settings);
    }
}
