<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    Waynet
 * @copyright Waynet
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */

namespace  Orlen\OrlenPaczka\Installer;

use Orlen\OrlenPaczka\Configuration\ConfigurationModule;
use Orlen\OrlenPaczka\Installer\Handler\CarrierInstaller;
use Orlen\OrlenPaczka\Installer\Handler\ConfigurationInstaller;
use Orlen\OrlenPaczka\Installer\Handler\DatabaseInstaller;
use Orlen\OrlenPaczka\Installer\Handler\DirectoryInstaller;
use Orlen\OrlenPaczka\Installer\Handler\HooksInstaller;
use Orlen\OrlenPaczka\Installer\Handler\Interfaces\InstallerInterface;
use Orlen\OrlenPaczka\Installer\Handler\Interfaces\UninstallerInterface;


if (!defined('_PS_VERSION_')) {
    exit;
}

class ModuleInstaller implements InstallerInterface, UninstallerInterface
{
    private $installers = [];
    private $uninstallers = [];

    public function __construct()
    {
        $this->initializeInstallers();
        $this->initializeUninstallers();
    }

    public function initializeInstallers()
    {
        $this->installers[] = new DatabaseInstaller();
        $this->installers[] = new HooksInstaller();
        $this->installers[] = new DirectoryInstaller();
        $this->installers[] = new CarrierInstaller();
    }

    public function initializeUninstallers()
    {
        $this->uninstallers[] = new DatabaseInstaller();
        $this->uninstallers[] = new ConfigurationInstaller();
        $this->uninstallers[] = new CarrierInstaller();
    }

    public function install(ConfigurationModule $configuration): bool
    {
        $result = true;
        foreach ($this->installers as $installer) {
            $result &= $installer->install($configuration);
        }

        return (bool) $result;
    }

    public function uninstall(ConfigurationModule $configuration): bool
    {
        $result = true;
        foreach ($this->uninstallers as $installer) {
            $result &= $installer->uninstall($configuration);
        }

        return (bool) $result;
    }
}
