<?php

namespace Orlen\OrlenPaczka\Installer\Handler;

use Orlen\OrlenPaczka\Configuration\ConfigurationModule;
use Orlen\OrlenPaczka\Helper\Lang\LangHelper;
use Orlen\OrlenPaczka\Installer\Handler\Interfaces\InstallerInterface;
use Orlen\OrlenPaczka\Installer\Handler\Interfaces\UninstallerInterface;

class CarrierInstaller implements InstallerInterface, UninstallerInterface
{
    public function install(ConfigurationModule $configuration): bool
    {
        $result = true;
        $result&= \Db::getInstance()->insert('orlenpaczka_shipment_type',
            [
                'name' => pSQL('standard'),
            ]
        );

        $shipmentTypeId = \Db::getInstance()->Insert_ID();

        $carrier = new \Carrier();
        $carrier->name = 'ORLEN Paczka';
        $carrier->url = 'https://www.orlenpaczka.pl/sledz-paczke/?numer=@';
        $carrier->active = true;
        $carrier->shipping_external = true;
        $carrier->is_module = true;
        $carrier->need_range = true;
        $carrier->external_module_name = ConfigurationModule::MODULE_NAME;
        $carrier->delay = LangHelper::createLangArrayForValue('24-48H');
        $result&= $carrier->save();
        !file_exists(ConfigurationModule::LABEL_PATH) || !copy(ConfigurationModule::LOGO_PATH, _PS_SHIP_IMG_DIR_ . $carrier->id . '.jpg');
        $groups = \Group::getGroups(\Context::getContext()->language->id);
        $groups = array_column($groups, 'id_group');
        $result &= $carrier->setGroups($groups);

        $result&= \Db::getInstance()->insert('orlenpaczka_shipment',
            [
                'id_shipment_type' => (int)$shipmentTypeId,
                'id_carrier_reference' => (int)$carrier->id,
                'carrier_active' => (bool)true,
                'map_active' => (int)true,
                'size' => pSQL('M'),
                'sender_orders' => ''
            ]
        );

        return $result;

    }

    public function uninstall(ConfigurationModule $configuration): bool
    {
        return \DB::getInstance()->update('carrier', ['deleted' => true, 'active' => false], '`external_module_name` = "' . pSQL(ConfigurationModule::MODULE_NAME) . '"');
    }

}
