<?php

namespace Orlen\OrlenPaczka\Hook;

use Orlen\OrlenPaczka\Configuration\ConfigurationModule;
use Orlen\OrlenPaczka\Hook\Interfaces\HookInterface;
use Symfony\Component\Routing\RouterInterface;

class DisplayBackOfficeHeader implements HookInterface
{
    private \Context $context;
    private RouterInterface $router;

    public function __construct(\Context $context, RouterInterface $router)
    {
        $this->context = $context;
        $this->router = $router;
    }
    public function execute($params)
    {
        $token =\Configuration::get(ConfigurationModule::ORLEN_PACZKA_MAP_WIDGET_TOKEN);
        if (empty($token) || $this->context->controller->php_self !== 'AdminOrders') {
            return '';
        }
        $this->context->controller->addJS(
            'modules/orlenpaczka/views/js/admin/carrier.js'
        );
        $this->context->controller->addJS(
            'modules/orlenpaczka/views/js/admin/order-bulk-actions.js'
        );
        \Media::addJsDef([
            'saveSelectedPointUrl' => $this->router->generate('orlenpaczka.order.save_pickup'),
        ]);
        $this->context->smarty->assign(['token' => $token, 'api' => ConfigurationModule::ORLEN_PACZKA_MAP_WIDGET_API]);
        return $this->context->smarty->fetch('module:orlenpaczka/views/templates/hook/map-script.tpl');
    }

}
