<?php

namespace Orlen\OrlenPaczka\Hook;

use Orlen\OrlenPaczka\Hook\Interfaces\HookInterface;
use PrestaShop\PrestaShop\Core\Grid\Data\GridData;
use PrestaShop\PrestaShop\Core\Grid\Record\RecordCollection;

class ActionOrlenpaczkaPackageGridDataModifier implements HookInterface
{
    public function execute($params)
    {
        $data = $params['data']->getRecords()->all();
        /* @var \PrestaShop\PrestaShop\Core\Grid\Data\GridData $data */
        foreach ($data as &$record) {
            $record['pack_code'] = '<a target="_blank" href="https://www.orlenpaczka.pl/sledz-paczke/?numer='.$record['pack_code'].'">'.$record['pack_code'].'</a>';
        }

        $recordCollection = new RecordCollection($data);
        $params['data'] = new GridData($recordCollection,$params['data']->getRecordsTotal(),$params['data']->getQuery());
    }

}
