<?php

namespace Orlen\OrlenPaczka\Hook;

use Orlen\OrlenPaczka\Hook\Interfaces\HookInterface;
use PrestaShop\PrestaShop\Core\Grid\Action\Bulk\Type\AjaxBulkAction;
use PrestaShop\PrestaShop\Core\Grid\Action\Bulk\Type\ModalFormSubmitBulkAction;
use Symfony\Component\Routing\RouterInterface;

class ActionOrderGridDefinitionModifier implements HookInterface
{
    private  $translator;
    private RouterInterface $router;

    public function __construct($translator, RouterInterface $router)
    {
        $this->translator = $translator;
        $this->router = $router;
    }
    public function execute($params)
    {

        $params['definition']->getBulkActions()->add(
            (new ModalFormSubmitBulkAction('generate_label'))
                ->setName($this->translator->trans('Generate label', [], 'Modules.Orlenpaczka.Admin'))
                ->setOptions([
                    'submit_route' => 'orlenpaczka.order.generate_label_list',
                    'modal_id' => 'generateLabelModal',
                ])
//                ->setIcon($icon)
        );

    }

}
