<?php

namespace Orlen\OrlenPaczka\Grid\Query;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use PrestaShop\PrestaShop\Core\Grid\Query\AbstractDoctrineQueryBuilder;
use PrestaShop\PrestaShop\Core\Grid\Query\DoctrineSearchCriteriaApplicatorInterface;
use PrestaShop\PrestaShop\Core\Grid\Search\SearchCriteriaInterface;

class ProtocolQueryBuilder extends AbstractDoctrineQueryBuilder
{
    private $searchCriteriaApplicator;

    public function __construct(
        Connection $connection,
        string $dbPrefix,
        DoctrineSearchCriteriaApplicatorInterface $searchCriteriaApplicator
    ) {
        parent::__construct($connection, $dbPrefix);

        $this->searchCriteriaApplicator = $searchCriteriaApplicator;
    }

    public function getSearchQueryBuilder(SearchCriteriaInterface $searchCriteria): QueryBuilder
    {
        $queryBuilder = $this
            ->getCommonQueryBuilder($searchCriteria)
            ->select('op.*, GROUP_CONCAT(opa.pack_code) as packages')
            ->groupBy('op.id_protocol');

        $this->searchCriteriaApplicator
            ->applyPagination($searchCriteria, $queryBuilder)
            ->applySorting($searchCriteria, $queryBuilder);

        return $queryBuilder;
    }

    public function getCountQueryBuilder(SearchCriteriaInterface $searchCriteria): QueryBuilder
    {
        return $this
            ->getCommonQueryBuilder($searchCriteria)
            ->select('COUNT(*)');
    }

    private function getCommonQueryBuilder(SearchCriteriaInterface $searchCriteria): QueryBuilder
    {
        $queryBuilder = $this->connection
            ->createQueryBuilder()
            ->from($this->dbPrefix . 'orlenpaczka_protocol', 'op')
            ->innerJoin('op',$this->dbPrefix . 'orlenpaczka_package', 'opa', 'op.id_protocol = opa.id_protocol')
        ;

        $this->applyFilters($searchCriteria->getFilters(), $queryBuilder);

        return $queryBuilder;
    }

    private function applyFilters(array $filters, QueryBuilder $qb)
    {
        foreach ($filters as $filterName => $filterValue) {
            switch ($filterName) {
                case 'id_protocol':
                    $qb->andWhere('op.`' . $filterName . '` = :' . $filterName);
                    $qb->setParameter($filterName, $filterValue);

                    break;
                case 'code':
                case 'status':
                    $qb->andWhere('op.`' . $filterName . '` LIKE :' . $filterName);
                    $qb->setParameter($filterName, '%' . $filterValue . '%');

                    break;
                case 'label_date_generated':
                    if (isset($filterValue['from'])){
                        $qb->andWhere('op.`label_date_generated` >= :from');
                        $qb->setParameter('from',  $filterValue['from'] );
                    }
                    if (isset($filterValue['to'])){
                        $qb->andWhere('op.`label_date_generated` <= :to');
                        $to = $filterValue['to'].' 23:59:59';
                        $qb->setParameter('to',  $to);
                    }

                    break;
                case  'packages':
                    $qb->andHaving('GROUP_CONCAT(opa.pack_code) LIKE :packages');
                    $qb->setParameter('packages', '%' . $filterValue . '%');
                default:
                    break;
            }
        }
    }
}
