<?php

namespace Orlen\OrlenPaczka\Grid\Definition\Factory;

use Orlen\OrlenPaczka\Form\Type\OrlenDateRangeType;
use Orlen\OrlenPaczka\Grid\Column\HtmlColumn;
use Orlen\OrlenPaczka\Repository\ShipmentRepository;
use Orlen\OrlenPaczka\Repository\ShipmentTypeRepository;
use PrestaShop\PrestaShop\Core\Grid\Action\Bulk\BulkActionCollection;
use PrestaShop\PrestaShop\Core\Grid\Action\Bulk\Type\ButtonBulkAction;
use PrestaShop\PrestaShop\Core\Grid\Action\Bulk\Type\ModalFormSubmitBulkAction;
use PrestaShop\PrestaShop\Core\Grid\Action\Bulk\Type\SubmitBulkAction;
use PrestaShop\PrestaShop\Core\Grid\Action\GridActionCollection;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\RowActionCollection;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\Type\LinkRowAction;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\Type\SubmitRowAction;
use PrestaShop\PrestaShop\Core\Grid\Action\Type\SimpleGridAction;
use PrestaShop\PrestaShop\Core\Grid\Column\ColumnCollection;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\ActionColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\BooleanColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\BulkActionColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\DateTimeColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\IdentifierColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\LinkColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\PositionColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\DataColumn;
use PrestaShop\PrestaShop\Core\Grid\Definition\Factory\AbstractFilterableGridDefinitionFactory;
use PrestaShop\PrestaShop\Core\Grid\Filter\Filter;
use PrestaShop\PrestaShop\Core\Grid\Filter\FilterCollection;
use PrestaShop\PrestaShop\Core\Hook\HookDispatcherInterface;
use PrestaShopBundle\Event\Dispatcher\NullDispatcher;
use PrestaShopBundle\Form\Admin\Type\SearchAndResetType;
use PrestaShopBundle\Form\Admin\Type\YesAndNoChoiceType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateIntervalType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\RangeType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;

class PackageGridDefinitionFactory extends AbstractFilterableGridDefinitionFactory
{
    public const GRID_ID = 'orlenpaczka_package';
    private ShipmentRepository $shipmentRepository;

    public function __construct(
        Translator $translator,
        HookDispatcherInterface $hookDispatcher = null,
        ShipmentRepository $shipmentRepository
    ) {
        parent::__construct($hookDispatcher ?? new NullDispatcher());
        $this->setTranslator($translator);
        $this->shipmentRepository = $shipmentRepository;
    }

    protected function getId(): string
    {
        return self::GRID_ID;
    }

    protected function getName(): string
    {
        return $this->trans('Packages', [], 'Modules.Orlenpaczka.Admin');
    }

    protected function getColumns(): ColumnCollection
    {
        return (new ColumnCollection())
            ->add(
                (new BulkActionColumn('package_bulk'))
                    ->setOptions([
                        'bulk_field' => 'id_package',
                    ])
            )
            ->add(
                (new IdentifierColumn('id_package'))
                    ->setName($this->trans('ID', [], 'Admin.Global'))
                    ->setOptions([
                        'identifier_field' => 'id_package',
                    ])
            )
            ->add(
                (new DataColumn('id_order'))
                    ->setName($this->trans('Id order', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'id_order',
                    ])
            )
            ->add(
                (new DataColumn('partner_id'))
                    ->setName($this->trans('Partner id', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'partner_id',
                    ])
            )
            ->add(
                (new HtmlColumn('pack_code'))
                    ->setName($this->trans('Pack code', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'pack_code',
                    ])
            )
            ->add(
                (new DataColumn('destination_code'))
                    ->setName($this->trans('Destination code', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'destination_code',
                    ])
            )
            ->add(
                (new DataColumn('size'))
                    ->setName($this->trans('Size', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'size',
                    ])
            )
//            ->add(
//                (new DataColumn('insurance_amount'))
//                    ->setName($this->trans('Insurance amount', [], 'Modules.Orlenpaczka.Admin'))
//                    ->setOptions([
//                        'field' => 'insurance_amount',
//                    ])
//            )
            ->add(
                (new DataColumn('sender_orders'))
                    ->setName($this->trans('Sender orders', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'sender_orders',
                    ])
            )
            ->add(
                (new DataColumn('phone'))
                    ->setName($this->trans('Phone', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'phone',
                    ])
            )
            ->add(
                (new DataColumn('email'))
                    ->setName($this->trans('Email', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'email',
                    ])
            )
            ->add(
                (new DataColumn('date_add'))
                    ->setName($this->trans('Order create', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'date_add',
                    ])
            )
            ->add(
                (new DataColumn('label_date_generated'))
                    ->setName($this->trans('Label date create', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'label_date_generated',
                    ])
            )
            ->add(
                (new BooleanColumn('generate_label'))
                    ->setName($this->trans('Generated label', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'generate_label',
                        'true_name' => 'Tak',
                        'false_name' => 'Nie',
                    ])
            )
            ->add(
                (new BooleanColumn('generate_protocol'))
                    ->setName($this->trans('Generated protocol', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'generate_protocol',
                        'true_name' => 'Tak',
                        'false_name' => 'Nie',
                    ])
            )
            ->add(
                (new BooleanColumn('delivery'))
                    ->setName($this->trans('Delivery', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'delivery',
                        'true_name' => 'Tak',
                        'false_name' => 'Nie',
                    ])
            )

            ->add(
                (new ActionColumn('actions'))
                    ->setName($this->trans('Actions', [], 'Admin.Global'))
                    ->setOptions([
                        'actions' => $this->getRowActions(),
                    ])
            );
    }

    protected function getFilters()
    {
        return (new FilterCollection())
            ->add(
                (new Filter('id_package', NumberType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search id', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('id_package')
            )
            ->add(
                (new Filter('id_order', NumberType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search id order', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('id_order')
            )
            ->add(
                (new Filter('partner_id', TextType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search partner id', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('partner_id')
            )
            ->add(
                (new Filter('pack_code', TextType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search pack code', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('pack_code')
            )
            ->add(
                (new Filter('destination_code', TextType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search destination code', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('destination_code')
            )
            ->add((new Filter('size', ChoiceType::class))
                ->setTypeOptions([
                    'required' => false,
                    'choices' => $this->shipmentRepository->getAllGrid(),
                    'translation_domain' => false,
                ])->setAssociatedColumn('size')
            )
//            ->add(
//                (new Filter('insurance_amount', TextType::class))
//                    ->setTypeOptions([
//                        'attr' => [
//                            'placeholder' => $this->trans('Search insurance amount', [], 'Modules.Orlenpaczka.Admin'),
//                        ],
//                        'required' => false,
//                    ])
//                    ->setAssociatedColumn('insurance_amount')
//            )


            ->add(
                (new Filter('sender_orders', TextType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search sender orders', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('sender_orders')
            )

            ->add(
                (new Filter('phone', TextType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search phone', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('phone')
            )

            ->add(
                (new Filter('email', TextType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search email', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('email')
            )

            ->add(
                (new Filter('date_add', OrlenDateRangeType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search date add', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('date_add')
            )

            ->add(
                (new Filter('label_date_generated', OrlenDateRangeType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search label generate', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('label_date_generated')
            )

            ->add(
                (new Filter('generate_label', YesAndNoChoiceType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search generate label', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('generate_label')
            )

            ->add(
                (new Filter('generate_protocol', YesAndNoChoiceType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search generate protocol', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('generate_protocol')
            )
            ->add(
                (new Filter('delivery', YesAndNoChoiceType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search delivery', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('delivery')
            )

            ->add(
                (new Filter('actions', SearchAndResetType::class))
                    ->setTypeOptions([
                        'reset_route' => 'admin_common_reset_search_by_filter_id',
                        'reset_route_params' => [
                            'filterId' => self::GRID_ID,
                        ],
                        'redirect_route' => 'orlenpaczka.config.shipping.index',
                    ])
                    ->setAssociatedColumn('actions')
            );
    }

    protected function getGridActions()
    {
        return (new GridActionCollection())
            ->add(
                (new SimpleGridAction('common_refresh_list'))
                    ->setName($this->trans('Refresh list', [], 'Admin.Advparameters.Feature'))
                    ->setIcon('refresh')
            )
            ->add(
                (new SimpleGridAction('common_show_query'))
                    ->setName($this->trans('Show SQL query', [], 'Admin.Actions'))
                    ->setIcon('code')
            )
            ->add(
                (new SimpleGridAction('common_export_sql_manager'))
                    ->setName($this->trans('Export to SQL Manager', [], 'Admin.Actions'))
                    ->setIcon('storage')
            );
    }

    private function getRowActions()
    {
        return (new RowActionCollection())
//            ->add(
//                (new LinkRowAction('edit'))
//                    ->setName($this->trans('Edit', [], 'Admin.Actions'))
//                    ->setOptions([
//                        'route' => 'orlenpaczka.config.shipping',
//                        'route_param_name' => 'id',
//                        'route_param_field' => 'id_package',
//                    ])
//                    ->setIcon('edit')
//            )
            ->add(
                (new LinkRowAction('download'))
                    ->setName($this->trans('Download label', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'route' => 'orlenpaczka.config.shipping.download_label',
                        'route_param_name' => 'id',
                        'route_param_field' => 'id_package',
                    ])
                    ->setIcon('download')
            );
//            ->add(
//                (new SubmitRowAction('create_new_package'))
//                    ->setName($this->trans('Generate new package', [], 'Admin.Actions'))
//                    ->setOptions([
//                        'route' => 'orlenpaczka.config.shipping.duplicate',
//                        'route_param_name' => 'id',
//                        'route_param_field' => 'id_package',
//
//                    ])
//                    ->setIcon('print')
//            );
//            ->add(
//                (new SubmitRowAction('delete'))
//                    ->setName($this->trans('Delete', [], 'Admin.Actions'))
//                    ->setOptions([
//                        'route' => 'orlenpaczka.config.shipping_history.grid',
//                        'method' => 'DELETE',
//                        'route_param_name' => 'id',
//                        'route_param_field' => 'id_package',
//                        'confirm_message' => $this->trans(
//                            'Delete selected item?',
//                            [],
//                            'Admin.Notifications.Warning'
//                        ),
//                    ])
//                    ->setIcon('delete')
//            );
    }

    protected function getBulkActions()
    {
        return (new BulkActionCollection())
            ->add((new ModalFormSubmitBulkAction('generate_label'))
                ->setName($this->trans('Generate label', [], 'Modules.Orlenpaczka.Admin'))
                ->setOptions([
                    'submit_route' => 'orlenpaczka.config.shipping.generate_label',
                    'modal_id' => 'generateLabelModal',
                ])
            )
            ->add((new SubmitBulkAction('generate_protocol'))
                ->setName($this->trans('Generate protocol', [], 'Modules.Orlenpaczka.Admin'))
                ->setOptions([
                    'submit_route' => 'orlenpaczka.config.shipping.generate_protocol',
                ])
            )
            ->add((new ModalFormSubmitBulkAction('call_pickup'))
                ->setName($this->trans('Call pickup', [], 'Modules.Orlenpaczka.Admin'))
                ->setOptions([
                    'submit_route' => 'orlenpaczka.call_pickup',
                    'modal_id' => 'callPickupModal',
                ])
            );


    }
}
