<?php

namespace Orlen\OrlenPaczka\Grid\Definition\Factory;

use Orlen\OrlenPaczka\Form\Type\OrlenDateRangeType;
use PrestaShop\PrestaShop\Core\Grid\Action\GridActionCollection;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\RowActionCollection;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\Type\LinkRowAction;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\Type\SubmitRowAction;
use PrestaShop\PrestaShop\Core\Grid\Action\Type\SimpleGridAction;
use PrestaShop\PrestaShop\Core\Grid\Column\ColumnCollection;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\BooleanColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\ActionColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\DateTimeColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\IdentifierColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\PositionColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\DataColumn;
use PrestaShop\PrestaShop\Core\Grid\Definition\Factory\AbstractFilterableGridDefinitionFactory;
use PrestaShop\PrestaShop\Core\Grid\Filter\Filter;
use PrestaShop\PrestaShop\Core\Grid\Filter\FilterCollection;
use PrestaShop\PrestaShop\Core\Hook\HookDispatcherInterface;
use PrestaShopBundle\Event\Dispatcher\NullDispatcher;
use PrestaShopBundle\Form\Admin\Type\DateRangeType;
use PrestaShopBundle\Form\Admin\Type\SearchAndResetType;
use PrestaShopBundle\Form\Admin\Type\YesAndNoChoiceType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;

class LogGridDefinitionFactory extends AbstractFilterableGridDefinitionFactory
{
    public const GRID_ID = 'orlenpaczka_log';

    public function __construct(
        Translator $translator,
        HookDispatcherInterface $hookDispatcher = null
    ) {
        parent::__construct($hookDispatcher ?? new NullDispatcher());
        $this->setTranslator($translator);
    }

    protected function getId(): string
    {
        return self::GRID_ID;
    }

    protected function getName(): string
    {
        return $this->trans('Logs', [], 'Modules.Orlenpaczka.Admin');
    }

    protected function getColumns(): ColumnCollection
    {
        return (new ColumnCollection())
            ->add(
                (new IdentifierColumn('id_log'))
                    ->setName($this->trans('ID', [], 'Admin.Global'))
                    ->setOptions([
                        'identifier_field' => 'id_log',
                    ])
            )
            ->add(
                (new DateTimeColumn('date'))
                    ->setName($this->trans('Date', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'date',
                        'format' => 'Y-m-d H:i:s',
                    ])
            )
            ->add(
                (new DataColumn('type'))
                    ->setName($this->trans('Type', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'type',
                    ])
            )
            ->add(
                (new DataColumn('message'))
                    ->setName($this->trans('Message', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'message',
                    ])
            )
            ->add(
                (new DataColumn('context'))
                    ->setName($this->trans('Context', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'context',
                    ])
            )
            ->add(
                (new ActionColumn('actions'))
                    ->setName($this->trans('Actions', [], 'Admin.Global'))
                    ->setOptions([
                        'actions' => $this->getRowActions(),
                    ])
            );
    }

    protected function getFilters()
    {
        return (new FilterCollection())
            ->add(
                (new Filter('id_log', NumberType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search id', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('id_log')
            )
            ->add(
                (new Filter('date', OrlenDateRangeType::class))
                    ->setTypeOptions([
                        'required' => false,
                    ])
                    ->setAssociatedColumn('date')
            )
            ->add(
                (new Filter('type', TextType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search type', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('type')
            )
            ->add(
                (new Filter('message', TextType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search message', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('message')
            )
            ->add(
                (new Filter('actions', SearchAndResetType::class))
                    ->setTypeOptions([
                        'reset_route' => 'admin_common_reset_search_by_filter_id',
                        'reset_route_params' => [
                            'filterId' => self::GRID_ID,
                        ],
                        'redirect_route' => 'orlenpaczka.config.logs.index',
                    ])
                    ->setAssociatedColumn('actions')
            );
    }

    protected function getGridActions()
    {
        return (new GridActionCollection())
            ->add(
                (new SimpleGridAction('common_refresh_list'))
                    ->setName($this->trans('Refresh list', [], 'Admin.Advparameters.Feature'))
                    ->setIcon('refresh')
            )
            ->add(
                (new SimpleGridAction('common_show_query'))
                    ->setName($this->trans('Show SQL query', [], 'Admin.Actions'))
                    ->setIcon('code')
            )
            ->add(
                (new SimpleGridAction('common_export_sql_manager'))
                    ->setName($this->trans('Export to SQL Manager', [], 'Admin.Actions'))
                    ->setIcon('storage')
            );
    }

    private function getRowActions()
    {
        return (new RowActionCollection());

    }
}
