<?php

namespace Orlen\OrlenPaczka\Grid\Definition\Factory;

use Orlen\OrlenPaczka\Form\Type\OrlenDateRangeType;
use PrestaShop\PrestaShop\Core\Grid\Action\GridActionCollection;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\RowActionCollection;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\Type\LinkRowAction;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\Type\SubmitRowAction;
use PrestaShop\PrestaShop\Core\Grid\Action\Type\SimpleGridAction;
use PrestaShop\PrestaShop\Core\Grid\Column\ColumnCollection;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\BooleanColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\ActionColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\DateTimeColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\IdentifierColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\PositionColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\DataColumn;
use PrestaShop\PrestaShop\Core\Grid\Definition\Factory\AbstractFilterableGridDefinitionFactory;
use PrestaShop\PrestaShop\Core\Grid\Filter\Filter;
use PrestaShop\PrestaShop\Core\Grid\Filter\FilterCollection;
use PrestaShop\PrestaShop\Core\Hook\HookDispatcherInterface;
use PrestaShopBundle\Event\Dispatcher\NullDispatcher;
use PrestaShopBundle\Form\Admin\Type\DateRangeType;
use PrestaShopBundle\Form\Admin\Type\SearchAndResetType;
use PrestaShopBundle\Form\Admin\Type\YesAndNoChoiceType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;

class DeliveryGridDefinitionFactory extends AbstractFilterableGridDefinitionFactory
{
    public const GRID_ID = 'orlenpaczka_delivery';

    public function __construct(
        Translator $translator,
        HookDispatcherInterface $hookDispatcher = null
    ) {
        parent::__construct($hookDispatcher ?? new NullDispatcher());
        $this->setTranslator($translator);
    }

    protected function getId(): string
    {
        return self::GRID_ID;
    }

    protected function getName(): string
    {
        return $this->trans('Deliveries', [], 'Modules.Orlenpaczka.Admin');
    }

    protected function getColumns(): ColumnCollection
    {
        return (new ColumnCollection())
            ->add(
                (new IdentifierColumn('id_delivery'))
                    ->setName($this->trans('ID', [], 'Admin.Global'))
                    ->setOptions([
                        'identifier_field' => 'id_delivery',
                    ])
            )
            ->add(
                (new DataColumn('code'))
                    ->setName($this->trans('Code', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'code',
                    ])
            )
            ->add(
                (new DateTimeColumn('date_pickup'))
                    ->setName($this->trans('Date pickup', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'date_pickup',
                        'format' => 'Y-m-d',
                    ])
            )
            ->add(
                (new DateTimeColumn('hour_pickup_from'))
                    ->setName($this->trans('Hour pickup from', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'hour_pickup_from',
                        'format' => 'H',
                    ])
            )
            ->add(
                (new DateTimeColumn('hour_pickup_to'))
                    ->setName($this->trans('Hour pickup to', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'hour_pickup_to',
                        'format' => 'H',
                    ])
            )
            ->add(
                (new DateTimeColumn('date_add'))
                    ->setName($this->trans('Date add', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'date_add',
                        'format' => 'Y-m-d H:i:s',
                    ])
            )
            ->add(
                (new DataColumn('protocol_code'))
                    ->setName($this->trans('Protocol code', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'protocol_code',
                    ])
            )
            ->add(
                (new DateTimeColumn('protocol_create'))
                    ->setName($this->trans('Protocol create', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'protocol_create',
                        'format' => 'Y-m-d H:i:s',

                    ])
            )
            ->add(
                (new DataColumn('packages'))
                    ->setName($this->trans('Packages', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'field' => 'packages',
                    ])
            )



            ->add(
                (new ActionColumn('actions'))
                    ->setName($this->trans('Actions', [], 'Admin.Global'))
                    ->setOptions([
                        'actions' => $this->getRowActions(),
                    ])
            );
    }

    protected function getFilters()
    {
        return (new FilterCollection())
            ->add(
                (new Filter('id_delivery', NumberType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search id', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('id_delivery')
            )
            ->add(
                (new Filter('code', TextType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search code', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('code')
            )
            ->add(
                (new Filter('date_pickup', OrlenDateRangeType::class))
                    ->setTypeOptions([
                        'required' => false,
                        'attr' => [
                            'from' => [
                                'placeholder' => $this->trans('From', [], 'Modules.Orlenpaczka.Admin'),
                            ],
                            'to' => [
                                'placeholder' => $this->trans('To', [], 'Modules.Orlenpaczka.Admin'),
                            ]
                        ]

                    ])
                    ->setAssociatedColumn('date_pickup')
            )
            ->add(
                (new Filter('hour_pickup_from', OrlenDateRangeType::class))
                    ->setTypeOptions([
                        'required' => false,
                        'date_format' => 'H',
                        'attr' => [
                            'from' => [
                                'placeholder' => $this->trans('From', [], 'Modules.Orlenpaczka.Admin'),
                            ],
                            'to' => [
                                'placeholder' => $this->trans('To', [], 'Modules.Orlenpaczka.Admin'),
                            ]
                        ]
                    ])
                    ->setAssociatedColumn('hour_pickup_from')
            )
            ->add(
                (new Filter('hour_pickup_to', OrlenDateRangeType::class))
                    ->setTypeOptions([
                        'required' => false,
                        'date_format' => 'H',
                        'attr' => [
                            'from' => [
                                'placeholder' => $this->trans('From', [], 'Modules.Orlenpaczka.Admin'),
                            ],
                            'to' => [
                                'placeholder' => $this->trans('To', [], 'Modules.Orlenpaczka.Admin'),
                            ]
                        ]
                    ])
                    ->setAssociatedColumn('hour_pickup_to')
            )
            ->add(
                (new Filter('date_add', OrlenDateRangeType::class))
                    ->setTypeOptions([
                        'required' => false,
                        'attr' => [
                            'from' => [
                                'placeholder' => $this->trans('From', [], 'Modules.Orlenpaczka.Admin'),
                            ],
                            'to' => [
                                'placeholder' => $this->trans('To', [], 'Modules.Orlenpaczka.Admin'),
                            ]
                        ]
                    ])
                    ->setAssociatedColumn('date_add')
            )
            ->add(
                (new Filter('protocol_code', TextType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search protocol code', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('protocol_code')
            )
            ->add(
                (new Filter('protocol_create', OrlenDateRangeType::class))
                    ->setTypeOptions([
                        'required' => false,
                    ])
                    ->setAssociatedColumn('protocol_create')
            )
            ->add(
                (new Filter('packages', TextType::class))
                    ->setTypeOptions([
                        'attr' => [
                            'placeholder' => $this->trans('Search package', [], 'Modules.Orlenpaczka.Admin'),
                        ],
                        'required' => false,
                    ])
                    ->setAssociatedColumn('packages')
            )
            ->add(
                (new Filter('actions', SearchAndResetType::class))
                    ->setTypeOptions([
                        'reset_route' => 'admin_common_reset_search_by_filter_id',
                        'reset_route_params' => [
                            'filterId' => self::GRID_ID,
                        ],
                        'redirect_route' => 'orlenpaczka.config.delivery.index',
                    ])
                    ->setAssociatedColumn('actions')
            );
    }

    protected function getGridActions()
    {
        return (new GridActionCollection())
            ->add(
                (new SimpleGridAction('common_refresh_list'))
                    ->setName($this->trans('Refresh list', [], 'Admin.Advparameters.Feature'))
                    ->setIcon('refresh')
            )
            ->add(
                (new SimpleGridAction('common_show_query'))
                    ->setName($this->trans('Show SQL query', [], 'Admin.Actions'))
                    ->setIcon('code')
            )
            ->add(
                (new SimpleGridAction('common_export_sql_manager'))
                    ->setName($this->trans('Export to SQL Manager', [], 'Admin.Actions'))
                    ->setIcon('storage')
            );
    }

    private function getRowActions()
    {
        return (new RowActionCollection())
            ->add(
                (new LinkRowAction('generate_protocol'))
                    ->setName($this->trans('Generate protocol', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'route' => 'orlenpaczka.config.delivery.generate_protocol',
                        'route_param_name' => 'id',
                        'route_param_field' => 'id_delivery',
                        'accessibility_checker' => function ($record) {
                            return !isset($record['id_protocol']);
                        }
                    ])
                    ->setIcon('print')
            )
            ->add(
                (new LinkRowAction('download'))
                    ->setName($this->trans('Download protocol', [], 'Modules.Orlenpaczka.Admin'))
                    ->setOptions([
                        'route' => 'orlenpaczka.config.protocol.download_label',
                        'route_param_name' => 'id',
                        'route_param_field' => 'id_protocol',
                        'accessibility_checker' => function ($record) {
                            return isset($record['id_protocol']);
                        }
                    ])
                    ->setIcon('download')
            );

    }

    public function finishView()
    {

    }
}
