<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Form\Type;

use PrestaShopBundle\Form\Admin\Type\DatePickerType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;

class OrlenDateRangeType extends AbstractType
{

    private Translator $translator;

    public function __construct(Translator $translator)
    {
        $this->translator = $translator;
    }
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('from', DatePickerType::class, [
                'required' => false,
                'attr' => [
                    'placeholder' => $this->translator->trans('From', [], 'Modules.Orlenpaczka.Form'),
                ],
                'date_format' => $options['date_format'],
            ])
            ->add('to', DatePickerType::class, [
                'required' => false,
                'attr' => [
                    'placeholder' => $this->translator->trans('To', [], 'Modules.Orlenpaczka.Form'),
                ],
                'date_format' => $options['date_format'],
            ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'date_format' => 'YYYY-MM-DD',
        ]);
        $resolver->setAllowedTypes('date_format', 'string');
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'date_range';
    }

}
