<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Form\Type;

use Orlen\OrlenPaczka\Configuration\Enum\ConfigFormEnum;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Routing\RouterInterface;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;

class MapType extends AbstractType
{

    private Translator $translator;
    private RouterInterface $router;

    public function __construct(Translator $translator, RouterInterface $router)
    {
        $this->translator = $translator;
        $this->router = $router;
    }
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('token', TextType::class,
                [
                    'label' => $this->translator->trans('token', [], 'Modules.Orlenpaczka.Form'),
                    'required' => true,
                ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
    }
}
