<?php

namespace Orlen\OrlenPaczka\Form\Provider;

use Orlen\OrlenPaczka\Repository\ShipmentRepository;

class FormatLabelProvider
{
    private ShipmentRepository $shipmentRepository;

    public function __construct(ShipmentRepository $shipmentRepository)
    {
        $this->shipmentRepository = $shipmentRepository;
    }

    public function getFormatLabelArray($key = 'format')
    {
        $settings = $this->shipmentRepository->find(1);
        $data = [];
        if (!empty($settings)) {
            $data = [$key => $settings->getLabelFormat()];
        }
        return $data;

    }
}
