<?php

namespace Orlen\OrlenPaczka\Form\Provider;

use Orlen\OrlenPaczka\Repository\AddressRepository;

class CallPickupProvider
{
    private AddressRepository $addressRepository;

    public function __construct(AddressRepository $addressRepository)
    {

        $this->addressRepository = $addressRepository;
    }
    public function getData()
    {
        $address = $this->addressRepository->find(1);
        if (null === $address) {
            return [];
        }

        return [
            'City' => $address->getCity(),
            'Street' => $address->getStreet(),
            'BulidingNo' => $address->getBuildingNumber(),
            'Email' => $address->getEmail(),
            'PartnerName' => $address->getSenderName(),
            'PersonName' => $address->getFirstName(),
            'PersonSurname' => $address->getLastName(),
            'Telephone' => $address->getPhone(),
            'Code' => $address->getPostalCode(),
        ];
    }
}
