<?php

namespace Orlen\OrlenPaczka\Form\Handler\Voter;

use Orlen\OrlenPaczka\Voter\Interfaces\VoterInterface;

class CanPackagesCallPickupVoter implements VoterInterface
{
    const PACKAGES_NOT_IN_DELIVERY = 'PACKAGES_NO_DELIVERY';
    const PACKAGES_HAS_LABEL = 'PACKAGES_HAS_LABEL';
    public function supports(string $type, $params): ?string
    {
        switch ($type) {
            case self::PACKAGES_NOT_IN_DELIVERY:
                return (is_array($params))?
                    'votePackagesNotInDelivery':
                    null;
            case self::PACKAGES_HAS_LABEL:
                return (is_array($params))?
                    'votePackagesHasLabel':
                    null;
            default:
                return null;
        }
    }
    /* @var \Orlen\OrlenPaczka\Entity\Package[] $packages */

    public function votePackagesNotInDelivery($packages)
    {
        foreach ($packages as $package) {
            if ($package->getDelivery() !== null) {
                return false;
            }
        }
        return true;
    }
    /* @var \Orlen\OrlenPaczka\Entity\Package[] $packages */
    public function votePackagesHasLabel($packages)
    {
        foreach ($packages as $package) {
            if ($package->getLabelName() === null || empty($package->getLabelName())) {
                return false;
            }
        }
        return true;
    }

}
